/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.api.RemoteBinaryService;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public class RemoteBinaryServiceImpl
extends RemoteBinaryService {
    private static final RequestProcessor RP = new RequestProcessor("RemoteBinaryServiceImpl", 1);
    private final Map<ExecutionEnvironment, Delegate> impls = new HashMap<ExecutionEnvironment, Delegate>();
    private static int downloadCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteBinaryService.RemoteBinaryResult getRemoteBinaryImpl(ExecutionEnvironment execEnv, String remotePath) {
        Delegate delegate;
        CndUtils.assertNonUiThread();
        RemoteBinaryServiceImpl remoteBinaryServiceImpl = this;
        synchronized (remoteBinaryServiceImpl) {
            delegate = this.impls.get(execEnv);
            if (delegate == null) {
                delegate = new Delegate(execEnv);
                this.impls.put(execEnv, delegate);
            }
        }
        try {
            return delegate.getRemoteBinaryImpl(remotePath);
        }
        catch (InterruptedException ex) {
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static int getDownloadCount() {
        return downloadCount;
    }

    static void resetDownloadCount() {
        downloadCount = 0;
    }

    private static class Entry {
        private final String remotePath;
        private final ExecutionEnvironment execEnv;
        private RemoteBinaryService.RemoteBinaryResult lastResult;
        private String timeStamp;

        public Entry(ExecutionEnvironment execEnv, String remotePath) {
            this.remotePath = remotePath;
            this.execEnv = execEnv;
        }

        public RemoteBinaryService.RemoteBinaryResult ensureSync() throws InterruptedException, IOException, ExecutionException {
            String localPath = RemotePathMap.getPathMap(this.execEnv).getLocalPath(this.remotePath, false);
            RemoteBinaryService.RemoteBinaryResult result = null;
            if (localPath != null && RemotePathMap.isTheSame(this.execEnv, CndPathUtilities.getDirName((String)this.remotePath), CndFileUtils.createLocalFile((String)localPath).getParentFile())) {
                if (this.lastResult == null) {
                    this.lastResult = new RemoteBinaryService.RemoteBinaryResult(localPath, new FutureTask<Boolean>(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return true;
                        }
                    }));
                    File file = new File(localPath);
                    this.lastResult.setTimeStamp("" + file.lastModified());
                }
            } else {
                result = this.syncImpl();
                if (result != null) {
                    this.lastResult = result;
                }
            }
            return result == null ? this.lastResult : result;
        }

        private Pair<String, String[]> getFullTimeLsCommand(String path) throws IOException, ConnectionManager.CancellationException {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
            switch (hostInfo.getOSFamily()) {
                case LINUX: {
                    return Pair.of((Object)"/bin/ls", (Object)new String[]{"--full-time", path});
                }
                case MACOSX: {
                    return Pair.of((Object)"/bin/ls", (Object)new String[]{"-lT", path});
                }
                case SUNOS: {
                    return Pair.of((Object)"/bin/ls", (Object)new String[]{"-lE", path});
                }
                case WINDOWS: {
                    throw new IllegalStateException("Windows in unsupported");
                }
            }
            return Pair.of((Object)"/bin/ls", (Object)new String[]{"-l", path});
        }

        private synchronized RemoteBinaryService.RemoteBinaryResult syncImpl() throws IOException, InterruptedException, ExecutionException {
            final String newTimestamp = this.getTimestamp();
            if (this.timeStamp != null && this.timeStamp.equals(newTimestamp) && CndFileUtils.isValidLocalFile((String)this.lastResult.localFName)) {
                return this.lastResult;
            }
            final File localFile = File.createTempFile("cnd-remote-binary-", ".bin");
            localFile.deleteOnExit();
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Boolean call() throws Exception {
                    String remoteCopyPath;
                    block5: {
                        block4: {
                            Boolean bl;
                            remoteCopyPath = null;
                            try {
                                HostInfo hinfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)Entry.this.execEnv);
                                String tmpDir = hinfo.getTempDir();
                                remoteCopyPath = tmpDir + "/binary." + newTimestamp.hashCode();
                                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)Entry.this.execEnv);
                                npb.setExecutable("cp").setArguments(new String[]{Entry.this.remotePath, remoteCopyPath});
                                NativeProcess copyProcess = npb.call();
                                int copyProcessResult = copyProcess.waitFor();
                                if (copyProcessResult == 0) break block4;
                                bl = false;
                                if (remoteCopyPath == null) return bl;
                            }
                            catch (Throwable throwable) {
                                if (remoteCopyPath == null) throw throwable;
                                CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, remoteCopyPath, null);
                                throw throwable;
                            }
                            CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, (String)remoteCopyPath, null);
                            return bl;
                        }
                        Future task = CommonTasksSupport.downloadFile((String)remoteCopyPath, (ExecutionEnvironment)Entry.this.execEnv, (String)localFile.getAbsolutePath(), null);
                        if ((Integer)task.get() == 0) break block5;
                        Boolean bl = false;
                        if (remoteCopyPath == null) return bl;
                        CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, (String)remoteCopyPath, null);
                        return bl;
                    }
                    Entry.this.timeStamp = newTimestamp;
                    downloadCount++;
                    if (remoteCopyPath == null) return true;
                    CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, (String)remoteCopyPath, null);
                    return true;
                }
            });
            RP.post(task);
            RemoteBinaryService.RemoteBinaryResult remoteBinaryResult = new RemoteBinaryService.RemoteBinaryResult(localFile.getAbsolutePath(), task);
            remoteBinaryResult.setTimeStamp(newTimestamp);
            return remoteBinaryResult;
        }

        private String getTimestamp() {
            try {
                Pair<String, String[]> cmdAndArgs = this.getFullTimeLsCommand(this.remotePath);
                ProcessUtils.ExitStatus rc = ProcessUtils.execute((ExecutionEnvironment)this.execEnv, (String)((String)cmdAndArgs.first()), (String[])((String[])cmdAndArgs.second()));
                if (rc.isOK()) {
                    return rc.output;
                }
                StringBuilder sb = new StringBuilder((String)cmdAndArgs.first());
                for (String arg : (String[])cmdAndArgs.second()) {
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(arg);
                }
                throw new IOException("Cannot run #" + sb + ": " + rc.error);
            }
            catch (ConnectionManager.CancellationException ex) {
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
    }

    private static class Delegate {
        private final ExecutionEnvironment execEnv;
        private final Map<String, Entry> cache = new HashMap<String, Entry>();

        public Delegate(ExecutionEnvironment execEnv) {
            this.execEnv = execEnv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteBinaryService.RemoteBinaryResult getRemoteBinaryImpl(String remotePath) throws InterruptedException, IOException, ExecutionException {
            Entry entry;
            Delegate delegate = this;
            synchronized (delegate) {
                entry = this.cache.get(remotePath);
                if (entry == null) {
                    entry = new Entry(this.execEnv, remotePath);
                    this.cache.put(remotePath, entry);
                }
            }
            return entry.ensureSync();
        }
    }
}

