/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PlatformTypes;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostData;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CreateHostVisualPanel3
extends JPanel {
    private final CreateHostData data;
    private CompilerSetManager compilerSetManager;
    private JComboBox cbDefaultToolchain;
    private JComboBox cbSyncMode;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JEditorPane jTextArea1;
    private JLabel labelHostname;
    private JLabel labelHostnameValue;
    private JLabel labelPlatform;
    private JLabel labelPlatformValue;
    private JLabel labelUsername;
    private JLabel labelUsernameValue;
    private ButtonGroup syncButtonGroup;
    private JTextField textHostDisplayName;

    public CreateHostVisualPanel3(CreateHostData data) {
        this.data = data;
        this.initComponents();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel3.Title");
    }

    void init() {
        this.textHostDisplayName.setText(this.data.getExecutionEnvironment().getDisplayName());
        this.compilerSetManager = this.data.getCacheManager().getCompilerSetManagerCopy(this.data.getExecutionEnvironment(), false);
        this.labelPlatformValue.setText(PlatformTypes.toString((int)this.compilerSetManager.getPlatform()));
        this.labelUsernameValue.setText(this.data.getExecutionEnvironment().getUser());
        this.labelHostnameValue.setText(this.data.getExecutionEnvironment().getHost());
        this.cbDefaultToolchain.setModel(new DefaultComboBoxModel<Object>(this.compilerSetManager.getCompilerSets().toArray()));
        this.cbDefaultToolchain.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel out = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    out.setText("");
                } else if (value instanceof String) {
                    assert (((String)value).trim().isEmpty());
                    out.setText("");
                } else {
                    CompilerSet cset = (CompilerSet)value;
                    out.setText(cset.getName());
                }
                return out;
            }
        });
        boolean selected = false;
        for (CompilerSet cs : this.compilerSetManager.getCompilerSets()) {
            if (!this.compilerSetManager.isDefaultCompilerSet(cs)) continue;
            this.cbDefaultToolchain.setSelectedItem(cs);
            selected = true;
            break;
        }
        if (!selected && this.compilerSetManager.getCompilerSets().size() > 0) {
            this.cbDefaultToolchain.setSelectedItem(0);
        }
        this.cbDefaultToolchain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateHostVisualPanel3.this.compilerSetManager.setDefault((CompilerSet)CreateHostVisualPanel3.this.cbDefaultToolchain.getSelectedItem());
            }
        });
        List sets2 = this.compilerSetManager.getCompilerSets();
        String html = "<html>";
        StringBuilder st = new StringBuilder("<html>");
        for (CompilerSet set : sets2) {
            if (st.length() > "<html>".length()) {
                st.append("<br>\n");
            }
            st.append(set.getName()).append(" (").append(set.getDirectory()).append(")");
        }
        RemoteServerRecord record = (RemoteServerRecord)ServerList.get((ExecutionEnvironment)this.data.getExecutionEnvironment());
        if (record != null && record.hasProblems()) {
            st.append("<br><br>\n");
            st.append("<font color=red>");
            st.append(record.getProblems().replace("\n", "<br>\n"));
        }
        st.append("</html>");
        this.jTextArea1.setEditorKit(new HTMLEditorKit());
        this.jTextArea1.setText(st.toString());
        SyncUtils.arrangeComboBox(this.cbSyncMode, this.data.getExecutionEnvironment());
        this.cbSyncMode.setSelectedItem(record.getSyncFactory());
    }

    String getHostDisplayName() {
        return this.textHostDisplayName.getText();
    }

    RemoteSyncFactory getRemoteSyncFactory() {
        return (RemoteSyncFactory)this.cbSyncMode.getSelectedItem();
    }

    private void initComponents() {
        this.syncButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.textHostDisplayName = new JTextField();
        this.labelPlatform = new JLabel();
        this.labelHostname = new JLabel();
        this.labelUsername = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cbDefaultToolchain = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JEditorPane();
        this.labelPlatformValue = new JLabel();
        this.labelHostnameValue = new JLabel();
        this.labelUsernameValue = new JLabel();
        this.jLabel4 = new JLabel();
        this.cbSyncMode = new JComboBox();
        this.setPreferredSize(new Dimension(534, 409));
        this.setRequestFocusEnabled(false);
        this.jLabel1.setLabelFor(this.textHostDisplayName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.jLabel1.text"));
        this.labelPlatform.setLabelFor(this.labelPlatformValue);
        this.labelPlatform.setText(NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.labelPlatform.text"));
        this.labelHostname.setLabelFor(this.labelHostnameValue);
        this.labelHostname.setText(NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.labelHostname.text"));
        this.labelUsername.setLabelFor(this.labelUsernameValue);
        this.labelUsername.setText(NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.labelUsername.text"));
        this.jLabel2.setLabelFor(this.jTextArea1);
        this.jLabel2.setText(NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.jLabel2.text"));
        this.jLabel3.setLabelFor(this.cbDefaultToolchain);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.jLabel3.text"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        Mnemonics.setLocalizedText((JLabel)this.labelPlatformValue, (String)NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.labelPlatformValue.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelHostnameValue, (String)NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.labelHostnameValue.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelUsernameValue, (String)NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.labelUsernameValue.text"));
        this.jLabel4.setLabelFor(this.cbSyncMode);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(CreateHostVisualPanel3.class, (String)"CreateHostVisualPanel3.jLabel4.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textHostDisplayName, -1, 434, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPlatform).addComponent(this.labelHostname).addComponent(this.labelUsername)).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelUsernameValue).addComponent(this.labelHostnameValue).addComponent(this.labelPlatformValue)).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbSyncMode, 0, 376, Short.MAX_VALUE).addComponent(this.cbDefaultToolchain, 0, 376, Short.MAX_VALUE))).addComponent(this.jSeparator1, -1, 534, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 534, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.textHostDisplayName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelPlatform).addComponent(this.labelPlatformValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelHostname).addComponent(this.labelHostnameValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelUsername).addComponent(this.labelUsernameValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.cbDefaultToolchain, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbSyncMode, -2, -1, -2).addComponent(this.jLabel4)).addGap(29, 29, 29)));
    }
}

