/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.html.lexer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.html.lexer.HtmlElements;
import org.netbeans.lib.html.lexer.HtmlPlugins;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.netbeans.spi.lexer.TokenPropertyProvider;

public final class HtmlLexer
implements Lexer<HTMLTokenId> {
    private static final Logger LOGGER = Logger.getLogger(HtmlLexer.class.getName());
    private static final boolean LOG = Boolean.getBoolean("j2ee_lexer_debug");
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<HTMLTokenId> tokenFactory;
    private final HashMap<CompoundState, CompoundState> STATES_CACHE = new HashMap();
    private static final String SCRIPT = "script";
    private static final String STYLE = "style";
    private static final String[] STYLE_ATTRS = new String[]{"style", "id", "class"};
    private int lexerSubState = 0;
    private int lexerState = 0;
    private String attribute;
    private String tag;
    private String scriptType;
    private Map<String, Collection<String>> cssClassTagAttrMap;
    private String CSS_CLASS_MAP_PROPERTY_KEY = "cssClassTagAttrMap";
    private int lexerEmbeddingState = 0;
    private byte customELIndex = 0;
    private boolean quoteType;
    public static final String EL_CONTENT_PROVIDER_INDEX = "elci";
    private static final int ISI_SCRIPT = 1;
    private static final int ISI_STYLE = 2;
    private static final int INIT = 0;
    private static final int ISI_TEXT = 1;
    private static final int ISI_ERROR = 2;
    private static final int ISA_LT = 3;
    private static final int ISA_SLASH = 4;
    private static final int ISI_ENDTAG = 5;
    private static final int ISP_ENDTAG_X = 6;
    private static final int ISP_ENDTAG_WS = 7;
    private static final int ISI_TAG = 8;
    private static final int ISP_TAG_X = 9;
    private static final int ISP_TAG_WS = 10;
    private static final int ISI_ARG = 11;
    private static final int ISP_ARG_X = 12;
    private static final int ISP_ARG_WS = 13;
    private static final int ISP_EQ = 14;
    private static final int ISP_EQ_WS = 15;
    private static final int ISI_VAL = 16;
    private static final int ISI_VAL_QUOT = 17;
    private static final int ISI_VAL_QUOT_EL = 18;
    private static final int ISA_SGML_ESCAPE = 19;
    private static final int ISA_SGML_DASH = 20;
    private static final int ISI_HTML_COMMENT = 21;
    private static final int ISA_HTML_COMMENT_DASH = 22;
    private static final int ISI_HTML_COMMENT_WS = 23;
    private static final int ISI_SGML_DECL = 24;
    private static final int ISA_SGML_DECL_DASH = 25;
    private static final int ISI_SGML_COMMENT = 26;
    private static final int ISA_SGML_COMMENT_DASH = 27;
    private static final int ISA_REF = 28;
    private static final int ISI_REF_NAME = 29;
    private static final int ISA_REF_HASH = 30;
    private static final int ISI_REF_DEC = 31;
    private static final int ISA_REF_X = 32;
    private static final int ISI_REF_HEX = 33;
    private static final int ISI_TAG_SLASH = 34;
    private static final int ISI_SCRIPT_CONTENT = 35;
    private static final int ISI_SCRIPT_CONTENT_AFTER_LT = 36;
    private static final int ISI_SCRIPT_CONTENT_ENDTAG = 37;
    private static final int ISI_STYLE_CONTENT = 38;
    private static final int ISI_STYLE_CONTENT_AFTER_LT = 39;
    private static final int ISI_STYLE_CONTENT_ENDTAG = 40;
    private static final int ISI_SGML_DECL_WS = 41;
    private static final int ISI_VAL_QUOT_ESC = 42;
    private static final int ISA_ARG_UNDERSCORE = 44;
    private static final int ISP_TAG_X_ERROR = 45;
    private static final int ISI_XML_PI = 47;
    private static final int ISI_XML_PI_QM = 48;
    private static final int ISI_EL = 49;
    static final Set<String> EVENT_HANDLER_NAMES = new HashSet<String>();
    private static final String SUPPORTED_SCRIPT_TYPE = "text/javascript";
    private static final String IMG_EQUAL_SIGN = "=";
    private static final String IMG_CLOSE_TAG_SYMBOL = ">";
    private static final String IMG_CLOSE_TAG_SYMBOL2 = "/>";
    private static final String IMG_OPEN_TAG_SYMBOL = "<";
    private static final String IMG_OPEN_TAG_SYMBOL2 = "</";
    private final HtmlPlugins customELQuery = HtmlPlugins.getDefault();
    public static final String EL_EXPRESSION_CONTENT_MIMETYPE_TOKEN_PROPERTY_KEY = "contentMimeType";
    public static final String ATTRIBUTE_VALUE_EMBEDDING_MIMETYPE_TOKEN_PROPERTY_KEY = "embeddingMimeType";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String ID_ATTR_NAME = "id";
    private static final TokenPropertyProvider CLASS_TOKEN_PP;
    private static final TokenPropertyProvider ID_TOKEN_PP;

    public Object state() {
        CompoundState currentState = new CompoundState(this.lexerState, this.lexerSubState, this.lexerEmbeddingState, this.attribute, this.tag, this.scriptType, this.customELIndex, this.quoteType);
        CompoundState cached = this.STATES_CACHE.get(currentState);
        if (cached == null) {
            this.STATES_CACHE.put(currentState, currentState);
            return currentState;
        }
        return cached;
    }

    public HtmlLexer(LexerRestartInfo<HTMLTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        if (info.state() == null) {
            this.lexerSubState = 0;
            this.lexerState = 0;
            this.lexerEmbeddingState = 0;
            this.customELIndex = 0;
            this.quoteType = false;
        } else {
            CompoundState cs = (CompoundState)info.state();
            this.lexerState = cs.lexerState;
            this.lexerSubState = cs.lexerSubState;
            this.lexerEmbeddingState = cs.lexerEmbeddingState;
            this.attribute = cs.attribute;
            this.tag = cs.tag;
            this.customELIndex = cs.customELIndex;
            this.quoteType = cs.quoteType;
        }
        InputAttributes inputAttributes = info.inputAttributes();
        if (inputAttributes != null) {
            this.cssClassTagAttrMap = (Map)inputAttributes.getValue(LanguagePath.get(HTMLTokenId.language()), (Object)this.CSS_CLASS_MAP_PROPERTY_KEY);
        }
    }

    private boolean isAZ(int character) {
        return character >= 97 && character <= 122 || character >= 65 && character <= 90;
    }

    private boolean isName(int character) {
        return Character.isLetterOrDigit(character) || character == 45 || character == 95 || character == 46 || character == 58;
    }

    private boolean isWS(int character) {
        return Character.isWhitespace(character) || character == 64;
    }

    private boolean isJavascriptEventHandlerName(CharSequence attributeName) {
        if (attributeName == null) {
            return false;
        }
        if (attributeName.length() > 2) {
            char firstChar = attributeName.charAt(0);
            char secondChar = attributeName.charAt(1);
            if (!(firstChar != 'o' && firstChar != 'O' || secondChar != 'n' && secondChar != 'N')) {
                return EVENT_HANDLER_NAMES.contains(attributeName.toString().toLowerCase(Locale.ENGLISH));
            }
        }
        return false;
    }

    private boolean isStyleAttributeName(CharSequence chs) {
        if (chs == null) {
            return false;
        }
        block0: for (int j = 0; j < STYLE_ATTRS.length; ++j) {
            if (chs.length() != STYLE_ATTRS[j].length()) continue;
            for (int i = 0; i < chs.length(); ++i) {
                if (Character.toLowerCase(chs.charAt(i)) != Character.toLowerCase(STYLE_ATTRS[j].charAt(i))) continue block0;
            }
            return true;
        }
        return false;
    }

    private CharSequence getScriptType(CharSequence attributeValue, boolean quoted) {
        boolean hasEndQuote;
        char lastChar = attributeValue.charAt(attributeValue.length() - 1);
        boolean bl = hasEndQuote = attributeValue.length() > 1 && (lastChar == '\'' || lastChar == '\"');
        return quoted ? attributeValue.subSequence(1, attributeValue.length() - (hasEndQuote ? 1 : 0)) : attributeValue;
    }

    private boolean followsCloseTag(CharSequence closeTagName) {
        int actChar;
        int prev_read = this.input.readLength();
        int read = 0;
        do {
            actChar = this.input.read();
            ++read;
        } while ((Character.isLetter(actChar) || Character.isDigit(actChar) || actChar == 95 || actChar == 45 || actChar == 58 || actChar == 46 || actChar == 47) && actChar != -1);
        CharSequence tagName = this.input.readText().subSequence(prev_read, prev_read + read - 1);
        this.input.backup(read);
        return HtmlLexer.equals(closeTagName, tagName, true, true) && actChar == 62;
    }

    public Token<HTMLTokenId> nextToken() {
        while (true) {
            int actChar;
            if ((actChar = this.input.read()) == -1) {
                if (this.input.readLengthEOF() == 1) {
                    return null;
                }
                break;
            }
            block0 : switch (this.lexerState) {
                case 0: {
                    switch (actChar) {
                        case 60: {
                            this.lexerState = 3;
                            break block0;
                        }
                        case 38: {
                            this.lexerState = 28;
                            this.lexerSubState = 1;
                            break block0;
                        }
                        default: {
                            this.lexerState = 1;
                        }
                    }
                }
                case 1: {
                    char delimChar;
                    int i;
                    char read;
                    int alreadyRead;
                    String openDelimiter;
                    switch (actChar) {
                        case 38: 
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            if (this.input.readLength() <= 0) break;
                            return this.token(HTMLTokenId.TEXT);
                        }
                    }
                    block148: for (int delimiterIndex = 0; delimiterIndex < this.customELQuery.getOpenDelimiters().length; delimiterIndex = (int)((byte)(delimiterIndex + 1))) {
                        openDelimiter = this.customELQuery.getOpenDelimiters()[delimiterIndex];
                        if (openDelimiter == null) continue;
                        alreadyRead = this.input.readLength();
                        read = (char)actChar;
                        for (i = 0; i < openDelimiter.length(); ++i) {
                            delimChar = openDelimiter.charAt(i);
                            if (read != delimChar) {
                                this.input.backup(this.input.readLengthEOF() - alreadyRead);
                                continue block148;
                            }
                            if (i + 1 >= openDelimiter.length()) continue;
                            read = (char)this.input.read();
                        }
                        if (this.input.readLength() > openDelimiter.length()) {
                            this.input.backup(openDelimiter.length());
                            return this.token(HTMLTokenId.TEXT);
                        }
                        this.lexerState = 49;
                        this.customELIndex = (byte)(delimiterIndex + 1);
                        return this.token(HTMLTokenId.EL_OPEN_DELIMITER, new HtmlTokenPropertyProvider(EL_EXPRESSION_CONTENT_MIMETYPE_TOKEN_PROPERTY_KEY, this.customELQuery.getMimeTypes()[delimiterIndex]));
                    }
                    break;
                }
                case 49: {
                    String closeDelimiter;
                    char delimChar;
                    int i;
                    char read;
                    int alreadyRead;
                    block150: for (int delimiterIndex = 0; delimiterIndex < this.customELQuery.getOpenDelimiters().length; delimiterIndex = (int)((byte)(delimiterIndex + 1))) {
                        closeDelimiter = this.customELQuery.getCloseDelimiters()[delimiterIndex];
                        if (closeDelimiter == null) continue;
                        alreadyRead = this.input.readLength();
                        read = (char)actChar;
                        for (i = 0; i < closeDelimiter.length(); ++i) {
                            delimChar = closeDelimiter.charAt(i);
                            if (read != delimChar) {
                                this.input.backup(this.input.readLength() - alreadyRead);
                                continue block150;
                            }
                            if (i + 1 >= closeDelimiter.length()) continue;
                            read = (char)this.input.read();
                        }
                        if (this.input.readLength() > closeDelimiter.length()) {
                            this.input.backup(closeDelimiter.length());
                            return this.token(HTMLTokenId.EL_CONTENT, new HtmlTokenPropertyProvider(EL_CONTENT_PROVIDER_INDEX, new Byte((byte)(this.customELIndex - 1))));
                        }
                        this.lexerState = 0;
                        this.customELIndex = 0;
                        return this.token(HTMLTokenId.EL_CLOSE_DELIMITER);
                    }
                    break;
                }
                case 2: {
                    this.lexerState = 0;
                    this.tag = null;
                    return this.token(HTMLTokenId.ERROR);
                }
                case 3: {
                    if (this.isAZ(actChar)) {
                        this.lexerState = 8;
                        if (this.input.readLength() <= 1) break;
                        this.input.backup(1);
                        return this.token(HTMLTokenId.TAG_OPEN_SYMBOL);
                    }
                    switch (actChar) {
                        case 47: {
                            this.lexerState = 4;
                            return this.token(HTMLTokenId.TAG_OPEN_SYMBOL);
                        }
                        case 62: {
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                        case 33: {
                            this.lexerState = 19;
                            break block0;
                        }
                        case 63: {
                            this.lexerState = 47;
                            break block0;
                        }
                    }
                    this.input.backup(1);
                    this.lexerState = 1;
                    break;
                }
                case 47: {
                    if (actChar != 63) break;
                    this.lexerState = 48;
                    break;
                }
                case 48: {
                    if (actChar == 62) {
                        this.lexerState = 0;
                        return this.token(HTMLTokenId.XML_PI);
                    }
                    this.lexerState = 47;
                    break;
                }
                case 4: {
                    if (this.isAZ(actChar)) {
                        this.lexerState = 5;
                        break;
                    }
                    switch (actChar) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                    }
                    this.lexerState = 1;
                    this.input.backup(1);
                    break;
                }
                case 5: {
                    if (this.isName(actChar)) break;
                    this.lexerState = 6;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.TAG_CLOSE);
                }
                case 6: {
                    if (this.isWS(actChar)) {
                        this.lexerState = 7;
                        break;
                    }
                    this.tag = null;
                    switch (actChar) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            break block0;
                        }
                    }
                    this.lexerState = 2;
                    this.input.backup(1);
                    break;
                }
                case 7: {
                    if (this.isWS(actChar)) break;
                    this.lexerState = 6;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.WS);
                }
                case 8: {
                    if (this.isName(actChar)) break;
                    this.lexerState = 9;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    this.tag = this.input.readText().toString();
                    if (HtmlLexer.equals(SCRIPT, this.tag, true, true)) {
                        this.lexerEmbeddingState = 1;
                    }
                    if (HtmlLexer.equals(STYLE, this.tag, true, true)) {
                        this.lexerEmbeddingState = 2;
                    }
                    return this.token(HTMLTokenId.TAG_OPEN);
                }
                case 9: {
                    if (this.isWS(actChar)) {
                        this.lexerState = 10;
                        break;
                    }
                    if (this.isAZ(actChar)) {
                        this.lexerState = 11;
                        break;
                    }
                    switch (actChar) {
                        case 47: {
                            this.lexerState = 34;
                            break block0;
                        }
                        case 62: {
                            switch (this.lexerEmbeddingState) {
                                case 0: {
                                    this.lexerState = 0;
                                    break;
                                }
                                case 1: {
                                    if (this.scriptType != null && "text/html".equalsIgnoreCase(this.scriptType)) {
                                        this.lexerEmbeddingState = 0;
                                        this.scriptType = null;
                                        this.lexerState = 0;
                                        break;
                                    }
                                    this.lexerState = 35;
                                    break;
                                }
                                case 2: {
                                    this.lexerState = 38;
                                }
                            }
                            this.tag = null;
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                        case 60: {
                            this.tag = null;
                            this.lexerState = 0;
                            this.input.backup(1);
                            break block0;
                        }
                        case 95: {
                            this.lexerState = 44;
                            break block0;
                        }
                    }
                    this.lexerState = 45;
                    break;
                }
                case 45: {
                    if (this.isWS(actChar)) {
                        this.lexerState = 9;
                        this.input.backup(1);
                        return this.token(HTMLTokenId.ERROR);
                    }
                    switch (actChar) {
                        case 47: 
                        case 62: {
                            this.lexerState = 9;
                            this.input.backup(1);
                            return this.token(HTMLTokenId.ERROR);
                        }
                    }
                    break;
                }
                case 10: {
                    if (this.isWS(actChar)) break;
                    this.lexerState = 9;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(HTMLTokenId.WS);
                    }
                }
                case 34: {
                    this.tag = null;
                    switch (actChar) {
                        case 62: {
                            this.lexerEmbeddingState = 0;
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                    }
                    this.lexerState = 2;
                    this.input.backup(1);
                    break;
                }
                case 35: {
                    switch (actChar) {
                        case 60: {
                            this.lexerState = 36;
                            break block0;
                        }
                    }
                    break;
                }
                case 36: {
                    if (actChar == 47 && this.followsCloseTag(SCRIPT)) {
                        this.lexerEmbeddingState = 0;
                        this.lexerState = 0;
                        this.tag = null;
                        String type = this.scriptType;
                        this.scriptType = null;
                        this.input.backup(this.input.readLength() > 2 ? 2 : this.input.readLength());
                        if (this.input.readLength() <= 0) break;
                        return this.token(HTMLTokenId.SCRIPT, new HtmlTokenPropertyProvider("type", type));
                    }
                    this.lexerState = 35;
                    break;
                }
                case 38: {
                    switch (actChar) {
                        case 60: {
                            this.lexerState = 39;
                            break block0;
                        }
                    }
                    break;
                }
                case 39: {
                    if (actChar == 47 && this.followsCloseTag(STYLE)) {
                        this.lexerEmbeddingState = 0;
                        this.lexerState = 0;
                        this.tag = null;
                        this.input.backup(this.input.readLength() > 2 ? 2 : this.input.readLength());
                        if (this.input.readLength() <= 0) break;
                        return this.token(HTMLTokenId.STYLE);
                    }
                    this.lexerState = 38;
                    break;
                }
                case 44: {
                    if (this.isName(actChar)) {
                        this.lexerState = 11;
                    } else {
                        this.lexerState = 2;
                        this.input.backup(1);
                        break;
                    }
                }
                case 11: {
                    if (this.isName(actChar)) break;
                    this.lexerState = 12;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    this.attribute = this.input.readText().toString();
                    return this.token(HTMLTokenId.ARGUMENT);
                }
                case 12: {
                    if (this.isWS(actChar)) {
                        this.lexerState = 13;
                        break;
                    }
                    if (this.isAZ(actChar)) {
                        this.lexerState = 11;
                        break;
                    }
                    switch (actChar) {
                        case 47: 
                        case 62: {
                            this.input.backup(1);
                            this.lexerState = 9;
                            break block0;
                        }
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            break block0;
                        }
                        case 61: {
                            this.lexerState = 14;
                            return this.token(HTMLTokenId.OPERATOR);
                        }
                    }
                    this.lexerState = 2;
                    this.input.backup(1);
                    break;
                }
                case 13: {
                    if (this.isWS(actChar)) break;
                    this.lexerState = 12;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.WS);
                }
                case 14: {
                    if (this.isWS(actChar)) {
                        this.lexerState = 15;
                        break;
                    }
                    switch (actChar) {
                        case 39: {
                            this.quoteType = false;
                            this.lexerState = 17;
                            break block0;
                        }
                        case 34: {
                            this.quoteType = true;
                            this.lexerState = 17;
                            break block0;
                        }
                        case 47: 
                        case 60: 
                        case 62: {
                            this.input.backup(1);
                            this.lexerState = 9;
                            break block0;
                        }
                    }
                    this.lexerState = 16;
                    break;
                }
                case 15: {
                    if (this.isWS(actChar)) break;
                    this.lexerState = 14;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.WS);
                }
                case 16: {
                    if (actChar == 47) {
                        char next = (char)this.input.read();
                        this.input.backup(1);
                        if (next != '>') {
                            break;
                        }
                    } else if (!this.isWS(actChar) && actChar != 62 && actChar != 60) break;
                    this.lexerState = 9;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    Token<HTMLTokenId> resolveValueToken = this.resolveValueToken();
                    this.attribute = null;
                    return resolveValueToken;
                }
                case 17: {
                    char delimChar;
                    int i;
                    char read;
                    int alreadyRead;
                    String openDelimiter;
                    block152: for (int delimiterIndex = 0; delimiterIndex < this.customELQuery.getOpenDelimiters().length; delimiterIndex = (int)((byte)(delimiterIndex + 1))) {
                        openDelimiter = this.customELQuery.getOpenDelimiters()[delimiterIndex];
                        if (openDelimiter == null) continue;
                        alreadyRead = this.input.readLength();
                        read = (char)actChar;
                        for (i = 0; i < openDelimiter.length(); ++i) {
                            delimChar = openDelimiter.charAt(i);
                            if (read != delimChar) {
                                this.input.backup(this.input.readLength() - alreadyRead);
                                continue block152;
                            }
                            if (i + 1 >= openDelimiter.length()) continue;
                            read = (char)this.input.read();
                        }
                        if (this.input.readLength() > openDelimiter.length()) {
                            this.input.backup(openDelimiter.length());
                            return this.resolveValueToken();
                        }
                        this.lexerState = 18;
                        this.customELIndex = (byte)(delimiterIndex + 1);
                        return this.token(HTMLTokenId.EL_OPEN_DELIMITER, new HtmlTokenPropertyProvider(EL_EXPRESSION_CONTENT_MIMETYPE_TOKEN_PROPERTY_KEY, this.customELQuery.getMimeTypes()[delimiterIndex]));
                    }
                    switch (actChar) {
                        case 92: {
                            this.lexerState = 42;
                            break;
                        }
                        case 34: 
                        case 39: {
                            if ((actChar != 39 || this.quoteType) && (actChar != 34 || !this.quoteType)) break;
                            if (HtmlLexer.equals(SCRIPT, this.tag, true, true) && HtmlLexer.equals("type", this.attribute, true, true)) {
                                this.scriptType = this.getScriptType(this.input.readText(), true).toString();
                            }
                            this.lexerState = 9;
                            Token<HTMLTokenId> resolveValueToken = this.resolveValueToken();
                            this.attribute = null;
                            return resolveValueToken;
                        }
                    }
                    break;
                }
                case 18: {
                    String closeDelimiter;
                    char delimChar;
                    int i;
                    char read;
                    int alreadyRead;
                    block154: for (int delimiterIndex = 0; delimiterIndex < this.customELQuery.getOpenDelimiters().length; delimiterIndex = (int)((byte)(delimiterIndex + 1))) {
                        closeDelimiter = this.customELQuery.getCloseDelimiters()[delimiterIndex];
                        if (closeDelimiter == null) continue;
                        alreadyRead = this.input.readLength();
                        read = (char)actChar;
                        for (i = 0; i < closeDelimiter.length(); ++i) {
                            delimChar = closeDelimiter.charAt(i);
                            if (read != delimChar) {
                                this.input.backup(this.input.readLength() - alreadyRead);
                                continue block154;
                            }
                            if (i + 1 >= closeDelimiter.length()) continue;
                            read = (char)this.input.read();
                        }
                        if (this.input.readLength() > closeDelimiter.length()) {
                            this.input.backup(closeDelimiter.length());
                            return this.token(HTMLTokenId.EL_CONTENT, new HtmlTokenPropertyProvider(EL_CONTENT_PROVIDER_INDEX, new Byte((byte)(this.customELIndex - 1))));
                        }
                        this.lexerState = 17;
                        this.customELIndex = 0;
                        return this.token(HTMLTokenId.EL_CLOSE_DELIMITER);
                    }
                    break;
                }
                case 42: {
                    this.lexerState = 17;
                    break;
                }
                case 19: {
                    if (this.isAZ(actChar)) {
                        this.lexerState = 24;
                        break;
                    }
                    switch (actChar) {
                        case 45: {
                            this.lexerState = 20;
                            break block0;
                        }
                    }
                    this.lexerState = 1;
                    this.input.backup(1);
                    break;
                }
                case 20: {
                    switch (actChar) {
                        case 45: {
                            this.lexerState = 21;
                            break block0;
                        }
                    }
                    this.lexerState = 1;
                    this.input.backup(1);
                    break;
                }
                case 21: {
                    switch (actChar) {
                        case 45: {
                            this.lexerState = 22;
                            break block0;
                        }
                        case 10: {
                            return this.token(HTMLTokenId.BLOCK_COMMENT);
                        }
                    }
                    break;
                }
                case 22: {
                    switch (actChar) {
                        case 45: {
                            this.lexerState = 23;
                            break block0;
                        }
                    }
                    this.lexerState = 21;
                    break;
                }
                case 23: {
                    switch (actChar) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.BLOCK_COMMENT);
                        }
                    }
                    this.lexerState = 21;
                    this.input.backup(2);
                    break;
                }
                case 24: {
                    if (Character.isWhitespace(actChar)) {
                        this.lexerState = 41;
                        if (this.input.readLength() <= 1) break;
                        this.input.backup(1);
                        return this.token(HTMLTokenId.DECLARATION);
                    }
                    switch (actChar) {
                        case 62: {
                            if (this.input.readLength() > 1) {
                                this.input.backup(1);
                                return this.token(HTMLTokenId.DECLARATION);
                            }
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.DECLARATION);
                        }
                    }
                    break;
                }
                case 41: {
                    if (actChar == 45) {
                        if (this.input.readLength() == 1) {
                            this.lexerState = 25;
                            break;
                        }
                        if (this.input.readLength() <= 1) break;
                        this.input.backup(1);
                        return this.token(HTMLTokenId.DECLARATION);
                    }
                    if (Character.isWhitespace(actChar)) break;
                    this.lexerState = 24;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.WS);
                }
                case 25: {
                    if (actChar == 45) {
                        this.lexerState = 26;
                        break;
                    }
                    this.lexerState = 24;
                    this.input.backup(1);
                    break;
                }
                case 26: {
                    switch (actChar) {
                        case 45: {
                            this.lexerState = 27;
                        }
                    }
                    break;
                }
                case 27: {
                    if (actChar == 45) {
                        this.lexerState = 24;
                        return this.token(HTMLTokenId.SGML_COMMENT);
                    }
                    this.lexerState = 26;
                    this.input.backup(1);
                    break;
                }
                case 28: {
                    if (this.isAZ(actChar)) {
                        this.lexerState = 29;
                        break;
                    }
                    if (actChar == 35) {
                        this.lexerState = 30;
                        break;
                    }
                    this.lexerState = this.lexerSubState;
                    this.input.backup(1);
                    break;
                }
                case 29: {
                    if (this.isName(actChar)) break;
                    this.lexerState = this.lexerSubState;
                    if (this.input.readLength() <= 1) break;
                    if (actChar != 59) {
                        this.input.backup(1);
                        return this.token(HTMLTokenId.TEXT);
                    }
                    return this.token(HTMLTokenId.CHARACTER);
                }
                case 30: {
                    if (actChar >= 48 && actChar <= 57) {
                        this.lexerState = 31;
                        break;
                    }
                    if (actChar == 120 || actChar == 88) {
                        this.lexerState = 32;
                        break;
                    }
                    if (this.isAZ(actChar)) {
                        this.lexerState = this.lexerSubState;
                        return this.token(HTMLTokenId.ERROR);
                    }
                    this.lexerState = this.lexerSubState;
                    this.input.backup(1);
                    break;
                }
                case 31: {
                    if (actChar >= 48 && actChar <= 57) break;
                    this.lexerState = this.lexerSubState;
                    if (this.input.readLength() <= 1) break;
                    if (actChar != 59) {
                        this.input.backup(1);
                    }
                    return this.token(HTMLTokenId.CHARACTER);
                }
                case 32: {
                    if (actChar >= 48 && actChar <= 57 || actChar >= 97 && actChar <= 102 || actChar >= 65 && actChar <= 70) {
                        this.lexerState = 33;
                        break;
                    }
                    this.lexerState = this.lexerSubState;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.ERROR);
                }
                case 33: {
                    if (actChar >= 48 && actChar <= 57 || actChar >= 97 && actChar <= 102 || actChar >= 65 && actChar <= 70) break;
                    this.lexerState = this.lexerSubState;
                    if (this.input.readLength() <= 1) break;
                    if (actChar != 59) {
                        this.input.backup(1);
                    }
                    return this.token(HTMLTokenId.CHARACTER);
                }
            }
        }
        this.input.backup(1);
        switch (this.lexerState) {
            case 0: {
                if (this.input.readLength() != 0) break;
                return null;
            }
            case 1: 
            case 3: 
            case 4: 
            case 19: 
            case 20: 
            case 34: {
                return this.token(HTMLTokenId.TEXT);
            }
            case 47: 
            case 48: {
                return this.token(HTMLTokenId.XML_PI);
            }
            case 28: 
            case 30: {
                if (this.lexerSubState == 1) {
                    return this.token(HTMLTokenId.TEXT);
                }
                return this.token(HTMLTokenId.VALUE);
            }
            case 21: 
            case 22: 
            case 23: {
                return this.token(HTMLTokenId.BLOCK_COMMENT);
            }
            case 8: {
                this.lexerState = 9;
                if (HtmlLexer.equals(SCRIPT, this.input.readText(), true, true)) {
                    this.lexerEmbeddingState = 1;
                }
                if (HtmlLexer.equals(STYLE, this.input.readText(), true, true)) {
                    this.lexerEmbeddingState = 2;
                }
                return this.token(HTMLTokenId.TAG_OPEN);
            }
            case 5: {
                return this.token(HTMLTokenId.TAG_CLOSE);
            }
            case 11: 
            case 44: {
                return this.token(HTMLTokenId.ARGUMENT);
            }
            case 2: 
            case 45: {
                return this.token(HTMLTokenId.ERROR);
            }
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                return this.token(HTMLTokenId.WS);
            }
            case 6: 
            case 9: 
            case 12: 
            case 14: {
                return this.token(HTMLTokenId.WS);
            }
            case 16: 
            case 17: 
            case 42: {
                return this.resolveValueToken();
            }
            case 24: 
            case 25: 
            case 41: {
                return this.token(HTMLTokenId.DECLARATION);
            }
            case 26: 
            case 27: {
                return this.token(HTMLTokenId.SGML_COMMENT);
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                return this.token(HTMLTokenId.TEXT);
            }
            case 35: 
            case 36: 
            case 37: {
                return this.token(HTMLTokenId.SCRIPT);
            }
            case 38: 
            case 39: 
            case 40: {
                return this.token(HTMLTokenId.STYLE);
            }
            case 18: 
            case 49: {
                return this.token(HTMLTokenId.EL_CONTENT, new HtmlTokenPropertyProvider(EL_CONTENT_PROVIDER_INDEX, new Byte((byte)(this.customELIndex - 1))));
            }
        }
        assert (this.input.readLength() == 0) : "Returning null even if some chars still needs to be tokenized! lexer state=" + this.lexerState + "; " + "lexer substate=" + this.lexerSubState + "; " + "lexer embedding state=" + this.lexerEmbeddingState + "; " + "readtext='" + this.input.readText() + "'";
        return null;
    }

    private Token<HTMLTokenId> resolveValueToken() {
        Collection<String> attrs;
        assert (this.attribute != null);
        if (this.isJavascriptEventHandlerName(this.attribute)) {
            return this.token(HTMLTokenId.VALUE_JAVASCRIPT);
        }
        if (this.isStyleAttributeName(this.attribute)) {
            return this.createCssValueToken();
        }
        if (this.cssClassTagAttrMap != null && this.tag != null && (attrs = this.cssClassTagAttrMap.get(this.tag)) != null && attrs.contains(this.attribute)) {
            return this.token(HTMLTokenId.VALUE_CSS, CLASS_TOKEN_PP);
        }
        String embeddingMimeType = HtmlPlugins.getDefault().createAttributeEmbedding(this.tag, this.attribute);
        if (embeddingMimeType != null) {
            LOGGER.log(Level.FINE, "creating html attribute value token {0} in tag {1} with embedding {2}", new Object[]{this.attribute, this.tag, embeddingMimeType});
            return this.token(HTMLTokenId.VALUE, new HtmlTokenPropertyProvider(ATTRIBUTE_VALUE_EMBEDDING_MIMETYPE_TOKEN_PROPERTY_KEY, embeddingMimeType));
        }
        return this.token(HTMLTokenId.VALUE);
    }

    private Token<HTMLTokenId> createCssValueToken() {
        Object provider = HtmlLexer.equals(CLASS_ATTR_NAME, this.attribute, true, true) ? CLASS_TOKEN_PP : (HtmlLexer.equals(ID_ATTR_NAME, this.attribute, true, true) ? ID_TOKEN_PP : null);
        return this.token(HTMLTokenId.VALUE_CSS, (TokenPropertyProvider)provider);
    }

    private Token<HTMLTokenId> token(HTMLTokenId tokenId) {
        return this.token(tokenId, null);
    }

    private Token<HTMLTokenId> token(HTMLTokenId tokenId, TokenPropertyProvider tokenPropertyProvider) {
        if (LOG) {
            if (this.input.readLength() == 0) {
                LOGGER.log(Level.INFO, "Found zero length token: ");
            }
            LOGGER.log(Level.INFO, "[{0}] token (''{1}''; id={2}; state={3})\n", new Object[]{this.getClass().getSimpleName(), this.input.readText().toString(), tokenId, this.state()});
        }
        if (tokenPropertyProvider != null) {
            return this.tokenFactory.createPropertyToken((TokenId)tokenId, this.input.readLength(), tokenPropertyProvider);
        }
        CharSequence image = this.input.readText();
        switch (tokenId) {
            case OPERATOR: {
                return this.tokenFactory.getFlyweightToken((TokenId)tokenId, IMG_EQUAL_SIGN);
            }
            case TAG_CLOSE_SYMBOL: {
                switch (image.charAt(0)) {
                    case '/': {
                        if (this.input.readLength() <= 1 || image.charAt(1) != '>') break;
                        return this.tokenFactory.getFlyweightToken((TokenId)tokenId, IMG_CLOSE_TAG_SYMBOL2);
                    }
                    case '>': {
                        return this.tokenFactory.getFlyweightToken((TokenId)tokenId, IMG_CLOSE_TAG_SYMBOL);
                    }
                }
            }
            case TAG_OPEN_SYMBOL: {
                switch (image.charAt(0)) {
                    case '<': {
                        if (this.input.readLength() > 1) {
                            if (image.charAt(1) != '/') break;
                            return this.tokenFactory.getFlyweightToken((TokenId)tokenId, IMG_OPEN_TAG_SYMBOL2);
                        }
                        return this.tokenFactory.getFlyweightToken((TokenId)tokenId, IMG_OPEN_TAG_SYMBOL);
                    }
                }
            }
            case TAG_OPEN: 
            case TAG_CLOSE: {
                String cachedTagName = HtmlElements.getCachedTagName(image);
                if (cachedTagName == null) break;
                assert (cachedTagName.length() <= this.input.readLength()) : "readlength == " + this.input.readLength() + "; text=" + cachedTagName + "; image=" + image;
                return this.tokenFactory.getFlyweightToken((TokenId)tokenId, cachedTagName);
            }
            case ARGUMENT: {
                String cachedAttrName = HtmlElements.getCachedAttrName(image);
                if (cachedAttrName == null) break;
                assert (cachedAttrName.length() <= this.input.readLength()) : "readlength == " + this.input.readLength() + "; text=" + cachedAttrName + "; image=" + image;
                return this.tokenFactory.getFlyweightToken((TokenId)tokenId, cachedAttrName);
            }
        }
        return this.tokenFactory.createToken((TokenId)tokenId);
    }

    public void release() {
    }

    private static boolean equals(CharSequence text1, CharSequence text2, boolean ignoreCase, boolean optimized) {
        assert (text1 != null) : "text1 arg is null";
        assert (text2 != null) : "text2 arg is null";
        if (text1.length() != text2.length()) {
            return false;
        }
        for (int i = 0; i < text1.length(); ++i) {
            char ch2;
            char ch1 = ignoreCase && !optimized ? Character.toLowerCase(text1.charAt(i)) : text1.charAt(i);
            char c = ch2 = ignoreCase ? Character.toLowerCase(text2.charAt(i)) : text2.charAt(i);
            if (ch1 == ch2) continue;
            return false;
        }
        return true;
    }

    static {
        EVENT_HANDLER_NAMES.add("onload");
        EVENT_HANDLER_NAMES.add("onunload");
        EVENT_HANDLER_NAMES.add("onclick");
        EVENT_HANDLER_NAMES.add("ondblclick");
        EVENT_HANDLER_NAMES.add("onmousedown");
        EVENT_HANDLER_NAMES.add("onmouseup");
        EVENT_HANDLER_NAMES.add("onmouseover");
        EVENT_HANDLER_NAMES.add("onmousemove");
        EVENT_HANDLER_NAMES.add("onmouseout");
        EVENT_HANDLER_NAMES.add("onfocus");
        EVENT_HANDLER_NAMES.add("onblur");
        EVENT_HANDLER_NAMES.add("onkeypress");
        EVENT_HANDLER_NAMES.add("onkeydown");
        EVENT_HANDLER_NAMES.add("onkeyup");
        EVENT_HANDLER_NAMES.add("onsubmit");
        EVENT_HANDLER_NAMES.add("onreset");
        EVENT_HANDLER_NAMES.add("onselect");
        EVENT_HANDLER_NAMES.add("onchange");
        EVENT_HANDLER_NAMES.add("ondrag");
        EVENT_HANDLER_NAMES.add("ondrop");
        CLASS_TOKEN_PP = new HtmlTokenPropertyProvider("valueCssType", CLASS_ATTR_NAME);
        ID_TOKEN_PP = new HtmlTokenPropertyProvider("valueCssType", ID_ATTR_NAME);
    }

    private static class HtmlTokenPropertyProvider
    implements TokenPropertyProvider {
        private final String key;
        private final Object value;

        HtmlTokenPropertyProvider(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getValue(Token token, Object key) {
            if (this.key.equals(key)) {
                return this.value;
            }
            return null;
        }
    }

    private class CompoundState {
        private int lexerState;
        private int lexerSubState;
        private int lexerEmbeddingState;
        private byte customELIndex;
        private String attribute;
        private String tag;
        private String scriptType;
        private boolean quoteType;

        public CompoundState(int lexerState, int lexerSubState, int lexerEmbeddingState, String attributeName, String tagName, String scriptType, byte customELIndex, boolean quoteType) {
            this.lexerState = lexerState;
            this.lexerSubState = lexerSubState;
            this.lexerEmbeddingState = lexerEmbeddingState;
            this.attribute = attributeName;
            this.tag = tagName;
            this.scriptType = scriptType;
            this.customELIndex = customELIndex;
            this.quoteType = quoteType;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompoundState other = (CompoundState)obj;
            if (this.lexerState != other.lexerState) {
                return false;
            }
            if (this.lexerSubState != other.lexerSubState) {
                return false;
            }
            if (this.lexerEmbeddingState != other.lexerEmbeddingState) {
                return false;
            }
            if (!(this.attribute == other.attribute || this.attribute != null && this.attribute.equals(other.attribute))) {
                return false;
            }
            if (!(this.tag == other.tag || this.tag != null && this.tag.equals(other.tag))) {
                return false;
            }
            if (!(this.scriptType == other.scriptType || this.scriptType != null && this.scriptType.equals(other.scriptType))) {
                return false;
            }
            if (this.customELIndex != other.customELIndex) {
                return false;
            }
            return this.quoteType == other.quoteType;
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + this.lexerState;
            hash = 17 * hash + this.lexerSubState;
            hash = 17 * hash + this.lexerEmbeddingState;
            hash = 17 * hash + (this.attribute != null ? this.attribute.hashCode() : 0);
            hash = 17 * hash + (this.tag != null ? this.tag.hashCode() : 0);
            hash = 17 * hash + (this.scriptType != null ? this.scriptType.hashCode() : 0);
            if (this.customELIndex > 0) {
                hash = 17 * hash + this.customELIndex;
            }
            switch (this.lexerState) {
                case 17: 
                case 18: 
                case 42: {
                    hash = 17 * hash + (this.quoteType ? 1 : 0);
                }
            }
            return hash;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("HLS(hc=");
            sb.append(this.hashCode());
            sb.append(",s=");
            sb.append(this.lexerState);
            if (this.lexerSubState > 0) {
                sb.append(",ss=");
                sb.append(this.lexerSubState);
            }
            if (this.lexerEmbeddingState > 0) {
                sb.append(",es=");
                sb.append(this.lexerEmbeddingState);
            }
            if (this.tag != null) {
                sb.append(",tag=");
                sb.append(this.tag);
            }
            if (this.attribute != null) {
                sb.append(",attribute=");
                sb.append(this.attribute);
            }
            if (this.scriptType != null) {
                sb.append(",scriptType=");
                sb.append(this.scriptType);
            }
            sb.append(')');
            return sb.toString();
        }
    }
}

