/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.model.JPAHelper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateId;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.ConsistentAccessType;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class IdDefinedInHierarchy {
    public static ErrorDescription apply(HintContext hc) {
        TreePath par;
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        final JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled()) {
            return null;
        }
        TypeElement javaClass = ctx.getJavaClass();
        if (ctx.getModelElement() == null) {
            return null;
        }
        final boolean[] haveId = new boolean[]{false};
        try {
            MetadataModel<EntityMappingsMetadata> model = ModelUtils.getModel(hc.getInfo().getFileObject());
            model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                public Void run(EntityMappingsMetadata metadata) {
                    TypeElement javaClass = ctx.getJavaClass();
                    Object modelElement = ctx.getModelElement();
                    do {
                        Element parent;
                        if (JPAHelper.isAnyMemberAnnotatedAsIdOrEmbeddedId(modelElement)) {
                            haveId[0] = true;
                            return null;
                        }
                        TypeMirror parentType = javaClass.getSuperclass();
                        javaClass = null;
                        if ("java.lang.Object".equals(parentType.toString()) || parentType.getKind() != TypeKind.DECLARED || (parent = ((DeclaredType)parentType).asElement()).getKind() != ElementKind.CLASS || (modelElement = ModelUtils.getEntity(metadata, javaClass = (TypeElement)parent)) != null) continue;
                        modelElement = ModelUtils.getMappedSuperclass(metadata, javaClass);
                    } while (javaClass != null && modelElement != null);
                    return null;
                }
            });
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (haveId[0]) {
            return null;
        }
        CreateId fix = new CreateId(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)javaClass), ctx.getAccessType());
        for (par = hc.getPath(); par != null && par.getParentPath() != null && par.getLeaf().getKind() != Tree.Kind.CLASS; par = par.getParentPath()) {
        }
        Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), par.getLeaf());
        return ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(ConsistentAccessType.class, (String)"MSG_NoIdDefinedInHierarchy"), (Fix[])new Fix[]{fix});
    }
}

