/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.web.jsf.JSFCatalog;
import org.netbeans.modules.web.jsf.JSFConfigEditorContextImpl;
import org.netbeans.modules.web.jsf.JSFConfigEditorSupport;
import org.netbeans.modules.web.jsf.JSFConfigLoader;
import org.netbeans.modules.web.jsf.JSFConfigMultiViewEditorElement;
import org.netbeans.modules.web.jsf.JSFConfigNode;
import org.netbeans.modules.web.jsf.SAXParseError;
import org.netbeans.modules.web.jsf.api.editor.JSFConfigEditorContext;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.xml.api.XmlFileEncodingQueryImpl;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class JSFConfigDataObject
extends MultiDataObject
implements CookieSet.Factory {
    private static final long serialVersionUID = 1L;
    private static JSFCatalog jsfCatalog = new JSFCatalog();
    private boolean documentDirty = true;
    private boolean documentValid = true;
    protected boolean nodeDirty = false;
    private transient InputStream inputStream;
    private transient JSFConfigEditorSupport editorSupport;
    private transient SAXParseError error;
    private transient FacesConfig lastGoodFacesConfig = null;
    public static final String PROP_DOC_VALID = "documentValid";

    public JSFConfigDataObject(FileObject pf, JSFConfigLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        this.init();
    }

    private void init() {
        CookieSet cookies = this.getCookieSet();
        cookies.add(JSFConfigEditorSupport.class, (CookieSet.Factory)this);
        cookies.assign(JSFConfigEditorContext.class, (Object[])new JSFConfigEditorContext[]{new JSFConfigEditorContextImpl(this)});
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        cookies.add((Node.Cookie)new CheckXMLSupport(in));
        cookies.add((Node.Cookie)new ValidateXMLSupport(in));
        cookies.assign(FileEncodingQueryImplementation.class, (Object[])new FileEncodingQueryImplementation[]{XmlFileEncodingQueryImpl.singleton()});
    }

    public static MultiViewEditorElement createXmlMultiViewElement(Lookup context) {
        return new JSFConfigMultiViewEditorElement(context);
    }

    protected synchronized Node createNodeDelegate() {
        return new JSFConfigNode(this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(JSFConfigEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    public synchronized JSFConfigEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new JSFConfigEditorSupport(this);
        }
        return this.editorSupport;
    }

    public FacesConfig getFacesConfig() throws IOException {
        if (this.lastGoodFacesConfig == null) {
            this.parsingDocument();
        }
        return this.lastGoodFacesConfig;
    }

    protected InputStream prepareInputSource() throws IOException {
        if (this.getEditorSupport() != null && this.getEditorSupport().isDocumentLoaded()) {
            return this.getEditorSupport().getInputStream();
        }
        return this.getPrimaryFile().getInputStream();
    }

    protected void closeInputSource() {
        InputStream is = this.inputStream;
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (is == this.inputStream) {
                this.inputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsingDocument() {
        this.error = null;
        try {
            this.error = this.updateNode(this.prepareInputSource());
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            this.setDocumentValid(false);
            return;
        }
        finally {
            this.closeInputSource();
            this.documentDirty = false;
        }
        if (this.error == null) {
            this.setDocumentValid(true);
        } else {
            this.setDocumentValid(false);
        }
        this.setNodeDirty(false);
    }

    public void setDocumentValid(boolean valid) {
        if (this.documentValid != valid) {
            if (valid) {
                this.repairNode();
            }
            this.documentValid = valid;
            this.firePropertyChange(PROP_DOC_VALID, !this.documentValid ? Boolean.TRUE : Boolean.FALSE, this.documentValid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void repairNode() {
        StatusDisplayer.getDefault().setStatusText("");
    }

    private Document getDomDocument(InputStream inputSource) throws SAXParseException {
        try {
            Document doc = GraphManager.createXmlDocument((InputSource)new InputSource(inputSource), (boolean)false, (EntityResolver)jsfCatalog, (ErrorHandler)new J2eeErrorHandler(this));
            return doc;
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), new LocatorImpl());
        }
    }

    protected SAXParseError updateNode(InputStream is) throws IOException {
        return null;
    }

    public boolean isDocumentValid() {
        return this.documentValid;
    }

    public void setDocumentDirty(boolean dirty) {
        this.documentDirty = dirty;
    }

    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    public boolean isNodeDirty() {
        return this.nodeDirty;
    }

    public void setNodeDirty(boolean dirty) {
        this.nodeDirty = dirty;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    protected int associateLookup() {
        return 1;
    }

    private void createSAXParseError(SAXParseException error) {
        this.error = new SAXParseError(error);
    }

    public static class J2eeErrorHandler
    implements ErrorHandler {
        private JSFConfigDataObject dataObject;

        public J2eeErrorHandler(JSFConfigDataObject obj) {
            this.dataObject = obj;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.dataObject.createSAXParseError(exception);
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.dataObject.createSAXParseError(exception);
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.dataObject.createSAXParseError(exception);
            throw exception;
        }
    }
}

