/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbCollections;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public abstract class BrandingSupport {
    private final Project project;
    private Set<BrandableModule> brandedModules;
    private Set<BundleKey> brandedBundleKeys;
    private Set<BundleKey> localizedBrandedBundleKeys;
    private Set<BrandedFile> brandedFiles;
    private final String brandingPath;
    private final File brandingDir;
    private static final String BUNDLE_NAME_PREFIX = "Bundle";
    private static final String BUNDLE_NAME_SUFFIX = ".properties";
    protected Locale locale;
    private final Object LOCK = new Object();
    private SoftReference<Set<BrandableModule>> cacheLoaded;
    private boolean isCached;

    protected BrandingSupport(Project p, String brandingPath) {
        this.project = p;
        this.brandingPath = brandingPath;
        File suiteDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (suiteDir != null && suiteDir.exists());
        this.brandingDir = new File(suiteDir, brandingPath);
    }

    private File getProjectDirectory() {
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    File getBrandingRoot() {
        return new File(this.getProjectDirectory(), this.brandingPath);
    }

    File getModuleEntryDirectory(BrandableModule mEntry) {
        String relativePath = mEntry.getRelativePath();
        return new File(this.getBrandingRoot(), relativePath);
    }

    private File getLocalizingBundle(BrandableModule mEntry) {
        String bundlePath;
        ManifestManager mfm = ManifestManager.getInstanceFromJAR(mEntry.getJarLocation());
        File bundle = null;
        if (mfm != null && (bundlePath = mfm.getLocalizingBundle()) != null) {
            bundle = new File(this.getModuleEntryDirectory(mEntry), bundlePath);
        }
        return bundle;
    }

    boolean isBranded(BundleKey key) {
        boolean retval = this.getBrandedBundleKeys().contains(key);
        return retval;
    }

    boolean isLocalizedBranded(BundleKey key) {
        boolean retval = this.getLocalizedBrandedBundleKeys().contains(key);
        return retval;
    }

    boolean isBranded(BrandedFile bFile) {
        return this.getBrandedFiles().contains(bFile);
    }

    boolean isBranded(BrandableModule entry) {
        boolean retval = this.getBrandedModules().contains(entry);
        assert (retval == this.getModuleEntryDirectory(entry).exists());
        return retval;
    }

    private Set<BrandableModule> getBrandedModules() {
        return this.brandedModules;
    }

    Set<BundleKey> getBrandedBundleKeys() {
        return this.brandedBundleKeys;
    }

    Set<BundleKey> getLocalizedBrandedBundleKeys() {
        return this.localizedBrandedBundleKeys;
    }

    Set<BrandedFile> getBrandedFiles() {
        return this.brandedFiles;
    }

    Set<BundleKey> getLocalizingBundleKeys(String moduleCodeNameBase, Set<String> keys) {
        BrandableModule foundEntry = this.findBrandableModule(moduleCodeNameBase);
        return foundEntry != null ? this.getLocalizingBundleKeys(foundEntry, keys) : null;
    }

    Set<BundleKey> getLocalizedLocalizingBundleKeys(String moduleCodeNameBase, Set<String> keys) {
        BrandableModule foundEntry = this.findBrandableModule(moduleCodeNameBase);
        return foundEntry != null ? this.getLocalizingBundleKeys(foundEntry, keys) : null;
    }

    private Set<BundleKey> getLocalizingBundleKeys(BrandableModule moduleEntry, Set<String> keys) {
        HashSet<BundleKey> retval = new HashSet<BundleKey>();
        Iterator<BundleKey> it = this.getLocalizedBrandedBundleKeys().iterator();
        while (it.hasNext() && retval.size() != keys.size()) {
            BundleKey bKey = it.next();
            if (!keys.contains(bKey.getKey())) continue;
            retval.add(bKey);
        }
        if (retval.size() != keys.size()) {
            this.loadLocalizedBundlesFromPlatform(moduleEntry, keys, retval);
        }
        return retval.size() != keys.size() ? null : retval;
    }

    BrandedFile getBrandedFile(String moduleCodeNameBase, String entryPath) {
        BrandableModule foundEntry = this.findBrandableModule(moduleCodeNameBase);
        return foundEntry != null ? this.getBrandedFile(foundEntry, entryPath) : null;
    }

    private BrandedFile getBrandedFile(BrandableModule moduleEntry, String entryPath) {
        BrandedFile retval = null;
        try {
            retval = new BrandedFile(moduleEntry, entryPath);
            for (BrandedFile bFile : this.getBrandedFiles()) {
                if (!retval.equals(bFile)) continue;
                retval = bFile;
            }
        }
        catch (MalformedURLException ex) {
            retval = null;
        }
        return retval;
    }

    BundleKey getBundleKey(String moduleCodeNameBase, String bundleEntry, String key) {
        Set<BundleKey> keys = this.getBundleKeys(moduleCodeNameBase, bundleEntry, Collections.singleton(key), this.getBrandedBundleKeys());
        return keys == null ? null : (BundleKey)keys.toArray()[0];
    }

    BundleKey getLocalizedBundleKey(String moduleCodeNameBase, String bundleEntry, String key) {
        Set<BundleKey> keys = this.getBundleKeys(moduleCodeNameBase, bundleEntry, Collections.singleton(key), this.getLocalizedBrandedBundleKeys());
        return keys == null ? null : (BundleKey)keys.toArray()[0];
    }

    Set<BundleKey> getBundleKeys(String moduleCodeNameBase, String bundleEntry, Set<String> keys, Set<BundleKey> bundleKeys) {
        BrandableModule foundEntry = this.findBrandableModule(moduleCodeNameBase);
        return foundEntry != null ? this.getBundleKeys(foundEntry, bundleEntry, keys, bundleKeys) : null;
    }

    private Set<BundleKey> getBundleKeys(BrandableModule moduleEntry, String bundleEntry, Set<String> keys, Set<BundleKey> bundleKeys) {
        HashSet<BundleKey> retval = new HashSet<BundleKey>();
        Iterator<BundleKey> it = bundleKeys.iterator();
        while (it.hasNext() && retval.size() != keys.size()) {
            BundleKey bKey = it.next();
            if (!keys.contains(bKey.getKey())) continue;
            retval.add(bKey);
        }
        if (retval.size() != keys.size()) {
            try {
                this.loadLocalizedBundlesFromPlatform(moduleEntry, bundleEntry, keys, retval);
            }
            catch (IOException ex) {
                Logger.getLogger(BrandingSupport.class.getName()).log(Level.WARNING, "#211911", ex);
                return null;
            }
        }
        return retval.size() != keys.size() ? null : retval;
    }

    protected abstract BrandableModule findBrandableModule(String var1);

    protected abstract Set<File> getBrandableJars();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void brandFile(BrandedFile bFile) throws IOException {
        if (!bFile.isModified()) {
            return;
        }
        File target = bFile.getFileLocation();
        if (!target.exists()) {
            target.getParentFile().mkdirs();
            target.createNewFile();
        }
        assert (target.exists());
        FileObject fo = FileUtil.toFileObject((File)target);
        InputStream is = null;
        OutputStream os = null;
        try {
            is = bFile.getBrandingSource().openStream();
            os = fo.getOutputStream();
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            this.brandedFiles.add(bFile);
            bFile.modified = false;
        }
    }

    void brandFile(BrandedFile bFile, Runnable saveTask) throws IOException {
        if (!bFile.isModified()) {
            return;
        }
        saveTask.run();
        this.brandedFiles.add(bFile);
        bFile.modified = false;
    }

    void brandBundleKey(BundleKey bundleKey) throws IOException {
        if (bundleKey == null) {
            return;
        }
        this.brandBundleKeys(Collections.singleton(bundleKey));
    }

    void brandBundleKeys(Set<BundleKey> bundleKeys) throws IOException {
        this.init();
        HashMap<File, EditableProperties> mentryToEditProp = new HashMap<File, EditableProperties>();
        for (BundleKey bundleKey : bundleKeys) {
            if (!bundleKey.isModified()) continue;
            EditableProperties ep = (EditableProperties)mentryToEditProp.get(bundleKey.getBrandingBundle());
            if (ep == null) {
                File bundle = bundleKey.getBrandingBundle();
                if (!bundle.exists()) {
                    bundle.getParentFile().mkdirs();
                    bundle.createNewFile();
                }
                ep = BrandingSupport.getEditableProperties(bundle);
                mentryToEditProp.put(bundleKey.getBrandingBundle(), ep);
            }
            ep.setProperty(bundleKey.getKey(), bundleKey.getValue());
        }
        for (Map.Entry entry : mentryToEditProp.entrySet()) {
            File bundle = (File)entry.getKey();
            assert (bundle.exists());
            BrandingSupport.storeEditableProperties((EditableProperties)entry.getValue(), bundle);
            for (BundleKey bKey : bundleKeys) {
                File bundle2 = bKey.getBrandingBundle();
                if (!bundle2.equals(bundle)) continue;
                this.brandedBundleKeys.add(bKey);
                bKey.modified = false;
                this.brandedModules.add(bKey.getModuleEntry());
            }
        }
    }

    @CheckForNull
    protected abstract Set<BrandableModule> loadModules() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws IOException {
        Set<BrandableModule> loaded = null;
        Object object = this.LOCK;
        synchronized (object) {
            this.isCached = false;
            loaded = this.cacheOrLoadModules();
        }
        if (this.brandedModules == null || loaded != null) {
            this.brandedModules = new HashSet<BrandableModule>();
            this.brandedBundleKeys = new HashSet<BundleKey>();
            this.localizedBrandedBundleKeys = new HashSet<BundleKey>();
            this.brandedFiles = new HashSet<BrandedFile>();
            if (this.brandingDir.exists()) {
                if (this.locale == null) {
                    this.locale = Locale.getDefault();
                }
                assert (this.brandingDir.isDirectory());
                this.scanModulesInBrandingDir(this.brandingDir, loaded);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshLocalizedBundles(Locale locale) throws IOException {
        this.locale = locale;
        Set<BrandableModule> loaded = null;
        Object object = this.LOCK;
        synchronized (object) {
            loaded = this.cacheOrLoadModules();
        }
        if (this.brandedModules == null || loaded != null) {
            this.brandedModules = new HashSet<BrandableModule>();
            this.brandedBundleKeys = new HashSet<BundleKey>();
            this.localizedBrandedBundleKeys = new HashSet<BundleKey>();
            this.brandedFiles = new HashSet<BrandedFile>();
            if (this.brandingDir.exists()) {
                assert (this.brandingDir.isDirectory());
                this.scanModulesInBrandingDir(this.brandingDir, loaded);
            }
        }
    }

    private Set<BrandableModule> cacheOrLoadModules() throws IOException {
        Set<BrandableModule> loaded = null;
        if (this.isCached) {
            Set<BrandableModule> set = loaded = this.cacheLoaded != null ? this.cacheLoaded.get() : null;
        }
        if (loaded == null) {
            loaded = this.loadModules();
            this.cacheLoaded = new SoftReference<Set<BrandableModule>>(loaded);
            this.isCached = true;
        }
        return loaded;
    }

    private void scanModulesInBrandingDir(File srcDir, Set<BrandableModule> platformModules) throws IOException {
        if (srcDir.getName().endsWith(".jar")) {
            BrandableModule foundEntry = null;
            for (BrandableModule platformModule : platformModules) {
                if (!this.isBrandingForModuleEntry(srcDir, platformModule)) continue;
                this.scanBrandedFiles(srcDir, platformModule);
                foundEntry = platformModule;
                break;
            }
            if (foundEntry != null) {
                this.brandedModules.add(foundEntry);
            }
        } else {
            String[] kids = srcDir.list();
            assert (kids != null);
            for (String kidName : kids) {
                File kid = new File(srcDir, kidName);
                if (!kid.isDirectory()) continue;
                this.scanModulesInBrandingDir(kid, platformModules);
            }
        }
    }

    private void scanBrandedFiles(File srcDir, BrandableModule mEntry) throws IOException {
        File defaultBundle;
        String[] kids = srcDir.list();
        assert (kids != null);
        boolean foundLocale = false;
        File kid = null;
        for (String kidName : kids) {
            kid = new File(srcDir, kidName);
            if (!kid.isDirectory()) {
                if (kid.getName().endsWith("Bundle.properties")) {
                    this.loadBundleKeys(mEntry, kid);
                    continue;
                }
                if (kid.getName().endsWith("Bundle_" + this.locale.toString() + BUNDLE_NAME_SUFFIX)) {
                    this.loadLocalizedBundleKeys(mEntry, kid);
                    foundLocale = true;
                    continue;
                }
                this.loadBrandedFiles(mEntry, kid);
                continue;
            }
            this.scanBrandedFiles(kid, mEntry);
        }
        if (!foundLocale && (defaultBundle = new File(srcDir, "Bundle.properties")).exists()) {
            this.loadLocalizedBundleKeys(mEntry, defaultBundle);
        }
    }

    private void loadBundleKeys(BrandableModule mEntry, File bundle) throws IOException {
        EditableProperties p = BrandingSupport.getEditableProperties(bundle);
        for (Map.Entry entry : p.entrySet()) {
            this.brandedBundleKeys.add(new BundleKey(mEntry, bundle, (String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private void loadLocalizedBundleKeys(BrandableModule mEntry, File bundle) throws IOException {
        EditableProperties p = BrandingSupport.getEditableProperties(bundle);
        for (Map.Entry entry : p.entrySet()) {
            this.localizedBrandedBundleKeys.add(new BundleKey(mEntry, bundle, (String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private void loadBrandedFiles(BrandableModule mEntry, File file) throws IOException {
        String entryPath = PropertyUtils.relativizeFile((File)this.getModuleEntryDirectory(mEntry), (File)file);
        BrandedFile bf = new BrandedFile(mEntry, Utilities.toURI((File)file).toURL(), entryPath);
        this.brandedFiles.add(bf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditableProperties getEditableProperties(File bundle) throws IOException {
        EditableProperties p = new EditableProperties(true);
        FileInputStream is = new FileInputStream(bundle);
        try {
            p.load((InputStream)is);
        }
        finally {
            ((InputStream)is).close();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeEditableProperties(EditableProperties p, File bundle) throws IOException {
        FileObject fo = FileUtil.toFileObject((File)bundle);
        OutputStream os = null == fo ? new FileOutputStream(bundle) : fo.getOutputStream();
        try {
            p.store(os);
        }
        finally {
            os.close();
        }
    }

    protected abstract Map<String, String> localizingBundle(BrandableModule var1);

    private void loadLocalizedBundlesFromPlatform(BrandableModule moduleEntry, Set<String> keys, Set<BundleKey> bundleKeys) {
        Map<String, String> p = this.localizingBundle(moduleEntry);
        for (String key : p.keySet()) {
            if (!keys.contains(key)) continue;
            String value = p.get(key);
            bundleKeys.add(new BundleKey(moduleEntry, key, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedBundlesFromPlatform(BrandableModule moduleEntry, String bundleEntry, Set<String> keys, Set<BundleKey> bundleKeys) throws IOException {
        Properties p = new Properties();
        JarFile module = new JarFile(moduleEntry.getJarLocation());
        JarEntry je = module.getJarEntry(bundleEntry);
        InputStream is = module.getInputStream(je);
        File bundle = new File(this.getModuleEntryDirectory(moduleEntry), bundleEntry);
        try {
            p.load(is);
        }
        finally {
            is.close();
        }
        for (String key : NbCollections.checkedMapByFilter((Map)p, String.class, String.class, (boolean)true).keySet()) {
            if (!keys.contains(key)) continue;
            String value = p.getProperty(key);
            bundleKeys.add(new BundleKey(moduleEntry, bundle, key, value));
        }
    }

    BundleKey createModifiedBundleKey(BrandableModule moduleEntry, File brandingBundle, String key, String value) {
        BundleKey bundleKey = new BundleKey(moduleEntry, brandingBundle, key, "");
        bundleKey.setValue(value);
        return bundleKey;
    }

    private boolean isBrandingForModuleEntry(File srcDir, BrandableModule mEntry) {
        return mEntry.getRelativePath().equals(PropertyUtils.relativizeFile((File)this.brandingDir, (File)srcDir));
    }

    public final class BrandedFile {
        private final BrandableModule moduleEntry;
        private final String entryPath;
        @NonNull
        private URL brandingSource;
        private boolean modified = false;

        private BrandedFile(BrandableModule moduleEntry, String entry) throws MalformedURLException {
            this(moduleEntry, null, entry);
        }

        private BrandedFile(BrandableModule moduleEntry, URL source, String entry) throws MalformedURLException {
            this.moduleEntry = moduleEntry;
            this.entryPath = entry;
            if (source == null) {
                this.brandingSource = Utilities.toURI((File)moduleEntry.getJarLocation()).toURL();
                this.brandingSource = new URL("jar:" + this.brandingSource + "!/" + this.entryPath);
            } else {
                this.brandingSource = source;
            }
        }

        File getFileLocation() {
            return new File(BrandingSupport.this.getModuleEntryDirectory(this.moduleEntry), this.entryPath);
        }

        @NonNull
        public URL getBrandingSource() {
            return this.brandingSource;
        }

        public void setBrandingSource(@NonNull URL brandingSource) {
            Parameters.notNull((CharSequence)"brandingSource", (Object)brandingSource);
            if (!Utilities.compareObjects((Object)brandingSource, (Object)this.brandingSource)) {
                this.modified = true;
            }
            this.brandingSource = brandingSource;
        }

        boolean isModified() {
            return this.modified;
        }

        public boolean equals(Object obj) {
            boolean retval = false;
            if (obj instanceof BrandedFile) {
                BrandedFile bFile = (BrandedFile)obj;
                retval = this.moduleEntry.equals(bFile.moduleEntry) && this.entryPath.equals(bFile.entryPath);
            }
            return retval;
        }

        public int hashCode() {
            return 0;
        }
    }

    public final class BundleKey {
        private final File brandingBundle;
        private final BrandableModule moduleEntry;
        @NonNull
        private final String key;
        @NonNull
        private String value;
        private boolean modified = false;

        private BundleKey(BrandableModule moduleEntry, File brandingBundle, String key, String value) {
            this.moduleEntry = moduleEntry;
            assert (key != null && value != null);
            this.key = key;
            this.value = value;
            this.brandingBundle = brandingBundle;
        }

        private BundleKey(BrandableModule mEntry, String key, String value) {
            this(mEntry, brandingSupport.getLocalizingBundle(mEntry), key, value);
        }

        BrandableModule getModuleEntry() {
            return this.moduleEntry;
        }

        @NonNull
        String getKey() {
            return this.key;
        }

        @NonNull
        public String getValue() {
            return this.value;
        }

        public void setValue(@NonNull String value) {
            assert (value != null);
            if (!this.value.equals(value)) {
                this.modified = true;
            }
            this.value = value;
        }

        public boolean equals(Object obj) {
            boolean retval = false;
            if (obj instanceof BundleKey) {
                BundleKey bKey = (BundleKey)obj;
                retval = this.getKey().equals(bKey.getKey()) && this.getModuleEntry().equals(bKey.getModuleEntry()) && this.getBrandingBundle().equals(bKey.getBrandingBundle());
            }
            return retval;
        }

        public int hashCode() {
            return 0;
        }

        boolean isModified() {
            return this.modified;
        }

        private File getBrandingBundle() {
            return this.brandingBundle;
        }

        String getBundleFilePath() {
            return this.brandingBundle.getPath();
        }
    }

    protected static interface BrandableModule {
        public String getCodeNameBase();

        public File getJarLocation();

        public String getRelativePath();
    }
}

