/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.cfg.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.netbeans.modules.hibernate.cfg.model.Security;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HibernateConfiguration
extends BaseBean {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(5, 0, 0);
    private static final String SERIALIZATION_HELPER_CHARSET = "UTF-8";
    public static final String SESSION_FACTORY = "SessionFactory";
    public static final String SECURITY = "Security";

    public HibernateConfiguration() {
        this(null, 1);
    }

    public HibernateConfiguration(Node doc, int options) {
        this(2);
        try {
            this.initFromNode(doc, options);
        }
        catch (Schema2BeansException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initFromNode(Node doc, int options) throws Schema2BeansException {
        if (doc == null && (doc = GraphManager.createRootElementNode((String)"hibernate-configuration")) == null) {
            throw new Schema2BeansException(Common.getMessage((String)"CantCreateDOMRoot_msg", (Object)"hibernate-configuration"));
        }
        Node n = GraphManager.getElementNode((String)"hibernate-configuration", (Node)doc);
        if (n == null) {
            throw new Schema2BeansException(Common.getMessage((String)"DocRootNotInDOMGraph_msg", (Object)"hibernate-configuration", (Object)doc.getFirstChild().getNodeName()));
        }
        this.graphManager.setXmlDocument(doc);
        this.createBean(n, this.graphManager());
        this.initialize(options);
    }

    public HibernateConfiguration(int options) {
        super(comparators, runtimeVersion);
        this.initOptions(options);
    }

    protected void initOptions(int options) {
        this.graphManager = new GraphManager((BaseBean)this);
        this.createRoot("hibernate-configuration", "HibernateConfiguration", 544, HibernateConfiguration.class);
        this.initPropertyTables(2);
        this.createProperty("session-factory", SESSION_FACTORY, 66080, SessionFactory.class);
        this.createAttribute(SESSION_FACTORY, "name", "Name", 513, null, null);
        this.createProperty("security", SECURITY, 66064, Security.class);
        this.createAttribute(SECURITY, "context", "Context", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setSessionFactory(SessionFactory value) {
        this.setValue(SESSION_FACTORY, (Object)value);
    }

    public SessionFactory getSessionFactory() {
        return (SessionFactory)((Object)this.getValue(SESSION_FACTORY));
    }

    public void setSecurity(Security value) {
        this.setValue(SECURITY, (Object)value);
    }

    public Security getSecurity() {
        return (Security)((Object)this.getValue(SECURITY));
    }

    public SessionFactory newSessionFactory() {
        return new SessionFactory();
    }

    public Security newSecurity() {
        return new Security();
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static HibernateConfiguration createGraph(Node doc) {
        return new HibernateConfiguration(doc, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HibernateConfiguration createGraph(File f) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            HibernateConfiguration hibernateConfiguration = HibernateConfiguration.createGraph(in, false);
            return hibernateConfiguration;
        }
    }

    public static HibernateConfiguration createGraph(InputStream in) {
        return HibernateConfiguration.createGraph(in, false);
    }

    public static HibernateConfiguration createGraph(InputStream in, boolean validate) {
        try {
            Document doc = GraphManager.createXmlDocument((InputStream)in, (boolean)validate);
            return HibernateConfiguration.createGraph(doc);
        }
        catch (Exception t) {
            throw new RuntimeException(Common.getMessage((String)"DOMGraphCreateFailed_msg", (Object)t));
        }
    }

    public static HibernateConfiguration createGraph() {
        return new HibernateConfiguration();
    }

    public void validate() throws ValidateException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int MAX_SIZE = 65535;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.write(baos, SERIALIZATION_HELPER_CHARSET);
            byte[] array = baos.toByteArray();
            int numStrings = array.length / 65535;
            int leftover = array.length % 65535;
            out.writeInt(numStrings + (0 == leftover ? 0 : 1));
            out.writeInt(65535);
            int offset = 0;
            for (int i = 0; i < numStrings; ++i) {
                out.writeUTF(new String(array, offset, 65535, SERIALIZATION_HELPER_CHARSET));
                offset += 65535;
            }
            if (leftover > 0) {
                int count = array.length - offset;
                out.writeUTF(new String(array, offset, count, SERIALIZATION_HELPER_CHARSET));
            }
        }
        catch (Schema2BeansException ex) {
            throw new Schema2BeansRuntimeException((Throwable)ex);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            this.init(comparators, runtimeVersion);
            int numStrings = in.readInt();
            int max_size = in.readInt();
            StringBuilder sb = new StringBuilder(numStrings * max_size);
            for (int i = 0; i < numStrings; ++i) {
                sb.append(in.readUTF());
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(sb.toString().getBytes(SERIALIZATION_HELPER_CHARSET));
            Document doc = GraphManager.createXmlDocument((InputStream)bais, (boolean)false);
            this.initOptions(2);
            this.initFromNode(doc, 2);
        }
        catch (Schema2BeansException e) {
            throw new RuntimeException(e);
        }
    }

    public void _setSchemaLocation(String location) {
        if (this.beanProp().getAttrProp("xsi:schemaLocation", true) == null) {
            this.createAttribute("xmlns:xsi", "xmlns:xsi", 513, null, "http://www.w3.org/2001/XMLSchema-instance");
            this.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.createAttribute("xsi:schemaLocation", "xsi:schemaLocation", 513, null, location);
        }
        this.setAttributeValue("xsi:schemaLocation", location);
    }

    public String _getSchemaLocation() {
        if (this.beanProp().getAttrProp("xsi:schemaLocation", true) == null) {
            this.createAttribute("xmlns:xsi", "xmlns:xsi", 513, null, "http://www.w3.org/2001/XMLSchema-instance");
            this.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.createAttribute("xsi:schemaLocation", "xsi:schemaLocation", 513, null, null);
        }
        return this.getAttributeValue("xsi:schemaLocation");
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(SESSION_FACTORY);
        BaseBean n = this.getSessionFactory();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SESSION_FACTORY, 0, str, indent);
        str.append(indent);
        str.append(SECURITY);
        n = this.getSecurity();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SECURITY, 0, str, indent);
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("HibernateConfiguration\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

