/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hqleditor;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.swing.SwingUtilities;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.SAXReader;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.catalog.HibernateCatalog;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.hqleditor.HQLExecutor;
import org.netbeans.modules.hibernate.hqleditor.HQLResult;
import org.netbeans.modules.hibernate.hqleditor.ui.HQLEditorTopComponent;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.xml.sax.EntityResolver;

public class HQLEditorController {
    private Logger logger = Logger.getLogger(HQLEditorController.class.getName());
    private HQLEditorTopComponent editorTopComponent = null;

    public void executeHQLQuery(final String hql, final FileObject configFileObject, final int maxRowCount, final ProgressHandle ph) {
        ArrayList<URL> localResourcesURLList = new ArrayList<URL>();
        try {
            ph.progress(10);
            ph.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionPrepare"));
            final Project project = FileOwnerQuery.getOwner((FileObject)configFileObject);
            HibernateEnvironment env = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
            localResourcesURLList.addAll(env.getProjectClassPath(configFileObject));
            for (FileObject mappingFO : env.getAllHibernateMappingFileObjects()) {
                localResourcesURLList.add(mappingFO.getURL());
            }
            HibernateCfgDataObject hibernateCfgDataObject = null;
            try {
                hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)configFileObject);
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            if (hibernateCfgDataObject != null) {
                JDBCDriver jdbcDriver;
                HibernateConfiguration hCfg = hibernateCfgDataObject.getHibernateConfiguration();
                DatabaseConnection dbConnection = null;
                try {
                    dbConnection = HibernateUtil.getDBConnection(hCfg);
                }
                catch (DatabaseException ex) {
                    // empty catch block
                }
                if (dbConnection != null && (jdbcDriver = dbConnection.getJDBCDriver()) != null) {
                    localResourcesURLList.addAll(Arrays.asList(jdbcDriver.getURLs()));
                }
            }
            ClassLoader customClassLoader = env.getProjectClassLoader(localResourcesURLList.toArray(new URL[0]));
            final ClassLoader defClassLoader = Thread.currentThread().getContextClassLoader();
            Thread t = new Thread(){

                @Override
                public void run() {
                    ClassLoader customClassLoader = Thread.currentThread().getContextClassLoader();
                    HQLExecutor queryExecutor = new HQLExecutor();
                    HQLResult hqlResult = new HQLResult();
                    try {
                        SessionFactory sessionFactory = HQLEditorController.this.processAndConstructSessionFactory(hql, configFileObject, customClassLoader, project);
                        ph.progress(50);
                        ph.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionPassControlToHibernate"));
                        hqlResult = queryExecutor.execute(hql, sessionFactory, maxRowCount, ph);
                        ph.progress(80);
                        ph.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionProcessResults"));
                    }
                    catch (Exception e) {
                        HQLEditorController.this.logger.log(Level.INFO, "Problem in executing HQL", e);
                        hqlResult.getExceptions().add(e);
                    }
                    final HQLResult hqlResult0 = hqlResult;
                    final ClassLoader customClassLoader0 = customClassLoader;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HQLEditorController.this.editorTopComponent.setResult(hqlResult0, customClassLoader0);
                        }
                    });
                    Thread.currentThread().setContextClassLoader(defClassLoader);
                }
            };
            t.setContextClassLoader(customClassLoader);
            t.start();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void init(Node[] activatedNodes) {
        this.editorTopComponent = new HQLEditorTopComponent(this);
        this.editorTopComponent.open();
        this.editorTopComponent.requestActive();
        this.editorTopComponent.setFocusToEditor();
        this.editorTopComponent.fillHibernateConfigurations(activatedNodes);
    }

    public SessionFactory getHibernateSessionFactoryForThisContext(FileObject configFileObject, Set<FileObject> mappingFOList, List<Class> annotatedClassList, ClassLoader customClassLoader) throws Exception {
        AnnotationConfiguration customConfiguration = null;
        try {
            Class<?> configClass = customClassLoader.loadClass("org.hibernate.cfg.AnnotationConfiguration");
            customConfiguration = (AnnotationConfiguration)configClass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Exceptions.printStackTrace((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver((EntityResolver)new HibernateCatalog());
            Document document = saxReader.read(configFileObject.getInputStream());
            Element sessionFactoryElement = document.getRootElement().element("session-factory");
            Iterator mappingIterator = sessionFactoryElement.elementIterator("mapping");
            while (mappingIterator.hasNext()) {
                Element node = (Element)mappingIterator.next();
                this.logger.fine("Removing mapping element ..  " + node);
                node.getParent().remove(node);
            }
            String sessionName = sessionFactoryElement.attributeValue("name");
            if (sessionName != null && !sessionName.trim().equals("")) {
                Properties prop = new Properties();
                Iterator propertyIterator = sessionFactoryElement.elementIterator("property");
                while (propertyIterator.hasNext()) {
                    Element propNode = (Element)propertyIterator.next();
                    if ("hibernate.jndi.class".equals(propNode.attributeValue("name"))) {
                        prop.setProperty("java.naming.factory.initial", propNode.getTextTrim());
                    }
                    if (!"hibernate.jndi.url".equals(propNode.attributeValue("name"))) continue;
                    prop.setProperty("java.naming.provider.url", propNode.getTextTrim());
                }
                try {
                    InitialContext context = new InitialContext(prop);
                    context.bind("dummy", new Object());
                    context.unbind("dummy");
                }
                catch (NamingException namingException) {
                    this.logger.log(Level.INFO, "Incorrect JNDI properties", namingException);
                    throw namingException;
                }
            }
            for (FileObject mappingFO : mappingFOList) {
                this.logger.info("Adding mapping to custom configuration " + mappingFO.getName());
                Element mappingElement = sessionFactoryElement.addElement("mapping");
                File mappingFile = FileUtil.toFile((FileObject)mappingFO);
                mappingElement.addAttribute("file", mappingFile.getAbsolutePath());
            }
            for (Class annotatedPOJO : annotatedClassList) {
                this.logger.info("Adding annotated class to custom configuration " + annotatedPOJO.getName());
                customConfiguration.addAnnotatedClass(annotatedPOJO);
            }
            this.logger.info("configuring custom configuration..");
            customConfiguration.configure(this.getW3CDocument(document));
            return customConfiguration.buildSessionFactory();
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Problem in constructing custom configuration", e);
            throw e;
        }
    }

    private org.w3c.dom.Document getW3CDocument(Document document) {
        try {
            return new DOMWriter().write(document);
        }
        catch (DocumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public SessionFactory processAndConstructSessionFactory(String hql, FileObject configFileObject, ClassLoader customClassLoader, Project project) throws Exception {
        HibernateEnvironment env = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        StringTokenizer hqlTokenizer = new StringTokenizer(hql, " \n\r\f\t(),");
        ArrayList<String> tokenList = new ArrayList<String>();
        while (hqlTokenizer.hasMoreTokens()) {
            tokenList.add(hqlTokenizer.nextToken());
        }
        HashSet<FileObject> matchedMappingFOList = new HashSet<FileObject>();
        ArrayList<FileObject> mappingFOList = new ArrayList<FileObject>();
        Map<FileObject, List<String>> mappingPOJOMap = env.getAllPOJONamesFromConfiguration(configFileObject);
        for (FileObject mappingFO : mappingPOJOMap.keySet()) {
            List<String> pojoNameList = mappingPOJOMap.get(mappingFO);
            this.logger.info("pojoNameList from configuration : ");
            for (String name : pojoNameList) {
                this.logger.info("pojo-name " + name);
            }
            for (String className : pojoNameList) {
                for (String hqlClassName : tokenList) {
                    if (!this.foundClassNameMatch(hqlClassName, className)) continue;
                    Class clazz = this.processMatchingClass(className, customClassLoader, project);
                    this.logger.info("matching classname = " + className);
                    this.logger.info("Got clazz " + clazz);
                    if (clazz == null) continue;
                    matchedMappingFOList.add(mappingFO);
                    mappingFOList.add(mappingFO);
                    this.getRelatedMappings(mappingFO, matchedMappingFOList, mappingPOJOMap);
                    for (FileObject relatedMappingFO : matchedMappingFOList) {
                        List<String> relatedPojoNames = mappingPOJOMap.get(relatedMappingFO);
                        if (relatedPojoNames == null) continue;
                        this.logger.info("Processing relationships from " + relatedMappingFO + " mapping file.");
                        this.logger.info("Related POJOs " + relatedPojoNames);
                        for (String relatedClassName : relatedPojoNames) {
                            Class relatedClazz = this.processMatchingClass(relatedClassName, customClassLoader, project);
                            this.logger.info("Got related POJO clazz " + relatedClazz);
                            if (relatedClazz == null) continue;
                            mappingFOList.add(relatedMappingFO);
                        }
                    }
                }
            }
        }
        List<String> annotatedPOJOClassNameList = env.getAnnotatedPOJOClassNames(configFileObject);
        ArrayList<Class> matchedAnnotatedPOJOClassNameList = new ArrayList<Class>();
        if (annotatedPOJOClassNameList.size() != 0) {
            for (String annotatedClassName : annotatedPOJOClassNameList) {
                for (String hqlClassName : tokenList) {
                    if (!this.foundClassNameMatch(hqlClassName, annotatedClassName)) continue;
                    Class clazz = this.processMatchingClass(annotatedClassName, customClassLoader, project);
                    this.logger.info("matching classname = " + annotatedClassName);
                    this.logger.info("Got clazz " + clazz);
                    if (clazz == null) continue;
                    matchedAnnotatedPOJOClassNameList.add(clazz);
                    List<Class> relatedPOJOClasses = this.getRelatedPOJOClasses(clazz, annotatedPOJOClassNameList, customClassLoader, project);
                    this.logger.info("Related POJO Class list " + relatedPOJOClasses);
                    matchedAnnotatedPOJOClassNameList.addAll(relatedPOJOClasses);
                }
            }
        }
        return this.getHibernateSessionFactoryForThisContext(configFileObject, matchedMappingFOList, matchedAnnotatedPOJOClassNameList, customClassLoader);
    }

    private List<Class> getRelatedPOJOClasses(Class clazz, List<String> annotatedPOJOClassNameList, ClassLoader ccl, Project project) {
        ArrayList<Class> relatedPOJOClasses = new ArrayList<Class>();
        this.getRelatedPOJOClassesByType(clazz, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
        return relatedPOJOClasses;
    }

    private void getRelatedPOJOClassesByType(Class clazz, List<String> annotatedPOJOClassNameList, List<Class> relatedPOJOClasses, ClassLoader ccl, Project project) {
        AnnotationAccessType annotationAccessType = this.findAnnotationAccessType(clazz);
        if (annotationAccessType == AnnotationAccessType.METHOD_TYPE) {
            this.logger.info("Annotation Access type for " + clazz.getName() + " is : METHOD_TYPE");
            this.getRelatedPOJOClassesByMethodType(clazz, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
        } else {
            this.logger.info("Annotation Access type for " + clazz.getName() + " is : FIELD_TYPE");
            this.getRelatedPOJOClassesByFieldType(clazz, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
        }
    }

    private AnnotationAccessType findAnnotationAccessType(Class clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(EmbeddedId.class)) continue;
            return AnnotationAccessType.FIELD_TYPE;
        }
        return AnnotationAccessType.METHOD_TYPE;
    }

    private void getRelatedPOJOClassesByMethodType(Class clazz, List<String> annotatedPOJOClassNameList, List<Class> relatedPOJOClasses, ClassLoader ccl, Project project) {
        for (Method m : clazz.getMethods()) {
            if (!m.isAnnotationPresent(ManyToOne.class) && !m.isAnnotationPresent(OneToOne.class) && !m.isAnnotationPresent(OneToMany.class)) continue;
            this.logger.info("Found relationship in " + m.getName() + " method of " + clazz.getName() + " related POJO.");
            try {
                Class targetEntityClass;
                OneToOne oneToOneAnnotation;
                Class targetEntityClass2;
                ManyToOne manyToOneAnnotation;
                Class targetEntityClass3;
                OneToMany oneToManyAnnotation;
                Class relatedPOJOClass = m.getReturnType();
                if (Collection.class.isAssignableFrom(relatedPOJOClass)) {
                    try {
                        Class returnClassType = (Class)((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments()[0];
                        this.logger.info("Method return type is java.util.Collection");
                        if (!returnClassType.equals(Object.class)) {
                            this.logger.info("Re-assigning related class to " + returnClassType);
                            relatedPOJOClass = returnClassType;
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (Map.class.isAssignableFrom(relatedPOJOClass)) {
                    this.logger.info("Accessor method return type is java.util.Map");
                }
                if (annotatedPOJOClassNameList.contains(relatedPOJOClass.getName())) {
                    this.logger.info("Related POJO Class " + relatedPOJOClass.getName());
                    if (relatedPOJOClasses.contains(relatedPOJOClass)) {
                        this.logger.info("Already processed " + relatedPOJOClass + ". Skipping.");
                        continue;
                    }
                    this.logger.info("adding to related POJO class list " + relatedPOJOClass);
                    relatedPOJOClasses.add(relatedPOJOClass);
                    this.getRelatedPOJOClassesByType(relatedPOJOClass, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
                }
                if ((oneToManyAnnotation = m.getAnnotation(OneToMany.class)) != null && (targetEntityClass3 = oneToManyAnnotation.targetEntity()) != null && !targetEntityClass3.getName().equals("void")) {
                    if (relatedPOJOClasses.contains(targetEntityClass3)) {
                        this.logger.info("Already processed " + targetEntityClass3 + ". Skipping.");
                        continue;
                    }
                    if ((targetEntityClass3 = this.processMatchingClass(targetEntityClass3.getName(), ccl, project)) != null) {
                        this.logger.info("adding to related POJO class list from targetEntity : " + targetEntityClass3);
                        relatedPOJOClasses.add(targetEntityClass3);
                        this.getRelatedPOJOClassesByType(targetEntityClass3, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
                    }
                }
                if ((manyToOneAnnotation = m.getAnnotation(ManyToOne.class)) != null && (targetEntityClass2 = manyToOneAnnotation.targetEntity()) != null && !targetEntityClass2.getName().equals("void")) {
                    if (relatedPOJOClasses.contains(targetEntityClass2)) {
                        this.logger.info("Already processed " + targetEntityClass2 + ". Skipping.");
                        continue;
                    }
                    if ((targetEntityClass2 = this.processMatchingClass(targetEntityClass2.getName(), ccl, project)) != null) {
                        this.logger.info("adding to related POJO class list from targetEntity : " + targetEntityClass2);
                        relatedPOJOClasses.add(targetEntityClass2);
                        this.getRelatedPOJOClassesByType(targetEntityClass2, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
                    }
                }
                if ((oneToOneAnnotation = m.getAnnotation(OneToOne.class)) == null || (targetEntityClass = oneToOneAnnotation.targetEntity()) == null || targetEntityClass.getName().equals("void")) continue;
                if (relatedPOJOClasses.contains(targetEntityClass)) {
                    this.logger.info("Already processed " + targetEntityClass + ". Skipping.");
                    continue;
                }
                if ((targetEntityClass = this.processMatchingClass(targetEntityClass.getName(), ccl, project)) == null) continue;
                this.logger.info("adding to related POJO class list from targetEntity : " + targetEntityClass);
                relatedPOJOClasses.add(targetEntityClass);
                this.getRelatedPOJOClassesByType(targetEntityClass, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.log(Level.INFO, "Accessor method is not annotated", illegalArgumentException);
            }
        }
    }

    private void getRelatedPOJOClassesByFieldType(Class clazz, List<String> annotatedPOJOClassNameList, List<Class> relatedPOJOClasses, ClassLoader ccl, Project project) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ManyToOne.class) && !field.isAnnotationPresent(OneToOne.class) && !field.isAnnotationPresent(OneToMany.class)) continue;
            this.logger.info("Found relationship in " + field.getName() + " field of " + clazz.getName() + " related POJO.");
            try {
                Class targetEntityClass;
                OneToOne oneToOneAnnotation;
                Class targetEntityClass2;
                ManyToOne manyToOneAnnotation;
                Class targetEntityClass3;
                OneToMany oneToManyAnnotation;
                Class relatedPOJOClass = field.getType();
                if (Collection.class.isAssignableFrom(relatedPOJOClass)) {
                    try {
                        Class returnClassType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        this.logger.info("Field type is java.util.Collection");
                        if (!returnClassType.equals(Object.class)) {
                            this.logger.info("Re-assigning related class to " + returnClassType);
                            relatedPOJOClass = returnClassType;
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (Map.class.isAssignableFrom(relatedPOJOClass)) {
                    this.logger.info("Field type is java.util.Map");
                }
                if (annotatedPOJOClassNameList.contains(relatedPOJOClass.getName())) {
                    this.logger.info("Related POJO Class " + relatedPOJOClass.getName());
                    if (relatedPOJOClasses.contains(relatedPOJOClass)) {
                        this.logger.info("Already processed " + relatedPOJOClass + ". Skipping.");
                        continue;
                    }
                    this.logger.info("adding to related POJO class list " + relatedPOJOClass);
                    relatedPOJOClasses.add(relatedPOJOClass);
                    this.getRelatedPOJOClassesByType(relatedPOJOClass, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
                }
                if ((oneToManyAnnotation = field.getAnnotation(OneToMany.class)) != null && (targetEntityClass3 = oneToManyAnnotation.targetEntity()) != null && !targetEntityClass3.getName().equals("void")) {
                    if (relatedPOJOClasses.contains(targetEntityClass3)) {
                        this.logger.info("Already processed " + targetEntityClass3 + ". Skipping.");
                        continue;
                    }
                    if ((targetEntityClass3 = this.processMatchingClass(targetEntityClass3.getName(), ccl, project)) != null) {
                        this.logger.info("adding to related POJO class list from targetEntity : " + targetEntityClass3);
                        relatedPOJOClasses.add(targetEntityClass3);
                        this.getRelatedPOJOClassesByType(targetEntityClass3, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
                    }
                }
                if ((manyToOneAnnotation = field.getAnnotation(ManyToOne.class)) != null && (targetEntityClass2 = manyToOneAnnotation.targetEntity()) != null && !targetEntityClass2.getName().equals("void")) {
                    if (!relatedPOJOClasses.contains(targetEntityClass2)) {
                        if ((targetEntityClass2 = this.processMatchingClass(targetEntityClass2.getName(), ccl, project)) != null) {
                            this.logger.info("adding to related POJO class list from targetEntity : " + targetEntityClass2);
                            relatedPOJOClasses.add(targetEntityClass2);
                            this.getRelatedPOJOClassesByType(targetEntityClass2, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
                        }
                    } else {
                        this.logger.info("Already processed " + targetEntityClass2 + ". Skipping.");
                        continue;
                    }
                }
                if ((oneToOneAnnotation = field.getAnnotation(OneToOne.class)) == null || (targetEntityClass = oneToOneAnnotation.targetEntity()) == null || targetEntityClass.getName().equals("void")) continue;
                if (relatedPOJOClasses.contains(targetEntityClass)) {
                    this.logger.info("Already processed " + targetEntityClass + ". Skipping.");
                    continue;
                }
                if ((targetEntityClass = this.processMatchingClass(targetEntityClass.getName(), ccl, project)) == null) continue;
                this.logger.info("adding to related POJO class list from targetEntity : " + targetEntityClass);
                relatedPOJOClasses.add(targetEntityClass);
                this.getRelatedPOJOClassesByType(targetEntityClass, annotatedPOJOClassNameList, relatedPOJOClasses, ccl, project);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.log(Level.INFO, "Field is not annotated", illegalArgumentException);
            }
        }
    }

    private Set<FileObject> getRelatedMappings(FileObject mappingFO, Set<FileObject> relatedMappings, Map<FileObject, List<String>> mappingPOJOMap) {
        try {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEntityResolver((EntityResolver)new HibernateCatalog());
            Document document = xmlReader.read(FileUtil.toFile((FileObject)mappingFO));
            Iterator classElementIterator = document.getRootElement().elementIterator("class");
            while (classElementIterator.hasNext()) {
                Element classElement = (Element)classElementIterator.next();
                this.logger.info("Processing many-to-one");
                this.processMappingRelationships(classElement.elementIterator("many-to-one"), relatedMappings, mappingPOJOMap);
                this.logger.info("Processing one-to-one");
                this.processMappingRelationships(classElement.elementIterator("one-to-one"), relatedMappings, mappingPOJOMap);
                this.logger.info("Processing set");
                this.processMappingRelationships(classElement.elementIterator("set"), relatedMappings, mappingPOJOMap);
                this.logger.info("Processing idbag");
                this.processMappingRelationships(classElement.elementIterator("idbag"), relatedMappings, mappingPOJOMap);
                this.logger.info("Processing map");
                this.processMappingRelationships(classElement.elementIterator("map"), relatedMappings, mappingPOJOMap);
                this.logger.info("Processing bag");
                this.processMappingRelationships(classElement.elementIterator("bag"), relatedMappings, mappingPOJOMap);
                this.logger.info("Processing list");
                this.processMappingRelationships(classElement.elementIterator("list"), relatedMappings, mappingPOJOMap);
                this.logger.info("Processing array");
                this.processMappingRelationships(classElement.elementIterator("array"), relatedMappings, mappingPOJOMap);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Problem in parsing mapping file for relation", e);
        }
        return relatedMappings;
    }

    private Set<FileObject> processMappingRelationships(Iterator relationshipIterator, Set<FileObject> relatedMappings, Map<FileObject, List<String>> mappingPOJOMap) {
        while (relationshipIterator.hasNext()) {
            FileObject relatedMappingFO;
            Element relationshipElement = (Element)relationshipIterator.next();
            String pojoName = relationshipElement.attributeValue("class");
            if (pojoName == null) {
                Element connectionTypeElement = relationshipElement.element("one-to-many");
                if (connectionTypeElement == null) {
                    connectionTypeElement = relationshipElement.element("composite-element");
                }
                if (connectionTypeElement == null) {
                    connectionTypeElement = relationshipElement.element("one-to-many");
                }
                if (connectionTypeElement == null) {
                    connectionTypeElement = relationshipElement.element("many-to-many");
                }
                if (connectionTypeElement != null) {
                    pojoName = connectionTypeElement.attributeValue("class");
                }
            }
            if ((relatedMappingFO = this.findRelatedMappingFO(pojoName, mappingPOJOMap)) == null || relatedMappings.contains(relatedMappingFO)) continue;
            relatedMappings.add(relatedMappingFO);
            this.getRelatedMappings(relatedMappingFO, relatedMappings, mappingPOJOMap);
        }
        this.logger.info("Related mapping files : " + relatedMappings);
        return relatedMappings;
    }

    private FileObject findRelatedMappingFO(String pojoName, Map<FileObject, List<String>> mappingPOJOMap) {
        for (FileObject mappingFile : mappingPOJOMap.keySet()) {
            List<String> pojoNameList = mappingPOJOMap.get(mappingFile);
            if (!pojoNameList.contains(pojoName)) continue;
            this.logger.info("Related POJO : " + pojoName);
            return mappingFile;
        }
        return null;
    }

    private boolean foundClassNameMatch(String hqlClassName, String className) {
        boolean foundMatch = false;
        if (hqlClassName.indexOf(".") != -1) {
            if (className.endsWith(hqlClassName)) {
                foundMatch = true;
            }
        } else if (className.indexOf(".") == -1) {
            if (className.equals(hqlClassName)) {
                foundMatch = true;
            }
        } else {
            String actualClassName = className.substring(className.lastIndexOf(".") + 1);
            if (actualClassName.equals(hqlClassName)) {
                foundMatch = true;
            }
        }
        return foundMatch;
    }

    private Class processMatchingClass(String className, ClassLoader customClassLoader, Project project) {
        FileObject clazzFO = HibernateUtil.findJavaFileObjectInProject(className, project);
        FileObject buildFolderFO = HibernateUtil.getBuildFO(project);
        if (clazzFO == null || buildFolderFO == null) {
            return null;
        }
        return this.checkAndCompile(className, clazzFO, buildFolderFO, customClassLoader, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class checkAndCompile(String className, FileObject sourceFO, FileObject buildFolderFO, ClassLoader customClassLoader, Project project) {
        Class<?> clazz = null;
        try {
            clazz = customClassLoader.loadClass(className);
            if (clazz != null) {
                this.logger.info("Found pre-existing class. Returning.." + clazz.getName());
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.info("CNF. Processing .. " + className);
            try {
                String biggest;
                JavaCompiler javaCompiler = null;
                ClassLoader orig = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(ClasspathInfo.class.getClassLoader());
                    javaCompiler = ToolProvider.getSystemJavaCompiler();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(orig);
                }
                StandardJavaFileManager fileManager = javaCompiler.getStandardFileManager(null, null, null);
                className = className.replace(".", File.separator);
                File sourceFile = FileUtil.toFile((FileObject)sourceFO);
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(sourceFile));
                ArrayList<File> outputPath = new ArrayList<File>();
                outputPath.add(FileUtil.toFile((FileObject)buildFolderFO));
                ArrayList<File> sourcePath = new ArrayList<File>();
                for (SourceGroup sourceGroup : HibernateUtil.getSourceGroups(project)) {
                    sourcePath.add(FileUtil.toFile((FileObject)sourceGroup.getRootFolder()));
                }
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, outputPath);
                fileManager.setLocation(StandardLocation.CLASS_PATH, this.getProjectClasspath(project, sourceFO));
                fileManager.setLocation(StandardLocation.SOURCE_PATH, sourcePath);
                ArrayList<String> options = new ArrayList<String>();
                options.add("-target");
                String jdkVersion = System.getProperty("java.specification.version");
                if (jdkVersion == null || jdkVersion.equals("")) {
                    jdkVersion = "1.5";
                } else if (SourceVersion.latest().ordinal() < 10 && jdkVersion.compareTo(biggest = "1." + SourceVersion.latest().ordinal()) > 0) {
                    jdkVersion = biggest;
                }
                options.add(jdkVersion);
                Boolean b = javaCompiler.getTask(null, fileManager, null, options, null, compilationUnits).call();
                this.logger.info("b = " + b);
                if (!b.booleanValue()) {
                    FileObject classfileFO = buildFolderFO.getFileObject(className + ".class");
                    if (classfileFO != null && classfileFO.isValid()) {
                        classfileFO.delete();
                    }
                    return clazz;
                }
                try {
                    className = className.replace(File.separator, ".");
                    clazz = customClassLoader.loadClass(className);
                    if (clazz != null) {
                        this.logger.info("Found class after processing. Returning.." + clazz.getName());
                        return clazz;
                    }
                }
                catch (ClassNotFoundException ee) {
                    this.logger.info("CNF after processing.. " + className);
                    Exceptions.printStackTrace((Throwable)ee);
                }
            }
            catch (Exception ee) {
                Exceptions.printStackTrace((Throwable)ee);
            }
        }
        return clazz;
    }

    private List<File> getProjectClasspath(Project project, FileObject sourceFO) {
        ArrayList<File> cpEntries = new ArrayList<File>();
        HibernateEnvironment env = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        List<URL> urls = env.getProjectClassPath(sourceFO);
        for (URL url : urls) {
            String cpEntry = url.getPath();
            cpEntry = cpEntry.replace("file:", "");
            cpEntry = cpEntry.replace("!/", "");
            File f = new File(cpEntry);
            cpEntries.add(f);
        }
        this.logger.info("Adding classpath " + cpEntries);
        return cpEntries;
    }

    private static enum AnnotationAccessType {
        FIELD_TYPE,
        METHOD_TYPE;

    }
}

