/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenWizard;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenWizardHelper;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenerationPanel;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HibernateCodeGenWizardDescriptor
implements WizardDescriptor.Panel,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Logger logger = Logger.getLogger(HibernateCodeGenWizardDescriptor.class.getName());
    private HibernateCodeGenerationPanel component;
    private boolean componentInitialized;
    private WizardDescriptor wizardDescriptor;
    private Project project;
    private String title;

    public HibernateCodeGenWizardDescriptor(Project project, String title) {
        this.project = project;
        this.title = title;
    }

    public HibernateCodeGenerationPanel getComponent() {
        if (this.component == null) {
            this.component = new HibernateCodeGenerationPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public HelpCtx getHelp() {
        return new HelpCtx(HibernateCodeGenWizardDescriptor.class);
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.wizardDescriptor.putProperty("NewFileWizard_Title", (Object)this.title);
        HibernateCodeGenWizardHelper helper = HibernateCodeGenWizard.getHelper(this.wizardDescriptor);
        if (!this.componentInitialized) {
            this.componentInitialized = true;
            this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
            this.getComponent().initialize(this.project, targetFolder);
        }
    }

    public boolean isValid() {
        SourceGroup sourceGroup = this.getComponent().getLocationValue();
        DataObject cfgDataObject = null;
        if (this.getComponent().getConfigurationFile() == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_ConfFileChooser"));
            return false;
        }
        try {
            cfgDataObject = DataObject.find((FileObject)this.getComponent().getConfigurationFile());
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        if (cfgDataObject != null) {
            HibernateCfgDataObject hco = (HibernateCfgDataObject)cfgDataObject;
            HibernateConfiguration config = hco.getHibernateConfiguration();
            String dbDriver = HibernateUtil.getDbConnectionDetails(config, "hibernate.connection.driver_class");
            if (dbDriver == null || "".equals(dbDriver)) {
                dbDriver = HibernateUtil.getDbConnectionDetails(config, "connection.driver_class");
            }
            if (dbDriver == null || "".equals(dbDriver)) {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_No_DB_ConnectionDriver_Exists"));
                return false;
            }
        }
        if (this.getComponent().getRevengFile() == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_RevengFileChooser"));
            return false;
        }
        try {
            this.checkConfig(this.getComponent().getRevengFile());
        }
        catch (HibernateException e) {
            this.logger.log(Level.INFO, "access to hibernate fails.", e);
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_HibernateError", (Object)e.getMessage()));
            return false;
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "access to hibernate fails.", e);
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_HibernateError", (Object)e.toString()));
            return false;
        }
        String packageName = this.getComponent().getPackageName();
        if (sourceGroup == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_JavaTargetChooser_SelectSourceGroup"));
            return false;
        }
        if (packageName.trim().equals("")) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_JavaTargetChooser_CantUseDefaultPackage"));
            return false;
        }
        if (!JavaIdentifiers.isValidPackageName((String)packageName)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_JavaTargetChooser_InvalidPackage"));
            return false;
        }
        if (!SourceGroups.isFolderWritable((SourceGroup)sourceGroup, (String)packageName)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_JavaTargetChooser_UnwritablePackage"));
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    public void storeSettings(Object settings) {
        Object buttonPressed = ((WizardDescriptor)settings).getValue();
        if (buttonPressed.equals(WizardDescriptor.NEXT_OPTION) || buttonPressed.equals(WizardDescriptor.FINISH_OPTION)) {
            HibernateCodeGenWizardHelper helper = HibernateCodeGenWizard.getHelper(this.wizardDescriptor);
            helper.setConfigurationFile(this.getComponent().getConfigurationFile());
            helper.setRevengFile(this.getComponent().getRevengFile());
            helper.setLocation(this.getComponent().getLocationValue());
            helper.setPackageName(this.getComponent().getPackageName());
            helper.setDomainGen(this.getComponent().getChkDomain());
            helper.setHbmGen(this.getComponent().getChkHbm());
            helper.setJavaSyntax(this.getComponent().getChkJava());
            helper.setEjbAnnotation(this.getComponent().getChkEjb());
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.changeSupport.fireChange();
    }

    private void setErrorMessage(String errorMessage) {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConfig(FileObject revengFile) throws Exception {
        JDBCMetaDataConfiguration cfg = null;
        ClassLoader oldClassLoader = null;
        File confFile = FileUtil.toFile((FileObject)this.getComponent().getConfigurationFile());
        try {
            HibernateEnvironment env = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            DataObject confDataObject = DataObject.find((FileObject)this.getComponent().getConfigurationFile());
            HibernateCfgDataObject hco = (HibernateCfgDataObject)confDataObject;
            HibernateConfiguration hibConf = hco.getHibernateConfiguration();
            DatabaseConnection dbconn = HibernateUtil.getDBConnection(hibConf);
            List<URL> urls = env.getProjectClassPath(revengFile);
            if (dbconn != null) {
                dbconn.getJDBCConnection();
                if (dbconn.getJDBCDriver() != null) {
                    urls.addAll(Arrays.asList(dbconn.getJDBCDriver().getURLs()));
                }
            }
            ClassLoader ccl = env.getProjectClassLoader(urls.toArray(new URL[0]));
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ccl);
            try {
                DefaultReverseEngineeringStrategy defaultStrategy;
                cfg = new JDBCMetaDataConfiguration();
                DefaultReverseEngineeringStrategy revStrategy = defaultStrategy = new DefaultReverseEngineeringStrategy();
                OverrideRepository or = new OverrideRepository();
                Configuration c = cfg.configure(confFile);
                or.addFile(FileUtil.toFile((FileObject)revengFile));
                revStrategy = or.getReverseEngineeringStrategy((ReverseEngineeringStrategy)revStrategy);
                ReverseEngineeringSettings settings = new ReverseEngineeringSettings((ReverseEngineeringStrategy)revStrategy);
                settings.setDefaultPackageName("validname");
                defaultStrategy.setSettings(settings);
                revStrategy.setSettings(settings);
                cfg.setReverseEngineeringStrategy(or.getReverseEngineeringStrategy((ReverseEngineeringStrategy)revStrategy));
                cfg.readFromJDBC();
                cfg.buildMappings();
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
        return true;
    }
}

