/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cordova.platforms.spi.SDK;

public class IOSSDK
implements SDK {
    public static final String IOS_BUILD_SDK_PROP = "ios.build.sdk";
    private String name;
    private final String identifier;

    public static Collection<SDK> parse(String output) throws IOException {
        BufferedReader r = new BufferedReader(new StringReader(output));
        Pattern pattern = Pattern.compile("(.*)-sdk(.*)");
        ArrayList<SDK> result = new ArrayList<SDK>();
        String line = null;
        do {
            if ((line = r.readLine()) != null) continue;
            return result;
        } while (!line.startsWith("iOS Simulator SDKs"));
        line = r.readLine();
        while (line != null) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) {
                return result;
            }
            IOSSDK sdk = new IOSSDK(m.group(1).trim(), m.group(2).trim());
            result.add(sdk);
            line = r.readLine();
        }
        return result;
    }

    IOSSDK(String name, String identifier) {
        this.name = name;
        this.identifier = identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return "SDK{name=" + this.name + ", identifier=" + this.identifier + '}';
    }
}

