/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.phpunit.commands.Bundle;
import org.netbeans.modules.php.phpunit.options.PhpUnitOptions;
import org.netbeans.modules.php.phpunit.options.PhpUnitOptionsValidator;
import org.netbeans.modules.php.phpunit.preferences.PhpUnitPreferences;
import org.netbeans.modules.php.phpunit.preferences.PhpUnitPreferencesValidator;
import org.netbeans.modules.php.phpunit.ui.PhpUnitTestGroupsPanel;
import org.netbeans.modules.php.phpunit.ui.customizer.PhpUnitCustomizer;
import org.netbeans.modules.php.spi.testing.run.TestRunException;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;

public final class PhpUnit {
    private static final Logger LOGGER = Logger.getLogger(PhpUnit.class.getName());
    static final ExecutionDescriptor.LineConvertorFactory PHPUNIT_LINE_CONVERTOR_FACTORY = new PhpUnitLineConvertorFactory();
    public static final String SCRIPT_NAME = "phpunit";
    public static final String SCRIPT_NAME_LONG = "phpunit" + FileUtils.getScriptExtension((boolean)true);
    public static final String SCRIPT_NAME_PHAR = "phpunit.phar";
    public static final String TEST_CLASS_SUFFIX = "Test";
    private static final String TEST_FILE_SUFFIX = "Test.php";
    public static final String TEST_METHOD_PREFIX = "test";
    private static final String SUITE_CLASS_SUFFIX = "Suite";
    private static final String SUITE_FILE_SUFFIX = "Suite.php";
    private static final String COLORS_PARAM = "--colors";
    private static final String JUNIT_LOG_PARAM = "--log-junit";
    private static final String FILTER_PARAM = "--filter";
    private static final String COVERAGE_LOG_PARAM = "--coverage-clover";
    private static final String LIST_GROUPS_PARAM = "--list-groups";
    private static final String GROUP_PARAM = "--group";
    private static final String PARAM_SEPARATOR = "--";
    private static final String BOOTSTRAP_PARAM = "--bootstrap";
    private static final String BOOTSTRAP_FILENAME = "bootstrap%s.php";
    private static final String CONFIGURATION_PARAM = "--configuration";
    private static final String CONFIGURATION_FILENAME = "configuration%s.xml";
    private static final List<String> DEFAULT_PARAMS = Arrays.asList("--colors");
    public static final File XML_LOG;
    public static final File COVERAGE_LOG;
    private static final String SUITE_NAME = "NetBeansSuite";
    private static final String SUITE_RUN = "--run=%s";
    private static final String SUITE_PATH_DELIMITER = ";";
    private static final String SUITE_REL_PATH = "phpunit/NetBeansSuite.php";
    private static final String DIRNAME_FILE = ".dirname(__FILE__).'/";
    private static final String PHP_UNIT_GROUPS_PARAM = "phpUnit.groups";
    private static final char DIRECTORY_SEPARATOR = '/';
    public static final Pattern LINE_PATTERN;
    private static volatile File suite;
    private final String phpUnitPath;

    private PhpUnit(String phpUnitPath) {
        assert (phpUnitPath != null);
        this.phpUnitPath = phpUnitPath;
    }

    public static PhpUnit getDefault() throws InvalidPhpExecutableException {
        String error = PhpUnit.validateDefault();
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new PhpUnit(PhpUnitOptions.getInstance().getPhpUnitPath());
    }

    @CheckForNull
    public static PhpUnit getForPhpModule(PhpModule phpModule, boolean showCustomizer) {
        String path;
        if (PhpUnit.validatePhpModule(phpModule) != null) {
            if (showCustomizer) {
                UiUtils.invalidScriptProvided((PhpModule)phpModule, (String)PhpUnitCustomizer.IDENTIFIER, null);
            }
            return null;
        }
        if (PhpUnitPreferences.isPhpUnitEnabled(phpModule)) {
            path = PhpUnitPreferences.getPhpUnitPath(phpModule);
        } else {
            String error = PhpUnit.validateDefault();
            if (error != null) {
                if (showCustomizer) {
                    UiUtils.invalidScriptProvided((String)error, (String)"FrameworksAndTools/PhpUnit");
                }
                return null;
            }
            path = PhpUnitOptions.getInstance().getPhpUnitPath();
        }
        return new PhpUnit(path);
    }

    @CheckForNull
    private static String validateDefault() {
        ValidationResult result = new PhpUnitOptionsValidator().validatePhpUnitPath(PhpUnitOptions.getInstance().getPhpUnitPath()).getResult();
        return PhpUnit.validateResult(result);
    }

    @CheckForNull
    private static String validatePhpModule(PhpModule phpModule) {
        ValidationResult result = new PhpUnitPreferencesValidator().validate(phpModule).getResult();
        return PhpUnit.validateResult(result);
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        }
        return ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
    }

    private static File getNbSuite() {
        if (suite == null) {
            suite = InstalledFileLocator.getDefault().locate(SUITE_REL_PATH, "org.netbeans.modules.php.phpunit", false);
            assert (suite != null) : "Cannot find NB test suite?!";
        }
        return suite;
    }

    @CheckForNull
    public Integer runTests(PhpModule phpModule, TestRunInfo runInfo) throws TestRunException {
        List customTests;
        PhpExecutable phpUnit = this.getExecutable(phpModule);
        if (phpUnit == null) {
            return null;
        }
        List<String> params = this.createParams(true);
        params.add(JUNIT_LOG_PARAM);
        params.add(XML_LOG.getAbsolutePath());
        this.addBootstrap(phpModule, params);
        this.addConfiguration(phpModule, params);
        if (runInfo.isCoverageEnabled()) {
            params.add(COVERAGE_LOG_PARAM);
            params.add(COVERAGE_LOG.getAbsolutePath());
        }
        if (PhpUnitPreferences.getAskForTestGroups(phpModule)) {
            List<String> testGroups = null;
            if (runInfo.isRerun()) {
                List<String> savedGroups;
                testGroups = savedGroups = (List<String>)runInfo.getParameter(PHP_UNIT_GROUPS_PARAM, List.class);
            } else {
                List<String> allTestGroups = this.getTestGroups(phpModule);
                if (allTestGroups != null && (testGroups = PhpUnitTestGroupsPanel.showDialog(allTestGroups, PhpUnitPreferences.getTestGroups(phpModule))) != null) {
                    PhpUnitPreferences.setTestGroups(phpModule, testGroups);
                    runInfo.setParameter(PHP_UNIT_GROUPS_PARAM, testGroups);
                }
            }
            if (testGroups != null && !testGroups.isEmpty()) {
                params.add(GROUP_PARAM);
                params.add(StringUtils.implode(testGroups, (String)","));
            }
        }
        if (!(customTests = runInfo.getCustomTests()).isEmpty()) {
            StringBuilder buffer = new StringBuilder(200);
            buffer.append("%");
            for (TestRunInfo.TestInfo test : customTests) {
                if (buffer.length() > 1) {
                    buffer.append("|");
                }
                buffer.append("\\b");
                buffer.append(test.getName());
                buffer.append("\\b");
            }
            buffer.append("%");
            params.add(FILTER_PARAM);
            params.add(buffer.toString());
        }
        if (PhpUnitPreferences.isCustomSuiteEnabled(phpModule)) {
            params.add(PhpUnitPreferences.getCustomSuitePath(phpModule));
        } else {
            params.add(PhpUnit.getNbSuite().getAbsolutePath());
            params.add(PARAM_SEPARATOR);
            params.add(String.format(SUITE_RUN, this.joinPaths(runInfo.getStartFiles(), SUITE_PATH_DELIMITER)));
        }
        File workingDirectory = this.getWorkingDirectory(phpModule);
        if (workingDirectory != null) {
            phpUnit.workDir(workingDirectory);
        }
        phpUnit.additionalParameters(params);
        try {
            if (runInfo.getSessionType() == TestRunInfo.SessionType.TEST) {
                return phpUnit.runAndWait(this.getDescriptor(), "Running PhpUnit tests...");
            }
            List startFiles = runInfo.getStartFiles();
            assert (startFiles.size() == 1) : "Exactly one file expected for debugging but got " + startFiles;
            return phpUnit.debug((FileObject)startFiles.get(0), this.getDescriptor(), null);
        }
        catch (CancellationException ex) {
            LOGGER.log(Level.FINE, "Test running cancelled", ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            if (PhpUnitPreferences.isPhpUnitEnabled(phpModule)) {
                UiUtils.processExecutionException((ExecutionException)ex, (PhpModule)phpModule, (String)PhpUnitCustomizer.IDENTIFIER);
            } else {
                UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/PhpUnit");
            }
            throw new TestRunException((Throwable)ex);
        }
        return null;
    }

    @CheckForNull
    private List<String> getTestGroups(PhpModule phpModule) throws TestRunException {
        PhpExecutable phpUnit = this.getExecutable(phpModule);
        assert (phpUnit != null);
        File workingDirectory = this.getWorkingDirectory(phpModule);
        if (workingDirectory == null) {
            return null;
        }
        phpUnit.workDir(workingDirectory);
        List<String> params = this.createParams(true);
        this.addBootstrap(phpModule, params);
        this.addConfiguration(phpModule, params);
        params.add(LIST_GROUPS_PARAM);
        params.add(".");
        phpUnit.additionalParameters(params);
        TestGroupsOutputProcessorFactory testGroupsProcessorFactory = new TestGroupsOutputProcessorFactory();
        try {
            phpUnit.runAndWait(this.getDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)testGroupsProcessorFactory, "Fetching test groups...");
            if (!testGroupsProcessorFactory.hasTestGroups() && testGroupsProcessorFactory.hasOutput) {
                throw new TestRunException("Test groups cannot be listed. Review Output window for details.");
            }
            return testGroupsProcessorFactory.getTestGroups();
        }
        catch (CancellationException ex) {
            LOGGER.log(Level.FINE, "Test groups getting cancelled", ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/PhpUnit");
            throw new TestRunException((Throwable)ex);
        }
        return null;
    }

    @CheckForNull
    private PhpExecutable getExecutable(PhpModule phpModule) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            org.netbeans.modules.php.phpunit.ui.UiUtils.warnNoSources(phpModule.getDisplayName());
            return null;
        }
        return new PhpExecutable(this.phpUnitPath).optionsSubcategory("FrameworksAndTools/PhpUnit").displayName(Bundle.PhpUnit_run_title(phpModule.getDisplayName()));
    }

    private List<String> createParams(boolean withDefaults) {
        ArrayList<String> params = new ArrayList<String>();
        if (withDefaults) {
            params.addAll(DEFAULT_PARAMS);
        }
        return params;
    }

    private void addBootstrap(PhpModule phpModule, List<String> params) {
        if (PhpUnitPreferences.isBootstrapEnabled(phpModule)) {
            params.add(BOOTSTRAP_PARAM);
            params.add(PhpUnitPreferences.getBootstrapPath(phpModule));
        }
    }

    private void addConfiguration(PhpModule phpModule, List<String> params) {
        if (PhpUnitPreferences.isConfigurationEnabled(phpModule)) {
            params.add(CONFIGURATION_PARAM);
            params.add(PhpUnitPreferences.getConfigurationPath(phpModule));
        }
    }

    private ExecutionDescriptor getDescriptor() {
        return new ExecutionDescriptor().optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/PhpUnit").outConvertorFactory(PHPUNIT_LINE_CONVERTOR_FACTORY).preExecution(new Runnable(){

            @Override
            public void run() {
                PhpUnit.this.cleanupLogFiles();
            }
        });
    }

    @CheckForNull
    private File getWorkingDirectory(PhpModule phpModule) {
        if (PhpUnitPreferences.isConfigurationEnabled(phpModule)) {
            return new File(PhpUnitPreferences.getConfigurationPath(phpModule)).getParentFile();
        }
        FileObject testDirectory = phpModule.getTestDirectory(null);
        if (testDirectory == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)testDirectory);
    }

    void cleanupLogFiles() {
        if (XML_LOG.exists() && !XML_LOG.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete PHPUnit log {0}", XML_LOG);
        }
        if (COVERAGE_LOG.exists() && !COVERAGE_LOG.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete code coverage log {0}", COVERAGE_LOG);
        }
    }

    private String joinPaths(List<FileObject> startFiles, String delimiter) {
        StringBuilder builder = new StringBuilder(200);
        for (FileObject startFile : startFiles) {
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            builder.append(FileUtil.toFile((FileObject)startFile).getAbsolutePath());
        }
        return builder.toString();
    }

    public static boolean isTestFile(String fileName) {
        return !fileName.equals(TEST_FILE_SUFFIX) && fileName.endsWith(TEST_FILE_SUFFIX);
    }

    public static boolean isTestClass(String className) {
        return !className.equals(TEST_CLASS_SUFFIX) && className.endsWith(TEST_CLASS_SUFFIX);
    }

    public static boolean isTestMethod(String methodName) {
        return !methodName.equals(TEST_METHOD_PREFIX) && methodName.startsWith(TEST_METHOD_PREFIX);
    }

    public static boolean isSuiteFile(String fileName) {
        return !fileName.equals(SUITE_FILE_SUFFIX) && fileName.endsWith(SUITE_FILE_SUFFIX);
    }

    public static boolean isSuiteClass(String className) {
        return !className.equals(SUITE_CLASS_SUFFIX) && className.endsWith(SUITE_CLASS_SUFFIX);
    }

    public static boolean isTestOrSuiteFile(String fileName) {
        return PhpUnit.isTestFile(fileName) || PhpUnit.isSuiteFile(fileName);
    }

    public static boolean isTestOrSuiteClass(String className) {
        return PhpUnit.isTestClass(className) || PhpUnit.isSuiteClass(className);
    }

    public static String getTestedClass(String testOrSuiteClass) {
        assert (PhpUnit.isTestOrSuiteClass(testOrSuiteClass)) : "Not Test or Suite class: " + testOrSuiteClass;
        int lastIndexOf = -1;
        if (PhpUnit.isTestClass(testOrSuiteClass)) {
            lastIndexOf = testOrSuiteClass.lastIndexOf(TEST_CLASS_SUFFIX);
        } else if (PhpUnit.isSuiteClass(testOrSuiteClass)) {
            lastIndexOf = testOrSuiteClass.lastIndexOf(SUITE_CLASS_SUFFIX);
        }
        assert (lastIndexOf != -1);
        return testOrSuiteClass.substring(0, lastIndexOf);
    }

    public static String makeTestFile(String testedFileName) {
        return testedFileName + TEST_FILE_SUFFIX;
    }

    public static String makeTestClass(String testedClass) {
        return testedClass + TEST_CLASS_SUFFIX;
    }

    public static String makeSuiteFile(String testedFileName) {
        return testedFileName + SUITE_FILE_SUFFIX;
    }

    public static String makeSuiteClass(String testedClass) {
        return testedClass + SUITE_CLASS_SUFFIX;
    }

    public static File createBootstrapFile(final PhpModule phpModule) {
        assert (!phpModule.getTestDirectories().isEmpty()) : "Test directory must already be set";
        FileObject testDirectory = (FileObject)phpModule.getTestDirectories().get(0);
        final FileObject configFile = FileUtil.getConfigFile((String)"Templates/Scripting/Tests/PHPUnitBootstrap.php");
        final DataFolder dataFolder = DataFolder.findFolder((FileObject)testDirectory);
        final File bootstrapFile = new File(PhpUnit.getBootstrapFilepath(testDirectory));
        final File[] files = new File[1];
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DataObject dataTemplate = DataObject.find((FileObject)configFile);
                    DataObject bootstrap = dataTemplate.createFromTemplate(dataFolder, bootstrapFile.getName() + "~");
                    assert (bootstrap != null);
                    PhpUnit.moveAndAdjustBootstrap(phpModule, FileUtil.toFile((FileObject)bootstrap.getPrimaryFile()), bootstrapFile);
                    assert (bootstrapFile.isFile());
                    files[0] = bootstrapFile;
                    PhpUnit.informAboutGeneratedFile(bootstrapFile.getName());
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Cannot create PHPUnit bootstrap file", ex);
                }
            }
        });
        if (files[0] == null) {
            PhpUnit.warnAboutNotGeneratedFile(bootstrapFile.getName());
        }
        return files[0];
    }

    private static void moveAndAdjustBootstrap(PhpModule phpModule, File tmpBootstrap, File finalBootstrap) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpBootstrap), "UTF-8"));
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(finalBootstrap), "UTF-8"));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.contains("%INCLUDE_PATH%")) {
                    if (line.startsWith("//")) continue;
                    List includePath = ((PhpModuleProperties.Factory)phpModule.getLookup().lookup(PhpModuleProperties.Factory.class)).getProperties().getIncludePath();
                    assert (includePath != null) : "Include path should be always present";
                    line = PhpUnit.processIncludePath(finalBootstrap, line, includePath, FileUtil.toFile((FileObject)phpModule.getProjectDirectory()));
                }
                out.write(line);
                out.newLine();
            }
            out.flush();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        if (!tmpBootstrap.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete temporary file {0}", tmpBootstrap);
            tmpBootstrap.deleteOnExit();
        }
        FileUtil.refreshFor((File[])new File[]{finalBootstrap.getParentFile()});
    }

    static String processIncludePath(File bootstrap, String line, List<String> includePath, File projectDir) {
        String resolvedIncludePath = "";
        if (!includePath.isEmpty()) {
            StringBuilder buffer = new StringBuilder(200);
            for (String path : includePath) {
                File reference = PropertyUtils.resolveFile((File)projectDir, (String)path);
                buffer.append(".PATH_SEPARATOR");
                buffer.append(PhpUnit.getDirnameFile(bootstrap, reference));
            }
            resolvedIncludePath = buffer.toString();
        } else {
            line = "//" + line;
        }
        line = line.replace("%INCLUDE_PATH%", resolvedIncludePath);
        return line;
    }

    public static File createConfigurationFile(PhpModule phpModule) {
        assert (!phpModule.getTestDirectories().isEmpty()) : "Test directory must already be set";
        FileObject testDirectory = (FileObject)phpModule.getTestDirectories().get(0);
        FileObject configFile = FileUtil.getConfigFile((String)"Templates/Scripting/Tests/PHPUnitConfiguration.xml");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)testDirectory);
        File configurationFile = new File(PhpUnit.getConfigurationFilepath(testDirectory));
        File file = null;
        try {
            DataObject dataTemplate = DataObject.find((FileObject)configFile);
            DataObject configuration = dataTemplate.createFromTemplate(dataFolder, configurationFile.getName().replace(".xml", ""));
            assert (configuration != null);
            file = configurationFile;
            PhpUnit.informAboutGeneratedFile(configurationFile.getName());
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Cannot create PHPUnit configuration file", ex);
        }
        if (file == null) {
            PhpUnit.warnAboutNotGeneratedFile(configurationFile.getName());
            return null;
        }
        FileUtil.refreshFor((File[])new File[]{file.getParentFile()});
        return file;
    }

    public static void informAboutGeneratedFile(String generatedFile) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.PhpUnit_generating_success(generatedFile)));
    }

    private static void warnAboutNotGeneratedFile(String file) {
        NotifyDescriptor.Message warning = new NotifyDescriptor.Message((Object)Bundle.PhpUnit_generating_failure(file), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)warning);
    }

    private static String getDirnameFile(File testFile, File sourceFile) {
        return PhpUnit.getRelPath(testFile, sourceFile, ".'", DIRNAME_FILE, "'");
    }

    private static String getRelPath(File testFile, File sourceFile, String absolutePrefix, String relativePrefix, String suffix) {
        return PhpUnit.getRelPath(testFile, sourceFile, absolutePrefix, relativePrefix, suffix, false);
    }

    static String getRelPath(File testFile, File sourceFile, String absolutePrefix, String relativePrefix, String suffix, boolean forceAbsolute) {
        File parentFile = testFile.getParentFile();
        String relPath = PropertyUtils.relativizeFile((File)parentFile, (File)sourceFile);
        relPath = relPath == null || forceAbsolute ? absolutePrefix + sourceFile.getAbsolutePath() + suffix : relativePrefix + relPath + suffix;
        return relPath.replace(File.separatorChar, '/');
    }

    private static String getBootstrapFilepath(FileObject testDirectory) {
        return PhpUnit.getFilepath(testDirectory, BOOTSTRAP_FILENAME);
    }

    private static String getConfigurationFilepath(FileObject testDirectory) {
        return PhpUnit.getFilepath(testDirectory, CONFIGURATION_FILENAME);
    }

    private static String getFilepath(FileObject testDirectory, String filename) {
        assert (testDirectory != null) : "Test directory must already be set";
        File tests = FileUtil.toFile((FileObject)testDirectory);
        File file = null;
        int i = 0;
        while ((file = new File(tests, PhpUnit.getFilename(filename, i++))).isFile()) {
        }
        assert (!file.isFile());
        return file.getAbsolutePath();
    }

    private static String getFilename(String filename, int i) {
        return String.format(filename, i == 0 ? "" : Integer.valueOf(i));
    }

    static {
        LINE_PATTERN = Pattern.compile("(?:.+\\(\\) )?(.+):(\\d+)");
        String logDirName = System.getProperty("java.io.tmpdir");
        String userLogDirName = System.getProperty("nb.php.phpunit.logdir");
        if (userLogDirName != null) {
            LOGGER.log(Level.INFO, "Custom directory for PhpUnit logs provided: {0}", userLogDirName);
            File userLogDir = new File(userLogDirName);
            if (userLogDir.isDirectory() && FileUtils.isDirectoryWritable((File)userLogDir)) {
                logDirName = userLogDirName;
            } else {
                LOGGER.log(Level.WARNING, "Directory for PhpUnit logs {0} is not writable directory", userLogDirName);
            }
        }
        LOGGER.log(Level.FINE, "Directory for PhpUnit logs: {0}", logDirName);
        XML_LOG = new File(logDirName, "nb-phpunit-log.xml");
        COVERAGE_LOG = new File(logDirName, "nb-phpunit-coverage.xml");
    }

    private static final class TestGroupsOutputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory2 {
        private final Pattern testGroupName = Pattern.compile("^\\s-\\s(.*)$");
        private final List<String> testGroups = Collections.synchronizedList(new ArrayList());
        private volatile boolean hasOutput = false;

        private TestGroupsOutputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String line) {
                    TestGroupsOutputProcessorFactory.this.hasOutput = true;
                    Matcher matcher = TestGroupsOutputProcessorFactory.this.testGroupName.matcher(line);
                    if (matcher.matches()) {
                        TestGroupsOutputProcessorFactory.this.testGroups.add(matcher.group(1).trim());
                    }
                }

                public void reset() {
                }

                public void close() {
                }
            });
        }

        public List<String> getTestGroups() {
            return this.testGroups;
        }

        public boolean hasTestGroups() {
            return !this.testGroups.isEmpty();
        }

        public boolean hasOutput() {
            return this.hasOutput;
        }
    }

    static final class PhpUnitLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        PhpUnitLineConvertorFactory() {
        }

        public LineConvertor newLineConvertor() {
            return LineConvertors.filePattern(null, (Pattern)LINE_PATTERN, null, (int)1, (int)2);
        }
    }
}

