/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.run;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.phpunit.run.TestCaseVo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class TestSuiteVo {
    private final List<TestCaseVo> testCases = new ArrayList<TestCaseVo>();
    private final String name;
    private final String file;
    private final long time;

    public TestSuiteVo(String name, String file, long time) {
        assert (name != null);
        assert (file != null);
        this.name = name;
        this.file = file;
        this.time = time;
    }

    void addTestCase(TestCaseVo testCase) {
        this.testCases.add(testCase);
    }

    public String getName() {
        return this.name;
    }

    public String getFile() {
        return this.file;
    }

    public FileObject getLocation() {
        if (this.file == null) {
            return null;
        }
        File f = new File(this.file);
        if (!f.isFile()) {
            return null;
        }
        return FileUtil.toFileObject((File)f);
    }

    public List<TestCaseVo> getPureTestCases() {
        return this.testCases;
    }

    public List<TestCaseVo> getTestCases() {
        return this.sanitizedTestCases();
    }

    public long getTime() {
        return this.time;
    }

    private List<TestCaseVo> sanitizedTestCases() {
        if (!this.testCases.isEmpty()) {
            return this.testCases;
        }
        return Collections.singletonList(TestCaseVo.skippedTestCase());
    }

    public String toString() {
        return String.format("TestSuiteVo{name: %s, file: %s, time: %d, cases: %d}", this.name, this.file, this.time, this.testCases.size());
    }
}

