/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;

public abstract class AbstractDatabaseCollector
implements DatabaseCollector {
    private Map oneToManyCandidates;
    protected final Map suggestedIdentifierStrategies = new HashMap();
    private MetaDataDialect metaDataDialect;

    public AbstractDatabaseCollector(MetaDataDialect metaDataDialect) {
        this.metaDataDialect = metaDataDialect;
    }

    @Override
    public void setOneToManyCandidates(Map oneToManyCandidates) {
        this.oneToManyCandidates = oneToManyCandidates;
    }

    @Override
    public Map getOneToManyCandidates() {
        return this.oneToManyCandidates;
    }

    @Override
    public String getSuggestedIdentifierStrategy(String catalog, String schema, String name) {
        TableIdentifier identifier = new TableIdentifier(catalog, schema, name);
        return (String)this.suggestedIdentifierStrategies.get(identifier);
    }

    @Override
    public void addSuggestedIdentifierStrategy(String catalog, String schema, String name, String idstrategy) {
        TableIdentifier identifier = new TableIdentifier(catalog, schema, name);
        this.suggestedIdentifierStrategies.put(identifier, idstrategy);
    }

    protected String quote(String name) {
        if (name == null) {
            return name;
        }
        if (this.metaDataDialect.needQuote(name)) {
            if (name.length() > 1 && name.charAt(0) == '`' && name.charAt(name.length() - 1) == '`') {
                return name;
            }
            return "`" + name + "`";
        }
        return name;
    }
}

