/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.api.client.WsCompileClientEditorSupport;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class J2SEProjectJaxRpcClientSupport
implements WebServicesClientSupportImpl {
    private static final String JAX_RPC_NAMESPACE = "http://www.netbeans.org/ns/j2se-project/jax-rpc";
    private Project project;
    private String proxyHost;
    private String proxyPort;
    public static final String WSDL_FOLDER = "wsdl";
    private static final String[] WSCOMPILE_CLIENT_FEATURES = new String[]{"datahandleronly", "explicitcontext", "jaxbenumtype", "nodatabinding", "noencodedtypes", "nomultirefs", "norpcstructures", "novalidation", "resolveidref", "searchschema", "serializeinterfaces", "strict", "wsi", "unwrap", "donotoverride", "donotunwrap"};
    private static final List allClientFeatures = Arrays.asList(WSCOMPILE_CLIENT_FEATURES);
    private static final String[] WSCOMPILE_KEY_CLIENT_FEATURES = new String[]{"wsi", "strict", "norpcstructures", "unwrap", "donotunwrap", "donotoverride", "datahandleronly", "nodatabinding", "novalidation", "searchschema"};
    private static final List importantClientFeatures = Arrays.asList(WSCOMPILE_KEY_CLIENT_FEATURES);
    private static final JAXRPCClientStubDescriptor jaxrpcClientStub = new JAXRPCClientStubDescriptor("jaxrpc_static_client", NbBundle.getMessage(J2SEProjectJaxRpcClientSupport.class, (String)"LBL_JAXRPCStaticClientStub"), new String[]{"wsi", "strict"});
    private static final String PROXY_HOST_OPTION = "-Dhttp.proxyHost";
    private static final String PROXY_PORT_OPTION = "-Dhttp.proxyPort";
    private static final String NON_PROXY_HOSTS_OPTION = "-Dhttp.nonProxyHosts";
    private static final String RUN_JVM_ARGS = "run.jvmargs";
    private static final DocumentBuilder db;

    public J2SEProjectJaxRpcClientSupport(Project project) {
        this.project = project;
    }

    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor) {
        this.addServiceClient(serviceName, packageName, sourceUrl, configFile, stubDescriptor, null);
    }

    public void addServiceClient(final String serviceName, final String packageName, final String sourceUrl, FileObject configFile, final ClientStubDescriptor stubDescriptor, final String[] wscompileFeatures) {
        boolean needToSave = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                String packagePropertyName;
                String oldPackageName;
                String oldFeatures;
                Document doc;
                boolean needsSave = false;
                boolean modifiedProjectProperties = false;
                boolean modifiedPrivateProperties = false;
                AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration((Project)J2SEProjectJaxRpcClientSupport.this.project);
                Element clientElements = aux.getConfigurationFragment("web-service-clients", J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, true);
                if (clientElements == null) {
                    doc = J2SEProjectJaxRpcClientSupport.createNewDocument();
                    Element root = doc.createElementNS(J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, "web-service-clients");
                    aux.putConfigurationFragment(root, true);
                    clientElements = aux.getConfigurationFragment("web-service-clients", J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, true);
                }
                doc = clientElements.getOwnerDocument();
                boolean serviceAlreadyAdded = false;
                NodeList clientNameList = clientElements.getElementsByTagNameNS(J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, "web-service-client-name");
                for (int i = 0; i < clientNameList.getLength(); ++i) {
                    Node n;
                    Element clientNameElement = (Element)clientNameList.item(i);
                    NodeList nl = clientNameElement.getChildNodes();
                    if (nl.getLength() < 1 || 3 != (n = nl.item(0)).getNodeType() || !serviceName.equalsIgnoreCase(n.getNodeValue())) continue;
                    serviceAlreadyAdded = true;
                }
                if (!serviceAlreadyAdded) {
                    Element clientElement = doc.createElementNS(J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, "web-service-client");
                    clientElements.appendChild(clientElement);
                    Element clientElementName = doc.createElementNS(J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, "web-service-client-name");
                    clientElement.appendChild(clientElementName);
                    clientElementName.appendChild(doc.createTextNode(serviceName));
                    Element clientElementStubType = doc.createElementNS(J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, "web-service-stub-type");
                    clientElement.appendChild(clientElementStubType);
                    clientElementStubType.appendChild(doc.createTextNode(stubDescriptor.getName()));
                    Element clientElementSourceUrl = doc.createElementNS(J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, "client-source-url");
                    clientElement.appendChild(clientElementSourceUrl);
                    clientElementSourceUrl.appendChild(doc.createTextNode(sourceUrl));
                    aux.putConfigurationFragment(clientElements, true);
                    needsSave = true;
                }
                EditableProperties projectProperties = null;
                EditableProperties privateProperties = null;
                try {
                    projectProperties = WSUtils.getEditableProperties((Project)J2SEProjectJaxRpcClientSupport.this.project, (String)"nbproject/project.properties");
                    privateProperties = WSUtils.getEditableProperties((Project)J2SEProjectJaxRpcClientSupport.this.project, (String)"nbproject/private/private.properties");
                }
                catch (IOException ex) {
                    // empty catch block
                }
                assert (projectProperties != null && privateProperties != null);
                String featurePropertyName = "wscompile.client." + serviceName + ".features";
                String defaultFeatures = "wsi, strict";
                if (stubDescriptor instanceof JAXRPCClientStubDescriptor) {
                    JAXRPCClientStubDescriptor stubDesc = (JAXRPCClientStubDescriptor)stubDescriptor;
                    if (wscompileFeatures != null) {
                        stubDesc.setDefaultFeatures(wscompileFeatures);
                    }
                    defaultFeatures = stubDesc.getDefaultFeaturesAsArgument();
                }
                if (!defaultFeatures.equals(oldFeatures = projectProperties.getProperty(featurePropertyName))) {
                    projectProperties.put(featurePropertyName, defaultFeatures);
                    modifiedProjectProperties = true;
                }
                if (!packageName.equals(oldPackageName = projectProperties.getProperty(packagePropertyName = "wscompile.client." + serviceName + ".package"))) {
                    projectProperties.put(packagePropertyName, packageName);
                    modifiedProjectProperties = true;
                }
                if (J2SEProjectJaxRpcClientSupport.this.proxyHost != null && J2SEProjectJaxRpcClientSupport.this.proxyHost.length() > 0) {
                    String oldProxyProperty;
                    String proxyProperty;
                    boolean modif = J2SEProjectJaxRpcClientSupport.this.addJVMProxyOptions(projectProperties, J2SEProjectJaxRpcClientSupport.this.proxyHost, J2SEProjectJaxRpcClientSupport.this.proxyPort);
                    if (modif) {
                        modifiedProjectProperties = true;
                    }
                    if (!(proxyProperty = "wscompile.client." + serviceName + ".proxy").equals(oldProxyProperty = privateProperties.getProperty(proxyProperty))) {
                        privateProperties.put(proxyProperty, J2SEProjectJaxRpcClientSupport.this.proxyHost + ":" + (J2SEProjectJaxRpcClientSupport.this.proxyPort == null ? "8080" : J2SEProjectJaxRpcClientSupport.this.proxyPort));
                        modifiedPrivateProperties = true;
                    }
                }
                if (modifiedProjectProperties) {
                    try {
                        WSUtils.storeEditableProperties((Project)J2SEProjectJaxRpcClientSupport.this.project, (String)"nbproject/project.properties", (EditableProperties)projectProperties);
                        needsSave = true;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (modifiedPrivateProperties) {
                    try {
                        WSUtils.storeEditableProperties((Project)J2SEProjectJaxRpcClientSupport.this.project, (String)"nbproject/private/private.properties", (EditableProperties)privateProperties);
                        needsSave = true;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (J2SEProjectJaxRpcClientSupport.this.updateWsCompileProperties(serviceName)) {
                    needsSave = true;
                }
                return needsSave;
            }
        });
        if (needToSave) {
            try {
                ProjectManager.getDefault().saveProject(this.project);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEProjectJaxRpcClientSupport.class, (String)"MSG_ErrorSavingOnWSClientAdd", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }

    public void addInfrastructure(String implBeanClass, FileObject pkg) {
    }

    public FileObject getDeploymentDescriptor() {
        return null;
    }

    private boolean updateWsCompileProperties(String serviceName) {
        boolean globalPropertiesChanged = false;
        EditableProperties globalProperties = PropertyUtils.getGlobalProperties();
        if (globalProperties.getProperty("wscompile.tools.classpath") == null) {
            globalProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            try {
                PropertyUtils.putGlobalProperties((EditableProperties)globalProperties);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEProjectJaxRpcClientSupport.class, (String)"MSG_ErrorSavingGlobalProperties", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            globalPropertiesChanged = true;
        }
        boolean projectPropertiesChanged = false;
        EditableProperties projectProperties = null;
        try {
            projectProperties = WSUtils.getEditableProperties((Project)this.project, (String)"nbproject/project.properties");
        }
        catch (IOException ex) {
            // empty catch block
        }
        boolean newWscJars = false;
        String wscClientClasspath = projectProperties.getProperty("wscompile.classpath");
        if (wscClientClasspath == null) {
            wscClientClasspath = "${wscompile.tools.classpath}:${javac.classpath}";
            projectProperties.put("wscompile.classpath", wscClientClasspath);
            projectPropertiesChanged = true;
        }
        if (projectProperties.getProperty("wscompile.tools.classpath") == null) {
            projectProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            projectPropertiesChanged = true;
        }
        if (projectPropertiesChanged) {
            try {
                WSUtils.storeEditableProperties((Project)this.project, (String)"nbproject/project.properties", (EditableProperties)projectProperties);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return globalPropertiesChanged || projectPropertiesChanged;
    }

    public void removeServiceClient(final String serviceName) {
        boolean needToSave = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                AuxiliaryConfiguration aux;
                Element clientElements;
                boolean needsSave = false;
                boolean needsSave1 = false;
                String featureProperty = "wscompile.client." + serviceName + ".features";
                String packageProperty = "wscompile.client." + serviceName + ".package";
                String proxyProperty = "wscompile.client." + serviceName + ".proxy";
                EditableProperties ep = null;
                EditableProperties ep1 = null;
                try {
                    ep = WSUtils.getEditableProperties((Project)J2SEProjectJaxRpcClientSupport.this.project, (String)"nbproject/project.properties");
                    ep1 = WSUtils.getEditableProperties((Project)J2SEProjectJaxRpcClientSupport.this.project, (String)"nbproject/private/private.properties");
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                assert (ep != null && ep1 != null);
                if (ep.getProperty(featureProperty) != null) {
                    ep.remove((Object)featureProperty);
                    needsSave = true;
                }
                if (ep.getProperty(packageProperty) != null) {
                    ep.remove((Object)packageProperty);
                    needsSave = true;
                }
                if (ep1.getProperty(proxyProperty) != null) {
                    ep1.remove((Object)proxyProperty);
                    needsSave1 = true;
                }
                if (needsSave) {
                    try {
                        WSUtils.storeEditableProperties((Project)J2SEProjectJaxRpcClientSupport.this.project, (String)"nbproject/project.properties", (EditableProperties)ep);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
                if (needsSave1) {
                    try {
                        WSUtils.storeEditableProperties((Project)J2SEProjectJaxRpcClientSupport.this.project, (String)"nbproject/private/private.properties", (EditableProperties)ep1);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
                if ((clientElements = (aux = ProjectUtils.getAuxiliaryConfiguration((Project)J2SEProjectJaxRpcClientSupport.this.project)).getConfigurationFragment("web-service-clients", J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, true)) != null) {
                    NodeList clientNameList = clientElements.getElementsByTagNameNS(J2SEProjectJaxRpcClientSupport.JAX_RPC_NAMESPACE, "web-service-client-name");
                    for (int i = 0; i < clientNameList.getLength(); ++i) {
                        Node n;
                        Element clientNameElement = (Element)clientNameList.item(i);
                        NodeList nl = clientNameElement.getChildNodes();
                        if (nl.getLength() != 1 || (n = nl.item(0)).getNodeType() != 3 || !serviceName.equalsIgnoreCase(n.getNodeValue())) continue;
                        Node clientNode = clientNameElement.getParentNode();
                        clientElements.removeChild(clientNode);
                        aux.putConfigurationFragment(clientElements, true);
                        needsSave = true;
                    }
                }
                return needsSave || needsSave1;
            }
        });
        if (needToSave) {
            try {
                ProjectManager.getDefault().saveProject(this.project);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEProjectJaxRpcClientSupport.class, (String)"MSG_ErrorSavingOnWSClientRemove", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        String srcDirProp;
        EditableProperties ep = null;
        try {
            ep = WSUtils.getEditableProperties((Project)this.project, (String)"nbproject/project.properties");
        }
        catch (IOException ex) {
            // empty catch block
        }
        String srcDir = "src";
        if (ep != null && (srcDirProp = ep.getProperty("src.dir")) != null) {
            srcDir = srcDirProp;
        }
        String wsdlFolderStr = srcDir + "/META-INF/" + WSDL_FOLDER;
        FileObject wsdlFolder = this.project.getProjectDirectory().getFileObject(wsdlFolderStr);
        if (wsdlFolder == null && create) {
            wsdlFolder = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)wsdlFolderStr);
        }
        return wsdlFolder;
    }

    public List<ClientStubDescriptor> getStubDescriptors() {
        ArrayList<ClientStubDescriptor> stubs = new ArrayList<ClientStubDescriptor>(2);
        stubs.add(jaxrpcClientStub);
        return stubs;
    }

    private boolean isProjectOpened() {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    public List getServiceClients() {
        ArrayList<WsCompileClientEditorSupport.ServiceSettings> serviceNames = new ArrayList<WsCompileClientEditorSupport.ServiceSettings>();
        AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration((Project)this.project);
        Element clientElements = aux.getConfigurationFragment("web-service-clients", JAX_RPC_NAMESPACE, true);
        if (clientElements != null) {
            NodeList clientNameList = clientElements.getElementsByTagNameNS(JAX_RPC_NAMESPACE, "web-service-client-name");
            for (int i = 0; i < clientNameList.getLength(); ++i) {
                Node n;
                Element clientNameElement = (Element)clientNameList.item(i);
                NodeList nl = clientNameElement.getChildNodes();
                if (nl.getLength() != 1 || (n = nl.item(0)).getNodeType() != 3) continue;
                EditableProperties projectProperties = null;
                try {
                    projectProperties = WSUtils.getEditableProperties((Project)this.project, (String)"nbproject/project.properties");
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (projectProperties == null) continue;
                String serviceName = n.getNodeValue();
                String currentFeatures = projectProperties.getProperty("wscompile.client." + serviceName + ".features");
                if (currentFeatures == null) {
                    currentFeatures = "wsi, strict";
                }
                ClientStubDescriptor stubType = this.getClientStubDescriptor(clientNameElement.getParentNode());
                boolean propVerbose = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".verbose"));
                boolean propDebug = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".debug"));
                boolean propPrintStackTrace = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".xPrintStackTrace"));
                boolean propExtensible = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".xSerializable"));
                boolean propOptimize = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".optimize"));
                boolean[] options = new boolean[]{propVerbose, propDebug, propPrintStackTrace, propExtensible, propOptimize};
                WsCompileClientEditorSupport.ServiceSettings settings = new WsCompileClientEditorSupport.ServiceSettings(serviceName, stubType, options, currentFeatures, allClientFeatures, importantClientFeatures);
                serviceNames.add(settings);
            }
        }
        return serviceNames;
    }

    private ClientStubDescriptor getClientStubDescriptor(Node parentNode) {
        String stubName;
        Node n;
        Element clientStubElement;
        NodeList nl;
        Element parentElement;
        NodeList clientNameList;
        JAXRPCClientStubDescriptor result = null;
        if (parentNode instanceof Element && (clientNameList = (parentElement = (Element)parentNode).getElementsByTagNameNS(JAX_RPC_NAMESPACE, "web-service-stub-type")).getLength() == 1 && (nl = (clientStubElement = (Element)clientNameList.item(0)).getChildNodes()).getLength() == 1 && (n = nl.item(0)).getNodeType() == 3 && "jaxrpc_static_client".equals(stubName = n.getNodeValue())) {
            result = jaxrpcClientStub;
        }
        return result;
    }

    public String getWsdlSource(String serviceName) {
        String wsdlSource = null;
        return wsdlSource;
    }

    public void setWsdlSource(String serviceName, String wsdlSource) {
    }

    private Element getWebServiceClientNode(Element data, String serviceName) {
        Element clientElement = null;
        return clientElement;
    }

    public void addServiceClientReference(String serviceName, String fqServiceName, String relativeWsdlPath, String relativeMappingPath, String[] portSEIInfo) {
    }

    public void setProxyJVMOptions(String proxyHost, String proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    @SuppressWarnings(value={"DE_MIGHT_IGNORE"})
    private boolean addJVMProxyOptions(EditableProperties prop, String proxyHost, String proxyPort) {
        String jvmOptions = prop.getProperty(RUN_JVM_ARGS);
        boolean modif = false;
        String localHosts = "localhost";
        try {
            localHosts = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        if (!"localhost".equals(localHosts)) {
            localHosts = "\"" + localHosts + "|localhost\"";
        }
        if (jvmOptions == null || jvmOptions.length() == 0) {
            jvmOptions = "-Dhttp.proxyHost=" + proxyHost + " " + PROXY_PORT_OPTION + "=" + proxyPort + " " + NON_PROXY_HOSTS_OPTION + "=" + localHosts;
            modif = true;
        } else {
            if (jvmOptions.indexOf(PROXY_HOST_OPTION) < 0) {
                jvmOptions = jvmOptions + " -Dhttp.proxyHost=" + proxyHost;
                modif = true;
            }
            if (jvmOptions.indexOf(PROXY_PORT_OPTION) < 0) {
                jvmOptions = jvmOptions + " -Dhttp.proxyPort=" + proxyPort;
                modif = true;
            }
            if (jvmOptions.indexOf(NON_PROXY_HOSTS_OPTION) < 0) {
                jvmOptions = jvmOptions + " -Dhttp.nonProxyHosts=" + localHosts;
                modif = true;
            }
        }
        if (modif) {
            prop.setProperty(RUN_JVM_ARGS, jvmOptions);
        }
        return modif;
    }

    public String getServiceRefName(String serviceName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document createNewDocument() {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            return db.newDocument();
        }
    }

    static {
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class JAXRPCClientStubDescriptor
    extends ClientStubDescriptor {
        private String[] defaultFeatures;

        public JAXRPCClientStubDescriptor(String name, String displayName, String[] defaultFeatures) {
            super(name, displayName);
            this.defaultFeatures = defaultFeatures;
        }

        public String[] getDefaultFeatures() {
            return this.defaultFeatures;
        }

        public String getDefaultFeaturesAsArgument() {
            StringBuffer buf = new StringBuffer(this.defaultFeatures.length * 32);
            for (int i = 0; i < this.defaultFeatures.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.defaultFeatures[i]);
            }
            return buf.toString();
        }

        void setDefaultFeatures(String[] defaultFeatures) {
            this.defaultFeatures = defaultFeatures;
        }
    }
}

