/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.SessionConfig;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class OverviewPanel
extends SectionInnerPanel
implements ItemListener {
    private final DDDataObject dObj;
    private final WebApp webApp;
    private JLabel descriptionLabel;
    private JTextArea descriptionTA;
    private JLabel dispNameLabel;
    private JTextField dispNameTF;
    private JPanel filler;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel stLabel;
    private JTextField stTF;
    private JTextField tfName;

    public OverviewPanel(SectionView sectionView, DDDataObject dObj) {
        super(sectionView);
        this.dObj = dObj;
        this.webApp = dObj.getWebApp();
        this.initComponents();
        this.dispNameTF.setText(this.webApp.getDefaultDisplayName());
        this.addModifier(this.dispNameTF);
        Utils.makeTextAreaLikeTextField((JTextArea)this.descriptionTA, (JTextField)this.dispNameTF);
        this.descriptionTA.setText(this.webApp.getDefaultDescription());
        this.addModifier(this.descriptionTA);
        this.jCheckBox1.setSelected(this.webApp.isDistributable());
        this.jCheckBox1.addItemListener(this);
        this.stTF.setText(this.getSessionTimeout());
        this.addValidatee(this.stTF);
        BigDecimal ver = new BigDecimal(this.webApp.getVersion());
        boolean showNameElement = ver.compareTo(new BigDecimal(3.0)) >= 0 && this.webApp instanceof WebFragment;
        this.jLabel2.setVisible(showNameElement);
        this.tfName.setVisible(showNameElement);
        if (showNameElement) {
            this.tfName.setText(this.getXmlNames());
            this.addModifier(this.tfName);
        }
    }

    private String getSessionTimeout() {
        SessionConfig config = this.webApp.getSingleSessionConfig();
        if (config == null) {
            return "";
        }
        BigInteger timeout = config.getSessionTimeout();
        return timeout == null ? "" : timeout.toString();
    }

    private void setSessionTimeout(String text) {
        String val = text.trim();
        SessionConfig config = this.webApp.getSingleSessionConfig();
        if (config != null) {
            if (text.length() == 0) {
                this.webApp.setSessionConfig(null);
            } else {
                config.setSessionTimeout(new BigInteger(val));
            }
        } else if (text.length() > 0) {
            try {
                SessionConfig newConfig = (SessionConfig)this.webApp.createBean("SessionConfig");
                newConfig.setSessionTimeout(new BigInteger(val));
                this.webApp.setSessionConfig(newConfig);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
    }

    private String getXmlNames() {
        try {
            String[] names = this.webApp.getName();
            if (names != null && names.length > 0) {
                StringBuilder res = new StringBuilder();
                for (String s : names) {
                    if (res.length() > 0) {
                        res.append(", ");
                    }
                    res.append(s);
                }
                return res.toString();
            }
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            // empty catch block
        }
        return "";
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    public void documentChanged(JTextComponent comp, String value) {
        if (comp == this.stTF) {
            String text = value.trim();
            if (text.length() == 0) {
                this.getSectionView().getErrorPanel().clearError();
            } else {
                BigInteger st = null;
                try {
                    st = new BigInteger(text);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                if (st == null) {
                    this.getSectionView().getErrorPanel().setError(new Error(0, 0, "Invalid Value : " + text, (JComponent)this.stTF));
                    return;
                }
                this.getSectionView().getErrorPanel().clearError();
            }
        }
    }

    public void setValue(JComponent source, Object value) {
        String text = ((String)value).trim();
        if (source == this.dispNameTF) {
            this.webApp.setDisplayName(text.length() == 0 ? null : text);
        } else if (source == this.descriptionTA) {
            this.webApp.setDescription(text.length() == 0 ? null : text);
        } else if (source == this.stTF) {
            this.setSessionTimeout(text);
        } else if (source == this.tfName) {
            try {
                String[] res = text.split(",");
                int maxi = res.length;
                for (int i = 0; i < maxi; ++i) {
                    res[i] = res[i].trim();
                }
                this.webApp.setName(res);
            }
            catch (VersionNotSupportedException e) {
                // empty catch block
            }
        }
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.stTF) {
            this.stTF.setText(this.getSessionTimeout());
        }
    }

    public void linkButtonPressed(Object obj, String id) {
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.filler = new JPanel();
        this.dispNameLabel = new JLabel();
        this.dispNameTF = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTA = new JTextArea();
        this.jCheckBox1 = new JCheckBox();
        this.stLabel = new JLabel();
        this.stTF = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfName = new JTextField();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.jLabel2, gridBagConstraints);
        this.filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.filler, gridBagConstraints);
        this.dispNameLabel.setLabelFor(this.dispNameTF);
        Mnemonics.setLocalizedText((JLabel)this.dispNameLabel, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_displayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.dispNameLabel, gridBagConstraints);
        this.dispNameTF.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.dispNameTF, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionTA);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.descriptionLabel, gridBagConstraints);
        this.descriptionTA.setRows(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.descriptionTA, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_distributable"));
        this.jCheckBox1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.jCheckBox1, gridBagConstraints);
        this.stLabel.setLabelFor(this.stTF);
        Mnemonics.setLocalizedText((JLabel)this.stLabel, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_sessionTimeout"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.add(this.stLabel, gridBagConstraints);
        this.stTF.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add(this.stTF, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OverviewPanel.class, (String)"LBL_min"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add(this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.tfName, gridBagConstraints);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.jCheckBox1) {
            this.dObj.modelUpdatedFromUI();
            this.dObj.setChangedFromUI(true);
            this.webApp.setDistributable(this.jCheckBox1.isSelected());
            this.dObj.setChangedFromUI(false);
        }
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }
}

