/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.ScannerDescriptor;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.trampoline.Accessor;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;

public class TaskIndexer
extends CustomIndexer {
    private final TaskList taskList;
    private static final Logger LOG = Logger.getLogger(TaskIndexer.class.getName());
    static final String KEY_SCANNER = "scanner";
    static final String KEY_TASK = "task";

    public TaskIndexer(TaskList taskList) {
        this.taskList = taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void index(Iterable<? extends Indexable> files, Context context) {
        block25: {
            TaskManagerImpl tm = TaskManagerImpl.getInstance();
            if (!tm.isObserved()) {
                tm.makeCacheDirty();
                return;
            }
            TaskFilter filter = tm.getFilter();
            if (null == filter) {
                filter = TaskFilter.EMPTY;
            }
            TaskScanningScope scope = tm.getScope();
            ArrayList<FileTaskScanner> scanners = null;
            try {
                boolean firstScan = true;
                boolean isInScope = false;
                boolean currentFileFound = false;
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : files) {
                    if (context.isCancelled()) {
                        LOG.log(Level.FINE, "Indexer cancelled");
                        return;
                    }
                    FileObject root = context.getRoot();
                    if (null == root) {
                        LOG.log(Level.FINE, "Context root not available");
                        return;
                    }
                    FileObject fo = root.getFileObject(indexable.getRelativePath());
                    if (null == fo) {
                        LOG.log(Level.FINE, "Cannot find file [%0] under root [%1]", new Object[]{indexable.getRelativePath(), root});
                        continue;
                    }
                    if (tm.isCurrentEditorScope()) {
                        isInScope = scope.isInScope(fo);
                        if (isInScope) {
                            currentFileFound = true;
                        } else {
                            tm.makeCacheDirty();
                            continue;
                        }
                    }
                    if (null == scanners) {
                        scanners = new ArrayList<FileTaskScanner>(20);
                        for (FileTaskScanner fileTaskScanner : tm.getFileScanners()) {
                            if (!filter.isEnabled(fileTaskScanner)) continue;
                            fileTaskScanner.notifyPrepare();
                            scanners.add(fileTaskScanner);
                            LOG.fine("Using FileTaskScanner: " + fileTaskScanner);
                        }
                    }
                    if (firstScan) {
                        isInScope = scope.isInScope(fo);
                        firstScan = false;
                    }
                    is.removeDocuments(indexable);
                    IndexDocument doc = null;
                    for (FileTaskScanner scanner : scanners) {
                        List tasks = scanner.scan(fo);
                        if (null == tasks) continue;
                        if (isInScope) {
                            this.taskList.update(scanner, fo, new ArrayList<Task>(tasks), filter);
                        }
                        if (tasks.isEmpty()) continue;
                        if (null == doc) {
                            doc = is.createDocument(indexable);
                            doc.addPair(KEY_SCANNER, ScannerDescriptor.getType(scanner), true, true);
                        }
                        for (Task t : tasks) {
                            doc.addPair(KEY_TASK, TaskIndexer.encode(t), false, true);
                        }
                    }
                    if (doc != null) {
                        is.addDocument(doc);
                    }
                    if (!currentFileFound) continue;
                    break;
                }
            }
            catch (IOException ioE) {
                LOG.log(Level.INFO, "Error while scanning file for tasks.", ioE);
            }
            finally {
                if (null == scanners) break block25;
                for (FileTaskScanner s : scanners) {
                    s.notifyFinish();
                }
            }
        }
    }

    private static String encode(Task t) {
        StringBuffer res = new StringBuffer();
        URL url = Accessor.DEFAULT.getURL(t);
        if (null == url) {
            res.append("-");
        } else {
            res.append(url.toExternalForm());
        }
        res.append("\n");
        res.append(Accessor.DEFAULT.getLine(t));
        res.append("\n");
        res.append(Accessor.DEFAULT.getGroup(t).getName());
        res.append("\n");
        res.append(Accessor.DEFAULT.getDescription(t));
        return res.toString();
    }

    public static Task decode(FileObject fo, String encodedTask) {
        int delimIndex = encodedTask.indexOf("\n");
        String strUrl = encodedTask.substring(0, delimIndex);
        URL url = null;
        if (!"-".equals(strUrl)) {
            try {
                url = new URL(strUrl);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        encodedTask = encodedTask.substring(delimIndex + 1);
        delimIndex = encodedTask.indexOf("\n");
        int lineNumber = Integer.valueOf(encodedTask.substring(0, delimIndex));
        encodedTask = encodedTask.substring(delimIndex + 1);
        delimIndex = encodedTask.indexOf("\n");
        String groupName = encodedTask.substring(0, delimIndex);
        String description = encodedTask.substring(delimIndex + 1);
        if (null != url) {
            return Task.create((URL)url, (String)groupName, (String)description);
        }
        return Task.create((FileObject)fo, (String)groupName, (String)description, (int)lineNumber);
    }
}

