/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.impl;

import java.util.Comparator;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type$ptr;

public final class StdQuicksort {
    private static final type$ptr NULL = NativePointer.create_type$ptr((Object[])null);
    private static final int MAX_THRESH = 4;
    private static long STACK_SIZE = 64L;

    public static <T> void _quicksort(type$ptr<T> pbase, long total_elems, Comparator<T> cmp) {
        type$ptr<T> base_ptr = Native.$tryClone(pbase);
        long max_thresh = 4L;
        if (total_elems == 0L) {
            return;
        }
        if (total_elems > 4L) {
            type$ptr lo = Native.$tryClone(base_ptr);
            type$ptr hi = (type$ptr)lo.$add(total_elems - 1L);
            stack_node<T>[] stack2 = StdQuicksort.createStack();
            type$ptr<stack_node<T>> top = NativePointer.create_type$ptr(stack2);
            StdQuicksort.PUSH(top, NULL, NULL);
            while (StdQuicksort.STACK_NOT_EMPTY(stack2, top)) {
                type$ptr mid = (type$ptr)lo.$add(hi.$sub(lo) >> 1);
                boolean jump_over = false;
                if (cmp.compare(mid.$star(), lo.$star()) < 0) {
                    StdQuicksort.SWAP(mid, lo);
                }
                if (cmp.compare(hi.$star(), mid.$star()) < 0) {
                    StdQuicksort.SWAP(mid, hi);
                } else {
                    jump_over = true;
                }
                if (!jump_over && cmp.compare(mid.$star(), lo.$star()) < 0) {
                    StdQuicksort.SWAP(mid, lo);
                }
                type$ptr left_ptr = (type$ptr)lo.$add(1);
                type$ptr right_ptr = (type$ptr)hi.$sub(1);
                while (true) {
                    if (cmp.compare(left_ptr.$star(), mid.$star()) < 0) {
                        left_ptr.$inc(1);
                        continue;
                    }
                    while (cmp.compare(mid.$star(), right_ptr.$star()) < 0) {
                        right_ptr.$dec(1);
                    }
                    if (left_ptr.$less(right_ptr)) {
                        StdQuicksort.SWAP(left_ptr, right_ptr);
                        if (mid.$eq(left_ptr)) {
                            mid = Native.$tryClone(right_ptr);
                        } else if (mid.$eq(right_ptr)) {
                            mid = Native.$tryClone(left_ptr);
                        }
                        left_ptr.$inc(1);
                        right_ptr.$dec(1);
                    } else if (left_ptr.$eq(right_ptr)) {
                        left_ptr.$inc(1);
                        right_ptr.$dec(1);
                        break;
                    }
                    if (!left_ptr.$lesseq(right_ptr)) break;
                }
                if ((long)right_ptr.$sub(lo) <= 4L) {
                    if ((long)hi.$sub(left_ptr) <= 4L) {
                        StdQuicksort.POP(top, lo, hi);
                        continue;
                    }
                    lo = Native.$tryAssign(lo, left_ptr, false);
                    continue;
                }
                if ((long)hi.$sub(left_ptr) <= 4L) {
                    hi = Native.$tryAssign(hi, right_ptr, false);
                    continue;
                }
                if (right_ptr.$sub(lo) > hi.$sub(left_ptr)) {
                    StdQuicksort.PUSH(top, lo, right_ptr);
                    lo = Native.$tryAssign(lo, left_ptr, false);
                    continue;
                }
                StdQuicksort.PUSH(top, left_ptr, hi);
                hi = Native.$tryAssign(hi, right_ptr, false);
            }
        }
        type$ptr end_ptr = (type$ptr)base_ptr.$add(total_elems - 1L);
        type$ptr tmp_ptr = Native.$tryClone(base_ptr);
        type$ptr<T> thresh = Native.$tryClone(StdQuicksort.min(end_ptr, (type$ptr)base_ptr.$add(4L)));
        type$ptr run_ptr = (type$ptr)tmp_ptr.$add(1);
        while (run_ptr.$lesseq(thresh)) {
            if (cmp.compare(run_ptr.$star(), tmp_ptr.$star()) < 0) {
                tmp_ptr = Native.$tryClone(run_ptr);
            }
            run_ptr.$preInc();
        }
        if (tmp_ptr.$noteq(base_ptr)) {
            StdQuicksort.SWAP(tmp_ptr, base_ptr);
        }
        run_ptr = (type$ptr)base_ptr.$add(1);
        while (((type$ptr)run_ptr.$inc(1)).$lesseq(end_ptr)) {
            tmp_ptr = (type$ptr)run_ptr.$sub(1);
            while (cmp.compare(run_ptr.$star(), tmp_ptr.$star()) < 0) {
                tmp_ptr.$dec(1);
            }
            tmp_ptr.$inc(1);
            if (!tmp_ptr.$noteq(run_ptr)) continue;
            type$ptr trav = (type$ptr)run_ptr.$add(1);
            while (((type$ptr)trav.$preDec()).$greatereq(run_ptr)) {
                Object c = trav.$star();
                type$ptr lo = Native.$tryClone(trav);
                type$ptr hi = Native.$tryClone(lo);
                while (((type$ptr)lo.$preDec()).$greatereq(tmp_ptr)) {
                    hi.$set(lo.$star());
                    hi = Native.$tryClone(lo);
                }
                hi.$set(c);
            }
        }
    }

    private static <T> stack_node<T>[] createStack() {
        stack_node[] stack2 = new stack_node[(int)STACK_SIZE];
        for (int i = 0; i < stack2.length; ++i) {
            stack2[i] = new stack_node();
        }
        return stack2;
    }

    private static <T> type$ptr<T> min(type$ptr<T> x, type$ptr<T> y) {
        return x.$less(y) ? x : y;
    }

    private static <T> void SWAP(type$ptr<T> left, type$ptr<T> right) {
        std.swap(left, right);
    }

    private static <T> void PUSH(type$ptr<stack_node<T>> top, type$ptr<T> low, type$ptr<T> high) {
        top.$star().lo = Native.$tryClone(low);
        top.$star().hi = Native.$tryClone(high);
        top.$preInc();
    }

    private static <T> void POP(type$ptr<stack_node<T>> top, type$ptr<T> low, type$ptr<T> high) {
        top.$preDec();
        Native.$tryAssign(low, top.$star().lo, false);
        Native.$tryAssign(high, top.$star().hi, false);
    }

    private static <T> boolean STACK_NOT_EMPTY(stack_node<T>[] stack2, type$ptr<stack_node<T>> top) {
        return NativePointer.create_type$ptr(stack2).$noteq((stack_node<type$ptr<stack_node<T>>>)((Object)top));
    }

    private static class stack_node<T> {
        type$ptr<T> lo;
        type$ptr<T> hi;

        private stack_node() {
        }
    }
}

