/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.impl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.type$ptr;

public final class StdStrToNumber {
    private static byte[] cvtIn = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 100, 100, 100, 100, 100, 100, 100, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 100, 100, 100, 100, 100, 100, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    private static int maxExponent = 511;
    private static double[] powersOf10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};

    public static long strtoul(char$ptr string2, type$ptr<char$ptr> endPtr, int base) {
        long result = 0L;
        boolean anyDigits = false;
        boolean negative = false;
        boolean overflow = false;
        char$ptr p = Native.$tryClone(string2);
        while (std.isspace(p.$star()) != 0) {
            p.$inc(1);
        }
        if (p.$star() == NativePointer.$('-')) {
            negative = true;
            p.$inc(1);
        } else if (p.$star() == NativePointer.$('+')) {
            p.$inc(1);
        }
        if (base == 0) {
            if (p.$star() == NativePointer.$('0')) {
                p.$inc(1);
                if (p.$star() == NativePointer.$('x') || p.$star() == NativePointer.$('X')) {
                    p.$inc(1);
                    base = 16;
                } else {
                    anyDigits = true;
                    base = 8;
                }
            } else {
                base = 10;
            }
        } else if (base == 16 && p.$at(0) == NativePointer.$('0') && (p.$at(1) == NativePointer.$('x') || p.$at(1) == NativePointer.$('X'))) {
            p.$inc(2);
        }
        if (base == 8) {
            long digit;
            long maxres = 0xFFFFFFFFFFFFFFFL;
            while (Unsigned.compare(digit = (long)(p.$star() - 48), 7L) <= 0L) {
                if (result > maxres) {
                    overflow = true;
                }
                if (digit > Long.MAX_VALUE - (result <<= 3)) {
                    overflow = true;
                }
                result += digit;
                anyDigits = true;
                p.$inc(1);
            }
        } else if (base == 10) {
            long digit;
            long maxres = 0xCCCCCCCCCCCCCCCL;
            while (Unsigned.compare(digit = (long)(p.$star() - 48), 9L) <= 0L) {
                if (result > maxres) {
                    overflow = true;
                }
                if (digit > Long.MAX_VALUE - (result *= 10L)) {
                    overflow = true;
                }
                result += digit;
                anyDigits = true;
                p.$inc(1);
            }
        } else if (base == 16) {
            long digit;
            long maxres = 0x7FFFFFFFFFFFFFFL;
            while (Unsigned.compare(digit = (long)(p.$star() - 48), 74L) <= 0L && (digit = (long)cvtIn[(int)digit]) <= 15L) {
                if (result > maxres) {
                    overflow = true;
                }
                if (digit > Long.MAX_VALUE - (result <<= 4)) {
                    overflow = true;
                }
                result += digit;
                anyDigits = true;
                p.$inc(1);
            }
        } else if (base >= 2 && base <= 36) {
            long digit;
            long maxres = Long.MAX_VALUE / (long)base;
            while (Unsigned.compare(digit = (long)(p.$star() - 48), 74L) <= 0L && (digit = (long)cvtIn[(int)digit]) < (long)base) {
                if (result > maxres) {
                    overflow = true;
                }
                if (digit > Long.MAX_VALUE - (result *= (long)base)) {
                    overflow = true;
                }
                result += digit;
                anyDigits = true;
                p.$inc(1);
            }
        }
        if (!anyDigits) {
            p = Native.$tryClone(string2);
        }
        if (endPtr != null) {
            endPtr.$set(Native.$tryClone(p));
        }
        if (overflow) {
            std.setErrno(34);
            return Long.MAX_VALUE;
        }
        if (negative) {
            return -result;
        }
        return result;
    }

    public static double strtod(char$ptr string2, type$ptr<char$ptr> endPtr) {
        byte c;
        boolean sign;
        boolean expSign = false;
        int exp = 0;
        int fracExp = 0;
        boolean done = false;
        char$ptr p = Native.$tryClone(string2);
        while (std.isspace(p.$star()) != 0) {
            p.$inc(1);
        }
        if (p.$star() == NativePointer.$('-')) {
            sign = true;
            p.$inc(1);
        } else {
            if (p.$star() == NativePointer.$('+')) {
                p.$inc(1);
            }
            sign = false;
        }
        int decPt = -1;
        int mantSize = 0;
        while (true) {
            if (std.isdigit(c = p.$star()) == 0) {
                if (c != NativePointer.$('.') || decPt >= 0) break;
                decPt = mantSize;
            }
            p.$inc(1);
            ++mantSize;
        }
        char$ptr pExp = Native.$tryClone(p);
        p.$dec(mantSize);
        if (decPt < 0) {
            decPt = mantSize;
        } else {
            --mantSize;
        }
        if (mantSize > 18) {
            fracExp = decPt - 18;
            mantSize = 18;
        } else {
            fracExp = decPt - mantSize;
        }
        if (mantSize == 0) {
            double fraction = 0.0;
            p = Native.$tryClone(string2);
            return StdStrToNumber.done(p, sign, fraction, endPtr);
        }
        int frac1 = 0;
        while (mantSize > 9) {
            c = p.$star();
            p.$inc(1);
            if (c == NativePointer.$('.')) {
                c = p.$star();
                p.$inc(1);
            }
            frac1 = 10 * frac1 + (c - 48);
            --mantSize;
        }
        int frac2 = 0;
        while (mantSize > 0) {
            c = p.$star();
            p.$inc(1);
            if (c == NativePointer.$('.')) {
                c = p.$star();
                p.$inc(1);
            }
            frac2 = 10 * frac2 + (c - 48);
            --mantSize;
        }
        double fraction = 1.0E9 * (double)frac1 + (double)frac2;
        p = Native.$tryClone(pExp);
        if (p.$star() == NativePointer.$('E') || p.$star() == NativePointer.$('e')) {
            p.$inc(1);
            if (p.$star() == NativePointer.$('-')) {
                expSign = true;
                p.$inc(1);
            } else {
                if (p.$star() == NativePointer.$('+')) {
                    p.$inc(1);
                }
                expSign = false;
            }
            if (std.isdigit(p.$star()) == 0) {
                p = Native.$tryClone(pExp);
                return StdStrToNumber.done(p, sign, fraction, endPtr);
            }
            while (std.isdigit(p.$star()) != 0) {
                exp = exp * 10 + (p.$star() - 48);
                p.$inc(1);
            }
        }
        if ((exp = expSign ? fracExp - exp : fracExp + exp) < 0) {
            expSign = true;
            exp = -exp;
        } else {
            expSign = false;
        }
        if (exp > maxExponent) {
            exp = maxExponent;
            std.setErrno(34);
        }
        double dblExp = 1.0;
        int i = 0;
        while (exp != 0) {
            double d = powersOf10[i];
            if ((exp & 1) != 0) {
                dblExp *= d;
            }
            exp >>= 1;
            ++i;
        }
        fraction = expSign ? (fraction /= dblExp) : (fraction *= dblExp);
        return StdStrToNumber.done(p, sign, fraction, endPtr);
    }

    private static double done(char$ptr p, boolean sign, double fraction, type$ptr<char$ptr> endPtr) {
        if (endPtr != null) {
            endPtr.$set(Native.$tryClone(p));
        }
        if (sign) {
            return -fraction;
        }
        return fraction;
    }
}

