/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java;

import java.io.BufferedReader;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clank.java.io_defines;
import org.clank.java.mman_defines;
import org.clank.java.std;
import org.clank.java.std_defines;
import org.clank.java.std_errors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char$iterator;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.char$ptr$array;
import org.clank.support.aliases.uchar;
import org.clank.support.void$ptr;

public class io
extends std_errors
implements std_defines,
io_defines,
mman_defines {
    private static final Path ROOT_PATH = Paths.get("/", new String[0]);
    private static final ThreadLocal<AtomicInteger> errnoVal = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    public static final istream cin = new StreamIn(System.in);
    public static final ostream cout = new StreamOut(System.out);
    public static final ostream stderr = new StreamOut(System.err);
    public static final Object endl = "\n";
    public static final int S_IFMT = 61440;
    public static final int S_IAMB = 511;
    public static final int S_IFIFO = 4096;
    public static final int S_IFCHR = 8192;
    public static final int S_IFDIR = 16384;
    public static final int S_IFNAM = 20480;
    public static final int S_INSEM = 1;
    public static final int S_INSHD = 2;
    public static final int S_IFBLK = 24576;
    public static final int S_IFREG = 32768;
    public static final int S_IFLNK = 40960;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFDOOR = 53248;
    public static final int S_IFPORT = 57344;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IREAD = 256;
    public static final int S_IWRITE = 128;
    public static final int S_IEXEC = 64;
    public static final int S_ENFMT = 1024;
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    private static final int RW_MASK = 3;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_SEARCH = 0x200000;
    public static final int O_EXEC = 0x400000;
    public static final int O_NDELAY = 4;
    public static final int O_APPEND = 8;
    public static final int O_SYNC = 16;
    public static final int O_DSYNC = 64;
    public static final int O_RSYNC = 32768;
    public static final int O_NONBLOCK = 128;
    public static final int O_LARGEFILE = 8192;
    public static final int O_CREAT = 256;
    public static final int O_TRUNC = 512;
    public static final int O_EXCL = 1024;
    public static final int O_NOCTTY = 2048;
    public static final int O_XATTR = 16384;
    public static final int O_NOFOLLOW = 131072;
    public static final int O_NOLINKS = 262144;
    public static final int O_CLOEXEC = 0x800000;
    public static final int O_DIRECTORY = 0x1000000;
    public static final int O_TTY_INIT = 0x2000000;
    private static final List<OpenedFile> openedFiles = new ArrayList<OpenedFile>(3);
    private static final String R_OPEN_MODE = "r";
    private static final String RW_OPEN_MODE = "rw";
    public static final int R_OK = 4;
    public static final int W_OK = 2;
    public static final int X_OK = 1;
    public static final int F_OK = 0;
    public static final char$ptr MAP_FAILED;
    private static final int _UTSNAME_LENGTH = 65;
    private static final int _UTSNAME_DOMAIN_LENGTH = 65;
    private static final int _UTSNAME_SYSNAME_LENGTH = 65;
    private static final int _UTSNAME_NODENAME_LENGTH = 65;
    private static final int _UTSNAME_RELEASE_LENGTH = 65;
    private static final int _UTSNAME_VERSION_LENGTH = 65;
    private static final int _UTSNAME_MACHINE_LENGTH = 65;
    public static final String UNKNOWN = "unknown";

    protected io() {
    }

    public static int errno() {
        return errnoVal.get().get();
    }

    public static int setErrno(int errno) {
        errnoVal.get().set(errno);
        return errno;
    }

    public static void fprintf(ostream stderr, CharSequence format, Object ... args) {
        io.fprintf(stderr, format.toString(), args);
    }

    public static void fprintf(ostream stderr, String format, Object ... args) {
        stderr.$out(format, args);
    }

    public static int snprintf(char$ptr s, long n, char$ptr format, Object ... objects) {
        throw new UnsupportedOperationException("Empty body");
    }

    public static basic_ostream $out_os_T(basic_ostream out, byte o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_T(basic_ostream out, char o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_T(basic_ostream out, int o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_T(basic_ostream out, long o) {
        return out.$out(o);
    }

    public static <T> basic_ostream $out_os_T(basic_ostream out, T o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_str(basic_ostream out, std.string o) {
        return out.$out_os_str(o);
    }

    public static int getline(basic_istream in, std.string to) {
        return in.getline(to);
    }

    public static char$ptr realpath(char$ptr name, byte[] buf) {
        throw new UnsupportedOperationException();
    }

    public static long write(int fildes, char$ptr buf, int bufIdxFrom, long __nbytes) {
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("write requested for " + fildes, NativeTrace.TRACE_IO);
        }
        return io.pwrite(fildes, buf, bufIdxFrom, __nbytes, Long.MIN_VALUE);
    }

    public static long pwrite(int fildes, char$ptr __buf, int bufIdxFrom, long __nbytes, long __offset) {
        int offset;
        byte[] buffer;
        if (__buf instanceof char$ptr$array) {
            buffer = __buf.$array();
            offset = bufIdxFrom;
        } else {
            offset = 0;
            buffer = NativePointer.new$char(__nbytes, new byte[0]);
            char$ptr first = __buf;
            int i = 0;
            int j = bufIdxFrom;
            while ((long)i < __nbytes) {
                buffer[i] = first.$at(j);
                ++i;
                ++j;
            }
        }
        return io.pwrite(fildes, buffer, offset, __nbytes, __offset);
    }

    public static long write(int fildes, byte[] buffer, int bufOffset, long __nbytes) {
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("write byte[] requested for " + fildes, NativeTrace.TRACE_IO);
        }
        return io.pwrite(fildes, buffer, bufOffset, __nbytes, Long.MIN_VALUE);
    }

    public static long write(int __fd, char$ptr __buf, long __n) {
        return io.write(__fd, __buf, 0, __n);
    }

    public static long pwrite(int fildes, byte[] buffer, int bufOffset, long __nbytes, long __file_offset) {
        OpenedFile openedFile = io.getOpenedFileImpl(fildes);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("pwrite requested " + __nbytes + " bytes " + (__file_offset != Long.MIN_VALUE ? "from " + __file_offset : "from the last") + " position for " + fildes + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "pread not opened {0}", fildes);
            io.setErrno(9);
            return -1L;
        }
        if (__nbytes == 0L) {
            return 0L;
        }
        long savedPosition = 0L;
        if (__file_offset != Long.MIN_VALUE) {
            try {
                savedPosition = openedFile.file.getChannel().position();
                openedFile.file.seek(__file_offset);
            }
            catch (IOException ex) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
                io.setErrno(79);
                return -1L;
            }
        }
        long written = __nbytes;
        try {
            openedFile.write(buffer, bufOffset, (int)__nbytes);
        }
        catch (IOException ex) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
            return -1L;
        }
        if (__file_offset != Long.MIN_VALUE) {
            try {
                openedFile.file.getChannel().position(savedPosition);
            }
            catch (IOException ex) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
                io.setErrno(79);
                return -1L;
            }
        }
        return written;
    }

    public static long lseek(int fildes, long offset, int whence) {
        OpenedFile openedFile = io.getOpenedFileImpl(fildes);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("lseek to position " + offset + " for " + fildes + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "lseek not opened {0}", fildes);
            io.setErrno(9);
            return -1L;
        }
        if (offset < 0L || offset == Long.MIN_VALUE) {
            io.setErrno(22);
            return -1L;
        }
        if (openedFile.file == null) {
            assert (fildes <= 2);
            if (offset != 0L) {
                io.setErrno(79);
                return -1L;
            }
            return 0L;
        }
        long savedPosition = 0L;
        try {
            savedPosition = openedFile.file.getChannel().position();
            openedFile.file.seek(offset);
        }
        catch (IOException ex) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
            try {
                openedFile.file.seek(savedPosition);
            }
            catch (IOException ex1) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex1);
            }
            io.setErrno(79);
            return -1L;
        }
        return offset;
    }

    public static long read(int __fd, char$iterator buf, long __nbytes) {
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("read requested for " + __fd, NativeTrace.TRACE_IO);
        }
        return io.pread(__fd, buf, __nbytes, Long.MIN_VALUE);
    }

    public static long pread(int __fd, char$iterator<?> __buf, long __nbytes, long __offset) {
        long read;
        block6: {
            boolean createdOwnBuffer;
            int offset;
            byte[] buffer;
            if (__buf instanceof char$ptr$array) {
                buffer = ((char$ptr$array)__buf).$array();
                offset = ((char$ptr$array)__buf).$index();
                createdOwnBuffer = false;
            } else {
                buffer = NativePointer.new$char(__nbytes, new byte[0]);
                offset = 0;
                createdOwnBuffer = true;
            }
            read = io.pread(__fd, buffer, offset, __nbytes, __offset);
            if (!createdOwnBuffer || read <= 0L) break block6;
            if (__buf instanceof char$ptr) {
                int i = 0;
                while ((long)i < read) {
                    ((char$ptr)__buf).$set(i, buffer[i]);
                    ++i;
                }
            } else {
                char$iterator<?> first = Native.$tryClone(__buf);
                int i = 0;
                while ((long)i < read) {
                    first.star$ref().$set(buffer[i]);
                    first.$preInc();
                    ++i;
                }
            }
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long pread(int __fd, byte[] buffer, int __bufOffset, long __nbytes, long __offset) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate read request to custome FS impl?";
        OpenedFile openedFile = io.getOpenedFileImpl(__fd);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("pread requested " + __nbytes + " bytes " + (__offset != Long.MIN_VALUE ? "from " + __offset : "from the last") + " position for " + __fd + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "pread not opened {0}", __fd);
            io.setErrno(9);
            return -1L;
        }
        if (__nbytes == 0L) {
            return 0L;
        }
        OpenedFile openedFile2 = openedFile;
        synchronized (openedFile2) {
            int read;
            long savedPosition = 0L;
            if (__offset != Long.MIN_VALUE) {
                try {
                    savedPosition = openedFile.file.getChannel().position();
                    openedFile.file.seek(__offset);
                }
                catch (IOException ex) {
                    Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
                    io.setErrno(79);
                    return -1L;
                }
            }
            try {
                read = openedFile.file.read(buffer, __bufOffset, (int)__nbytes);
            }
            catch (IOException ex) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
                return -1L;
            }
            if (__offset != Long.MIN_VALUE) {
                try {
                    openedFile.file.getChannel().position(savedPosition);
                }
                catch (IOException ex) {
                    Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
                    io.setErrno(79);
                    return -1L;
                }
            }
            return read;
        }
    }

    public static int gettimeofday(timeval out, timezone tz) {
        io.setErrno(0);
        out.tv_sec = System.currentTimeMillis() / 1000L;
        out.tv_usec = System.nanoTime();
        return 0;
    }

    public static int futimens(int FD, timespec[] out) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean S_ISFIFO(long mode) {
        return (mode & 0xF000L) == 4096L;
    }

    public static boolean S_ISCHR(long mode) {
        return (mode & 0xF000L) == 8192L;
    }

    public static boolean S_ISDIR(long mode) {
        return (mode & 0xF000L) == 16384L;
    }

    public static boolean S_ISBLK(long mode) {
        return (mode & 0xF000L) == 24576L;
    }

    public static boolean S_ISREG(long mode) {
        return (mode & 0xF000L) == 32768L;
    }

    public static boolean S_ISLNK(long mode) {
        return (mode & 0xF000L) == 40960L;
    }

    public static boolean S_ISSOCK(long mode) {
        return (mode & 0xF000L) == 49152L;
    }

    public static boolean S_ISDOOR(long mode) {
        return (mode & 0xF000L) == 53248L;
    }

    public static boolean S_ISPORT(long mode) {
        return (mode & 0xF000L) == 57344L;
    }

    private static int toUnixPermImpl(PosixFilePermission p) {
        switch (p) {
            case OWNER_READ: {
                return 256;
            }
            case OWNER_WRITE: {
                return 128;
            }
            case OWNER_EXECUTE: {
                return 64;
            }
            case GROUP_READ: {
                return 32;
            }
            case GROUP_WRITE: {
                return 16;
            }
            case GROUP_EXECUTE: {
                return 8;
            }
            case OTHERS_READ: {
                return 4;
            }
            case OTHERS_WRITE: {
                return 2;
            }
            case OTHERS_EXECUTE: {
                return 1;
            }
        }
        throw new AssertionError((Object)p.name());
    }

    public static int isatty(int __fd) {
        io.setErrno(0);
        if (__fd <= 2) {
            return System.console() != null ? 1 : 0;
        }
        return 0;
    }

    public static int stat(char$ptr file, stat out) {
        return io.stat(Native.$toString(file), out);
    }

    public static int stat(String fileName, stat out) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate stat request to custome FS impl?";
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("stat requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        Path path = ROOT_PATH.resolve(fileName);
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                out.st_mode |= 0x4000L;
            } else if (Files.isRegularFile(path, new LinkOption[0])) {
                out.st_mode |= 0x8000L;
            } else if (Files.isSymbolicLink(path)) {
                out.st_mode |= 0xA000L;
            }
            try {
                out.st_size = Files.size(path);
                out.st_ino = ((Number)Files.getAttribute(path, "unix:ino", new LinkOption[0])).longValue();
                out.st_dev = ((Number)Files.getAttribute(path, "unix:dev", new LinkOption[0])).longValue();
                out.st_gid = ((Number)Files.getAttribute(path, "unix:gid", new LinkOption[0])).longValue();
                out.st_uid = ((Number)Files.getAttribute(path, "unix:uid", new LinkOption[0])).longValue();
                out.st_mtim.tv_nsec = Files.getLastModifiedTime(path, new LinkOption[0]).to(TimeUnit.NANOSECONDS);
                out.st_mtim.tv_sec = Files.getLastModifiedTime(path, new LinkOption[0]).to(TimeUnit.SECONDS);
                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(path, new LinkOption[0]);
                for (PosixFilePermission perm : perms) {
                    out.st_mode |= (long)io.toUnixPermImpl(perm);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 0;
        }
        io.setErrno(2);
        return -1;
    }

    public static int fstat(int fildes, stat out) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate fstat request to custome FS impl?";
        String openedFileNameImpl = io.getOpenedFileNameImpl(fildes);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("fstat requested for " + fildes + ":" + openedFileNameImpl, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFileNameImpl == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing not opened {0}", fildes);
            io.setErrno(9);
            return -1;
        }
        if (fildes <= 2) {
            out.st_mode = 8192L;
            out.st_blksize = io.isatty(fildes) != 0 ? 0L : 1024L;
            return 0;
        }
        return io.stat(openedFileNameImpl, out);
    }

    public static int mkdir(char$iterator<?> file, int mode) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static DIR opendir(char$iterator<?> file) {
        io.setErrno(0);
        Logger.getLogger(io.class.getName()).log(Level.SEVERE, "opendir is not supported {0}", file);
        return null;
    }

    public static int closedir(DIR dir) {
        io.setErrno(0);
        Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closedir is not supported {0}", dir);
        return io.errno();
    }

    public static dirent readdir(DIR dir) {
        io.setErrno(0);
        Logger.getLogger(io.class.getName()).log(Level.SEVERE, "readdir is not supported {0}", dir);
        return null;
    }

    public static int remove(char$iterator<?> __file) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int link(char$iterator<?> __existingfile, char$iterator<?> __link) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int symlink(char$iterator<?> __existingfile, char$iterator<?> __link) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int rename(char$iterator<?> __from, char$iterator<?> __to) {
        String from = Native.$toString(__from);
        String to = Native.$toString(__to);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("rename requested [" + from + "] => [" + to + "]", NativeTrace.TRACE_IO);
        }
        Path fromPath = ROOT_PATH.resolve(from);
        Path toPath = ROOT_PATH.resolve(to);
        io.setErrno(0);
        try {
            Files.move(fromPath, toPath, new CopyOption[0]);
        }
        catch (IOException ex) {
            io.setErrno(5);
            return -1;
        }
        return 0;
    }

    public static int truncate(char$iterator<?> __file, long size) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static char$iterator<?> getcwd(char$iterator<?> buf, long bufSize) {
        io.setErrno(0);
        String curDir = System.getProperty("user.dir");
        char$iterator<?> first = Native.$tryClone(buf);
        int i = 0;
        while ((long)i < Math.min(bufSize, (long)curDir.length())) {
            first.star$ref().$set((byte)curDir.charAt(i));
            first.$preInc();
            ++i;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int close(int FileDescriptor2) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate close request to custome FS impl?";
        io.setErrno(0);
        OpenedFile openedFile = io.getOpenedFileImpl(FileDescriptor2);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("closing " + FileDescriptor2 + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing not opened {0}", FileDescriptor2);
            io.setErrno(9);
            return -1;
        }
        if (FileDescriptor2 <= 2) {
            if (FileDescriptor2 == 2) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing standard stream {0}", FileDescriptor2);
                io.setErrno(9);
                return -1;
            }
            return 0;
        }
        List<OpenedFile> list2 = openedFiles;
        synchronized (list2) {
            openedFiles.set(FileDescriptor2, null);
        }
        try {
            openedFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
            io.setErrno(5);
            return -1;
        }
        return 0;
    }

    public static int open(char$iterator<?> __file, long __oflag, long ... additional_args) {
        boolean create;
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate open request to custome FS impl?";
        String fileName = Native.$toString(__file);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("open requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        Path filePath = ROOT_PATH.resolve(fileName);
        io.setErrno(0);
        boolean read = (__oflag & 3L) == 0L || (__oflag & 3L) == 2L || (__oflag & 0x400L) == 1024L;
        boolean truncate = (__oflag & 0x100L) == 256L || (__oflag & 0x200L) == 512L;
        boolean write = (__oflag & 3L) == 1L || (__oflag & 3L) == 2L || truncate;
        boolean bl = create = (__oflag & 0x100L) == 256L;
        if (create || Files.exists(filePath, new LinkOption[0])) {
            if (!create && read && !Files.isReadable(filePath)) {
                io.setErrno(13);
                return -1;
            }
            if (!create && write && !Files.isWritable(filePath)) {
                io.setErrno(13);
                return -1;
            }
            String mode = io.convertToJavaFileOpenMode(__oflag);
            try {
                return io.openFileDescriptorImpl(fileName, mode, truncate);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(io.class.getName()).log(Level.FINEST, null, ex);
                io.setErrno(2);
                return -1;
            }
            catch (IOException ex) {
                Logger.getLogger(io.class.getName()).log(Level.INFO, null, ex);
                io.setErrno(13);
                return -1;
            }
        }
        io.setErrno(2);
        return -1;
    }

    public static int unlink(char$iterator<?> __file) {
        try {
            io.setErrno(0);
            String fileName = Native.$toString(__file);
            if (NativeTrace.TRACE_IO) {
                NativeTrace.trace("unlink requested for:" + fileName, NativeTrace.TRACE_IO);
            }
            Path filePath = ROOT_PATH.resolve(fileName);
            Files.delete(filePath);
            return 0;
        }
        catch (IOException ex) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
            io.setErrno(30);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OpenedFile getOpenedFileImpl(void$ptr MMap) {
        List<OpenedFile> list2 = openedFiles;
        synchronized (list2) {
            for (OpenedFile file : openedFiles) {
                if (file == null || !file.isPtrOwner(MMap)) continue;
                return file;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OpenedFile getOpenedFileImpl(int FileDescriptor2) {
        List<OpenedFile> list2 = openedFiles;
        synchronized (list2) {
            return FileDescriptor2 < openedFiles.size() ? openedFiles.get(FileDescriptor2) : null;
        }
    }

    private static String getOpenedFileNameImpl(int FileDescriptor2) {
        OpenedFile file = io.getOpenedFileImpl(FileDescriptor2);
        return file == null ? null : file.name;
    }

    private static String convertToJavaFileOpenMode(long __oflag) {
        boolean write;
        boolean read = (__oflag & 3L) == 0L || (__oflag & 3L) == 2L || (__oflag & 0x400L) == 1024L;
        boolean bl = write = (__oflag & 3L) == 1L || (__oflag & 3L) == 2L || (__oflag & 0x100L) == 256L || (__oflag & 0x200L) == 512L;
        assert (read || write);
        return write ? RW_OPEN_MODE : R_OPEN_MODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int openFileDescriptorImpl(String name, String mode, boolean truncate) throws FileNotFoundException, IOException {
        RandomAccessFile file;
        block8: {
            file = new RandomAccessFile(name, mode);
            if (truncate) {
                try {
                    file.getChannel().truncate(0L);
                }
                catch (IOException e) {
                    if ("/dev/null".contentEquals(name)) break block8;
                    throw e;
                }
            }
        }
        List<OpenedFile> list2 = openedFiles;
        synchronized (list2) {
            int index = -1;
            for (int i = 0; i < openedFiles.size(); ++i) {
                if (openedFiles.get(i) != null) continue;
                index = i;
                break;
            }
            if (index == -1) {
                index = openedFiles.size();
                openedFiles.add(null);
            }
            openedFiles.set(index, new OpenedFile(name, file));
            return index;
        }
    }

    public static FILE fopen(char$iterator<?> __file, CharSequence mode) {
        String fileName = Native.$toString(__file);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("fopen requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (new File(fileName).exists()) {
            FILE out = new FILE();
            return out;
        }
        io.setErrno(2);
        return null;
    }

    public static int access(char$iterator<?> __file, long mode) {
        String fileName = Native.$toString(__file);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("access requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        Path path = ROOT_PATH.resolve(fileName);
        io.setErrno(0);
        if (mode > 7L) {
            io.setErrno(22);
            return -1;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            io.setErrno(2);
            return -1;
        }
        if (mode == 0L) {
            return 0;
        }
        if ((mode & 4L) == 4L && !Files.isReadable(path)) {
            io.setErrno(13);
            return -1;
        }
        if ((mode & 2L) == 2L && !Files.isWritable(path)) {
            io.setErrno(13);
            return -1;
        }
        if ((mode & 1L) == 1L && !Files.isExecutable(path)) {
            io.setErrno(13);
            return -1;
        }
        return 0;
    }

    public static int ferror(FILE F) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int feof(FILE F) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fclose(FILE F) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int ftruncate(int FD, long size) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fread(char$ptr buf, long elem_size, long count, FILE F) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static char$ptr mmap(void$ptr start, long length, int prot, int flags, int FD, long offset) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate mmap-open request to custome FS impl?";
        OpenedFile openedFile = io.getOpenedFileImpl(FD);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("fstat requested for " + FD + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (start != null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "invalid addr {0}:{1}", new Object[]{FD, start});
            io.setErrno(22);
            return MAP_FAILED;
        }
        if (offset != 0L) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "invalid offset {0}:{1}", new Object[]{FD, offset});
            io.setErrno(22);
            return MAP_FAILED;
        }
        assert (start == null) : "non null is not portable";
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing not opened {0}", FD);
            io.setErrno(9);
            return MAP_FAILED;
        }
        if (openedFile.file == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing {0}:{1}", new Object[]{FD, openedFile});
            io.setErrno(9);
            return MAP_FAILED;
        }
        FileChannel.MapMode mode = io.toMapMode(prot, flags);
        if (mode == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "no write or read flags {0}:{1}", new Object[]{FD, Integer.toHexString(flags)});
            io.setErrno(22);
            return MAP_FAILED;
        }
        try {
            return openedFile.mmap(mode, offset, length);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(io.class.getName()).log(Level.WARNING, "file {0} not found, probably removed", new Object[]{openedFile.toString()});
            io.setErrno(22);
            return MAP_FAILED;
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("cannot extend file to required size")) {
                Logger.getLogger(io.class.getName()).log(Level.WARNING, "file {0} size doesn't match, probably updated externally", new Object[]{openedFile.toString()});
            } else {
                Logger.getLogger(io.class.getName()).log(Level.WARNING, "" + openedFile, ex);
            }
            io.setErrno(22);
            return MAP_FAILED;
        }
    }

    public static int munmap(void$ptr start, long length) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate munmap request to custome FS impl?";
        OpenedFile openedFile = io.getOpenedFileImpl(start);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("munmap requested " + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFile == null) {
            io.setErrno(22);
            return -1;
        }
        openedFile.munmap(start, length);
        return 0;
    }

    private static FileChannel.MapMode toMapMode(int protection, int flags) {
        FileChannel.MapMode mode = null;
        if ((protection & 2) == 2) {
            if ((protection & 1) == 1) {
                return FileChannel.MapMode.READ_WRITE;
            }
            if ((flags & 2) == 2) {
                return FileChannel.MapMode.PRIVATE;
            }
        } else if ((protection & 1) == 1) {
            return FileChannel.MapMode.READ_ONLY;
        }
        return mode;
    }

    public static int uname(utsname out) {
        io.setErrno(0);
        std.memcpy(out.sysname, System.getProperty("os.name", UNKNOWN));
        std.memcpy(out.version, System.getProperty("os.version", UNKNOWN));
        std.memcpy(out.machine, System.getProperty("os.arch", UNKNOWN));
        std.memcpy(out.nodename, Hostname.hostName);
        std.memcpy(out.release, System.getProperty("os.arch", UNKNOWN) + "-" + System.getProperty("os.name", UNKNOWN) + "-" + System.getProperty("os.version", UNKNOWN));
        return io.errno();
    }

    public static int dladdr(void$ptr addr, Dl_info out) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int sscanf(char$ptr __s, char$ptr __format, Object ... variables) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int dup2(int oldfd, int newfd) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    static {
        openedFiles.add(0, new OpenedFile("stdin", (RandomAccessFile)null));
        openedFiles.add(1, new OpenedFile("stdout", FileDescriptor.out));
        openedFiles.add(2, new OpenedFile("stderr", FileDescriptor.err));
        if (NativeTrace.VERBOSE_MODE) {
            System.err.printf("STDOUT is a TTY? %s\n", io.isatty(1) != 0);
        }
        assert (openedFiles.size() == 3);
        MAP_FAILED = Native.$toConst(NativePointer.create_char$ptr((byte[])null));
    }

    public static final class Dl_info {
        public char$ptr dli_fname;
        public void$ptr dli_fbase;
        public char$ptr dli_sname;
        public void$ptr dli_saddr;
    }

    private static final class Hostname {
        private static final String hostName = Hostname.get();

        private Hostname() {
        }

        private static String get() {
            String hostName = null;
            if (hostName == null) {
                hostName = System.getProperty("HOSTNAME");
            }
            if (hostName == null) {
                hostName = System.getenv("HOSTNAME");
            }
            if (hostName == null) {
                try {
                    Process uname = Runtime.getRuntime().exec("uname -n");
                    BufferedReader input = new BufferedReader(new InputStreamReader(uname.getInputStream()));
                    hostName = input.readLine();
                    int ret = uname.waitFor();
                    if (ret != 0) {
                        hostName = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hostName == null) {
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return hostName == null ? io.UNKNOWN : hostName;
        }
    }

    public static final class utsname {
        public byte[] sysname = NativePointer.new$char(65, new byte[0]);
        public byte[] nodename = NativePointer.new$char(65, new byte[0]);
        public byte[] release = NativePointer.new$char(65, new byte[0]);
        public byte[] version = NativePointer.new$char(65, new byte[0]);
        public byte[] machine = NativePointer.new$char(65, new byte[0]);
        public byte[] domainname = NativePointer.new$char(65, new byte[0]);
    }

    private static final class JavaPrintStreamWrapper
    implements DataOutput {
        private final OutputStream delegate;

        public JavaPrintStreamWrapper(FileDescriptor outFD) {
            assert (outFD == FileDescriptor.out || outFD == FileDescriptor.err);
            this.delegate = outFD == FileDescriptor.out ? System.out : System.err;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeByte(int v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeShort(int v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeChar(int v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeInt(int v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeLong(long v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeFloat(float v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeDouble(double v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeBytes(String s) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeChars(String s) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeUTF(String s) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class OpenedFile {
        private final String name;
        private final RandomAccessFile file;
        private final DataOutput outStream;
        private boolean closed = false;
        private final char$ptr charPtr = NativePointer.create_char$null$ptr();
        private MappedByteBuffer BBuffer = null;

        public OpenedFile(String name, RandomAccessFile file) {
            this.name = name;
            this.file = file;
            this.outStream = file;
        }

        public OpenedFile(String name, FileDescriptor outFD) {
            this.name = name;
            this.file = null;
            this.outStream = new JavaPrintStreamWrapper(outFD);
        }

        public String toString() {
            return "OpenedFile{name=" + this.name + ", file=" + this.file + '}';
        }

        public int close() throws IOException {
            if (this.closed) {
                throw new IllegalStateException("already closed " + this.name);
            }
            this.file.close();
            return 0;
        }

        private void write(byte[] buffer, int off, int len) throws IOException {
            this.outStream.write(buffer, off, len);
        }

        public char$ptr mmap(FileChannel.MapMode mode, long pos, long size) throws IOException {
            assert (this.charPtr.$isNull()) : "already in use";
            assert (this.BBuffer == null) : "already in use";
            MappedByteBuffer out = this.file.getChannel().map(mode, pos, size);
            byte[] dst = NativePointer.new$char(pos + size + 1L, new byte[0]);
            out.get(dst, Unsigned.long2uint(pos), Unsigned.long2uint(size));
            this.charPtr.$assign(NativePointer.create_char$ptr(dst, pos));
            return this.charPtr;
        }

        public boolean isPtrOwner(void$ptr MMapPtr) {
            assert (MMapPtr != this.charPtr || !this.charPtr.$isNull()) : "null can not be mapped";
            return MMapPtr == this.charPtr || this.charPtr.$eq(MMapPtr);
        }

        public boolean munmap(void$ptr MMapPtr, long length) {
            this.BBuffer = null;
            NativePointer.clear_char$ptr(this.charPtr);
            return true;
        }
    }

    public static final class stat {
        public long st_dev;
        public long[] st_pad1 = NativePointer.new$long(3, new int[0]);
        public long st_ino;
        public long st_mode;
        public long st_nlink;
        public long st_uid;
        public long st_gid;
        public long st_rdev;
        public long[] st_pad2 = NativePointer.new$long(2, new int[0]);
        public long st_size;
        public long st_pad3;
        public timespec st_atim = new timespec();
        public timespec st_mtim = new timespec();
        public timespec st_ctim = new timespec();
        public long st_blksize;
        public long st_blocks;
        public byte[] st_fstype = NativePointer.new$char(16, new byte[0]);
        public long[] st_pad4 = NativePointer.new$long(8, new int[0]);
    }

    public static class dirent {
        public long d_ino;
        public long d_off;
        public int d_reclen;
        public byte[] d_name = NativePointer.new$char(1, new byte[0]);

        public String toString() {
            return "dirent{d_ino=" + this.d_ino + ", d_off=" + this.d_off + ", d_reclen=" + this.d_reclen + ", d_name=" + new String(this.d_name) + '}';
        }
    }

    public static class DIR {
        public int d_fd;
        public int d_loc;
        public int d_size;
        public char$ptr d_buf;

        public String toString() {
            return "DIR{d_fd=" + this.d_fd + ", d_loc=" + this.d_loc + ", d_size=" + this.d_size + ", d_buf=" + this.d_buf + '}';
        }
    }

    public static class FILE {
        public int _cnt;
        public uchar.ptr _ptr;
        public uchar.ptr _base;
        public short _flag;
        public short _magic;
        public byte __orientation;
        public boolean __ionolock;
        public boolean __seekable;
        public boolean __extendedfd;
        public boolean __xf_nocheck;
        public char __filler;
    }

    public static final class timespec
    implements Native.NativePOD<timespec> {
        public long tv_sec;
        public long tv_nsec;

        public timespec() {
        }

        public timespec(timespec other) {
            this.tv_nsec = other.tv_nsec;
            this.tv_sec = other.tv_sec;
        }

        @Override
        public timespec $assign(timespec value) {
            this.tv_nsec = value.tv_nsec;
            this.tv_sec = value.tv_sec;
            return this;
        }

        @Override
        public timespec clone() {
            return new timespec(this);
        }

        @Override
        public boolean $noteq(timespec other) {
            return !this.$eq(other);
        }

        @Override
        public boolean $eq(timespec other) {
            return this.tv_nsec == other.tv_nsec && this.tv_sec == other.tv_sec;
        }
    }

    public static final class timezone {
        int tz_minuteswest;
        int tz_dsttime;
    }

    public static final class timeval {
        public long tv_sec;
        public long tv_usec;
    }

    private static class StreamOut
    implements ostream {
        private final PrintStream out;

        public StreamOut(PrintStream out) {
            this.out = out;
        }

        @Override
        public basic_ostream $out(String format, Object ... args) {
            this.out.printf(format, args);
            return this;
        }

        @Override
        public <T> basic_ostream $out(T o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream $out_os_str(std.string str) {
            this.out.print(str.c_str());
            return this;
        }

        @Override
        public basic_ostream $out(byte o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream $out(char o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream $out(int o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream $out(long o) {
            this.out.print(o);
            return this;
        }
    }

    private static class StreamIn
    implements istream {
        private final InputStream in;

        public StreamIn(InputStream in) {
            this.in = in;
        }

        @Override
        public boolean eof() {
            return false;
        }

        @Override
        public boolean fail() {
            return false;
        }

        @Override
        public int getline(std.string to) {
            StringBuilder out = new StringBuilder();
            try {
                int ch;
                while ((ch = this.in.read()) != -1 && ch != 10) {
                    out.append((char)ch);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
            }
            to.$assign(out.toString());
            return out.length() == 0 ? -1 : out.length();
        }
    }

    public static interface iostream
    extends istream,
    ostream {
    }

    public static interface ostream
    extends basic_ostream {
    }

    public static interface basic_ostream {
        public <T> basic_ostream $out(T var1);

        public basic_ostream $out(byte var1);

        public basic_ostream $out(char var1);

        public basic_ostream $out(int var1);

        public basic_ostream $out(long var1);

        public basic_ostream $out_os_str(std.string var1);

        public basic_ostream $out(String var1, Object ... var2);
    }

    public static interface istream
    extends basic_istream {
    }

    public static interface basic_istream {
        public boolean eof();

        public boolean fail();

        public int getline(std.string var1);
    }
}

