/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl;

import org.clank.java.built_in;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.clank.support.aliases.ushort$ref;

public class StdBaseBitset {
    protected static final int _GLIBCXX_BITSET_BITS_PER_WORD = 16;
    protected static final int __CHAR_BIT__ = 8;
    private final int _Nw;
    private final char[] _M_w;

    public StdBaseBitset() {
        this._Nw = 0;
        this._M_w = null;
    }

    protected StdBaseBitset(int _Nw) {
        this._Nw = _Nw;
        this._M_w = NativePointer.new$uchar(_Nw);
    }

    protected StdBaseBitset(int _Nw, long __val) {
        this(_Nw);
        this._M_w[0] = (char)__val;
    }

    protected static int _S_whichword(int __pos) {
        return __pos / 16;
    }

    protected static int _S_whichbyte(int __pos) {
        return __pos % 16 / 8;
    }

    protected static int _S_whichbit(int __pos) {
        return __pos % 16;
    }

    protected static char _S_maskbit(int __pos) {
        return (char)(1 << StdBaseBitset._S_whichbit(__pos));
    }

    protected int _M_getword(int __pos) {
        return this._M_w[StdBaseBitset._S_whichword(__pos)];
    }

    protected ushort$ref _M_getword$ref(int __pos) {
        return NativePointer.create_ushort$ref(this._M_w, StdBaseBitset._S_whichword(__pos));
    }

    protected int _M_hiword() {
        return this._M_w[this._Nw - 1];
    }

    protected ushort$ref _M_hiword$ref() {
        return NativePointer.create_ushort$ref(this._M_w, this._Nw - 1);
    }

    protected void _M_do_and(StdBaseBitset __x) {
        for (int __i = 0; __i < this._Nw; ++__i) {
            int n = __i;
            this._M_w[n] = (char)(this._M_w[n] & __x._M_w[__i]);
        }
    }

    protected void _M_do_or(StdBaseBitset __x) {
        for (int __i = 0; __i < this._Nw; ++__i) {
            int n = __i;
            this._M_w[n] = (char)(this._M_w[n] | __x._M_w[__i]);
        }
    }

    protected void _M_do_xor(StdBaseBitset __x) {
        for (int __i = 0; __i < this._Nw; ++__i) {
            int n = __i;
            this._M_w[n] = (char)(this._M_w[n] ^ __x._M_w[__i]);
        }
    }

    protected void _M_do_left_shift(int __shift) {
        if (__shift != 0) {
            int __wshift = __shift / 16;
            int __offset = __shift % 16;
            if (__offset == 0) {
                for (int __n = this._Nw - 1; __n >= __wshift; --__n) {
                    this._M_w[__n] = this._M_w[__n - __wshift];
                }
            } else {
                int __sub_offset = 16 - __offset;
                for (int __n = this._Nw - 1; __n > __wshift; --__n) {
                    this._M_w[__n] = (char)(this._M_w[__n - __wshift] << __offset | this._M_w[__n - __wshift - 1] >> __sub_offset);
                }
                this._M_w[__wshift] = (char)(this._M_w[0] << __offset);
            }
            std.fill(NativePointer.create_ushort$ptr(this._M_w), NativePointer.create_ushort$ptr(this._M_w, __wshift), '\u0000');
        }
    }

    protected void _M_do_right_shift(int __shift) {
        if (__shift != 0) {
            int __wshift = __shift / 16;
            int __offset = __shift % 16;
            int __limit = this._Nw - __wshift - 1;
            if (__offset == 0) {
                for (int __n = 0; __n <= __limit; ++__n) {
                    this._M_w[__n] = this._M_w[__n + __wshift];
                }
            } else {
                int __sub_offset = 16 - __offset;
                for (int __n = 0; __n < __limit; ++__n) {
                    this._M_w[__n] = (char)(this._M_w[__n + __wshift] >> __offset | this._M_w[__n + __wshift + 1] << __sub_offset);
                }
                this._M_w[__limit] = (char)(this._M_w[this._Nw - 1] >> __offset);
            }
            std.fill(NativePointer.create_ushort$ptr(this._M_w, __limit + 1), NativePointer.create_ushort$ptr(this._M_w, this._Nw), '\u0000');
        }
    }

    protected void _M_do_flip() {
        for (int __i = 0; __i < this._Nw; ++__i) {
            this._M_w[__i] = ~this._M_w[__i];
        }
    }

    protected void _M_do_set() {
        for (int __i = 0; __i < this._Nw; ++__i) {
            this._M_w[__i] = 65535;
        }
    }

    protected void _M_do_reset() {
        std.memset(this._M_w, '\u0000', this._Nw);
    }

    protected boolean _M_is_equal(StdBaseBitset __x) {
        for (int __i = 0; __i < this._Nw; ++__i) {
            if (this._M_w[__i] == __x._M_w[__i]) continue;
            return false;
        }
        return true;
    }

    protected boolean _M_are_all(int _Nb) {
        for (int __i = 0; __i < this._Nw - 1; ++__i) {
            if (this._M_w[__i] == '\uffff') continue;
            return false;
        }
        return this._M_hiword() == -1 >> this._Nw * 16 - _Nb;
    }

    protected boolean _M_is_any() {
        for (int __i = 0; __i < this._Nw; ++__i) {
            if (this._M_w[__i] == '\u0000') continue;
            return true;
        }
        return false;
    }

    protected int _M_do_count() {
        int __result = 0;
        for (int __i = 0; __i < this._Nw; ++__i) {
            __result += built_in.__builtin_popcountl(this._M_w[__i]);
        }
        return __result;
    }

    protected long _M_do_to_ulong() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    protected int _M_do_find_first(int __not_found) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    protected int _M_do_find_next(int __prev, int __not_found) {
        throw new UnsupportedOperationException("Not supported yet!");
    }
}

