/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.text.MessageFormat;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clank.support.StackElementArray;

public final class NativeTrace {
    private static final Logger LOG = Logger.getLogger("cnd.logger");
    private static boolean releaseMode;
    private static volatile Throwable lastAssertion;
    private static final boolean STANDALONE;
    public static final int TO_STRING_LIMIT = 256;
    public static final boolean OPTIMIZE_DENSE_MAP_INFO;
    public static final String REUSE_JAVA_CLEANER_PROP = "org.clank.reuse.java.cleaner";
    public static final boolean REUSE_JAVA_CLEANER;
    public static final boolean STATISTICS;
    public static final boolean TRACE_IO;
    public static final boolean TRACE_BUILT_IN;
    public static final boolean TRACE_MEMORY;
    public static final String TRACE_FILE_INFO_EXIT_PROP = "org.clank.trace.file.level";
    public static final int TRACE_FILE_INFO_EXIT;
    public static final String CLANK_VERBOSE_PROP = "org.clank.verbose";
    public static final boolean VERBOSE_MODE;
    public static final boolean UNIT_TEST_MODE;
    public static final boolean CHECK_ALLOCATOR;
    public static final String CHECK_STD_PTR_ACCESS_PROP = "clank.check.unique_ptr";
    public static final boolean CHECK_STD_PTR_ACCESS;
    public static final boolean ALWAYS_USE_NB_FS;
    private static final ConcurrentHashMap<CharSequence, AtomicInteger> restrictLog;
    private static final Set<StackElementArray> toStringStacks;

    private static boolean initStandalone() {
        if ("true".equals(System.getProperty("cnd.command.line.utility"))) {
            return true;
        }
        if (NativeTrace.getBoolean("java.awt.headless", false)) {
            return true;
        }
        return !NativeTrace.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    public static boolean getBoolean(String systemPropertyName, boolean defaultValue) {
        String text = System.getProperty(systemPropertyName);
        if (text != null) {
            defaultValue = Boolean.parseBoolean(text);
        }
        return defaultValue;
    }

    public static boolean isStandalone() {
        return STANDALONE;
    }

    public static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    public static boolean isReleaseMode() {
        return releaseMode;
    }

    public static boolean isDebugMode() {
        return !NativeTrace.isReleaseMode();
    }

    public static final void trace(String message, boolean traceFlag) {
        if (traceFlag) {
            System.err.println(message);
        }
    }

    private NativeTrace() {
        throw new AssertionError((Object)"Not instantiable");
    }

    public static String formatNumber(long num) {
        return NativeTrace.formatNumber(num, -1);
    }

    public static String formatNumber(long num, int digits) {
        String fmt = "%,";
        if (digits > 0) {
            fmt = fmt + digits;
        }
        fmt = fmt + "d";
        return String.format(fmt, num);
    }

    public static void assertTrue(boolean value) {
        if (!value && NativeTrace.isDebugMode()) {
            NativeTrace.severe("Assertion error");
        }
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null && NativeTrace.isDebugMode()) {
            NativeTrace.severe(message);
        }
    }

    public static void assertUnconditional(String message) {
        if (NativeTrace.isDebugMode()) {
            NativeTrace.severe(message);
        }
    }

    public static void assertNotNull(Object object, CharSequence prefix, Object message) {
        if (object == null && NativeTrace.isDebugMode()) {
            NativeTrace.severe(prefix.toString() + message);
        }
    }

    public static void assertNotNullInConsole(Object object, String message) {
        if (object == null && NativeTrace.isDebugMode()) {
            NativeTrace.info(message);
        }
    }

    public static void assertNull(Object object, String message) {
        if (object != null && NativeTrace.isDebugMode()) {
            NativeTrace.severe(message);
        }
    }

    public static int getNumberCndWorkerThreads() {
        int threadCount = Math.min(4, Runtime.getRuntime().availableProcessors() - 2);
        if (System.getProperty("cnd.modelimpl.parser.threads") != null) {
            threadCount = Integer.getInteger("cnd.modelimpl.parser.threads");
        }
        return Math.max(threadCount, 1);
    }

    public static int getConcurrencyLevel() {
        return NativeTrace.getNumberCndWorkerThreads();
    }

    public static void assertFalse(boolean value) {
        if (value && NativeTrace.isDebugMode()) {
            NativeTrace.severe("Assertion error");
        }
    }

    public static void assertFalse(boolean value, String message) {
        NativeTrace.assertTrue(!value, message);
    }

    public static void assertTrue(boolean value, String message) {
        if (NativeTrace.isDebugMode() && !value) {
            NativeTrace.severe(message);
        }
    }

    private static String addThreadName(String msg) {
        return msg + "\n@[" + Thread.currentThread().getName() + "]";
    }

    public static void assertTrue(boolean value, String prefix, Object message) {
        if (NativeTrace.isDebugMode() && !value) {
            lastAssertion = new Exception(NativeTrace.addThreadName(prefix + message));
            NativeTrace.printStackTraceOnce(lastAssertion);
        }
    }

    public static void severe(Exception exception) {
        lastAssertion = exception;
        LOG.log(Level.SEVERE, exception.getMessage(), lastAssertion);
    }

    private static void severe(String message) {
        lastAssertion = new Exception(NativeTrace.addThreadName(message));
        LOG.log(Level.SEVERE, message, lastAssertion);
    }

    private static void info(String message) {
        if (LOG.isLoggable(Level.INFO)) {
            lastAssertion = new Exception(NativeTrace.addThreadName(message));
            LOG.log(Level.INFO, message, lastAssertion);
        }
    }

    public static void assertTrueInConsole(boolean value, String message) {
        if (NativeTrace.isDebugMode() && !value && LOG.isLoggable(Level.INFO)) {
            StackTraceElement[] stackTrace;
            Exception exception = new Exception(NativeTrace.addThreadName(message));
            Level level = Level.INFO;
            for (StackTraceElement element : stackTrace = exception.getStackTrace()) {
                int i;
                AtomicInteger counter;
                String className = element.getClassName();
                if (className.contains(".NativeTrace")) continue;
                int lineNumber = element.getLineNumber();
                String key = className + "-" + lineNumber;
                AtomicInteger old = restrictLog.putIfAbsent(key, counter = new AtomicInteger());
                if (old != null) {
                    counter = old;
                }
                if ((i = counter.incrementAndGet()) <= 3) break;
                level = Level.FINE;
                break;
            }
            lastAssertion = exception;
            LOG.log(level, message, exception);
        }
    }

    private static boolean pathsEqual(CharSequence path1, CharSequence path2) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return false;
        }
        if (path1 == path2) {
            return true;
        }
        int len = path1.length();
        if (len == path2.length()) {
            for (int i = len - 1; i >= 0; --i) {
                char c1 = path1.charAt(i);
                char c2 = path2.charAt(i);
                if (!(c1 == '/' || c1 == '\\' ? c2 != '/' && c2 != '\\' : c1 != c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void assertPathsEqualInConsole(CharSequence path1, CharSequence path2, String format, Object ... args) {
        if (NativeTrace.isDebugMode() && !NativeTrace.pathsEqual(path1, path2)) {
            String text = MessageFormat.format(format, args);
            NativeTrace.assertTrueInConsole(false, text);
        }
    }

    public static void assertTrueInConsole(boolean value, String prefix, Object message) {
        if (NativeTrace.isDebugMode() && !value && LOG.isLoggable(Level.INFO)) {
            NativeTrace.assertTrueInConsole(value, prefix + message);
        }
    }

    public static Throwable getLastAssertion() {
        return lastAssertion;
    }

    public static void clearLastAssertion() {
        lastAssertion = null;
    }

    public static Logger getLogger() {
        return LOG;
    }

    public static void printStackTraceOnce(Throwable exception, int stackCompareSize) {
        NativeTrace.printStackTraceOnce(exception, Level.INFO, true, stackCompareSize);
    }

    public static void printStackTraceOnce(Throwable exception) {
        NativeTrace.printStackTraceOnce(exception, Level.INFO, true);
    }

    public static void printStackTraceOnce(Throwable cause, Level level, boolean once, int stackCompareSize) {
        if (NativeTrace.isDebugMode() && (!once || StackElementArray.addStackIfNew(cause.getStackTrace(), toStringStacks, stackCompareSize))) {
            lastAssertion = cause;
            LOG.log(level, cause.getMessage(), lastAssertion);
        }
    }

    public static void printStackTraceOnce(Throwable cause, Level level, boolean once) {
        NativeTrace.printStackTraceOnce(cause, level, once, 6);
    }

    static {
        String text = System.getProperty("cnd.release.mode");
        if (text == null) {
            releaseMode = true;
            if (!$assertionsDisabled) {
                releaseMode = false;
                if (false) {
                    throw new AssertionError();
                }
            }
        } else {
            releaseMode = Boolean.parseBoolean(text);
        }
        STANDALONE = NativeTrace.initStandalone();
        OPTIMIZE_DENSE_MAP_INFO = Boolean.valueOf(System.getProperty("org.clank.optimize.densemap.info", "true"));
        REUSE_JAVA_CLEANER = Boolean.valueOf(System.getProperty(REUSE_JAVA_CLEANER_PROP, "false"));
        STATISTICS = Boolean.valueOf(System.getProperty("org.clank.statistics", "false"));
        TRACE_IO = Boolean.valueOf(System.getProperty("org.clank.trace_io", "false"));
        TRACE_BUILT_IN = Boolean.valueOf(System.getProperty("org.clank.trace_builtin", "false"));
        TRACE_MEMORY = Boolean.valueOf(System.getProperty("org.clank.trace_memory", "false"));
        TRACE_FILE_INFO_EXIT = Integer.valueOf(System.getProperty(TRACE_FILE_INFO_EXIT_PROP, "0"));
        VERBOSE_MODE = Boolean.valueOf(System.getProperty(CLANK_VERBOSE_PROP, "false"));
        UNIT_TEST_MODE = Boolean.getBoolean("cnd.mode.unittest");
        CHECK_ALLOCATOR = Boolean.getBoolean("clank.check.allocator");
        ALWAYS_USE_NB_FS = Boolean.valueOf(System.getProperty("apt.always.use.filesystem", "false"));
        boolean checkStdPtrAccess = false;
        if (System.getProperty(CHECK_STD_PTR_ACCESS_PROP) != null) {
            checkStdPtrAccess = Boolean.getBoolean(CHECK_STD_PTR_ACCESS_PROP);
        } else if (UNIT_TEST_MODE) {
            checkStdPtrAccess = true;
        }
        CHECK_STD_PTR_ACCESS = checkStdPtrAccess;
        restrictLog = new ConcurrentHashMap();
        toStringStacks = NativeTrace.isDebugMode() ? StackElementArray.createSet() : null;
    }
}

