/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.RegularFileObject;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.SymbolArchive;
import com.sun.tools.javac.file.ZipArchive;
import com.sun.tools.javac.file.ZipFileIndex;
import com.sun.tools.javac.file.ZipFileIndexArchive;
import com.sun.tools.javac.file.ZipFileIndexCache;
import com.sun.tools.javac.util.BaseFileManager;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JavacFileManager
extends BaseFileManager
implements StandardJavaFileManager {
    private FSInfo fsInfo;
    private boolean contextUseOptimizedZip;
    private ZipFileIndexCache zipFileIndexCache;
    private final Set<JavaFileObject.Kind> sourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    protected boolean mmappedIO;
    protected boolean symbolFileEnabled;
    protected SortFiles sortFiles;
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';
    Map<File, Archive> archives = new HashMap<File, Archive>();
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final RelativePath.RelativeDirectory symbolFilePrefix = new RelativePath.RelativeDirectory("META-INF/sym/rt.jar/");
    private String defaultEncodingName;

    public static char[] toArray(CharBuffer buffer) {
        if (buffer.hasArray()) {
            return ((CharBuffer)buffer.compact().flip()).array();
        }
        return buffer.toString().toCharArray();
    }

    public static void preRegister(Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make(Context c) {
                return new JavacFileManager(c, true, null);
            }
        });
    }

    public JavacFileManager(Context context, boolean register, Charset charset) {
        super(charset);
        if (register) {
            context.put(JavaFileManager.class, this);
        }
        this.setContext(context);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.fsInfo = FSInfo.instance(context);
        this.contextUseOptimizedZip = this.options.getBoolean("useOptimizedZip", true);
        if (this.contextUseOptimizedZip) {
            this.zipFileIndexCache = ZipFileIndexCache.getSharedInstance();
        }
        this.mmappedIO = this.options.isSet("mmappedIO");
        this.symbolFileEnabled = !this.options.isSet("ignore.symbol.file");
        String sf = this.options.get("sortFiles");
        if (sf != null) {
            this.sortFiles = sf.equals("reverse") ? SortFiles.REVERSE : SortFiles.FORWARD;
        }
    }

    public void setSymbolFileEnabled(boolean b) {
        this.symbolFileEnabled = b;
    }

    @Override
    public boolean isDefaultBootClassPath() {
        return this.locations.isDefaultBootClassPath();
    }

    public JavaFileObject getFileForInput(String name) {
        return this.getRegularFile(new File(name));
    }

    public JavaFileObject getRegularFile(File file) {
        return new RegularFileObject(this, file);
    }

    public JavaFileObject getFileForOutput(String classname, JavaFileObject.Kind kind, JavaFileObject sibling) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, classname, kind, sibling);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        ListBuffer<File> files = new ListBuffer<File>();
        for (String name : names) {
            files.append(new File(JavacFileManager.nullCheck(name)));
        }
        return this.getJavaFileObjectsFromFiles(files.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList((Object[])JavacFileManager.nullCheck(names)));
    }

    private static boolean isValidName(String name) {
        for (String s : name.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String className) {
        if (!JavacFileManager.isValidName(className)) {
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
    }

    private static void validatePackageName(String packageName) {
        if (packageName.length() > 0 && !JavacFileManager.isValidName(packageName)) {
            throw new IllegalArgumentException("Invalid packageName name: " + packageName);
        }
    }

    public static void testName(String name, boolean isValidPackageName, boolean isValidClassName) {
        try {
            JavacFileManager.validatePackageName(name);
            if (!isValidPackageName) {
                throw new AssertionError((Object)("Invalid package name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidPackageName) {
                throw new AssertionError((Object)("Valid package name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", name);
        }
        try {
            JavacFileManager.validateClassName(name);
            if (!isValidClassName) {
                throw new AssertionError((Object)("Invalid class name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidClassName) {
                throw new AssertionError((Object)("Valid class name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", name);
        }
    }

    private static void printAscii(String format, Object ... args) {
        String message;
        try {
            String ascii = "US-ASCII";
            message = new String(String.format(null, format, args).getBytes("US-ASCII"), "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
        System.out.println(message);
    }

    private void listDirectory(File directory, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) {
        File d = subdirectory.getFile(directory);
        if (!this.caseMapCheck(d, subdirectory)) {
            return;
        }
        File[] files = d.listFiles();
        if (files == null) {
            return;
        }
        if (this.sortFiles != null) {
            Arrays.sort(files, this.sortFiles);
        }
        for (File f : files) {
            String fname = f.getName();
            if (f.isDirectory()) {
                if (!recurse || !SourceVersion.isIdentifier(fname)) continue;
                this.listDirectory(directory, new RelativePath.RelativeDirectory(subdirectory, fname), fileKinds, recurse, resultList);
                continue;
            }
            if (!this.isValidFile(fname, fileKinds)) continue;
            RegularFileObject fe = new RegularFileObject(this, fname, new File(d, fname));
            resultList.append(fe);
        }
    }

    private void listArchive(Archive archive, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) {
        List<String> files = archive.getFiles(subdirectory);
        if (files != null) {
            while (!files.isEmpty()) {
                String file = (String)files.head;
                if (this.isValidFile(file, fileKinds)) {
                    resultList.append(archive.getFileObject(subdirectory, file));
                }
                files = files.tail;
            }
        }
        if (recurse) {
            for (RelativePath.RelativeDirectory s : archive.getSubdirectories()) {
                if (!subdirectory.contains(s)) continue;
                this.listArchive(archive, s, fileKinds, false, resultList);
            }
        }
    }

    private void listContainer(File container, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) {
        Archive archive = this.archives.get(container);
        if (archive == null) {
            if (this.fsInfo.isDirectory(container)) {
                this.listDirectory(container, subdirectory, fileKinds, recurse, resultList);
                return;
            }
            try {
                archive = this.openArchive(container);
            }
            catch (IOException ex) {
                this.log.error("error.reading.file", container, JavacFileManager.getMessage(ex));
                return;
            }
        }
        this.listArchive(archive, subdirectory, fileKinds, recurse, resultList);
    }

    private boolean isValidFile(String s, Set<JavaFileObject.Kind> fileKinds) {
        JavaFileObject.Kind kind = JavacFileManager.getKind(s);
        return fileKinds.contains((Object)kind);
    }

    private boolean caseMapCheck(File f, RelativePath name) {
        String path;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException ex) {
            return false;
        }
        char[] pcs = path.toCharArray();
        char[] ncs = name.path.toCharArray();
        int i = pcs.length - 1;
        int j = ncs.length - 1;
        while (i >= 0 && j >= 0) {
            while (i >= 0 && pcs[i] == File.separatorChar) {
                --i;
            }
            while (j >= 0 && ncs[j] == '/') {
                --j;
            }
            if (i < 0 || j < 0) continue;
            if (pcs[i] != ncs[j]) {
                return false;
            }
            --i;
            --j;
        }
        return j < 0;
    }

    protected Archive openArchive(File zipFilename) throws IOException {
        try {
            return this.openArchive(zipFilename, this.contextUseOptimizedZip);
        }
        catch (IOException ioe) {
            if (ioe instanceof ZipFileIndex.ZipFormatException) {
                return this.openArchive(zipFilename, false);
            }
            throw ioe;
        }
    }

    private Archive openArchive(File zipFileName, boolean useOptimizedZip) throws IOException {
        Archive archive;
        File origZipFileName = zipFileName;
        if (this.symbolFileEnabled && this.locations.isDefaultBootClassPathRtJar(zipFileName)) {
            File file = zipFileName.getParentFile().getParentFile();
            if (new File(file.getName()).equals(new File("jre"))) {
                file = file.getParentFile();
            }
            for (String name : symbolFileLocation) {
                file = new File(file, name);
            }
            if (file.exists()) {
                zipFileName = file;
            }
        }
        try {
            ZipFile zdir = null;
            boolean usePreindexedCache = false;
            String preindexCacheLocation = null;
            if (!useOptimizedZip) {
                zdir = new ZipFile(zipFileName);
            } else {
                usePreindexedCache = this.options.isSet("usezipindex");
                preindexCacheLocation = this.options.get("java.io.tmpdir");
                String optCacheLoc = this.options.get("cachezipindexdir");
                if (optCacheLoc != null && optCacheLoc.length() != 0) {
                    File cacheDir;
                    if (optCacheLoc.startsWith("\"")) {
                        optCacheLoc = optCacheLoc.endsWith("\"") ? optCacheLoc.substring(1, optCacheLoc.length() - 1) : optCacheLoc.substring(1);
                    }
                    if ((cacheDir = new File(optCacheLoc)).exists() && cacheDir.canWrite() && !(preindexCacheLocation = optCacheLoc).endsWith("/") && !preindexCacheLocation.endsWith(File.separator)) {
                        preindexCacheLocation = preindexCacheLocation + File.separator;
                    }
                }
            }
            archive = origZipFileName == zipFileName ? (!useOptimizedZip ? new ZipArchive(this, zdir) : new ZipFileIndexArchive(this, this.zipFileIndexCache.getZipFileIndex(zipFileName, null, usePreindexedCache, preindexCacheLocation, this.options.isSet("writezipindexfiles")))) : (!useOptimizedZip ? new SymbolArchive(this, origZipFileName, zdir, symbolFilePrefix) : new ZipFileIndexArchive(this, this.zipFileIndexCache.getZipFileIndex(zipFileName, symbolFilePrefix, usePreindexedCache, preindexCacheLocation, this.options.isSet("writezipindexfiles"))));
        }
        catch (FileNotFoundException ex) {
            archive = new MissingArchive(zipFileName);
        }
        catch (ZipFileIndex.ZipFormatException zfe) {
            throw zfe;
        }
        catch (IOException ex) {
            if (zipFileName.exists()) {
                this.log.error("error.reading.file", zipFileName, JavacFileManager.getMessage(ex));
            }
            archive = new MissingArchive(zipFileName);
        }
        this.archives.put(origZipFileName, archive);
        return archive;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
    }

    @Override
    public void close() {
        Iterator<Archive> i = this.archives.values().iterator();
        while (i.hasNext()) {
            Archive a = i.next();
            i.remove();
            try {
                a.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        }
        return this.defaultEncodingName;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        ListBuffer<URL> lb = new ListBuffer<URL>();
        for (File file : path) {
            try {
                lb.append(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.getClassLoader(lb.toArray(new URL[lb.size()]));
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        JavacFileManager.nullCheck(packageName);
        JavacFileManager.nullCheck(kinds);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return List.nil();
        }
        RelativePath.RelativeDirectory subdirectory = RelativePath.RelativeDirectory.forPackage(packageName);
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (File file : path) {
            this.listContainer(file, subdirectory, kinds, recurse, results);
        }
        return results.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        file.getClass();
        location.getClass();
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        if (file instanceof BaseFileObject) {
            return ((BaseFileObject)file).inferBinaryName(path);
        }
        throw new IllegalArgumentException(file.getClass().getName());
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        JavacFileManager.nullCheck(a);
        JavacFileManager.nullCheck(b);
        if (!(a instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + a);
        }
        if (!(b instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + b);
        }
        return a.equals(b);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocation(location) != null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForInput(location, RelativePath.RelativeFile.forClass(className, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(relativeName)) {
            throw new IllegalArgumentException("Invalid relative name: " + relativeName);
        }
        RelativePath.RelativeFile name = packageName.length() == 0 ? new RelativePath.RelativeFile(relativeName) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(packageName), relativeName);
        return this.getFileForInput(location, name);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, RelativePath.RelativeFile name) throws IOException {
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        for (File file : path) {
            Archive a = this.archives.get(file);
            if (a == null) {
                if (this.fsInfo.isDirectory(file)) {
                    File f = name.getFile(file);
                    if (!f.exists()) continue;
                    return new RegularFileObject(this, f);
                }
                a = this.openArchive(file);
            }
            if (!a.contains(name)) continue;
            return a.getFileObject(name.dirname(), name.basename());
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, RelativePath.RelativeFile.forClass(className, kind), sibling);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(relativeName)) {
            throw new IllegalArgumentException("Invalid relative name: " + relativeName);
        }
        RelativePath.RelativeFile name = packageName.length() == 0 ? new RelativePath.RelativeFile(relativeName) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(packageName), relativeName);
        return this.getFileForOutput(location, name, sibling);
    }

    /*
     * Enabled aggressive block sorting
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, RelativePath.RelativeFile fileName, FileObject sibling) throws IOException {
        File dir;
        block7: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    dir = this.getClassOutDir();
                    break block7;
                } else {
                    File siblingDir = null;
                    if (sibling != null && sibling instanceof RegularFileObject) {
                        siblingDir = ((RegularFileObject)sibling).file.getParentFile();
                    }
                    return new RegularFileObject(this, new File(siblingDir, fileName.basename()));
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                dir = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                Collection<File> path = this.locations.getLocation(location);
                dir = null;
                Iterator i$ = path.iterator();
                if (i$.hasNext()) {
                    File f;
                    dir = f = (File)i$.next();
                }
            }
        }
        File file = fileName.getFile(dir);
        return new RegularFileObject(this, file);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        ArrayList<RegularFileObject> result = files instanceof Collection ? new ArrayList(((Collection)files).size()) : new ArrayList<RegularFileObject>();
        for (File file : files) {
            result.add(new RegularFileObject(this, JavacFileManager.nullCheck(file)));
        }
        return result;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList((Object[])JavacFileManager.nullCheck(files)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, path);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.getLocation(location);
    }

    private File getClassOutDir() {
        return this.locations.getOutputLocation(StandardLocation.CLASS_OUTPUT);
    }

    private File getSourceOutDir() {
        return this.locations.getOutputLocation(StandardLocation.SOURCE_OUTPUT);
    }

    protected static boolean isRelativeUri(URI uri) {
        if (uri.isAbsolute()) {
            return false;
        }
        String path = uri.normalize().getPath();
        if (path.length() == 0) {
            return false;
        }
        if (!path.equals(uri.getPath())) {
            return false;
        }
        return !path.startsWith("/") && !path.startsWith("./") && !path.startsWith("../");
    }

    protected static boolean isRelativeUri(String u) {
        try {
            return JavacFileManager.isRelativeUri(new URI(u));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static String getRelativeName(File file) {
        String result;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(result = file.getPath().replace(File.separatorChar, '/'))) {
            return result;
        }
        throw new IllegalArgumentException("Invalid relative path: " + file);
    }

    public static String getMessage(IOException e) {
        String s = e.getLocalizedMessage();
        if (s != null) {
            return s;
        }
        s = e.getMessage();
        if (s != null) {
            return s;
        }
        return e.toString();
    }

    public class MissingArchive
    implements Archive {
        final File zipFileName;

        public MissingArchive(File name) {
            this.zipFileName = name;
        }

        @Override
        public boolean contains(RelativePath name) {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public JavaFileObject getFileObject(RelativePath.RelativeDirectory subdirectory, String file) {
            return null;
        }

        @Override
        public List<String> getFiles(RelativePath.RelativeDirectory subdirectory) {
            return List.nil();
        }

        @Override
        public Set<RelativePath.RelativeDirectory> getSubdirectories() {
            return Collections.emptySet();
        }

        public String toString() {
            return "MissingArchive[" + this.zipFileName + "]";
        }
    }

    public static interface Archive {
        public void close() throws IOException;

        public boolean contains(RelativePath var1);

        public JavaFileObject getFileObject(RelativePath.RelativeDirectory var1, String var2);

        public List<String> getFiles(RelativePath.RelativeDirectory var1);

        public Set<RelativePath.RelativeDirectory> getSubdirectories();
    }

    protected static enum SortFiles implements Comparator<File>
    {
        FORWARD{

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        }
        ,
        REVERSE{

            @Override
            public int compare(File f1, File f2) {
                return -f1.getName().compareTo(f2.getName());
            }
        };

    }
}

