/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.j2ee.common.ClasspathUtil;
import org.netbeans.modules.j2ee.common.DatasourceHelper;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.jboss4.JB7Deployer;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.netbeans.modules.j2ee.jboss4.util.ProgressEventSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JBDriverDeployer
implements JDBCDriverDeployer {
    private static final Logger LOGGER = Logger.getLogger(JBDriverDeployer.class.getName());
    private final JBDeploymentManager manager;

    public JBDriverDeployer(JBDeploymentManager manager) {
        this.manager = manager;
    }

    public boolean supportsDeployJDBCDrivers(Target target) {
        return true;
    }

    public ProgressObject deployJDBCDrivers(Target target, Set<Datasource> datasources) {
        return new DriverDeploymentProgressObject(datasources);
    }

    private class DriverDeploymentProgressObject
    implements ProgressObject,
    Runnable {
        private final ProgressEventSupport eventSupport;
        private final Set<Datasource> datasources;

        public DriverDeploymentProgressObject(Set<Datasource> datasources) {
            this.eventSupport = new ProgressEventSupport(JBDriverDeployer.this);
            this.datasources = datasources;
            String msg = NbBundle.getMessage(JBDriverDeployer.class, (String)"MSG_CheckingMissingDrivers");
            this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, msg));
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            if (JBDriverDeployer.this.manager.isAs7()) {
                this.deployDriversAs7();
            } else {
                this.deployDrivers();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deployDrivers() {
            List<FileObject> jdbcDriverURLs = this.jdbcDriversToDeploy(false);
            if (!jdbcDriverURLs.isEmpty()) {
                JBProperties properties = JBDriverDeployer.this.manager.getProperties();
                for (FileObject file : jdbcDriverURLs) {
                    String msg;
                    File libsDir = properties.getLibsDir();
                    File toJar = new File(libsDir, file.getNameExt());
                    try {
                        BufferedInputStream is = new BufferedInputStream(file.getInputStream());
                        try {
                            msg = NbBundle.getMessage(JBDriverDeployer.class, (String)"MSG_DeployingJDBCDrivers", (Object)toJar.getPath());
                            this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, msg));
                            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(toJar));
                            try {
                                FileUtil.copy((InputStream)is, (OutputStream)os);
                            }
                            finally {
                                os.close();
                            }
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.INFO, null, e);
                        msg = NbBundle.getMessage(JBDriverDeployer.class, (String)"MSG_DeployingJDBCDriversFailed", (Object)toJar.getPath(), (Object)libsDir.getPath());
                        this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, msg));
                        return;
                    }
                }
                JBDriverDeployer.this.manager.setNeedsRestart(true);
            }
            this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, ""));
        }

        private void deployDriversAs7() {
            List<FileObject> jdbcDriverURLs = this.jdbcDriversToDeploy(true);
            if (!jdbcDriverURLs.isEmpty()) {
                JBProperties properties = JBDriverDeployer.this.manager.getProperties();
                File deployDir = properties.getDeployDir();
                for (FileObject file : jdbcDriverURLs) {
                    try {
                        String message = JB7Deployer.deployFile(FileUtil.toFile((FileObject)file), deployDir);
                        if (message == null) continue;
                        this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, message));
                        return;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.INFO, null, e);
                        String msg = NbBundle.getMessage(JBDriverDeployer.class, (String)"MSG_DeployingJDBCDriversFailed", (Object)new File(deployDir, file.getNameExt()).getPath(), (Object)deployDir.getPath());
                        this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, msg));
                        return;
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                        String msg = NbBundle.getMessage(JBDriverDeployer.class, (String)"MSG_DeployingJDBCDriversInterrupted");
                        this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, msg));
                        return;
                    }
                }
                JBDriverDeployer.this.manager.setNeedsRestart(true);
            }
            this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, ""));
        }

        private List<FileObject> jdbcDriversToDeploy(boolean as7) {
            ArrayList<FileObject> jdbcDriverFiles = new ArrayList<FileObject>();
            Collection<File> driverCP = this.getJDBCDriverClasspath(as7);
            for (Datasource datasource : this.datasources) {
                String className = datasource.getDriverClassName();
                boolean exists = false;
                try {
                    exists = ClasspathUtil.containsClass(driverCP, (String)className);
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
                if (exists) continue;
                for (DatabaseConnection databaseConnection : DatasourceHelper.findDatabaseConnections((Datasource)datasource)) {
                    JDBCDriver[] jdbcDrivers;
                    JDBCDriver connDriver = databaseConnection.getJDBCDriver();
                    if (connDriver != null) {
                        jdbcDrivers = new JDBCDriver[]{connDriver};
                    } else {
                        String driverClass = databaseConnection.getDriverClass();
                        jdbcDrivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
                    }
                    for (JDBCDriver jdbcDriver : jdbcDrivers) {
                        for (URL url : jdbcDriver.getURLs()) {
                            FileObject file = URLMapper.findFileObject((URL)url);
                            if (file == null) continue;
                            jdbcDriverFiles.add(file);
                        }
                    }
                }
            }
            return jdbcDriverFiles;
        }

        private Collection<File> getJDBCDriverClasspath(boolean as7) {
            JBProperties properties = JBDriverDeployer.this.manager.getProperties();
            if (!as7) {
                return Arrays.asList(properties.getLibsDir().listFiles());
            }
            return Arrays.asList(properties.getDeployDir().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            }));
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.eventSupport.getDeploymentStatus();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return null;
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Cancel is not supported");
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Stop is not supported");
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.eventSupport.addProgressListener(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.eventSupport.removeProgressListener(progressListener);
        }
    }
}

