/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.toolchain.execution.OutputListenerImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.windows.IOPosition;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public abstract class ErrorParserProvider {
    public static final String UNIVERSAL_PROVIDER_ID = "universal";
    public static final Result NO_RESULT = new NoResult();
    public static final Result REMOVE_LINE = new RemoveLine();
    private static final DefaultErrorParserProvider DEFAULT = new DefaultErrorParserProvider();

    public static ErrorParserProvider getDefault() {
        return DEFAULT;
    }

    public static List<ErrorParser> getUniversalErorParsers(Project project, ExecutionEnvironment execEnv, FileObject relativeTo) {
        return DEFAULT.getUniversalErorParsersImpl(project, execEnv, relativeTo);
    }

    public abstract ErrorParser getErorParser(Project var1, CompilerFlavor var2, ExecutionEnvironment var3, FileObject var4);

    public abstract String getID();

    private static final class DefaultErrorParserProvider
    extends ErrorParserProvider {
        private final Lookup.Result<ErrorParserProvider> res = Lookup.getDefault().lookupResult(ErrorParserProvider.class);

        DefaultErrorParserProvider() {
        }

        private ErrorParserProvider getService(String id) {
            for (ErrorParserProvider service : this.res.allInstances()) {
                if (!service.getID().equals(id)) continue;
                return service;
            }
            return null;
        }

        @Override
        public ErrorParser getErorParser(Project project, CompilerFlavor flavor, ExecutionEnvironment execEnv, FileObject relativeTo) {
            ErrorParserProvider provider = this.getService(flavor.getToolchainDescriptor().getScanner().getID());
            if (provider != null) {
                return provider.getErorParser(project, flavor, execEnv, relativeTo);
            }
            return null;
        }

        @Override
        public String getID() {
            throw new UnsupportedOperationException();
        }

        public List<ErrorParser> getUniversalErorParsersImpl(Project project, ExecutionEnvironment execEnv, FileObject relativeTo) {
            ArrayList<ErrorParser> parsers = new ArrayList<ErrorParser>();
            for (ErrorParserProvider service : this.res.allInstances()) {
                ErrorParser erorParser;
                if (!ErrorParserProvider.UNIVERSAL_PROVIDER_ID.equals(service.getID()) || (erorParser = service.getErorParser(project, null, execEnv, relativeTo)) == null) continue;
                parsers.add(erorParser);
            }
            return parsers;
        }
    }

    private static final class RemoveLine
    implements Result {
        private RemoveLine() {
        }

        @Override
        public boolean result() {
            return true;
        }

        @Override
        public List<ConvertedLine> converted() {
            return Collections.emptyList();
        }
    }

    private static final class NoResult
    implements Result {
        private NoResult() {
        }

        @Override
        public boolean result() {
            return false;
        }

        @Override
        public List<ConvertedLine> converted() {
            return Collections.emptyList();
        }
    }

    public static final class Results
    implements Result {
        private final List<ConvertedLine> result = new ArrayList<ConvertedLine>(1);

        public Results() {
        }

        public Results(String line, OutputListener listener) {
            this.result.add(ConvertedLine.forText((String)line, (OutputListener)listener));
        }

        public void add(String line, OutputListener listener) {
            this.result.add(ConvertedLine.forText((String)line, (OutputListener)listener));
        }

        @Override
        public boolean result() {
            return true;
        }

        @Override
        public List<ConvertedLine> converted() {
            return this.result;
        }
    }

    public static interface Result {
        public boolean result();

        public List<ConvertedLine> converted();
    }

    public static interface ErrorParser {
        public Result handleLine(String var1);

        public void setOutputListenerRegistry(OutputListenerRegistry var1);
    }

    public static final class OutputListenerRegistry {
        private final Map<FileObject, Set<OutputListener>> storage = new HashMap<FileObject, Set<OutputListener>>();
        private final Project project;
        private final InputOutput io;
        private boolean scrollingSupported = false;

        protected OutputListenerRegistry(Project project, InputOutput io) {
            this.project = project;
            this.io = io;
            this.scrollingSupported = IOPosition.isSupported((InputOutput)io);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputListener register(FileObject file, int line, boolean isError, String description) {
            IOPosition.Position ioPos = IOPosition.currentPosition((InputOutput)this.io);
            OutputListenerImpl res = new OutputListenerImpl(this, file, line, isError, description, ioPos);
            Map<FileObject, Set<OutputListener>> map = this.storage;
            synchronized (map) {
                Set<OutputListener> list = this.storage.get(file);
                if (list == null) {
                    list = new HashSet<OutputListener>();
                    this.storage.put(file, list);
                }
                list.add(res);
            }
            return res;
        }

        Project getProject() {
            return this.project;
        }

        public InputOutput getIO() {
            return this.io;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<OutputListener> getFileListeners(FileObject file) {
            Set<OutputListener> res = null;
            if (file.isData()) {
                Map<FileObject, Set<OutputListener>> map = this.storage;
                synchronized (map) {
                    res = this.storage.get(file);
                    if (res != null) {
                        res = new HashSet<OutputListener>(res);
                    }
                }
            }
            Map<FileObject, Set<OutputListener>> map = this.storage;
            synchronized (map) {
                for (Map.Entry<FileObject, Set<OutputListener>> entry : this.storage.entrySet()) {
                    if (!FileUtil.isParentOf((FileObject)file, (FileObject)entry.getKey())) continue;
                    if (res == null) {
                        res = new HashSet<OutputListener>();
                    }
                    res.addAll((Collection<OutputListener>)entry.getValue());
                }
            }
            return res;
        }
    }
}

