/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.execution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.cnd.toolchain.execution.OutputListenerImpl;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;
import org.openide.windows.OutputListener;

public class CompileErrorScanner
extends PushTaskScanner {
    private static final Logger LOG = Logger.getLogger(CompileErrorScanner.class.getName());
    private static final Map<RequestProcessor.Task, Work> TASKS = new HashMap<RequestProcessor.Task, Work>();
    private static boolean clearing;
    private static final RequestProcessor RP;
    private static CompileErrorScanner INSTANCE;
    private static final WeakHashMap<Project, ErrorParserProvider.OutputListenerRegistry> storage;
    private TaskScanningScope scope;
    private PushTaskScanner.Callback callback;

    public CompileErrorScanner() {
        super(NbBundle.getMessage(CompileErrorScanner.class, (String)"CompileErrorTasks"), NbBundle.getMessage(CompileErrorScanner.class, (String)"CompileErrorTasksDesc"), null);
        INSTANCE = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attach(ErrorParserProvider.OutputListenerRegistry registry, Project project) {
        WeakHashMap<Project, ErrorParserProvider.OutputListenerRegistry> weakHashMap = storage;
        synchronized (weakHashMap) {
            storage.put(project, registry);
        }
        CompileErrorScanner.refreshAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshAll() {
        if (INSTANCE != null) {
            CompileErrorScanner compileErrorScanner = INSTANCE;
            synchronized (compileErrorScanner) {
                INSTANCE.setScope(CompileErrorScanner.INSTANCE.scope, CompileErrorScanner.INSTANCE.callback);
            }
        }
    }

    public synchronized void setScope(TaskScanningScope scope, PushTaskScanner.Callback callback) {
        CompileErrorScanner.cancelAllCurrent();
        this.scope = scope;
        this.callback = callback;
        if (scope == null || callback == null) {
            return;
        }
        for (FileObject file : scope.getLookup().lookupAll(FileObject.class)) {
            CompileErrorScanner.enqueue(new Work(file, callback));
        }
        for (Project p : scope.getLookup().lookupAll(Project.class)) {
            for (SourceGroup generic : ProjectUtils.getSources((Project)p).getSourceGroups("generic")) {
                CompileErrorScanner.enqueue(new Work(generic.getRootFolder(), callback));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueue(Work w) {
        Map<RequestProcessor.Task, Work> map = TASKS;
        synchronized (map) {
            RequestProcessor.Task task = RP.post((Runnable)w);
            TASKS.put(task, w);
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(org.openide.util.Task task) {
                    Map map = TASKS;
                    synchronized (map) {
                        if (!clearing) {
                            TASKS.remove(task);
                        }
                    }
                }
            });
            if (task.isFinished()) {
                TASKS.remove(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelAllCurrent() {
        Map<RequestProcessor.Task, Work> map = TASKS;
        synchronized (map) {
            clearing = true;
            try {
                for (Map.Entry<RequestProcessor.Task, Work> t : TASKS.entrySet()) {
                    t.getKey().cancel();
                    t.getValue().cancel();
                }
                TASKS.clear();
            }
            finally {
                clearing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitWorkFinished() throws Exception {
        while (true) {
            RequestProcessor.Task t;
            Map<RequestProcessor.Task, Work> map = TASKS;
            synchronized (map) {
                if (TASKS.isEmpty()) {
                    return;
                }
                t = TASKS.keySet().iterator().next();
            }
            t.waitFinished();
        }
    }

    static {
        RP = new RequestProcessor("CND compiler scanner");
        storage = new WeakHashMap();
    }

    private static final class Work
    implements Runnable {
        private final FileObject fileOrRoot;
        private final PushTaskScanner.Callback callback;
        private final AtomicBoolean canceled = new AtomicBoolean();

        public Work(FileObject fileOrRoot, PushTaskScanner.Callback callback) {
            this.fileOrRoot = fileOrRoot;
            this.callback = callback;
        }

        public FileObject getFileOrRoot() {
            return this.fileOrRoot;
        }

        public PushTaskScanner.Callback getCallback() {
            return this.callback;
        }

        public void cancel() {
            this.canceled.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ErrorParserProvider.OutputListenerRegistry aRegestry;
            FileObject file = this.getFileOrRoot();
            LOG.log(Level.FINE, "dequeued work for: {0}", file);
            Project p = FileOwnerQuery.getOwner((FileObject)file);
            if (p == null) {
                LOG.log(Level.FINE, "project == null");
                return;
            }
            WeakHashMap weakHashMap = storage;
            synchronized (weakHashMap) {
                aRegestry = (ErrorParserProvider.OutputListenerRegistry)storage.get(p);
            }
            ArrayList<Task> tasks = new ArrayList<Task>();
            if (aRegestry != null) {
                this.getCallback().started();
                this.getCallback().clearAllTasks();
                LOG.log(Level.FINE, "setting {1} for {0}", new Object[]{file, tasks});
                Set<OutputListener> fileListeners = aRegestry.getFileListeners(file);
                if (fileListeners != null) {
                    for (OutputListener listener : fileListeners) {
                        if (!(listener instanceof OutputListenerImpl)) continue;
                        OutputListenerImpl impl = (OutputListenerImpl)listener;
                        String type = impl.isError() ? "nb-tasklist-error" : "nb-tasklist-warning";
                        Task task = Task.create((FileObject)impl.getFile(), (String)type, (String)impl.getDescription(), (int)(impl.getLine() + 1));
                        tasks.add(task);
                    }
                }
                this.getCallback().setTasks(file, tasks);
                this.getCallback().finished();
            }
        }
    }
}

