/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.lex.ClangStatics;
import org.clang.lex.impl.HeaderMapStatics;
import org.clank.java.io;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeType;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;

public class HeaderMap
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<MemoryBuffer> FileBuffer;
    private boolean NeedsBSwap;

    private HeaderMap(HeaderMap $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private void $assign(HeaderMap $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private HeaderMap(std_ptr.unique_ptr<MemoryBuffer> File, boolean BSwap) {
        this.FileBuffer = new std_ptr.unique_ptr(JavaDifferentiators.Move.INSTANCE, std.move(File));
        this.NeedsBSwap = BSwap;
    }

    public void $destroy() {
        this.FileBuffer.$destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HeaderMap Create(FileEntry FE, FileManager FM) {
        ErrorOr FileBuffer = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            boolean NeedsByteSwap;
            long FileSize = FE.getSize();
            if (FileSize <= (long)NativeType.sizeof(ClangStatics.HMapHeader.class)) {
                HeaderMap headerMap = null;
                return headerMap;
            }
            FileBuffer = FM.getBufferForFile(FE);
            if (!FileBuffer.$boolean()) {
                HeaderMap headerMap = null;
                return headerMap;
            }
            char.ptr FileStart = Native.$tryClone((char.ptr)((MemoryBuffer)((std_ptr.unique_ptr)FileBuffer.$star()).$arrow()).getBufferStart());
            ClangStatics.HMapHeader Header = (ClangStatics.HMapHeader)Casts.reinterpret_cast(ClangStatics.HMapHeader.class, (void.ptr)FileStart);
            if (Header.Magic == (long)HeaderMapStatics.Unnamed_enum.HMAP_HeaderMagicNumber.getValue() && Header.Version == HeaderMapStatics.Unnamed_enum.HMAP_HeaderVersion.getValue()) {
                NeedsByteSwap = false;
            } else if (Header.Magic == llvm.ByteSwap_32((long)HeaderMapStatics.Unnamed_enum.HMAP_HeaderMagicNumber.getValue()) && Header.Version == llvm.ByteSwap_16((char)((char)HeaderMapStatics.Unnamed_enum.HMAP_HeaderVersion.getValue()))) {
                NeedsByteSwap = true;
            } else {
                HeaderMap headerMap = null;
                return headerMap;
            }
            if (Header.Reserved != '\u0000') {
                HeaderMap headerMap = null;
                return headerMap;
            }
            HeaderMap headerMap = (HeaderMap)$c.clean((Object)new HeaderMap((std_ptr.unique_ptr<MemoryBuffer>)$c.track(new std_ptr.unique_ptr(std.move((std_ptr.unique_ptr)((std_ptr.unique_ptr)FileBuffer.$star())))), NeedsByteSwap));
            return headerMap;
        }
        finally {
            if (FileBuffer != null) {
                FileBuffer.$destroy();
            }
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry LookupFile(StringRef Filename, FileManager FM) {
        SmallString Path = null;
        try {
            Path = new SmallString(1024);
            StringRef Dest = this.lookupFilename(Filename, Path);
            if (Dest.empty()) {
                FileEntry fileEntry = null;
                return fileEntry;
            }
            FileEntry fileEntry = FM.getFile(Dest);
            return fileEntry;
        }
        finally {
            if (Path != null) {
                Path.$destroy();
            }
        }
    }

    public StringRef lookupFilename(StringRef Filename, SmallString DestPath) {
        ClangStatics.HMapHeader Hdr = this.getHeader();
        long NumBuckets = this.getEndianAdjustedWord(Hdr.NumBuckets);
        if ((NumBuckets & NumBuckets - 1L) != 0L) {
            return new StringRef();
        }
        long Bucket = HeaderMapStatics.HashHMapKey(Filename);
        while (true) {
            ClangStatics.HMapBucket B = this.getBucket(Bucket & NumBuckets - 1L);
            if (B.Key == (long)HeaderMapStatics.Unnamed_enum.HMAP_EmptyBucketKey.getValue()) {
                return new StringRef();
            }
            if (Filename.equals_lower(new StringRef(this.getString(B.Key)))) {
                char.ptr Prefix = this.getString(B.Prefix);
                char.ptr Suffix = this.getString(B.Suffix);
                DestPath.clear();
                DestPath.append(Prefix);
                DestPath.append(Suffix);
                return new StringRef(DestPath.begin().toPointer(), DestPath.size());
            }
            ++Bucket;
        }
    }

    public char.ptr getFileName() {
        return ((MemoryBuffer)this.FileBuffer.$arrow()).getBufferIdentifier();
    }

    public void dump() {
        ClangStatics.HMapHeader Hdr = this.getHeader();
        long NumBuckets = this.getEndianAdjustedWord(Hdr.NumBuckets);
        std.fprintf((io.ostream)std.stderr, (String)"Header Map %s:\n  %d buckets, %d entries\n", (Object[])new Object[]{this.getFileName(), NumBuckets, this.getEndianAdjustedWord(Hdr.NumEntries)});
        for (long i = 0L; i != NumBuckets; ++i) {
            ClangStatics.HMapBucket B = this.getBucket(i);
            if (B.Key == (long)HeaderMapStatics.Unnamed_enum.HMAP_EmptyBucketKey.getValue()) continue;
            char.ptr Key = this.getString(B.Key);
            char.ptr Prefix = this.getString(B.Prefix);
            char.ptr Suffix = this.getString(B.Suffix);
            std.fprintf((io.ostream)std.stderr, (String)"  %d. %s -> '%s' '%s'\n", (Object[])new Object[]{i, Key, Prefix, Suffix});
        }
    }

    private long getEndianAdjustedWord(long X) {
        if (!this.NeedsBSwap) {
            return X;
        }
        return llvm.ByteSwap_32((long)X);
    }

    private ClangStatics.HMapHeader getHeader() {
        return (ClangStatics.HMapHeader)Casts.reinterpret_cast(ClangStatics.HMapHeader.class, (void.ptr)((MemoryBuffer)this.FileBuffer.$arrow()).getBufferStart());
    }

    private ClangStatics.HMapBucket getBucket(long BucketNo) {
        ClangStatics.HMapBucket Result = new ClangStatics.HMapBucket();
        Result.Key = HeaderMapStatics.Unnamed_enum.HMAP_EmptyBucketKey.getValue();
        type.ptr BucketArray = Casts.reinterpret_ptr_cast(ClangStatics.HMapBucket.class, (void.ptr)((void.ptr)((MemoryBuffer)this.FileBuffer.$arrow()).getBufferStart().$add(NativeType.sizeof(ClangStatics.HMapHeader.class))));
        type.ptr BucketPtr = (type.ptr)BucketArray.$add(BucketNo);
        if (((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)BucketPtr.$add(1)))).$greater((Object)((MemoryBuffer)this.FileBuffer.$arrow()).getBufferEnd())) {
            Result.Prefix = 0L;
            Result.Suffix = 0L;
            return Result;
        }
        Result.Key = this.getEndianAdjustedWord(((ClangStatics.HMapBucket)BucketPtr.$star()).Key);
        Result.Prefix = this.getEndianAdjustedWord(((ClangStatics.HMapBucket)BucketPtr.$star()).Prefix);
        Result.Suffix = this.getEndianAdjustedWord(((ClangStatics.HMapBucket)BucketPtr.$star()).Suffix);
        return Result;
    }

    private char.ptr getString(long StrTabIdx) {
        if ((StrTabIdx += this.getEndianAdjustedWord(this.getHeader().StringsOffset)) >= (long)((MemoryBuffer)this.FileBuffer.$arrow()).getBufferSize()) {
            return null;
        }
        return (char.ptr)((MemoryBuffer)this.FileBuffer.$arrow()).getBufferStart().$add(StrTabIdx);
    }

    public HeaderMap() {
    }
}

