/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.CharSourceRange;
import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileID;
import org.clang.basic.FixItHint;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.lex.ConflictMarkerKind;
import org.clang.lex.NumericLiteralParser;
import org.clang.lex.PPConditionalInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.PreprocessorLexer;
import org.clang.lex.Token;
import org.clang.lex.impl.LexerJavaPool;
import org.clang.lex.impl.LexerStatics;
import org.clang.lex.impl.UnicodeCharSetsStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.support.ConvertUTFGlobals;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.UnicodeCharSet;

public class Lexer
extends PreprocessorLexer
implements Destructors.ClassWithDestructor {
    private static final boolean COPY_LANG_OPTS = Boolean.getBoolean("lexer.copy.lang.opts");
    char.ptr BufferStart;
    int BufferEnd;
    private int FileLoc;
    private LangOptions LangOpts;
    boolean Is_PragmaLexer;
    private int ExtendedTokenMode;
    char.ptr BufferPtr = null;
    char.ptr $LexTokenInternalCurPtr = null;
    char.ptr $OrigBufferPtr = null;
    boolean $ArrayBasedOrigBufferPtr = false;
    private boolean IsAtStartOfLine;
    private boolean IsAtPhysicalStartOfLine;
    private boolean HasLeadingSpace;
    private boolean HasLeadingEmptyMacro;
    private ConflictMarkerKind CurrentConflictMarkerState;
    private final SourceLocation $SourceLocationHelper = new SourceLocation();
    public static final int INVALID_SPELLING = -1;
    private static final UnicodeCharSet UnicodeWhitespaceChars = new UnicodeCharSet(new ArrayRef((Object[])UnicodeCharSetsStatics.UnicodeWhitespaceCharRanges));
    private static long ConsumeCharCalls = 0L;
    private static long InitCalls = 0L;
    private static long prepareCalls = 0L;
    private static long instances = 0L;
    private final Token $IsNextPPTokenLParenHelper = new Token();
    private boolean $IsNextPPTokenLParenHelperInUse = false;

    @Override
    protected void anchor() {
    }

    private Lexer(Lexer $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private void $assign(Lexer $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private void InitLexer(char.ptr BufStart, char.ptr BufPtr, int BufEnd, boolean PasteTokenMode) {
        Lexer.trackInit();
        assert (BufStart != BufPtr) : "BufferPtr is going to be modified; should be different from BufferStart";
        this.BufferStart = Native.$toConst((char.ptr)BufStart);
        this.$OrigBufferPtr = Native.$noClone((char.ptr)BufPtr);
        this.$ArrayBasedOrigBufferPtr = PasteTokenMode ? true : Native.$is_array_based((char.ptr)this.$OrigBufferPtr);
        this.BufferEnd = BufEnd;
        assert (this.$BufferEnd().$at(0) == 0) : "We assume that the input buffer has a null character at the end to simplify lexing!";
        if (this.BufferStart.$eq((Object)this.$OrigBufferPtr)) {
            StringRef Buf = new StringRef(this.BufferStart, this.BufferEnd - this.BufferStart.$index());
            long BOMLength = ((Integer)new StringSwitch(Buf).StartsWith((CharSequence)"\u00ef\u00bb\u00bf", (Object)3).Default((Object)0)).intValue();
            this.$OrigBufferPtr.$inc(BOMLength);
        }
        this.BufferPtr = Native.$prepareCloneFor((char.ptr)this.BufferPtr, (char.ptr)this.$OrigBufferPtr);
        this.$LexTokenInternalCurPtr = Native.$prepareCloneFor((char.ptr)this.$LexTokenInternalCurPtr, (char.ptr)this.$OrigBufferPtr);
        this.Is_PragmaLexer = false;
        this.CurrentConflictMarkerState = ConflictMarkerKind.CMK_None;
        this.IsAtStartOfLine = true;
        this.IsAtPhysicalStartOfLine = true;
        this.HasLeadingSpace = false;
        this.HasLeadingEmptyMacro = false;
        this.ParsingPreprocessorDirective = false;
        this.ParsingFilename = false;
        this.LexingRawMode = false;
        this.ExtendedTokenMode = 0;
    }

    public Lexer(boolean needMIOpt) {
        super(needMIOpt);
        Lexer.trackInstance();
    }

    public Lexer(FileID FID, MemoryBuffer InputFile, Preprocessor PP) {
        this(FID.$ID(), InputFile, PP);
    }

    public Lexer(int FID, MemoryBuffer InputFile, Preprocessor PP) {
        super(PP, FID);
        this.FileLoc = PP.getSourceManager().getLocForStartOfFile(FID);
        this.LangOpts = COPY_LANG_OPTS ? new LangOptions(PP.getLangOpts()) : PP.getLangOpts();
        this.InitLexer(Native.$noClone((char.ptr)InputFile.getBufferStart()), Native.$tryClone((char.ptr)InputFile.getBufferStart()), InputFile.getBufferEnd().$index(), false);
        this.resetExtendedTokenMode();
        Lexer.trackInstance();
    }

    public Lexer(int fileloc, LangOptions langOpts, char.ptr BufStart, char.ptr BufPtr, int BufEnd) {
        super(false);
        this.$Prepare(fileloc, langOpts, BufStart, BufPtr, BufEnd, false);
        Lexer.trackInstance();
    }

    public void $Prepare(int fileloc, LangOptions langOpts, char.ptr BufStart, char.ptr BufPtr, int BufEnd, boolean PasteTokenMode) {
        this.FileLoc = fileloc;
        this.LangOpts = COPY_LANG_OPTS ? new LangOptions(langOpts) : langOpts;
        this.InitLexer(Native.$noClone((char.ptr)BufStart), Native.$noClone((char.ptr)BufPtr), BufEnd, PasteTokenMode);
        this.LexingRawMode = true;
        Lexer.trackPrepare();
    }

    public Lexer(FileID FID, MemoryBuffer FromFile, SourceManager SM, LangOptions langOpts) {
        this(FID.$ID(), FromFile, SM, langOpts);
    }

    public Lexer(int FID, MemoryBuffer FromFile, SourceManager SM, LangOptions langOpts) {
        this.FileLoc = SM.getLocForStartOfFile(FID);
        this.LangOpts = COPY_LANG_OPTS ? new LangOptions(langOpts) : langOpts;
        this.InitLexer(Native.$noClone((char.ptr)FromFile.getBufferStart()), Native.$tryClone((char.ptr)FromFile.getBufferStart()), FromFile.getBufferEnd().$index(), false);
        this.LexingRawMode = true;
        Lexer.trackInstance();
    }

    public static Lexer Create_PragmaLexer(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, long TokLen, Preprocessor PP) {
        SourceManager SM = PP.getSourceManager();
        int SpellingFID = SM.getFileID(SpellingLoc);
        MemoryBuffer InputFile = SM.getBuffer(SpellingFID);
        Lexer L = new Lexer(SpellingFID, InputFile, PP);
        char.ptr StrData = SM.getCharacterData(SpellingLoc);
        L.BufferPtr = Native.$tryClone((char.ptr)StrData);
        L.BufferEnd = StrData.$index() + (int)TokLen;
        assert (L.$BufferEnd().$at(0) == 0) : "Buffer is not nul terminated!";
        L.FileLoc = SM.createExpansionLoc(SM.getLocForStartOfFile(SpellingFID), ExpansionLocStart, ExpansionLocEnd, TokLen);
        L.ParsingPreprocessorDirective = true;
        L.Is_PragmaLexer = true;
        return L;
    }

    public LangOptions getLangOpts() {
        return this.LangOpts;
    }

    public int getFileLoc() {
        return this.FileLoc;
    }

    boolean Lex(Token Result) {
        Result.startToken();
        if (this.IsAtStartOfLine) {
            Result.setFlag(1);
            this.IsAtStartOfLine = false;
        }
        if (this.HasLeadingSpace) {
            Result.setFlag(2);
            this.HasLeadingSpace = false;
        }
        if (this.HasLeadingEmptyMacro) {
            Result.setFlag(16);
            this.HasLeadingEmptyMacro = false;
        }
        boolean atPhysicalStartOfLine = this.IsAtPhysicalStartOfLine;
        this.IsAtPhysicalStartOfLine = false;
        boolean isRawLex = this.isLexingRawMode();
        boolean returnedToken = this.LexTokenInternal(Result, atPhysicalStartOfLine);
        assert (returnedToken || !isRawLex || isRawLex && this.SkipTokensBetweenDirectives) : "Raw lex must succeed: " + returnedToken + " " + Result + "\n" + this.BufferPtr;
        return returnedToken;
    }

    public boolean isPragmaLexer() {
        return this.Is_PragmaLexer;
    }

    @Override
    protected void IndirectLex(Token Result) {
        this.Lex(Result);
    }

    public boolean LexFromRawLexer(Token Result) {
        assert (this.LexingRawMode) : "Not already in raw mode!";
        this.Lex(Result);
        return this.BufferPtr.$index() == this.BufferEnd;
    }

    public boolean isKeepWhitespaceMode() {
        return this.ExtendedTokenMode > 1;
    }

    public void SetKeepWhitespaceMode(boolean Val) {
        assert (!Val || this.LexingRawMode || this.LangOpts.TraditionalCPP) : "Can only retain whitespace in raw mode or -traditional-cpp";
        this.ExtendedTokenMode = Val ? 2 : 0;
    }

    public boolean inKeepCommentMode() {
        return this.ExtendedTokenMode > 0;
    }

    public void SetCommentRetentionState(boolean Mode) {
        assert (!this.isKeepWhitespaceMode()) : "Can't play with comment retention state when retaining whitespace";
        this.ExtendedTokenMode = Mode ? 1 : 0;
    }

    public final void resetExtendedTokenMode() {
        assert (this.PP != null) : "Cannot reset token mode without a preprocessor";
        if (this.LangOpts.TraditionalCPP) {
            this.SetKeepWhitespaceMode(true);
        } else {
            this.SetCommentRetentionState(this.PP.getCommentRetentionState());
        }
    }

    public StringRef getBuffer() {
        return new StringRef(this.BufferStart, this.BufferEnd - this.BufferStart.$index());
    }

    public void ReadToEndOfLine() {
        this.ReadToEndOfLine(null);
    }

    public void ReadToEndOfLine(SmallString Result) {
        byte Char;
        assert (this.ParsingPreprocessorDirective && !this.ParsingFilename) : "Must be in a preprocessing directive!";
        Token Tmp = new Token();
        char.ptr CurPtr = Native.$tryClone((char.ptr)this.BufferPtr);
        block4: while (true) {
            Char = this.getAndAdvanceChar(CurPtr, Tmp);
            switch (Char) {
                default: {
                    if (Result == null) continue block4;
                    Result.push_back(Char);
                    continue block4;
                }
                case 0: {
                    if (CurPtr.$index() - 1 == this.BufferEnd) break block4;
                    if (this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) {
                        this.PP.CodeCompleteNaturalLanguage();
                        this.cutOffLexing();
                        return;
                    }
                    if (Result == null) continue block4;
                    Result.push_back(Char);
                    continue block4;
                }
                case 10: 
                case 13: 
            }
            break;
        }
        assert (CurPtr.$at(-1) == Char) : "Trigraphs for newline?";
        assert (this.BufferPtr.isComparableTo((void.ptr)CurPtr)) : "CurPtr was replaced by another buffer? " + CurPtr;
        Native.$setIndex((char.ptr)this.BufferPtr, (int)(CurPtr.$index() - 1));
        this.Lex(Tmp);
        if (Tmp.is((short)3)) {
            if (this.PP != null) {
                this.PP.CodeCompleteNaturalLanguage();
            }
            this.Lex(Tmp);
        }
        assert (Tmp.is((short)2)) : "Unexpected token!";
    }

    public DiagnosticBuilder Diag(char.ptr Loc, long DiagID) {
        return this.PP.Diag(this.getSourceLocation(Loc), DiagID);
    }

    public int getSourceLocation(char.ptr Loc) {
        return this.getSourceLocation(Loc, 1L);
    }

    public int getSourceLocation(char.ptr Loc, long TokLen) {
        return this.getSourceLocation(Loc.$index(), TokLen);
    }

    public int getSourceLocation(int Loc) {
        return this.getSourceLocation(Loc, 1L);
    }

    public int getSourceLocation(int Loc, long TokLen) {
        assert (Loc >= this.BufferStart.$index() && Loc <= this.BufferEnd) : "Location out of range for this buffer!";
        long CharNo = Loc - this.BufferStart.$index();
        if (SourceLocation.isFileID((int)this.FileLoc)) {
            return SourceLocation.getRawLocWithOffset((int)this.FileLoc, (long)CharNo);
        }
        assert (this.PP != null) : "This doesn't work on raw lexers";
        return LexerStatics.GetMappedTokenLoc(this.PP, this.FileLoc, CharNo, TokLen);
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.$SourceLocationHelper.$assign(this.getSourceLocation(this.BufferPtr));
    }

    public char.ptr getBufferLocation() {
        return this.BufferPtr;
    }

    public char.ptr $BufferEnd() {
        return (char.ptr)this.BufferStart.$add(this.BufferEnd - this.BufferStart.$index());
    }

    public static std.string Stringify(std.string Str) {
        return Lexer.Stringify(Str, false);
    }

    public static std.string Stringify(std.string Str, boolean Charify) {
        std.string Result = Str;
        byte Quote = Charify ? NativePointer.$SGL_QUOTE : NativePointer.$DBL_QUOTE;
        int e = Result.size();
        for (int i = 0; i != e; ++i) {
            if (Result.$at(i) != NativePointer.$BACK_SLASH && Result.$at(i) != Quote) continue;
            Result.insert((char.ptr)Result.begin().$add(i), NativePointer.$BACK_SLASH);
            ++i;
            ++e;
        }
        return Result;
    }

    public static void Stringify(SmallString Str) {
        long e = Str.size();
        for (long i = 0L; i != e; ++i) {
            if (Str.$at(i) != NativePointer.$BACK_SLASH && Str.$at(i) != NativePointer.$DBL_QUOTE) continue;
            Str.insert(Str.begin().$add(i), NativePointer.$BACK_SLASH);
            ++i;
            ++e;
        }
    }

    public static int getSpelling(Token Tok, char.ptr Buffer, SourceManager SourceMgr, LangOptions LangOpts) {
        return Lexer.getSpelling(Tok, Buffer, SourceMgr, LangOpts, (bool.ptr)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSpelling(Token Tok, char.ptr Buffer, SourceManager SourceMgr, LangOptions LangOpts, bool.ptr Invalid) {
        IdentifierInfo II;
        byte[] $CharPtrData;
        assert (Tok.getLength() >= 0) : "Token character range is bogus!";
        char.ptr.array $DataPtr = null;
        char.ptr TokStart = null;
        if (Tok.is((short)6)) {
            $CharPtrData = Tok.$CharPtrData();
            if ($CharPtrData != null) {
                $DataPtr = SourceMgr.$CharacterDataPtr();
                Native.$setArrayAndIndex((char.ptr.array)$DataPtr, (byte[])$CharPtrData, (int)Tok.$CharPtrDataIndex());
                TokStart = $DataPtr;
            } else {
                TokStart = Tok.getRawIdentifier().data();
            }
        } else if (!Tok.hasUCN() && (II = Tok.getIdentifierInfo()) != null) {
            Buffer.$assign((Object)II.getNameStart());
            return II.getLength();
        }
        try {
            if (TokStart == null && Tok.isLiteral()) {
                $CharPtrData = Tok.$CharPtrData();
                if ($CharPtrData != null) {
                    $DataPtr = SourceMgr.$CharacterDataPtr();
                    Native.$setArrayAndIndex((char.ptr.array)$DataPtr, (byte[])$CharPtrData, (int)Tok.$CharPtrDataIndex());
                    TokStart = $DataPtr;
                } else {
                    TokStart = Tok.getLiteralData();
                }
            }
            if (TokStart == null) {
                $DataPtr = SourceMgr.$CharacterDataPtr();
                TokStart = SourceMgr.getCharacterData_ValidOnly(Tok.getRawLocation(), (char.ptr)$DataPtr);
                if (Invalid != null) {
                    Invalid.$set(TokStart == NativePointer.EMPTY);
                }
                if (TokStart == NativePointer.EMPTY) {
                    Buffer.$assign((Object)NativePointer.EMPTY);
                    int n = 0;
                    return n;
                }
            }
            if (!Tok.needsCleaning()) {
                Buffer.$assign((Object)TokStart);
                int n = Tok.getLength();
                return n;
            }
            int n = LexerStatics.getSpellingSlow(Tok, TokStart, LangOpts, Buffer.$array(), Buffer.$index());
            return n;
        }
        finally {
            if ($DataPtr != null) {
                SourceMgr.$releaseCharacterDataPtr($DataPtr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copySpelling(Token Tok, byte[] DestBuffer, int toIdx, SourceManager SourceMgr, LangOptions LangOpts) {
        IdentifierInfo II;
        byte[] $CharPtrData;
        assert (Tok.getLength() >= 0) : "Token character range is bogus!";
        char.ptr.array $DataPtr = null;
        char.ptr TokStart = null;
        if (Tok.is((short)6)) {
            $CharPtrData = Tok.$CharPtrData();
            if ($CharPtrData != null) {
                $DataPtr = SourceMgr.$CharacterDataPtr();
                Native.$setArrayAndIndex((char.ptr.array)$DataPtr, (byte[])$CharPtrData, (int)Tok.$CharPtrDataIndex());
                TokStart = $DataPtr;
            } else {
                TokStart = Tok.getRawIdentifier().data();
            }
        } else if (!Tok.hasUCN() && (II = Tok.getIdentifierInfo()) != null) {
            int length = II.getLength();
            if (length != 0) {
                StringMapEntryBase Entry2 = II.getEntry();
                std.memcpy((byte[])DestBuffer, (int)toIdx, (byte[])Entry2.getKeyArray(), (int)Entry2.getKeyArrayIndex(), (int)length);
            }
            return length;
        }
        try {
            if (TokStart == null && Tok.isLiteral()) {
                $CharPtrData = Tok.$CharPtrData();
                if ($CharPtrData != null) {
                    $DataPtr = SourceMgr.$CharacterDataPtr();
                    Native.$setArrayAndIndex((char.ptr.array)$DataPtr, (byte[])$CharPtrData, (int)Tok.$CharPtrDataIndex());
                    TokStart = $DataPtr;
                } else {
                    TokStart = Tok.getLiteralData();
                }
            }
            if (TokStart == null) {
                $DataPtr = SourceMgr.$CharacterDataPtr();
                TokStart = SourceMgr.getCharacterData_ValidOnly(Tok.getRawLocation(), (char.ptr)$DataPtr);
                if (TokStart == NativePointer.EMPTY) {
                    int n = -1;
                    return n;
                }
                if (!Tok.needsCleaning()) {
                    assert (TokStart == $DataPtr) : "expected to be the same " + TokStart + " vs. " + $DataPtr;
                    assert (TokStart.$array() != null) : "we expected getCharacterData_ValidOnly to return array based $DataPtr" + TokStart;
                    std.memcpy((byte[])DestBuffer, (int)toIdx, (byte[])TokStart.$array(), (int)TokStart.$index(), (int)Tok.getLength());
                    int n = Tok.getLength();
                    return n;
                }
            } else if (!Tok.needsCleaning()) {
                std.memcpy((byte[])DestBuffer, (int)toIdx, (char.ptr)TokStart, (int)0, (int)Tok.getLength());
                int n = Tok.getLength();
                return n;
            }
            int n = LexerStatics.getSpellingSlow(Tok, TokStart, LangOpts, DestBuffer, toIdx);
            return n;
        }
        finally {
            if ($DataPtr != null) {
                SourceMgr.$releaseCharacterDataPtr($DataPtr);
            }
        }
    }

    public static std.string getSpelling(Token Tok, SourceManager SourceMgr, LangOptions LangOpts) {
        return Lexer.getSpelling(Tok, SourceMgr, LangOpts, (bool.ptr)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string getSpelling(Token Tok, SourceManager SourceMgr, LangOptions LangOpts, bool.ptr Invalid) {
        std.string Result = null;
        char.ptr.array $DataPtr = SourceMgr.$CharacterDataPtr();
        try {
            assert (Tok.getLength() >= 0) : "Token character range is bogus!";
            char.ptr TokStart = SourceMgr.getCharacterData_ValidOnly(Tok.getRawLocation(), (char.ptr)$DataPtr);
            if (Invalid != null) {
                Invalid.$set(TokStart == NativePointer.EMPTY);
            }
            if (TokStart == NativePointer.EMPTY) {
                std.string string2 = new std.string();
                return string2;
            }
            if (!Tok.needsCleaning()) {
                std.string string3 = new std.string((char.iterator)TokStart, (char.iterator)TokStart.$add(Tok.getLength()));
                return string3;
            }
            Result = new std.string();
            Result.resize(Tok.getLength());
            Result.resize(LexerStatics.getSpellingSlow(Tok, TokStart, LangOpts, Result.$array(), 0));
            std.string string4 = Result;
            return string4;
        }
        finally {
            SourceMgr.$releaseCharacterDataPtr($DataPtr);
        }
    }

    public static byte getSpelling_FirstChar(Token Tok, SourceManager SourceMgr, LangOptions LangOpts) {
        assert (Tok.getLength() >= 0) : "Token character range is bogus!";
        if (!Tok.needsCleaning()) {
            return SourceMgr.getCharacterData_FirstChar(Tok.getRawLocation(), null);
        }
        char.ptr.array $DataPtr = SourceMgr.$CharacterDataPtr();
        char.ptr TokStart = SourceMgr.getCharacterData_ValidOnly(Tok.getRawLocation(), (char.ptr)$DataPtr);
        if (TokStart == NativePointer.EMPTY) {
            SourceMgr.$releaseCharacterDataPtr($DataPtr);
            return std.string.TERM;
        }
        byte out = std.$first_byte((long)Lexer.getCharAndSizeNoWarn(TokStart, LangOpts));
        SourceMgr.$releaseCharacterDataPtr($DataPtr);
        return out;
    }

    public static StringRef getSpelling(SourceLocation loc, SmallString buffer, SourceManager SM, LangOptions options) {
        return Lexer.getSpelling(loc.getRawEncodingUInt(), buffer, SM, options, (bool.ptr)null);
    }

    public static StringRef getSpelling(SourceLocation loc, SmallString buffer, SourceManager SM, LangOptions options, bool.ptr invalid) {
        return Lexer.getSpelling(loc.getRawEncodingUInt(), buffer, SM, options, invalid);
    }

    public static StringRef getSpelling(int loc, SmallString buffer, SourceManager SM, LangOptions options) {
        return Lexer.getSpelling(loc, buffer, SM, options, (bool.ptr)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringRef getSpelling(int loc, SmallString buffer, SourceManager SM, LangOptions options, bool.ptr invalid) {
        Lexer lexer = null;
        try {
            long locInfo = SM.getDecomposedLoc(loc);
            bool.ptr invalidTemp = null;
            StringRef file = SM.getBufferData(ClangGlobals.$first_FileID((long)locInfo), invalidTemp);
            if (file == SourceManager.INVALID_BUFFER_DATA) {
                if (invalid != null) {
                    invalid.$set(true);
                }
                StringRef stringRef = new StringRef();
                return stringRef;
            }
            char.ptr tokenBegin = (char.ptr)file.data().$add(ClangGlobals.$second_offset((long)locInfo));
            int tokenBeginIndex = tokenBegin.$index();
            lexer = new Lexer(SM.getLocForStartOfFile(ClangGlobals.$first_FileID((long)locInfo)), options, Native.$noClone((char.ptr)file.begin()), Native.$noClone((char.ptr)tokenBegin), file.begin().$index() + file.size());
            Token token = new Token();
            lexer.LexFromRawLexer(token);
            int length = token.getLength();
            Native.$setIndex((char.ptr)tokenBegin, (int)tokenBeginIndex);
            if (!token.needsCleaning()) {
                StringRef stringRef = new StringRef(tokenBegin, length);
                return stringRef;
            }
            buffer.resize(length);
            buffer.resize(LexerStatics.getSpellingSlow(token, tokenBegin, options, buffer.$array(), 0));
            StringRef stringRef = new StringRef(buffer.data(), buffer.size());
            return stringRef;
        }
        finally {
            if (lexer != null) {
                lexer.$destroy();
            }
        }
    }

    public static int MeasureTokenLength(SourceLocation Loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.MeasureTokenLength(Loc.getRawEncodingUInt(), SM, LangOpts);
    }

    public static int MeasureTokenLength(int Loc, SourceManager SM, LangOptions LangOpts) {
        Token TheTok = LexerJavaPool.$getStaticMeasureLengthToken();
        if (Lexer.getRawToken(Loc, TheTok, SM, LangOpts)) {
            return 0;
        }
        int length = TheTok.getLength();
        LexerJavaPool.$releaseStaticMeasureLengthToken(TheTok);
        return length;
    }

    public static boolean getRawToken(SourceLocation Loc, Token Result, SourceManager SM, LangOptions LangOpts) {
        return Lexer.getRawToken(Loc.getRawEncodingUInt(), Result, SM, LangOpts, false);
    }

    public static boolean getRawToken(int Loc, Token Result, SourceManager SM, LangOptions LangOpts) {
        return Lexer.getRawToken(Loc, Result, SM, LangOpts, false);
    }

    public static boolean getRawToken(SourceLocation Loc, Token Result, SourceManager SM, LangOptions LangOpts, boolean IgnoreWhiteSpace) {
        return Lexer.getRawToken(Loc.getRawEncodingUInt(), Result, SM, LangOpts, IgnoreWhiteSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getRawToken(int Loc, Token Result, SourceManager SM, LangOptions LangOpts, boolean IgnoreWhiteSpace) {
        boolean bl;
        block9: {
            int offset;
            char.ptr data;
            StringRef Buffer;
            long LocInfo;
            Lexer TheLexer;
            block7: {
                boolean bl2;
                block8: {
                    block5: {
                        boolean bl3;
                        block6: {
                            TheLexer = null;
                            try {
                                Loc = SM.getExpansionLoc(Loc);
                                LocInfo = SM.getDecomposedLoc(Loc);
                                bool.ptr Invalid = null;
                                Buffer = SM.getBufferData(ClangGlobals.$first_FileID((long)LocInfo), Invalid);
                                if (Buffer != SourceManager.INVALID_BUFFER_DATA) break block5;
                                bl3 = true;
                                if (TheLexer == null) break block6;
                            }
                            catch (Throwable throwable) {
                                if (TheLexer != null) {
                                    LexerJavaPool.$releaseStaticRawTokenLexer(TheLexer);
                                }
                                throw throwable;
                            }
                            LexerJavaPool.$releaseStaticRawTokenLexer(TheLexer);
                        }
                        return bl3;
                    }
                    data = Buffer.data();
                    offset = ClangGlobals.$second_offset((long)LocInfo);
                    if (IgnoreWhiteSpace || !ClangGlobals.isWhitespace((byte)data.$at(offset))) break block7;
                    bl2 = true;
                    if (TheLexer == null) break block8;
                    LexerJavaPool.$releaseStaticRawTokenLexer(TheLexer);
                }
                return bl2;
            }
            char.ptr StrData = (char.ptr)data.$add(offset);
            TheLexer = LexerJavaPool.$getStaticRawTokenLexer();
            TheLexer.$Prepare(SM.getLocForStartOfFile(ClangGlobals.$first_FileID((long)LocInfo)), LangOpts, Native.$noClone((char.ptr)Buffer.begin()), Native.$noClone((char.ptr)StrData), Buffer.begin().$index() + Buffer.size(), false);
            TheLexer.SetCommentRetentionState(true);
            TheLexer.LexFromRawLexer(Result);
            bl = false;
            if (TheLexer == null) break block9;
            LexerJavaPool.$releaseStaticRawTokenLexer(TheLexer);
        }
        return bl;
    }

    public static int GetBeginningOfToken(SourceLocation Loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.GetBeginningOfToken(Loc.getRawEncodingUInt(), SM, LangOpts);
    }

    public static int GetBeginningOfToken(int Loc, SourceManager SM, LangOptions LangOpts) {
        if (SourceLocation.isFileID((int)Loc)) {
            return LexerStatics.getBeginningOfFileToken(Loc, SM, LangOpts);
        }
        if (!SM.isMacroArgExpansion(Loc)) {
            return Loc;
        }
        int FileLoc = SM.getSpellingLoc(Loc);
        int BeginFileLoc = LexerStatics.getBeginningOfFileToken(FileLoc, SM, LangOpts);
        long FileLocInfo = SM.getDecomposedLoc(FileLoc);
        long BeginFileLocInfo = SM.getDecomposedLoc(BeginFileLoc);
        assert (ClangGlobals.$first_FileID((long)FileLocInfo) == ClangGlobals.$first_FileID((long)BeginFileLocInfo) && ClangGlobals.$second_offset((long)FileLocInfo) >= ClangGlobals.$second_offset((long)BeginFileLocInfo));
        return SourceLocation.getRawLocWithOffset((int)Loc, (int)(ClangGlobals.$second_offset((long)BeginFileLocInfo) - ClangGlobals.$second_offset((long)FileLocInfo)));
    }

    public static int AdvanceToTokenCharacter(int TokStart, long CharNo, SourceManager SM, LangOptions LangOpts) {
        bool.ptr Invalid = NativePointer.create_bool$ptr((boolean)false);
        char.ptr TokPtr = Native.$tryClone((char.ptr)SM.getCharacterData(TokStart, Invalid));
        if (Invalid.$star() || CharNo == 0L && Lexer.isObviouslySimpleCharacter(TokPtr.$star())) {
            return TokStart;
        }
        long PhysOffset = 0L;
        while (Lexer.isObviouslySimpleCharacter(TokPtr.$star())) {
            if (CharNo == 0L) {
                return SourceLocation.getRawLocWithOffset((int)TokStart, (long)PhysOffset);
            }
            TokPtr.$preInc();
            --CharNo;
            ++PhysOffset;
        }
        while (CharNo != 0L) {
            long Size = Lexer.getCharAndSizeNoWarn(TokPtr, LangOpts);
            TokPtr.$inc(std.$second_int((long)Size));
            PhysOffset += (long)std.$second_int((long)Size);
            --CharNo;
        }
        if (!Lexer.isObviouslySimpleCharacter(TokPtr.$star())) {
            PhysOffset += (long)Lexer.SkipEscapedNewLines(TokPtr).$sub((abstract_iterator)TokPtr);
        }
        return SourceLocation.getRawLocWithOffset((int)TokStart, (long)PhysOffset);
    }

    public static SourceLocation getLocForEndOfToken(SourceLocation Loc, long Offset, SourceManager SM, LangOptions LangOpts) {
        return SourceLocation.getFromRawEncoding((int)Lexer.getLocForEndOfToken(Loc.getRawEncodingUInt(), Offset, SM, LangOpts));
    }

    public static int getLocForEndOfToken(int Loc, long Offset, SourceManager SM, LangOptions LangOpts) {
        long Len;
        if (SourceLocation.isInvalid((int)Loc)) {
            return SourceLocation.getInvalid();
        }
        if (SourceLocation.isMacroID((int)Loc)) {
            SourceLocation MacroEnd = SourceLocation.getFromRawEncoding((int)Loc);
            if (Offset > 0L || !Lexer.isAtEndOfMacroExpansion(Loc, SM, LangOpts, MacroEnd)) {
                return SourceLocation.getInvalid();
            }
            Loc = MacroEnd.getRawEncodingUInt();
        }
        if ((Len = (long)Lexer.MeasureTokenLength(Loc, SM, LangOpts)) <= Offset) {
            return Loc;
        }
        return SourceLocation.getRawLocWithOffset((int)Loc, (long)(Len -= Offset));
    }

    public static boolean isAtStartOfMacroExpansion(SourceLocation loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.isAtStartOfMacroExpansion(loc.getRawEncodingUInt(), SM, LangOpts, (SourceLocation)null);
    }

    public static boolean isAtStartOfMacroExpansion(SourceLocation loc, SourceManager SM, LangOptions LangOpts, SourceLocation MacroBegin) {
        return Lexer.isAtStartOfMacroExpansion(loc.getRawEncodingUInt(), SM, LangOpts, MacroBegin);
    }

    public static boolean isAtStartOfMacroExpansion(int loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.isAtStartOfMacroExpansion(loc, SM, LangOpts, (SourceLocation)null);
    }

    public static boolean isAtStartOfMacroExpansion(int loc, SourceManager SM, LangOptions LangOpts, SourceLocation MacroBegin) {
        assert (SourceLocation.isValid((int)loc) && SourceLocation.isMacroID((int)loc)) : "Expected a valid macro loc";
        SourceLocation expansionLoc = new SourceLocation();
        if (!SM.isAtStartOfImmediateMacroExpansion(loc, expansionLoc)) {
            return false;
        }
        if (expansionLoc.isFileID()) {
            if (MacroBegin != null) {
                MacroBegin.$assign(expansionLoc);
            }
            return true;
        }
        return Lexer.isAtStartOfMacroExpansion(expansionLoc, SM, LangOpts, MacroBegin);
    }

    public static boolean isAtEndOfMacroExpansion(SourceLocation loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.isAtEndOfMacroExpansion(loc.getRawEncodingUInt(), SM, LangOpts, (SourceLocation)null);
    }

    public static boolean isAtEndOfMacroExpansion(SourceLocation loc, SourceManager SM, LangOptions LangOpts, SourceLocation MacroEnd) {
        return Lexer.isAtEndOfMacroExpansion(loc.getRawEncodingUInt(), SM, LangOpts, MacroEnd);
    }

    public static boolean isAtEndOfMacroExpansion(int loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.isAtEndOfMacroExpansion(loc, SM, LangOpts, (SourceLocation)null);
    }

    public static boolean isAtEndOfMacroExpansion(int loc, SourceManager SM, LangOptions LangOpts, SourceLocation MacroEnd) {
        SourceLocation expansionLoc;
        assert (SourceLocation.isValid((int)loc) && SourceLocation.isMacroID((int)loc)) : "Expected a valid macro loc";
        int spellLoc = SM.getSpellingLoc(loc);
        long tokLen = Lexer.MeasureTokenLength(spellLoc, SM, LangOpts);
        if (tokLen == 0L) {
            return false;
        }
        int afterLoc = SourceLocation.getRawLocWithOffset((int)loc, (long)tokLen);
        if (!SM.isAtEndOfImmediateMacroExpansion(afterLoc, expansionLoc = new SourceLocation())) {
            return false;
        }
        if (expansionLoc.isFileID()) {
            if (MacroEnd != null) {
                MacroEnd.$assign(expansionLoc);
            }
            return true;
        }
        return Lexer.isAtEndOfMacroExpansion(expansionLoc, SM, LangOpts, MacroEnd);
    }

    public static CharSourceRange makeFileCharRange(CharSourceRange Range, SourceManager SM, LangOptions LangOpts) {
        int Begin = Range.getRawBegin();
        int End = Range.getRawEnd();
        if (SourceLocation.isInvalid((int)Begin) || SourceLocation.isInvalid((int)End)) {
            return new CharSourceRange();
        }
        if (SourceLocation.isFileID((int)Begin) && SourceLocation.isFileID((int)End)) {
            return LexerStatics.makeRangeFromFileLocs(Range, SM, LangOpts);
        }
        if (SourceLocation.isMacroID((int)Begin) && SourceLocation.isFileID((int)End)) {
            SourceLocation MacroBegin = SourceLocation.getFromRawEncoding((int)Begin);
            if (!Lexer.isAtStartOfMacroExpansion(Begin, SM, LangOpts, MacroBegin)) {
                return new CharSourceRange();
            }
            Begin = MacroBegin.getRawEncodingUInt();
            Range.setBegin(Begin);
            return LexerStatics.makeRangeFromFileLocs(Range, SM, LangOpts);
        }
        if (SourceLocation.isFileID((int)Begin) && SourceLocation.isMacroID((int)End)) {
            SourceLocation MacroEnd = SourceLocation.getFromRawEncoding((int)End);
            if (Range.isTokenRange() && !Lexer.isAtEndOfMacroExpansion(End, SM, LangOpts, MacroEnd)) {
                return new CharSourceRange();
            }
            End = MacroEnd.getRawEncodingUInt();
            if (Range.isCharRange() && !Lexer.isAtStartOfMacroExpansion(End, SM, LangOpts, MacroEnd)) {
                return new CharSourceRange();
            }
            End = MacroEnd.getRawEncodingUInt();
            Range.setEnd(End);
            return LexerStatics.makeRangeFromFileLocs(Range, SM, LangOpts);
        }
        assert (SourceLocation.isMacroID((int)Begin) && SourceLocation.isMacroID((int)End));
        SourceLocation MacroBegin = new SourceLocation();
        SourceLocation MacroEnd = new SourceLocation();
        if (Lexer.isAtStartOfMacroExpansion(Begin, SM, LangOpts, MacroBegin) && (Range.isTokenRange() && Lexer.isAtEndOfMacroExpansion(End, SM, LangOpts, MacroEnd) || Range.isCharRange() && Lexer.isAtStartOfMacroExpansion(End, SM, LangOpts, MacroEnd))) {
            Range.setBegin(MacroBegin);
            Range.setEnd(MacroEnd);
            return LexerStatics.makeRangeFromFileLocs(Range, SM, LangOpts);
        }
        int BeginEntry = SM.getSLocEntryByID_LoadEntryIfAbsent(SM.getFileID(Begin));
        if (BeginEntry == 0) {
            return new CharSourceRange();
        }
        if (SM.$isMacroArgExpansion(BeginEntry)) {
            int EndEntry = SM.getSLocEntryByID_LoadEntryIfAbsent(SM.getFileID(End));
            if (EndEntry == 0) {
                return new CharSourceRange();
            }
            if (SM.$isMacroArgExpansion(EndEntry) && ClangGlobals.$eq_SourceLocation((int)SM.$getExpansionLocStart(BeginEntry), (int)SM.$getExpansionLocStart(EndEntry))) {
                Range.setBegin(SM.getImmediateSpellingLoc(Begin));
                Range.setEnd(SM.getImmediateSpellingLoc(End));
                return Lexer.makeFileCharRange(Range, SM, LangOpts);
            }
        }
        return new CharSourceRange();
    }

    public static StringRef getSourceText(CharSourceRange Range, SourceManager SM, LangOptions LangOpts) {
        return Lexer.getSourceText(Range, SM, LangOpts, null);
    }

    public static StringRef getSourceText(CharSourceRange Range, SourceManager SM, LangOptions LangOpts, bool.ptr Invalid) {
        Range.$assign(Lexer.makeFileCharRange(Range, SM, LangOpts));
        if (Range.isInvalid()) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return new StringRef();
        }
        long beginInfo = SM.getDecomposedLoc(Range.getRawBegin());
        if (FileID.isInvalid((int)ClangGlobals.$first_FileID((long)beginInfo))) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return new StringRef();
        }
        int.ptr EndOffs = NativePointer.create_int$ptr();
        if (!SM.isInFileID(Range.getRawEnd(), ClangGlobals.$first_FileID((long)beginInfo), EndOffs) || ClangGlobals.$second_offset((long)beginInfo) > EndOffs.$star()) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return new StringRef();
        }
        bool.ptr invalidTemp = null;
        StringRef file = SM.getBufferData(ClangGlobals.$first_FileID((long)beginInfo), invalidTemp);
        if (file == SourceManager.INVALID_BUFFER_DATA) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return new StringRef();
        }
        if (Invalid != null) {
            Invalid.$set(false);
        }
        return file.substr(ClangGlobals.$second_offset((long)beginInfo), EndOffs.$star() - ClangGlobals.$second_offset((long)beginInfo));
    }

    public static StringRef getImmediateMacroName(SourceLocation Loc, SourceManager SM, LangOptions LangOpts) {
        return Lexer.getImmediateMacroName(Loc.getRawEncodingUInt(), SM, LangOpts);
    }

    public static StringRef getImmediateMacroName(int Loc, SourceManager SM, LangOptions LangOpts) {
        assert (SourceLocation.isMacroID((int)Loc)) : "Only reasonble to call this on macros";
        while (true) {
            int MacroFID;
            int FID = SM.getFileID(Loc);
            int Expansion = SM.getExpansionSLocEntryByID_LoadEntryIfAbsent(FID);
            Loc = SM.$getExpansionLocStart(Expansion);
            if (!SM.$isMacroArgExpansion(Expansion)) break;
            Loc = ClangGlobals.$first_SourceLocation((long)SM.getImmediateExpansionRange(Loc));
            int SpellLoc = SM.$getSpellingLoc(Expansion);
            if (SourceLocation.isFileID((int)SpellLoc) || SM.isInFileID(SpellLoc, MacroFID = SM.getFileID(Loc))) break;
            Loc = SpellLoc;
        }
        Loc = SM.getSpellingLoc(Loc);
        long ExpansionInfo = SM.getDecomposedLoc(Loc);
        int MacroTokenLength = Lexer.MeasureTokenLength(Loc, SM, LangOpts);
        StringRef ExpansionBuffer = SM.getBufferData(ClangGlobals.$first_FileID((long)ExpansionInfo));
        return ExpansionBuffer.substr(ClangGlobals.$second_offset((long)ExpansionInfo), MacroTokenLength);
    }

    public static std.pairUIntBool ComputePreamble(StringRef Buffer, LangOptions LangOpts) {
        return Lexer.ComputePreamble(Buffer, LangOpts, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.pairUIntBool ComputePreamble(StringRef Buffer, LangOptions LangOpts, long MaxLines) {
        Lexer TheLexer = null;
        try {
            SourceLocation ActiveCommentLoc;
            long IfCount;
            Token IfStartTok;
            Token TheTok;
            SourceLocation StartLoc;
            block21: {
                Token HashTok;
                int StartOffset;
                int FileLoc = StartOffset = 1;
                TheLexer = new Lexer(FileLoc, LangOpts, Native.$noClone((char.ptr)Buffer.begin()), Native.$tryClone((char.ptr)Buffer.begin()), Buffer.end().$index());
                TheLexer.SetCommentRetentionState(true);
                StartLoc = TheLexer.getSourceLocation();
                boolean InPreprocessorDirective = false;
                TheTok = new Token();
                IfStartTok = new Token();
                IfCount = 0L;
                ActiveCommentLoc = new SourceLocation();
                long MaxLineOffset = 0L;
                if (MaxLines != 0L) {
                    char.ptr CurPtr = Native.$tryClone((char.ptr)Buffer.begin());
                    long CurLine = 0L;
                    while (CurPtr.$noteq((Object)Buffer.end())) {
                        byte ch = CurPtr.$star();
                        CurPtr.$preInc();
                        if (ch != NativePointer.$LF || ++CurLine != MaxLines) continue;
                        break;
                    }
                    if (CurPtr.$noteq((Object)Buffer.end())) {
                        MaxLineOffset = CurPtr.$sub((abstract_iterator)Buffer.begin());
                    }
                }
                block9: while (true) {
                    TheLexer.LexFromRawLexer(TheTok);
                    if (InPreprocessorDirective) {
                        if (TheTok.getKind() == 1) break block21;
                        if (!TheTok.isAtStartOfLine()) continue;
                        InPreprocessorDirective = false;
                    }
                    if (TheTok.isAtStartOfLine()) {
                        long TokOffset = TheTok.getRawLocation() - StartOffset;
                        if (MaxLineOffset != 0L && TokOffset >= MaxLineOffset) break block21;
                    }
                    if (TheTok.getKind() == 4) {
                        if (!ActiveCommentLoc.isInvalid()) continue;
                        ActiveCommentLoc.$assign(TheTok.getRawLocation());
                        continue;
                    }
                    if (!TheTok.isAtStartOfLine() || TheTok.getKind() != 65) break block21;
                    HashTok = TheTok;
                    InPreprocessorDirective = true;
                    ActiveCommentLoc.$assign(SourceLocation.getInvalid());
                    TheLexer.LexFromRawLexer(TheTok);
                    if (TheTok.getKind() != 6 || TheTok.needsCleaning()) break;
                    StringRef Keyword = TheTok.getRawIdentifier();
                    LexerStatics.PreambleDirectiveKind PDK = (LexerStatics.PreambleDirectiveKind)((Object)new StringSwitch(Keyword).Case((CharSequence)"include", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"__include_macros", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"define", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"undef", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"line", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"error", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"pragma", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"import", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"include_next", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"warning", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"ident", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"sccs", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"assert", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"unassert", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"if", (Object)LexerStatics.PreambleDirectiveKind.PDK_StartIf).Case((CharSequence)"ifdef", (Object)LexerStatics.PreambleDirectiveKind.PDK_StartIf).Case((CharSequence)"ifndef", (Object)LexerStatics.PreambleDirectiveKind.PDK_StartIf).Case((CharSequence)"elif", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"else", (Object)LexerStatics.PreambleDirectiveKind.PDK_Skipped).Case((CharSequence)"endif", (Object)LexerStatics.PreambleDirectiveKind.PDK_EndIf).Default((Object)LexerStatics.PreambleDirectiveKind.PDK_Unknown));
                    switch (PDK) {
                        case PDK_Skipped: {
                            continue block9;
                        }
                        case PDK_StartIf: {
                            if (IfCount == 0L) {
                                IfStartTok.$assign(HashTok);
                            }
                            ++IfCount;
                            continue block9;
                        }
                        case PDK_EndIf: {
                            if (IfCount == 0L) break block9;
                            --IfCount;
                            continue block9;
                        }
                    }
                    break;
                }
                InPreprocessorDirective = false;
                TheTok.$assign(HashTok);
            }
            SourceLocation End = new SourceLocation();
            if (IfCount != 0L) {
                End.$assign(IfStartTok.getRawLocation());
            } else if (ActiveCommentLoc.isValid()) {
                End.$assign(ActiveCommentLoc);
            } else {
                End.$assign(TheTok.getRawLocation());
            }
            std.pairUIntBool pairUIntBool2 = std.make_pair_uint_bool((long)(End.getRawEncoding() - StartLoc.getRawEncoding()), (boolean)(IfCount != 0L ? IfStartTok.isAtStartOfLine() : TheTok.isAtStartOfLine()));
            return pairUIntBool2;
        }
        finally {
            if (TheLexer != null) {
                TheLexer.$destroy();
            }
        }
    }

    public static SourceLocation findLocationAfterToken(SourceLocation Loc, short TKind, SourceManager SM, LangOptions LangOpts, boolean SkipTrailingWhitespaceAndNewLine) {
        return SourceLocation.getFromRawEncoding((int)Lexer.findLocationAfterToken(Loc.getRawEncodingUInt(), TKind, SM, LangOpts, SkipTrailingWhitespaceAndNewLine));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findLocationAfterToken(int Loc, short TKind, SourceManager SM, LangOptions LangOpts, boolean SkipTrailingWhitespaceAndNewLine) {
        Lexer lexer = null;
        try {
            if (SourceLocation.isMacroID((int)Loc)) {
                SourceLocation MacroEnd = SourceLocation.getFromRawEncoding((int)Loc);
                if (!Lexer.isAtEndOfMacroExpansion(Loc, SM, LangOpts, MacroEnd)) {
                    int n = SourceLocation.getInvalid();
                    return n;
                }
                Loc = MacroEnd.getRawEncodingUInt();
            }
            Loc = Lexer.getLocForEndOfToken(Loc, 0L, SM, LangOpts);
            long LocInfo = SM.getDecomposedLoc(Loc);
            bool.ptr InvalidTemp = null;
            StringRef File = SM.getBufferData(ClangGlobals.$first_FileID((long)LocInfo), InvalidTemp);
            if (File == SourceManager.INVALID_BUFFER_DATA) {
                int n = SourceLocation.getInvalid();
                return n;
            }
            char.ptr TokenBegin = (char.ptr)File.data().$add(ClangGlobals.$second_offset((long)LocInfo));
            lexer = new Lexer(SM.getLocForStartOfFile(ClangGlobals.$first_FileID((long)LocInfo)), LangOpts, Native.$noClone((char.ptr)File.begin()), Native.$noClone((char.ptr)TokenBegin), File.begin().$index() + File.size());
            Token Tok = new Token();
            lexer.LexFromRawLexer(Tok);
            if (Tok.isNot(TKind)) {
                int n = SourceLocation.getInvalid();
                return n;
            }
            int TokenLoc = Tok.getRawLocation();
            long NumWhitespaceChars = 0L;
            if (SkipTrailingWhitespaceAndNewLine) {
                char.ptr TokenEnd = (char.ptr)SM.getCharacterData(TokenLoc).$add(Tok.getLength());
                byte C = TokenEnd.$star();
                while (ClangGlobals.isHorizontalWhitespace((byte)C)) {
                    C = ((char.ptr)TokenEnd.$preInc()).$star();
                    ++NumWhitespaceChars;
                }
                if (C == NativePointer.$LF || C == NativePointer.$CR) {
                    byte PrevC = C;
                    C = ((char.ptr)TokenEnd.$preInc()).$star();
                    ++NumWhitespaceChars;
                    if ((C == NativePointer.$LF || C == NativePointer.$CR) && C != PrevC) {
                        ++NumWhitespaceChars;
                    }
                }
            }
            int n = SourceLocation.getRawLocWithOffset((int)TokenLoc, (long)((long)Tok.getLength() + NumWhitespaceChars));
            return n;
        }
        finally {
            if (lexer != null) {
                lexer.$destroy();
            }
        }
    }

    public static boolean isIdentifierBodyChar(byte c, LangOptions LangOpts) {
        return ClangGlobals.isIdentifierBody((byte)c, (boolean)LangOpts.DollarIdents);
    }

    public static long getCharAndSizeNoWarn(char.ptr Ptr, LangOptions LangOpts) {
        return Lexer.getCharAndSizeNoWarn(Ptr.$array(), Ptr.$index(), LangOpts);
    }

    public static long getCharAndSizeNoWarn(byte[] Ptr, int PtrIdx, LangOptions LangOpts) {
        byte Char = Ptr[PtrIdx];
        if (Lexer.isObviouslySimpleCharacter(Char)) {
            return std.wrap_char_int_pair((byte)Char, (int)1);
        }
        return Lexer.getCharAndSizeSlowNoWarn(Ptr, PtrIdx, 0, LangOpts);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean LexTokenInternal(Token Result, boolean _TokAtPhysicalStartOfLine) {
        char.ptr CurPtr;
        block146: {
            int Kind2;
            boolean CheckSkippedState;
            int TokAtPhysicalStartOfLine = std.wrap_bool_bool((boolean)true, (boolean)_TokAtPhysicalStartOfLine);
            Native.$setIndex((char.ptr)this.$LexTokenInternalCurPtr, (char.ptr)this.BufferPtr);
            CurPtr = this.$LexTokenInternalCurPtr;
            block42: while (true) {
                CheckSkippedState = true;
                Result.clearFlag(8);
                Result.setIdentifierInfo(null);
                Native.$setIndex((char.ptr)CurPtr, (char.ptr)this.BufferPtr);
                byte CurPtr$star = CurPtr.$star();
                if (CurPtr$star == NativePointer.$SPACE || CurPtr$star == NativePointer.$TAB) {
                    CurPtr.$preInc();
                    CurPtr$star = CurPtr.$star();
                    while (CurPtr$star == NativePointer.$SPACE || CurPtr$star == NativePointer.$TAB) {
                        CurPtr.$preInc();
                        CurPtr$star = CurPtr.$star();
                    }
                    if (this.isKeepWhitespaceMode()) {
                        this.FormTokenWithChars(Result, CurPtr.$index(), (short)0);
                        return true;
                    }
                    Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
                    Result.setFlag(2);
                }
                long SizeTmp = 0L;
                long SizeTmp2 = 0L;
                byte Char = this.getAndAdvanceChar(CurPtr, Result);
                int $CurPtrIndex = CurPtr.$index();
                switch (Char) {
                    case 0: {
                        if ($CurPtrIndex - 1 == this.BufferEnd) {
                            return this.LexEndOfFile(Result, (char.ptr)CurPtr.$dec(1));
                        }
                        if (this.isCodeCompletionPoint((char.ptr)CurPtr.$dec(1))) {
                            Result.startToken();
                            this.FormTokenWithChars(Result, $CurPtrIndex, (short)3);
                            return true;
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                        if (!this.isLexingRawMode()) {
                            this.Diag((char.ptr)CurPtr.$dec(1), 815L).$destroy();
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                        }
                        Result.setFlag(2);
                        if (!std.$first_bool((int)(TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std.$second_bool((int)TokAtPhysicalStartOfLine))))) continue block42;
                        return true;
                    }
                    case 26: {
                        if (this.LangOpts.MicrosoftExt) {
                            return this.LexEndOfFile(Result, (char.ptr)CurPtr.$dec(1));
                        }
                        Kind2 = 0;
                        break block42;
                    }
                    case 10: 
                    case 13: {
                        if (this.ParsingPreprocessorDirective) {
                            this.ParsingPreprocessorDirective = false;
                            if (this.PP != null) {
                                this.resetExtendedTokenMode();
                            }
                            this.IsAtStartOfLine = true;
                            this.IsAtPhysicalStartOfLine = true;
                            Kind2 = 2;
                            CheckSkippedState = false;
                            break block42;
                        }
                        Result.clearFlag(2);
                        if (!std.$first_bool((int)(TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std.$second_bool((int)TokAtPhysicalStartOfLine))))) continue block42;
                        return true;
                    }
                    case 9: 
                    case 11: 
                    case 12: 
                    case 32: {
                        while (true) {
                            Result.setFlag(2);
                            TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std.$second_bool((int)TokAtPhysicalStartOfLine));
                            if (std.$first_bool((int)TokAtPhysicalStartOfLine)) {
                                return true;
                            }
                            while (true) {
                                Native.$setIndex((char.ptr)CurPtr, (char.ptr)this.BufferPtr);
                                CurPtr$star = CurPtr.$star();
                                if (CurPtr$star == NativePointer.$SLASH && CurPtr.$at(1) == NativePointer.$SLASH && !this.inKeepCommentMode() && this.LangOpts.LineComment && (this.LangOpts.CPlusPlus || !this.LangOpts.TraditionalCPP)) {
                                    TokAtPhysicalStartOfLine = this.SkipLineComment(Result, (char.ptr)CurPtr.$inc(2), std.$second_bool((int)TokAtPhysicalStartOfLine));
                                    if (!std.$first_bool((int)TokAtPhysicalStartOfLine)) continue;
                                    return true;
                                }
                                if (CurPtr$star != NativePointer.$SLASH || CurPtr.$at(1) != NativePointer.$STAR || this.inKeepCommentMode()) break;
                                TokAtPhysicalStartOfLine = this.SkipBlockComment(Result, (char.ptr)CurPtr.$inc(2), std.$second_bool((int)TokAtPhysicalStartOfLine));
                                if (std.$first_bool((int)TokAtPhysicalStartOfLine)) return true;
                            }
                            if (!ClangGlobals.isHorizontalWhitespace((byte)CurPtr$star)) continue block42;
                        }
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.MIOpt.ReadToken();
                        return this.LexNumericConstant(Result, CurPtr);
                    }
                    case 117: {
                        this.MIOpt.ReadToken();
                        if (!this.LangOpts.CPlusPlus11 && !this.LangOpts.C11) return this.LexIdentifier(Result, CurPtr);
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$DBL_QUOTE) {
                            return this.LexStringLiteral(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), (short)17);
                        }
                        if (Char == NativePointer.$SGL_QUOTE) {
                            return this.LexCharConstant(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), (short)11);
                        }
                        assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                        if (Char == NativePointer.$R && this.LangOpts.CPlusPlus11 && std.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp))))) == NativePointer.$DBL_QUOTE) {
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            return this.LexRawStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result), (short)17);
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                        if (Char != NativePointer.$8) return this.LexIdentifier(Result, CurPtr);
                        SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp)));
                        byte Char2 = std.$first_byte((long)SizeTmp2);
                        Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                        if (Char2 == NativePointer.$DBL_QUOTE) {
                            return this.LexStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result), (short)16);
                        }
                        if (Char2 == NativePointer.$SGL_QUOTE && this.LangOpts.CPlusPlus1z) {
                            return this.LexCharConstant(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result), (short)10);
                        }
                        if (Char2 != NativePointer.$R || !this.LangOpts.CPlusPlus11) return this.LexIdentifier(Result, CurPtr);
                        long SizeTmp3 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp) + std.$second_int((long)SizeTmp2)));
                        byte Char3 = std.$first_byte((long)SizeTmp3);
                        Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                        if (Char3 != NativePointer.$DBL_QUOTE) return this.LexIdentifier(Result, CurPtr);
                        return this.LexRawStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result), std.$second_int((long)SizeTmp3), Result), (short)16);
                    }
                    case 85: {
                        this.MIOpt.ReadToken();
                        if (!this.LangOpts.CPlusPlus11 && !this.LangOpts.C11) return this.LexIdentifier(Result, CurPtr);
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$DBL_QUOTE) {
                            return this.LexStringLiteral(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), (short)18);
                        }
                        if (Char == NativePointer.$SGL_QUOTE) {
                            return this.LexCharConstant(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), (short)12);
                        }
                        assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                        if (Char == NativePointer.$R && this.LangOpts.CPlusPlus11 && std.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp))))) == NativePointer.$DBL_QUOTE) {
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            return this.LexRawStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result), (short)18);
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                        return this.LexIdentifier(Result, CurPtr);
                    }
                    case 82: {
                        this.MIOpt.ReadToken();
                        if (!this.LangOpts.CPlusPlus11 || (Char = std.$first_byte((long)(SizeTmp = this.getCharAndSize(CurPtr)))) != NativePointer.$DBL_QUOTE) return this.LexIdentifier(Result, CurPtr);
                        return this.LexRawStringLiteral(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), (short)13);
                    }
                    case 76: {
                        this.MIOpt.ReadToken();
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$DBL_QUOTE) {
                            return this.LexStringLiteral(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), (short)14);
                        }
                        assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                        if (this.LangOpts.CPlusPlus11 && Char == NativePointer.$R && std.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp))))) == NativePointer.$DBL_QUOTE) {
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            return this.LexRawStringLiteral(Result, this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result), (short)14);
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                        if (Char == NativePointer.$SGL_QUOTE) {
                            return this.LexCharConstant(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), (short)9);
                        }
                    }
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 95: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: {
                        this.MIOpt.ReadToken();
                        return this.LexIdentifier(Result, CurPtr);
                    }
                    case 36: {
                        if (this.LangOpts.DollarIdents) {
                            assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                            if (!this.isLexingRawMode()) {
                                this.Diag((char.ptr)CurPtr.$dec(1), 761L).$destroy();
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            }
                            this.MIOpt.ReadToken();
                            return this.LexIdentifier(Result, CurPtr);
                        }
                        Kind2 = 0;
                        break block42;
                    }
                    case 39: {
                        this.MIOpt.ReadToken();
                        return this.LexCharConstant(Result, CurPtr, (short)8);
                    }
                    case 34: {
                        this.MIOpt.ReadToken();
                        return this.LexStringLiteral(Result, CurPtr, (short)13);
                    }
                    case 63: {
                        Kind2 = 59;
                        break block42;
                    }
                    case 91: {
                        Kind2 = 19;
                        break block42;
                    }
                    case 93: {
                        Kind2 = 20;
                        break block42;
                    }
                    case 40: {
                        Kind2 = 21;
                        break block42;
                    }
                    case 41: {
                        Kind2 = 22;
                        break block42;
                    }
                    case 123: {
                        Kind2 = 23;
                        break block42;
                    }
                    case 125: {
                        Kind2 = 24;
                        break block42;
                    }
                    case 46: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                        if (Char >= NativePointer.$0 && Char <= NativePointer.$9) {
                            this.MIOpt.ReadToken();
                            return this.LexNumericConstant(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result));
                        }
                        if (this.LangOpts.CPlusPlus && Char == NativePointer.$STAR) {
                            Kind2 = 68;
                            CurPtr.$inc(std.$second_int((long)SizeTmp));
                            break block42;
                        }
                        if (Char == NativePointer.$DOT && std.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp))))) == NativePointer.$DOT) {
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            Kind2 = 26;
                            CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result);
                            break block42;
                        }
                        Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                        Kind2 = 25;
                        break block42;
                    }
                    case 38: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$AMP) {
                            Kind2 = 28;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (Char == NativePointer.$EQ) {
                            Kind2 = 29;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 27;
                        break block42;
                    }
                    case 42: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        if (std.$first_byte((long)SizeTmp) == NativePointer.$EQ) {
                            Kind2 = 31;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 30;
                        break block42;
                    }
                    case 43: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$PLUS) {
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 33;
                            break block42;
                        }
                        if (Char == NativePointer.$EQ) {
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 34;
                            break block42;
                        }
                        Kind2 = 32;
                        break block42;
                    }
                    case 45: {
                        assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$MINUS) {
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 37;
                            break block42;
                        }
                        if (Char == NativePointer.$GT && this.LangOpts.CPlusPlus && std.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp))))) == NativePointer.$STAR) {
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result);
                            Kind2 = 69;
                            break block42;
                        }
                        if (Char == NativePointer.$GT) {
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 36;
                            break block42;
                        }
                        if (Char == NativePointer.$EQ) {
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 38;
                            break block42;
                        }
                        Kind2 = 35;
                        break block42;
                    }
                    case 126: {
                        Kind2 = 39;
                        break block42;
                    }
                    case 33: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        if (std.$first_byte((long)SizeTmp) == NativePointer.$EQ) {
                            Kind2 = 41;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 40;
                        break block42;
                    }
                    case 47: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                        if (Char == NativePointer.$SLASH) {
                            boolean TreatAsComment;
                            boolean bl = TreatAsComment = this.LangOpts.LineComment && (this.LangOpts.CPlusPlus || !this.LangOpts.TraditionalCPP);
                            if (!(TreatAsComment || this.PP != null && this.PP.isPreprocessedOutput())) {
                                assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                                SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp)));
                                TreatAsComment = std.$first_byte((long)SizeTmp2) != NativePointer.$STAR;
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            }
                            if (TreatAsComment) {
                                assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                                TokAtPhysicalStartOfLine = this.SkipLineComment(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_bool((int)TokAtPhysicalStartOfLine));
                                if (std.$first_bool((int)TokAtPhysicalStartOfLine)) {
                                    return true;
                                }
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                                boolean goToSkipIgnoredUnits = true;
                                while (true) {
                                    if (!goToSkipIgnoredUnits) {
                                        Result.setFlag(2);
                                        TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std.$second_bool((int)TokAtPhysicalStartOfLine));
                                        if (std.$first_bool((int)TokAtPhysicalStartOfLine)) {
                                            return true;
                                        }
                                    }
                                    goToSkipIgnoredUnits = false;
                                    while (true) {
                                        Native.$setIndex((char.ptr)CurPtr, (char.ptr)this.BufferPtr);
                                        CurPtr$star = CurPtr.$star();
                                        if (CurPtr$star == NativePointer.$SLASH && CurPtr.$at(1) == NativePointer.$SLASH && !this.inKeepCommentMode() && this.LangOpts.LineComment && (this.LangOpts.CPlusPlus || !this.LangOpts.TraditionalCPP)) {
                                            TokAtPhysicalStartOfLine = this.SkipLineComment(Result, (char.ptr)CurPtr.$inc(2), std.$second_bool((int)TokAtPhysicalStartOfLine));
                                            if (!std.$first_bool((int)TokAtPhysicalStartOfLine)) continue;
                                            return true;
                                        }
                                        if (CurPtr$star != NativePointer.$SLASH || CurPtr.$at(1) != NativePointer.$STAR || this.inKeepCommentMode()) break;
                                        TokAtPhysicalStartOfLine = this.SkipBlockComment(Result, (char.ptr)CurPtr.$inc(2), std.$second_bool((int)TokAtPhysicalStartOfLine));
                                        if (std.$first_bool((int)TokAtPhysicalStartOfLine)) return true;
                                    }
                                    if (!ClangGlobals.isHorizontalWhitespace((byte)CurPtr$star)) continue block42;
                                }
                            }
                        }
                        if (Char == NativePointer.$STAR) {
                            assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                            TokAtPhysicalStartOfLine = this.SkipBlockComment(Result, this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_bool((int)TokAtPhysicalStartOfLine));
                            if (!std.$first_bool((int)TokAtPhysicalStartOfLine)) continue block42;
                            return true;
                        }
                        if (Char == NativePointer.$EQ) {
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 43;
                            break block42;
                        }
                        Kind2 = 42;
                        break block42;
                    }
                    case 37: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$EQ) {
                            Kind2 = 45;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (this.LangOpts.Digraphs && Char == NativePointer.$GT) {
                            Kind2 = 24;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (this.LangOpts.Digraphs && Char == NativePointer.$COLON) {
                            assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            $CurPtrIndex = CurPtr.$index();
                            SizeTmp = this.getCharAndSize(CurPtr);
                            Char = std.$first_byte((long)SizeTmp);
                            if (Char == NativePointer.$PERCENT && std.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp))))) == NativePointer.$COLON) {
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                                Kind2 = 66;
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result);
                                break block42;
                            }
                            if (Char == NativePointer.$AT && this.LangOpts.MicrosoftExt) {
                                CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                                if (!this.isLexingRawMode()) {
                                    this.Diag(this.BufferPtr, 760L).$destroy();
                                }
                                Kind2 = 67;
                                break block42;
                            }
                            if (!std.$second_bool((int)TokAtPhysicalStartOfLine) || this.LexingRawMode || this.Is_PragmaLexer) {
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                                Kind2 = 65;
                                CheckSkippedState = false;
                                break block42;
                            }
                            break block146;
                        }
                        Kind2 = 44;
                        break block42;
                    }
                    case 60: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (this.ParsingFilename) {
                            return this.LexAngledStringLiteral(Result, CurPtr);
                        }
                        if (Char == NativePointer.$LT) {
                            assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                            SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp)));
                            byte After = std.$first_byte((long)SizeTmp2);
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            if (After == NativePointer.$EQ) {
                                Kind2 = 49;
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result);
                                break block42;
                            }
                            if (After == NativePointer.$LT && this.IsStartOfConflictMarker((char.ptr)CurPtr.$dec(1)) || After == NativePointer.$LT && this.HandleEndOfConflictMarker(CurPtr)) continue block42;
                            if (this.LangOpts.CUDA && After == NativePointer.$LT) {
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                                Kind2 = 72;
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result);
                                break block42;
                            }
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 47;
                            break block42;
                        }
                        if (Char == NativePointer.$EQ) {
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 48;
                            break block42;
                        }
                        if (this.LangOpts.Digraphs && Char == NativePointer.$COLON) {
                            assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                            if (this.LangOpts.CPlusPlus11 && std.$first_byte((long)(SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp))))) == NativePointer.$COLON) {
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                                byte After = std.$first_byte((long)this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp) + std.$second_int((long)SizeTmp2))));
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                                if (After != NativePointer.$COLON && After != NativePointer.$GT) {
                                    Kind2 = 46;
                                    if (this.isLexingRawMode()) break block42;
                                    this.Diag(this.BufferPtr, 849L).$destroy();
                                    break block42;
                                }
                            }
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 19;
                            break block42;
                        }
                        if (this.LangOpts.Digraphs && Char == NativePointer.$PERCENT) {
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 23;
                            break block42;
                        }
                        Kind2 = 46;
                        break block42;
                    }
                    case 62: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$EQ) {
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 52;
                            break block42;
                        }
                        if (Char == NativePointer.$GT) {
                            assert ($CurPtrIndex == CurPtr.$index()) : "when it was changed? " + $CurPtrIndex + " vs. " + CurPtr.$index();
                            SizeTmp2 = this.getCharAndSize((char.ptr)CurPtr.$inc(std.$second_int((long)SizeTmp)));
                            byte After = std.$first_byte((long)SizeTmp2);
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            if (After == NativePointer.$EQ) {
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result);
                                Kind2 = 53;
                                break block42;
                            }
                            if (After == NativePointer.$GT && this.IsStartOfConflictMarker((char.ptr)CurPtr.$dec(1)) || After == NativePointer.$GT && this.HandleEndOfConflictMarker(CurPtr)) continue block42;
                            if (this.LangOpts.CUDA && After == NativePointer.$GT) {
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                                Kind2 = 73;
                                CurPtr = this.ConsumeChar(this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result), std.$second_int((long)SizeTmp2), Result);
                                break block42;
                            }
                            Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 51;
                            break block42;
                        }
                        Kind2 = 50;
                        break block42;
                    }
                    case 94: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$EQ) {
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            Kind2 = 55;
                            break block42;
                        }
                        Kind2 = 54;
                        break block42;
                    }
                    case 124: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$EQ) {
                            Kind2 = 58;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (Char == NativePointer.$PIPE) {
                            if (CurPtr.$at(1) == NativePointer.$PIPE) {
                                if (this.HandleEndOfConflictMarker((char.ptr)CurPtr.$dec(1))) continue block42;
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            }
                            Kind2 = 57;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 56;
                        break block42;
                    }
                    case 58: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (this.LangOpts.Digraphs && Char == NativePointer.$GT) {
                            Kind2 = 20;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (this.LangOpts.CPlusPlus && Char == NativePointer.$COLON) {
                            Kind2 = 70;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 60;
                        break block42;
                    }
                    case 59: {
                        Kind2 = 61;
                        break block42;
                    }
                    case 61: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$EQ) {
                            if (CurPtr.$at(1) == NativePointer.$EQ) {
                                if (this.HandleEndOfConflictMarker((char.ptr)CurPtr.$dec(1))) continue block42;
                                Native.$setIndex((char.ptr)CurPtr, (int)$CurPtrIndex);
                            }
                            Kind2 = 63;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        Kind2 = 62;
                        break block42;
                    }
                    case 44: {
                        Kind2 = 64;
                        break block42;
                    }
                    case 35: {
                        SizeTmp = this.getCharAndSize(CurPtr);
                        Char = std.$first_byte((long)SizeTmp);
                        if (Char == NativePointer.$HASH) {
                            Kind2 = 66;
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (Char == NativePointer.$AT && this.LangOpts.MicrosoftExt) {
                            Kind2 = 67;
                            if (!this.isLexingRawMode()) {
                                this.Diag(this.BufferPtr, 760L).$destroy();
                            }
                            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)SizeTmp), Result);
                            break block42;
                        }
                        if (!std.$second_bool((int)TokAtPhysicalStartOfLine) || this.LexingRawMode || this.Is_PragmaLexer) {
                            Kind2 = 65;
                            CheckSkippedState = false;
                            break block42;
                        }
                        break block146;
                    }
                    case 64: {
                        if (CurPtr.$at(-1) == NativePointer.$AT) {
                            Kind2 = 71;
                            break block42;
                        }
                        Kind2 = 0;
                        break block42;
                    }
                    case 92: {
                        long CodePoint = this.tryReadUCN(CurPtr, this.BufferPtr, Result);
                        if (CodePoint != 0L) {
                            if (!this.CheckUnicodeWhitespace(Result, CodePoint, CurPtr)) return this.LexUnicode(Result, CodePoint, CurPtr);
                            if (!std.$first_bool((int)(TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std.$second_bool((int)TokAtPhysicalStartOfLine))))) continue block42;
                            return true;
                        }
                        Kind2 = 0;
                        break block42;
                    }
                    default: {
                        if (ClangGlobals.isASCII((byte)Char)) {
                            Kind2 = 0;
                            break block42;
                        }
                        long[] CodePoint = NativePointer.new$long$elem((long)0L);
                        CurPtr.$preDec();
                        ConvertUTFGlobals.ConversionResult Status = llvm.convertUTF8Sequence((type.ptr)CurPtr.$addr(), (char.ptr)this.$BufferEnd(), (long[])CodePoint, (ConvertUTFGlobals.ConversionFlags)ConvertUTFGlobals.ConversionFlags.strictConversion);
                        if (Status == ConvertUTFGlobals.ConversionResult.conversionOK) {
                            if (!this.CheckUnicodeWhitespace(Result, CodePoint[0], CurPtr)) return this.LexUnicode(Result, CodePoint[0], CurPtr);
                            if (!std.$first_bool((int)(TokAtPhysicalStartOfLine = this.SkipWhitespace(Result, CurPtr, std.$second_bool((int)TokAtPhysicalStartOfLine))))) continue block42;
                            return true;
                        }
                        if (this.isLexingRawMode() || this.ParsingPreprocessorDirective || this.PP.isPreprocessedOutput()) {
                            CurPtr.$preInc();
                            Kind2 = 0;
                            break block42;
                        }
                        this.Diag(CurPtr, 645L).$destroy();
                        assert (this.BufferPtr.isComparableTo((void.ptr)CurPtr)) : "CurPtr was replaced by another buffer? " + CurPtr;
                        Native.$setIndex((char.ptr)this.BufferPtr, (int)(CurPtr.$index() + 1));
                        continue block42;
                    }
                }
                break;
            }
            this.MIOpt.ReadToken();
            if (CheckSkippedState && this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
                return false;
            }
            this.FormTokenWithChars(Result, CurPtr.$index(), (short)Kind2);
            return true;
        }
        this.FormTokenWithChars(Result, CurPtr.$index(), (short)65);
        this.PP.HandleDirective(Result);
        if (!this.PP.hadModuleLoaderFatalFailure()) return false;
        assert (Result.is((short)1)) : "Preprocessor did not set tok:eof";
        return true;
    }

    private boolean CheckUnicodeWhitespace(Token Result, long C, char.ptr CurPtr) {
        if (!this.isLexingRawMode() && !this.PP.isPreprocessedOutput() && UnicodeWhitespaceChars.contains(C)) {
            ClangGlobals.$out_DiagnosticBuilder_CharSourceRange((DiagnosticBuilder)this.Diag(this.BufferPtr, 799L), (CharSourceRange)LexerStatics.makeCharRange(this, this.BufferPtr, CurPtr)).$destroy();
            Result.setFlag(2);
            return true;
        }
        return false;
    }

    private boolean LexUnicode(Token Result, long C, char.ptr CurPtr) {
        if (LexerStatics.isAllowedIDChar(C, this.LangOpts) && LexerStatics.isAllowedInitiallyIDChar(C, this.LangOpts)) {
            if (!(this.isLexingRawMode() || this.ParsingPreprocessorDirective || this.PP.isPreprocessedOutput())) {
                LexerStatics.maybeDiagnoseIDCharCompat(this.PP.getDiagnostics(), C, LexerStatics.makeCharRange(this, this.BufferPtr, CurPtr), true);
            }
            this.MIOpt.ReadToken();
            return this.LexIdentifier(Result, CurPtr);
        }
        if (!(this.isLexingRawMode() || this.ParsingPreprocessorDirective || this.PP.isPreprocessedOutput() || ClangGlobals.isASCII((byte)this.BufferPtr.$star()) || LexerStatics.isAllowedIDChar(C, this.LangOpts))) {
            ClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(this.BufferPtr, 681L), (FixItHint)FixItHint.CreateRemoval((CharSourceRange)LexerStatics.makeCharRange(this, this.BufferPtr, CurPtr))).$destroy();
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return false;
        }
        this.MIOpt.ReadToken();
        this.FormTokenWithChars(Result, CurPtr.$index(), (short)0);
        return true;
    }

    void FormTokenWithChars(Token Result, int TokEnd, short Kind2) {
        long TokLen = TokEnd - this.BufferPtr.$index();
        Result.setLength(TokLen);
        Result.setLocation(this.getSourceLocation(this.BufferPtr, TokLen));
        Result.setKind(Kind2);
        Native.$setIndex((char.ptr)this.BufferPtr, (int)TokEnd);
        if (NativeTrace.isDebugMode() && !this.ParsingPreprocessorDirective && this.SkipTokensBetweenDirectives && !Result.is((short)2) && !Result.is((short)65)) {
            this.PP.DumpToken(Result, true, llvm.errs());
            new Exception("creating token " + Result).printStackTrace();
        }
    }

    private boolean ConsumedSkippedTokenBetweenDirectives(char.ptr TokEnd) {
        if (!this.ParsingPreprocessorDirective && this.SkipTokensBetweenDirectives) {
            Native.$setIndex((char.ptr)this.BufferPtr, (int)TokEnd.$index());
            return true;
        }
        return false;
    }

    int isNextPPTokenLParen() {
        assert (!this.LexingRawMode) : "How can we expand a macro from a skipping buffer?";
        this.LexingRawMode = true;
        int TmpBufferPtr = this.BufferPtr.$index();
        boolean inPPDirectiveMode = this.ParsingPreprocessorDirective;
        boolean atStartOfLine = this.IsAtStartOfLine;
        boolean atPhysicalStartOfLine = this.IsAtPhysicalStartOfLine;
        boolean leadingSpace = this.HasLeadingSpace;
        Token Tok = this.$getIsNextPPTokenLParenToken();
        this.Lex(Tok);
        Native.$setIndex((char.ptr)this.BufferPtr, (int)TmpBufferPtr);
        this.ParsingPreprocessorDirective = inPPDirectiveMode;
        this.HasLeadingSpace = leadingSpace;
        this.IsAtStartOfLine = atStartOfLine;
        this.IsAtPhysicalStartOfLine = atPhysicalStartOfLine;
        this.LexingRawMode = false;
        int out = Tok.is((short)1) ? 2 : (Tok.is((short)21) ? 1 : 0);
        this.$releaseIsNextPPTokenLParenToken(Tok);
        return out;
    }

    private static boolean isObviouslySimpleCharacter(byte C) {
        return C != NativePointer.$QMARK && C != NativePointer.$BACK_SLASH;
    }

    private byte getAndAdvanceChar(char.ptr Ptr, Token Tok) {
        byte out = Ptr.$at(0);
        if (Lexer.isObviouslySimpleCharacter(out)) {
            Ptr.$preInc();
            return out;
        }
        long Size = this.getCharAndSizeSlow(Ptr, 0, Tok);
        byte C = std.$first_byte((long)Size);
        Ptr.$inc(std.$second_int((long)Size));
        return C;
    }

    private char.ptr ConsumeChar(char.ptr Ptr, int Size, Token Tok) {
        return this.ConsumeChar(Ptr, Size, Tok, true);
    }

    private char.ptr ConsumeChar(char.ptr Ptr, int Size, Token Tok, boolean canModifyPtr) {
        assert (canModifyPtr) : "call this function with remembering and restoring curPtr.$index";
        if (!canModifyPtr) {
            Lexer.trackConsumeChar();
        }
        if (Size == 1) {
            return canModifyPtr ? (char.ptr)Ptr.$preInc() : (char.ptr)Ptr.$add(Size);
        }
        Size = std.$second_int((long)this.getCharAndSizeSlow(Ptr, 0, Tok));
        return canModifyPtr ? (char.ptr)Ptr.$inc(Size) : (char.ptr)Ptr.$add(Size);
    }

    private long getCharAndSize(char.ptr Ptr) {
        byte Ptr$star = Ptr.$star();
        if (Lexer.isObviouslySimpleCharacter(Ptr$star)) {
            return std.wrap_char_int_pair((byte)Ptr$star, (int)1);
        }
        return this.getCharAndSizeSlow(Ptr, 0);
    }

    private long getCharAndSizeSlow(char.ptr Ptr, int Size) {
        return this.getCharAndSizeSlow(Ptr, Size, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCharAndSizeSlow(char.ptr Ptr, int Size, Token Tok) {
        boolean executeLoop = true;
        boolean fromGoToSlash = false;
        int $PtrIndex = Ptr.$index();
        try {
            byte Ptr$star = NativePointer.$TERM;
            while (executeLoop) {
                executeLoop = false;
                Ptr$star = Ptr.$star();
                if (Ptr$star == NativePointer.$BACK_SLASH || fromGoToSlash) {
                    if (!fromGoToSlash) {
                        ++Size;
                        Ptr.$preInc();
                        Ptr$star = Ptr.$star();
                    }
                    fromGoToSlash = false;
                    if (!ClangGlobals.isWhitespace((byte)Ptr$star)) {
                        long l = std.wrap_char_int_pair((byte)NativePointer.$BACK_SLASH, (int)Size);
                        return l;
                    }
                    long EscapedNewLineSize = Lexer.getEscapedNewLineSize(Ptr);
                    if (EscapedNewLineSize != 0L) {
                        if (Tok != null) {
                            Tok.setFlag(8);
                        }
                        if (Ptr$star != NativePointer.$LF && Ptr$star != NativePointer.$CR && Tok != null && !this.isLexingRawMode()) {
                            this.Diag(Ptr, 621L).$destroy();
                        }
                        Size = (int)((long)Size + EscapedNewLineSize);
                        Ptr.$inc(EscapedNewLineSize);
                        Ptr$star = Ptr.$star();
                        if (Ptr$star == NativePointer.$LF || Ptr$star == NativePointer.$CR || Ptr$star == NativePointer.$TERM) {
                            long l = std.wrap_char_int_pair((byte)NativePointer.$SPACE, (int)Size);
                            return l;
                        }
                        long l = this.getCharAndSizeSlow(Ptr, Size, Tok);
                        return l;
                    }
                    EscapedNewLineSize = std.wrap_char_int_pair((byte)NativePointer.$BACK_SLASH, (int)Size);
                    return EscapedNewLineSize;
                }
                if (Ptr$star != NativePointer.$QMARK || Ptr.$at(1) != NativePointer.$QMARK) continue;
                byte C = LexerStatics.DecodeTrigraphChar((char.ptr)Ptr.$add(2), Tok != null ? this : null);
                if (C == 0) continue;
                if (Tok != null) {
                    Tok.setFlag(8);
                }
                Ptr.$inc(3);
                Size += 3;
                if (C == NativePointer.$BACK_SLASH) {
                    fromGoToSlash = true;
                    executeLoop = true;
                    continue;
                }
                long l = std.wrap_char_int_pair((byte)C, (int)Size);
                return l;
            }
            long l = std.wrap_char_int_pair((byte)Ptr$star, (int)(++Size));
            return l;
        }
        finally {
            Native.$setIndex((char.ptr)Ptr, (int)$PtrIndex);
        }
    }

    private static long getEscapedNewLineSize(char.ptr Ptr) {
        return Lexer.getEscapedNewLineSize(Ptr.$array(), Ptr.$index());
    }

    private static long getEscapedNewLineSize(byte[] Ptr, int PtrIdx) {
        byte PtrAt$Size;
        int Size = PtrIdx;
        while (ClangGlobals.isWhitespace((byte)(PtrAt$Size = Ptr[Size]))) {
            ++Size;
            if (PtrAt$Size != NativePointer.$LF && PtrAt$Size != NativePointer.$CR) continue;
            PtrAt$Size = Ptr[Size];
            if ((PtrAt$Size == NativePointer.$CR || PtrAt$Size == NativePointer.$LF) && Ptr[Size - 1] != PtrAt$Size) {
                ++Size;
            }
            return Size - PtrIdx;
        }
        return 0L;
    }

    private static char.ptr SkipEscapedNewLines(char.ptr P) {
        while (true) {
            char.ptr AfterEscape;
            byte P$star;
            if ((P$star = P.$star()) == NativePointer.$BACK_SLASH) {
                AfterEscape = (char.ptr)P.$add(1);
            } else if (P$star == NativePointer.$QMARK) {
                if (P.$at(1) != NativePointer.$QMARK || P.$at(2) != NativePointer.$SLASH) {
                    return P;
                }
                AfterEscape = (char.ptr)P.$add(3);
            } else {
                return P;
            }
            long NewLineSize = Lexer.getEscapedNewLineSize(AfterEscape);
            if (NewLineSize == 0L) {
                return P;
            }
            P = (char.ptr)AfterEscape.$add(NewLineSize);
        }
    }

    private static long getCharAndSizeSlowNoWarn(byte[] Ptr, int PtrIdx, int Size, LangOptions LangOpts) {
        boolean executeLoop = true;
        boolean fromGoToSlash = false;
        while (executeLoop) {
            byte C;
            executeLoop = false;
            if (Ptr[PtrIdx] == NativePointer.$BACK_SLASH || fromGoToSlash) {
                if (!fromGoToSlash) {
                    ++Size;
                    ++PtrIdx;
                }
                fromGoToSlash = false;
                if (!ClangGlobals.isWhitespace((byte)Ptr[PtrIdx])) {
                    return std.wrap_char_int_pair((byte)NativePointer.$BACK_SLASH, (int)Size);
                }
                long EscapedNewLineSize = Lexer.getEscapedNewLineSize(Ptr, PtrIdx);
                if (EscapedNewLineSize != 0L) {
                    Size = (int)((long)Size + EscapedNewLineSize);
                    if (Ptr[PtrIdx = (int)((long)PtrIdx + EscapedNewLineSize)] == NativePointer.$LF || Ptr[PtrIdx] == NativePointer.$CR || Ptr[PtrIdx] == NativePointer.$TERM) {
                        return std.wrap_char_int_pair((byte)NativePointer.$SPACE, (int)Size);
                    }
                    return Lexer.getCharAndSizeSlowNoWarn(Ptr, PtrIdx, Size, LangOpts);
                }
                return std.wrap_char_int_pair((byte)NativePointer.$BACK_SLASH, (int)Size);
            }
            if (!LangOpts.Trigraphs || Ptr[PtrIdx] != NativePointer.$QMARK || Ptr[PtrIdx + 1] != NativePointer.$QMARK || (C = LexerStatics.GetTrigraphCharForLetter(Ptr[PtrIdx + 2])) == 0) continue;
            PtrIdx += 3;
            Size += 3;
            if (C == NativePointer.$BACK_SLASH) {
                fromGoToSlash = true;
                executeLoop = true;
                continue;
            }
            return std.wrap_char_int_pair((byte)C, (int)Size);
        }
        return std.wrap_char_int_pair((byte)Ptr[PtrIdx], (int)(++Size));
    }

    void SkipBytes(long Bytes, boolean StartOfLine) {
        this.BufferPtr.$inc(Bytes);
        if (this.BufferPtr.$index() > this.BufferEnd) {
            Native.$setIndex((char.ptr)this.BufferPtr, (int)this.BufferEnd);
        }
        this.IsAtStartOfLine = StartOfLine;
        this.IsAtPhysicalStartOfLine = StartOfLine;
    }

    void PropagateLineStartLeadingSpaceInfo(Token Result) {
        this.IsAtStartOfLine = Result.isAtStartOfLine();
        this.HasLeadingSpace = Result.hasLeadingSpace();
        this.HasLeadingEmptyMacro = Result.hasLeadingEmptyMacro();
    }

    private char.ptr LexUDSuffix(Token Result, char.ptr CurPtr, boolean IsStringLiteral) {
        assert (this.getLangOpts().CPlusPlus);
        long Size = this.getCharAndSize(CurPtr);
        byte C = std.$first_byte((long)Size);
        boolean Consumed = false;
        if (!ClangGlobals.isIdentifierHead((byte)C)) {
            if (C == NativePointer.$BACK_SLASH && this.tryConsumeIdentifierUCN(CurPtr, std.$second_int((long)Size), Result)) {
                Consumed = true;
            } else if (!ClangGlobals.isASCII((byte)C) && this.tryConsumeIdentifierUTF8Char(CurPtr)) {
                Consumed = true;
            } else {
                return CurPtr;
            }
        }
        if (!this.getLangOpts().CPlusPlus11) {
            if (!this.isLexingRawMode()) {
                ClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(CurPtr, C == NativePointer.$UNDERSCORE ? 845L : 844L), (FixItHint)FixItHint.CreateInsertion((int)this.getSourceLocation(CurPtr), (StringRef)StringRef.SPACE)).$destroy();
            }
            return CurPtr;
        }
        if (!Consumed) {
            boolean IsUDSuffix = false;
            if (C == NativePointer.$UNDERSCORE) {
                IsUDSuffix = true;
            } else if (IsStringLiteral && this.getLangOpts().CPlusPlus14) {
                long MaxStandardSuffixLength = 3L;
                byte[] Buffer = NativePointer.new$char((int)3, (byte[])new byte[]{C});
                int _Consumed = std.$second_int((long)Size);
                int Chars = 1;
                while (true) {
                    long NextSize;
                    byte Next;
                    if (!ClangGlobals.isIdentifierBody((byte)(Next = std.$first_byte((long)(NextSize = Lexer.getCharAndSizeNoWarn((char.ptr)CurPtr.$add(_Consumed), this.getLangOpts())))))) {
                        IsUDSuffix = Chars == 1 && Buffer[0] == NativePointer.$s || NumericLiteralParser.isValidUDSuffix(this.getLangOpts(), new StringRef(Buffer, Chars));
                        break;
                    }
                    if ((long)Chars == MaxStandardSuffixLength) break;
                    Buffer[Chars++] = Next;
                    _Consumed += std.$second_int((long)NextSize);
                }
            }
            if (!IsUDSuffix) {
                if (!this.isLexingRawMode()) {
                    ClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(CurPtr, this.getLangOpts().MSVCCompat ? 771L : 795L), (FixItHint)FixItHint.CreateInsertion((int)this.getSourceLocation(CurPtr), (StringRef)StringRef.SPACE)).$destroy();
                }
                return CurPtr;
            }
            CurPtr = Native.$tryClone((char.ptr)this.ConsumeChar(CurPtr, std.$second_int((long)Size), Result));
        }
        Result.setFlag(32);
        while (true) {
            if (ClangGlobals.isIdentifierBody((byte)(C = std.$first_byte((long)(Size = this.getCharAndSize(CurPtr)))))) {
                CurPtr = Native.$tryClone((char.ptr)this.ConsumeChar(CurPtr, std.$second_int((long)Size), Result));
                continue;
            }
            if (!(C == NativePointer.$BACK_SLASH && this.tryConsumeIdentifierUCN(CurPtr, std.$second_int((long)Size), Result) || !ClangGlobals.isASCII((byte)C) && this.tryConsumeIdentifierUTF8Char(CurPtr))) break;
        }
        return CurPtr;
    }

    /*
     * Unable to fully structure code
     */
    private boolean LexIdentifier(Token Result, char.ptr CurPtr) {
        Size = 0L;
        C = CurPtr.$star();
        CurPtr.$preInc();
        while (ClangGlobals.isIdentifierBody((byte)C)) {
            C = CurPtr.$star();
            CurPtr.$preInc();
        }
        CurPtr.$preDec();
        executeLoop = true;
        fromGoToFinishIdentifier = false;
        block1: while (executeLoop) {
            executeLoop = false;
            if (ClangGlobals.isASCII((byte)C) && C != NativePointer.$BACK_SLASH && C != NativePointer.$QMARK && (C != NativePointer.$DOLLAR || !this.LangOpts.DollarIdents) || fromGoToFinishIdentifier) {
                fromGoToFinishIdentifier = false;
                if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
                    return false;
                }
                if (this.$ArrayBasedOrigBufferPtr) {
                    IdStart = this.BufferPtr.$index();
                    this.FormTokenWithChars(Result, CurPtr.$index(), (short)6);
                    Result.setRawIdentifierData(this.BufferPtr.$array(), IdStart);
                } else {
                    IdStart = this.getTokenStartFromBufferPtr();
                    this.FormTokenWithChars(Result, CurPtr.$index(), (short)6);
                    Result.setRawIdentifierData(IdStart);
                }
                if (this.LexingRawMode) {
                    return true;
                }
                II = this.PP.LookUpIdentifierInfo(Result);
                if (II.isHandleIdentifierCase()) {
                    return this.PP.HandleIdentifier(Result);
                }
                return true;
            }
            Size = this.getCharAndSize(CurPtr);
            C = std.$first_byte((long)Size);
            block2: while (true) {
                if (C == NativePointer.$DOLLAR) {
                    if (!this.LangOpts.DollarIdents) {
                        executeLoop = true;
                        fromGoToFinishIdentifier = true;
                        continue block1;
                    }
                    if (!this.isLexingRawMode()) {
                        this.Diag(CurPtr, 761L).$destroy();
                    }
                    CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)Size), Result);
                    Size = this.getCharAndSize(CurPtr);
                    C = std.$first_byte((long)Size);
                    continue;
                }
                if (C == NativePointer.$BACK_SLASH && this.tryConsumeIdentifierUCN(CurPtr, std.$second_int((long)Size), Result)) {
                    Size = this.getCharAndSize(CurPtr);
                    C = std.$first_byte((long)Size);
                    continue;
                }
                if (!ClangGlobals.isASCII((byte)C) && this.tryConsumeIdentifierUTF8Char(CurPtr)) {
                    Size = this.getCharAndSize(CurPtr);
                    C = std.$first_byte((long)Size);
                    continue;
                }
                if (!ClangGlobals.isIdentifierBody((byte)C)) {
                    executeLoop = true;
                    fromGoToFinishIdentifier = true;
                    continue block1;
                }
                CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)Size), Result);
                Size = this.getCharAndSize(CurPtr);
                C = std.$first_byte((long)Size);
                while (true) {
                    if (ClangGlobals.isIdentifierBody((byte)C)) ** break;
                    continue block2;
                    CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)Size), Result);
                    Size = this.getCharAndSize(CurPtr);
                    C = std.$first_byte((long)Size);
                }
                break;
            }
        }
        return false;
    }

    private boolean LexNumericConstant(Token Result, char.ptr CurPtr) {
        long NextSize;
        byte Next;
        long Size = this.getCharAndSize(CurPtr);
        byte C = std.$first_byte((long)Size);
        byte PrevCh = 0;
        while (ClangGlobals.isPreprocessingNumberBody((byte)C)) {
            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)Size), Result);
            PrevCh = C;
            Size = this.getCharAndSize(CurPtr);
            C = std.$first_byte((long)Size);
        }
        if (!(C != NativePointer.$MINUS && C != NativePointer.$PLUS || PrevCh != NativePointer.$E && PrevCh != NativePointer.$e || this.LangOpts.MicrosoftExt && this.isHexaLiteral(this.BufferPtr, this.LangOpts))) {
            return this.LexNumericConstant(Result, this.ConsumeChar(CurPtr, std.$second_int((long)Size), Result));
        }
        if (!(C != NativePointer.$MINUS && C != NativePointer.$PLUS || PrevCh != NativePointer.$P && PrevCh != NativePointer.$p)) {
            boolean IsHexFloat = true;
            if (!this.LangOpts.C99) {
                if (!this.isHexaLiteral(this.BufferPtr, this.LangOpts)) {
                    IsHexFloat = false;
                } else if (std.find((char.ptr)this.BufferPtr, (char.ptr)CurPtr, (byte)NativePointer.$UNDERSCORE) != CurPtr) {
                    IsHexFloat = false;
                }
            }
            if (IsHexFloat) {
                return this.LexNumericConstant(Result, this.ConsumeChar(CurPtr, std.$second_int((long)Size), Result));
            }
        }
        if (C == NativePointer.$SGL_QUOTE && this.getLangOpts().CPlusPlus14 && ClangGlobals.isIdentifierBody((byte)(Next = std.$first_byte((long)(NextSize = Lexer.getCharAndSizeNoWarn(CurPtr.$array(), CurPtr.$index() + std.$second_int((long)Size), this.getLangOpts())))))) {
            if (!this.isLexingRawMode()) {
                this.Diag(CurPtr, 843L).$destroy();
            }
            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)Size), Result);
            CurPtr = this.ConsumeChar(CurPtr, std.$second_int((long)NextSize), Result);
            return this.LexNumericConstant(Result, CurPtr);
        }
        if (C == NativePointer.$BACK_SLASH && this.tryConsumeIdentifierUCN(CurPtr, std.$second_int((long)Size), Result)) {
            return this.LexNumericConstant(Result, CurPtr);
        }
        if (!ClangGlobals.isASCII((byte)C) && this.tryConsumeIdentifierUTF8Char(CurPtr)) {
            return this.LexNumericConstant(Result, CurPtr);
        }
        if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
            return false;
        }
        if (this.$ArrayBasedOrigBufferPtr) {
            int TokStart = this.BufferPtr.$index();
            this.FormTokenWithChars(Result, CurPtr.$index(), (short)7);
            Result.setLiteralData(this.BufferPtr.$array(), TokStart);
        } else {
            char.ptr TokStart = this.getTokenStartFromBufferPtr();
            this.FormTokenWithChars(Result, CurPtr.$index(), (short)7);
            Result.setLiteralData(TokStart);
        }
        return true;
    }

    private boolean LexStringLiteral(Token Result, char.ptr CurPtr, short Kind2) {
        char.ptr NulCharacter = null;
        if (!(this.isLexingRawMode() || Kind2 != 16 && Kind2 != 17 && Kind2 != 18)) {
            this.Diag(this.BufferPtr, this.getLangOpts().CPlusPlus ? 856L : 840L).$destroy();
        }
        byte C = this.getAndAdvanceChar(CurPtr, Result);
        while (C != NativePointer.$DBL_QUOTE) {
            if (C == NativePointer.$BACK_SLASH) {
                C = this.getAndAdvanceChar(CurPtr, Result);
            }
            if (C == NativePointer.$LF || C == NativePointer.$CR || C == 0 && CurPtr.$index() - 1 == this.BufferEnd) {
                if (!this.isLexingRawMode() && !this.LangOpts.AsmPreprocessor) {
                    this.Diag(this.BufferPtr, 802L).$destroy();
                }
                this.FormTokenWithChars(Result, CurPtr.$index() - 1, Kind2);
                return true;
            }
            if (C == 0) {
                if (this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) {
                    this.PP.CodeCompleteNaturalLanguage();
                    this.FormTokenWithChars(Result, CurPtr.$index() - 1, Kind2);
                    this.cutOffLexing();
                    return true;
                }
                NulCharacter = (char.ptr)CurPtr.$sub(1);
            }
            C = this.getAndAdvanceChar(CurPtr, Result);
        }
        if (this.getLangOpts().CPlusPlus) {
            CurPtr = Native.$noClone((char.ptr)this.LexUDSuffix(Result, CurPtr, true));
        }
        if (NulCharacter != null && !this.isLexingRawMode()) {
            this.Diag(NulCharacter, 816L).$destroy();
        }
        if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
            return false;
        }
        if (this.$ArrayBasedOrigBufferPtr) {
            int TokStart = this.BufferPtr.$index();
            this.FormTokenWithChars(Result, CurPtr.$index(), Kind2);
            Result.setLiteralData(this.BufferPtr.$array(), TokStart);
        } else {
            char.ptr TokStart = this.getTokenStartFromBufferPtr();
            this.FormTokenWithChars(Result, CurPtr.$index(), Kind2);
            Result.setLiteralData(TokStart);
        }
        return true;
    }

    private boolean LexRawStringLiteral(Token Result, char.ptr CurPtr, short Kind2) {
        long PrefixLen;
        block16: {
            if (!this.isLexingRawMode()) {
                this.Diag(this.BufferPtr, 854L).$destroy();
            }
            for (PrefixLen = 0L; PrefixLen != 16L && ClangGlobals.isRawStringDelimBody((byte)CurPtr.$at(PrefixLen)); ++PrefixLen) {
            }
            if (CurPtr.$at(PrefixLen) != NativePointer.$LPAREN) {
                block15: {
                    byte C;
                    if (!this.isLexingRawMode()) {
                        char.ptr PrefixEnd = (char.ptr)CurPtr.$add(PrefixLen);
                        if (PrefixLen == 16L) {
                            this.Diag(PrefixEnd, 740L).$destroy();
                        } else {
                            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(PrefixEnd, 638L), (StringRef)new StringRef(PrefixEnd, 1)).$destroy();
                        }
                    }
                    do {
                        C = CurPtr.$star();
                        CurPtr.$preInc();
                        if (C == NativePointer.$DBL_QUOTE) break block15;
                    } while (C != 0 || CurPtr.$index() - 1 != this.BufferEnd);
                    CurPtr.$preDec();
                }
                if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
                    return false;
                }
                this.FormTokenWithChars(Result, CurPtr.$index(), (short)0);
                return true;
            }
            char.ptr Prefix = Native.$tryClone((char.ptr)CurPtr);
            CurPtr.$inc(PrefixLen + 1L);
            while (true) {
                byte C = CurPtr.$star();
                CurPtr.$preInc();
                if (C == NativePointer.$RPAREN) {
                    if (std.strncmp((char.ptr)CurPtr, (char.ptr)Prefix, (long)PrefixLen) != 0 || CurPtr.$at(PrefixLen) != NativePointer.$DBL_QUOTE) continue;
                    break block16;
                }
                if (C == 0 && CurPtr.$index() - 1 == this.BufferEnd) break;
            }
            if (!this.isLexingRawMode()) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(this.BufferPtr, 752L), (StringRef)new StringRef(Prefix, PrefixLen)).$destroy();
            }
            this.FormTokenWithChars(Result, CurPtr.$index() - 1, (short)0);
            return true;
        }
        CurPtr.$inc(PrefixLen + 1L);
        if (this.getLangOpts().CPlusPlus) {
            CurPtr = Native.$noClone((char.ptr)this.LexUDSuffix(Result, CurPtr, true));
        }
        if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
            return false;
        }
        if (this.$ArrayBasedOrigBufferPtr) {
            int TokStart = this.BufferPtr.$index();
            this.FormTokenWithChars(Result, CurPtr.$index(), Kind2);
            Result.setLiteralData(this.BufferPtr.$array(), TokStart);
        } else {
            char.ptr TokStart = this.getTokenStartFromBufferPtr();
            this.FormTokenWithChars(Result, CurPtr.$index(), Kind2);
            Result.setLiteralData(TokStart);
        }
        return true;
    }

    private boolean LexAngledStringLiteral(Token Result, char.ptr CurPtr) {
        char.ptr NulCharacter = null;
        int AfterLessPos = CurPtr.$index();
        byte C = this.getAndAdvanceChar(CurPtr, Result);
        while (C != NativePointer.$GT) {
            if (C == NativePointer.$BACK_SLASH) {
                this.getAndAdvanceChar(CurPtr, Result);
            } else {
                if (C == NativePointer.$LF || C == NativePointer.$CR || C == 0 && (CurPtr.$index() - 1 == this.BufferEnd || this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1)))) {
                    this.FormTokenWithChars(Result, AfterLessPos, (short)46);
                    return true;
                }
                if (C == 0) {
                    NulCharacter = (char.ptr)CurPtr.$sub(1);
                }
            }
            C = this.getAndAdvanceChar(CurPtr, Result);
        }
        if (NulCharacter != null && !this.isLexingRawMode()) {
            this.Diag(NulCharacter, 816L).$destroy();
        }
        if (this.$ArrayBasedOrigBufferPtr) {
            int TokStart = this.BufferPtr.$index();
            this.FormTokenWithChars(Result, CurPtr.$index(), (short)15);
            Result.setLiteralData(this.BufferPtr.$array(), TokStart);
        } else {
            char.ptr TokStart = this.getTokenStartFromBufferPtr();
            this.FormTokenWithChars(Result, CurPtr.$index(), (short)15);
            Result.setLiteralData(TokStart);
        }
        return true;
    }

    private boolean LexCharConstant(Token Result, char.ptr CurPtr, short Kind2) {
        byte C;
        char.ptr NulCharacter = null;
        if (!this.isLexingRawMode()) {
            if (Kind2 == 11 || Kind2 == 12) {
                this.Diag(this.BufferPtr, this.getLangOpts().CPlusPlus ? 856L : 840L).$destroy();
            } else if (Kind2 == 10) {
                this.Diag(this.BufferPtr, 847L).$destroy();
            }
        }
        if ((C = this.getAndAdvanceChar(CurPtr, Result)) == NativePointer.$SGL_QUOTE) {
            if (!this.isLexingRawMode() && !this.LangOpts.AsmPreprocessor) {
                this.Diag(this.BufferPtr, 763L).$destroy();
            }
            this.FormTokenWithChars(Result, CurPtr.$index(), Kind2);
            return true;
        }
        while (C != NativePointer.$SGL_QUOTE) {
            if (C == NativePointer.$BACK_SLASH) {
                C = this.getAndAdvanceChar(CurPtr, Result);
            }
            if (C == NativePointer.$LF || C == NativePointer.$CR || C == 0 && CurPtr.$index() - 1 == this.BufferEnd) {
                if (!this.isLexingRawMode() && !this.LangOpts.AsmPreprocessor) {
                    this.Diag(this.BufferPtr, 801L).$destroy();
                }
                this.FormTokenWithChars(Result, CurPtr.$index() - 1, Kind2);
                return true;
            }
            if (C == 0) {
                if (this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) {
                    this.PP.CodeCompleteNaturalLanguage();
                    this.FormTokenWithChars(Result, CurPtr.$index() - 1, Kind2);
                    this.cutOffLexing();
                    return true;
                }
                NulCharacter = (char.ptr)CurPtr.$sub(1);
            }
            C = this.getAndAdvanceChar(CurPtr, Result);
        }
        if (this.getLangOpts().CPlusPlus) {
            CurPtr = Native.$noClone((char.ptr)this.LexUDSuffix(Result, CurPtr, false));
        }
        if (NulCharacter != null && !this.isLexingRawMode()) {
            this.Diag(NulCharacter, 814L).$destroy();
        }
        if (this.ConsumedSkippedTokenBetweenDirectives(CurPtr)) {
            return false;
        }
        if (this.$ArrayBasedOrigBufferPtr) {
            int TokStart = this.BufferPtr.$index();
            this.FormTokenWithChars(Result, CurPtr.$index(), Kind2);
            Result.setLiteralData(this.BufferPtr.$array(), TokStart);
        } else {
            char.ptr TokStart = this.getTokenStartFromBufferPtr();
            this.FormTokenWithChars(Result, CurPtr.$index(), Kind2);
            Result.setLiteralData(TokStart);
        }
        return true;
    }

    private boolean LexEndOfFile(Token Result, char.ptr CurPtr) {
        if (this.ParsingPreprocessorDirective) {
            this.ParsingPreprocessorDirective = false;
            this.FormTokenWithChars(Result, CurPtr.$index(), (short)2);
            this.resetExtendedTokenMode();
            return true;
        }
        if (this.isLexingRawMode()) {
            Result.startToken();
            Native.$setIndex((char.ptr)this.BufferPtr, (int)this.BufferEnd);
            this.FormTokenWithChars(Result, this.BufferEnd, (short)1);
            return true;
        }
        while (!this.ConditionalStack.empty()) {
            if (this.PP.getCodeCompletionFileLoc().getRawEncodingUInt() != this.FileLoc) {
                this.PP.Diag(((PPConditionalInfo)this.ConditionalStack.back()).getIfLoc(), 734L).$destroy();
            }
            this.ConditionalStack.pop_back();
        }
        if (CurPtr.$noteq((Object)this.BufferStart) && CurPtr.$at(-1) != NativePointer.$LF && CurPtr.$at(-1) != NativePointer.$CR) {
            DiagnosticsEngine Diags = this.PP.getDiagnostics();
            int EndLoc = this.getSourceLocation(this.BufferEnd);
            long DiagID = this.LangOpts.CPlusPlus11 ? (!Diags.isIgnored(852L, EndLoc) ? 852L : 864L) : 775L;
            ClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(this.$BufferEnd(), DiagID), (FixItHint)FixItHint.CreateInsertion((int)EndLoc, (StringRef)new StringRef((CharSequence)"\n"))).$destroy();
        }
        Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
        return this.PP.HandleEndOfFile(Result, this.isPragmaLexer());
    }

    private int SkipWhitespace(Token Result, char.ptr CurPtr, boolean TokAtPhysicalStartOfLine) {
        boolean SawNewline = ClangGlobals.isVerticalWhitespace((byte)CurPtr.$at(-1));
        byte Char = CurPtr.$star();
        while (true) {
            if (ClangGlobals.isHorizontalWhitespace((byte)Char)) {
                Char = ((char.ptr)CurPtr.$preInc()).$star();
                continue;
            }
            if (!ClangGlobals.isVerticalWhitespace((byte)Char)) break;
            if (this.ParsingPreprocessorDirective) {
                Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
                return std.wrap_bool_bool((boolean)false, (boolean)TokAtPhysicalStartOfLine);
            }
            SawNewline = true;
            Char = ((char.ptr)CurPtr.$preInc()).$star();
        }
        if (this.isKeepWhitespaceMode()) {
            this.FormTokenWithChars(Result, CurPtr.$index(), (short)0);
            if (SawNewline) {
                this.IsAtStartOfLine = true;
                this.IsAtPhysicalStartOfLine = true;
            }
            return std.wrap_bool_bool((boolean)true, (boolean)TokAtPhysicalStartOfLine);
        }
        byte PrevChar = CurPtr.$at(-1);
        boolean HasLeadingSpace = !ClangGlobals.isVerticalWhitespace((byte)PrevChar);
        Result.setFlagValue(2, HasLeadingSpace);
        if (SawNewline) {
            Result.setFlag(1);
            TokAtPhysicalStartOfLine = true;
        }
        Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
        return std.wrap_bool_bool((boolean)false, (boolean)TokAtPhysicalStartOfLine);
    }

    private int SkipLineComment(Token Result, char.ptr CurPtr, boolean TokAtPhysicalStartOfLine) {
        byte C;
        if (!this.LangOpts.LineComment && !this.isLexingRawMode()) {
            this.Diag(this.BufferPtr, 768L).$destroy();
            this.LangOpts.LineComment = true;
        }
        do {
            C = CurPtr.$star();
            while (C != 0 && C != NativePointer.$LF && C != NativePointer.$CR) {
                C = ((char.ptr)CurPtr.$preInc()).$star();
            }
            int $NextLineIndex = CurPtr.$index();
            if (C != 0) {
                int $EscapePtrShift = -1;
                boolean HasSpace = false;
                while (ClangGlobals.isHorizontalWhitespace((byte)CurPtr.$at($EscapePtrShift))) {
                    --$EscapePtrShift;
                    HasSpace = true;
                }
                if (CurPtr.$at($EscapePtrShift) == NativePointer.$BACK_SLASH) {
                    CurPtr.$inc($EscapePtrShift);
                } else {
                    if (CurPtr.$at($EscapePtrShift) != NativePointer.$SLASH || CurPtr.$at($EscapePtrShift - 1) != NativePointer.$QMARK || CurPtr.$at($EscapePtrShift - 2) != NativePointer.$QMARK) break;
                    CurPtr.$inc($EscapePtrShift - 2);
                }
                if (HasSpace && !this.isLexingRawMode()) {
                    this.Diag((char.ptr)CurPtr.$add($EscapePtrShift), 621L).$destroy();
                }
            }
            int $OldPtrIndex = CurPtr.$index();
            boolean OldRawMode = this.isLexingRawMode();
            this.LexingRawMode = true;
            C = this.getAndAdvanceChar(CurPtr, Result);
            this.LexingRawMode = OldRawMode;
            int $OldPtrShift = $OldPtrIndex - CurPtr.$index();
            if (C != 0 && CurPtr.$index() == $OldPtrIndex + 1) {
                Native.$setIndex((char.ptr)CurPtr, (int)$NextLineIndex);
                break;
            }
            if (CurPtr.$index() != $OldPtrIndex + 1 && C != NativePointer.$SLASH && CurPtr.$at(0) != NativePointer.$SLASH) {
                while ($OldPtrIndex != CurPtr.$index()) {
                    if (CurPtr.$at($OldPtrShift) == NativePointer.$LF || CurPtr.$at($OldPtrShift) == NativePointer.$CR) {
                        if (ClangGlobals.isWhitespace((byte)C)) {
                            int $ForwardPtrShift = 0;
                            while (ClangGlobals.isWhitespace((byte)CurPtr.$at($ForwardPtrShift))) {
                                ++$ForwardPtrShift;
                            }
                            if (CurPtr.$at($ForwardPtrShift) == NativePointer.$SLASH && CurPtr.$at($ForwardPtrShift + 1) == NativePointer.$SLASH) break;
                        }
                        if (this.isLexingRawMode()) break;
                        this.Diag((char.ptr)CurPtr.$add($OldPtrShift - 1), 772L).$destroy();
                        break;
                    }
                    ++$OldPtrIndex;
                    ++$OldPtrShift;
                }
            }
            if (CurPtr.$index() == this.BufferEnd + 1) {
                CurPtr.$preDec();
                break;
            }
            if (C != NativePointer.$TERM || !this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) continue;
            this.PP.CodeCompleteNaturalLanguage();
            this.cutOffLexing();
            return std.wrap_bool_bool((boolean)false, (boolean)TokAtPhysicalStartOfLine);
        } while (C != NativePointer.$LF && C != NativePointer.$CR);
        if (this.PP != null && !this.isLexingRawMode() && this.PP.HandleComment(Result, new SourceRange(this.getSourceLocation(this.BufferPtr), this.getSourceLocation(CurPtr)))) {
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return std.wrap_bool_bool((boolean)true, (boolean)TokAtPhysicalStartOfLine);
        }
        if (this.inKeepCommentMode()) {
            return std.wrap_bool_bool((boolean)this.SaveLineComment(Result, CurPtr.$index()), (boolean)TokAtPhysicalStartOfLine);
        }
        if (this.ParsingPreprocessorDirective || CurPtr.$index() == this.BufferEnd) {
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return std.wrap_bool_bool((boolean)false, (boolean)TokAtPhysicalStartOfLine);
        }
        CurPtr.$preInc();
        Result.setFlag(1);
        TokAtPhysicalStartOfLine = true;
        Result.clearFlag(2);
        Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
        return std.wrap_bool_bool((boolean)false, (boolean)TokAtPhysicalStartOfLine);
    }

    private int SkipBlockComment(Token Result, char.ptr CurPtr, boolean TokAtPhysicalStartOfLine) {
        long CharSize = this.getCharAndSize(CurPtr);
        byte C = std.$first_byte((long)CharSize);
        CurPtr.$inc(std.$second_int((long)CharSize));
        if (C == 0 && CurPtr.$index() == this.BufferEnd + 1) {
            if (!this.isLexingRawMode()) {
                this.Diag(this.BufferPtr, 751L).$destroy();
            }
            CurPtr.$preDec();
            if (this.isKeepWhitespaceMode()) {
                this.FormTokenWithChars(Result, CurPtr.$index(), (short)0);
                return std.wrap_bool_bool((boolean)true, (boolean)TokAtPhysicalStartOfLine);
            }
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return std.wrap_bool_bool((boolean)false, (boolean)TokAtPhysicalStartOfLine);
        }
        if (C == NativePointer.$SLASH) {
            C = CurPtr.$star();
            CurPtr.$preInc();
        }
        while (true) {
            if (C != NativePointer.$SLASH && C != NativePointer.$TERM) {
                C = CurPtr.$star();
                CurPtr.$preInc();
                continue;
            }
            if (C == NativePointer.$SLASH) {
                if (CurPtr.$at(-2) == NativePointer.$STAR || (CurPtr.$at(-2) == NativePointer.$LF || CurPtr.$at(-2) == NativePointer.$CR) && LexerStatics.isEndOfBlockCommentWithEscapedNewLine((char.ptr)CurPtr.$sub(2), this)) break;
                if (CurPtr.$at(0) == NativePointer.$STAR && CurPtr.$at(1) != NativePointer.$SLASH && !this.isLexingRawMode()) {
                    this.Diag((char.ptr)CurPtr.$sub(1), 863L).$destroy();
                }
            } else {
                if (C == 0 && CurPtr.$index() == this.BufferEnd + 1) {
                    if (!this.isLexingRawMode()) {
                        this.Diag(this.BufferPtr, 751L).$destroy();
                    }
                    CurPtr.$preDec();
                    if (this.isKeepWhitespaceMode()) {
                        this.FormTokenWithChars(Result, CurPtr.$index(), (short)0);
                        return std.wrap_bool_bool((boolean)true, (boolean)TokAtPhysicalStartOfLine);
                    }
                    Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
                    return std.wrap_bool_bool((boolean)false, (boolean)TokAtPhysicalStartOfLine);
                }
                if (C == NativePointer.$TERM && this.isCodeCompletionPoint((char.ptr)CurPtr.$sub(1))) {
                    this.PP.CodeCompleteNaturalLanguage();
                    this.cutOffLexing();
                    return std.wrap_bool_bool((boolean)false, (boolean)TokAtPhysicalStartOfLine);
                }
            }
            C = CurPtr.$star();
            CurPtr.$preInc();
        }
        if (this.PP != null && !this.isLexingRawMode() && this.PP.HandleComment(Result, new SourceRange(this.getSourceLocation(this.BufferPtr), this.getSourceLocation(CurPtr)))) {
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return std.wrap_bool_bool((boolean)true, (boolean)TokAtPhysicalStartOfLine);
        }
        if (this.inKeepCommentMode()) {
            this.FormTokenWithChars(Result, CurPtr.$index(), (short)4);
            if (TokAtPhysicalStartOfLine) {
                this.HasLeadingSpace = true;
                this.IsAtPhysicalStartOfLine = true;
            }
            return std.wrap_bool_bool((boolean)true, (boolean)TokAtPhysicalStartOfLine);
        }
        if (ClangGlobals.isHorizontalWhitespace((byte)CurPtr.$star())) {
            return std.wrap_bool_bool((boolean)false, (boolean)std.$second_bool((int)this.SkipWhitespace(Result, (char.ptr)CurPtr.$add(1), TokAtPhysicalStartOfLine)));
        }
        Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
        Result.setFlag(2);
        return std.wrap_bool_bool((boolean)false, (boolean)TokAtPhysicalStartOfLine);
    }

    private boolean SaveLineComment(Token Result, int CurPtr) {
        this.FormTokenWithChars(Result, CurPtr, (short)4);
        if (!this.ParsingPreprocessorDirective || this.LexingRawMode) {
            return true;
        }
        bool.ptr Invalid = NativePointer.create_bool$ptr((boolean)false);
        std.string Spelling = this.PP.getSpelling(Result, Invalid);
        if (Invalid.$star()) {
            return true;
        }
        assert (Spelling.$at(0) == NativePointer.$SLASH && Spelling.$at(1) == NativePointer.$SLASH) : "Not line comment?";
        Spelling.$set(1, NativePointer.$STAR);
        Spelling.$addassign((CharSequence)"*/");
        Result.setKind((short)4);
        this.PP.CreateString(Spelling.$array(), 0, Spelling.size(), Result, Result.getRawLocation(), Result.getRawLocation());
        return true;
    }

    private boolean IsStartOfConflictMarker(char.ptr CurPtr) {
        ConflictMarkerKind Kind2;
        if (CurPtr.$noteq((Object)this.BufferStart) && CurPtr.$at(-1) != NativePointer.$LF && CurPtr.$at(-1) != NativePointer.$CR) {
            return false;
        }
        if ((this.BufferEnd - CurPtr.$index() < 8 || llvm.$noteq_StringRef((char.ptr)CurPtr, (int)7, (CharSequence)"<<<<<<<")) && (this.BufferEnd - CurPtr.$index() < 6 || llvm.$noteq_StringRef((char.ptr)CurPtr, (int)5, (CharSequence)">>>> "))) {
            return false;
        }
        if (this.CurrentConflictMarkerState.getValue() != 0 || this.isLexingRawMode()) {
            return false;
        }
        ConflictMarkerKind conflictMarkerKind = Kind2 = CurPtr.$star() == NativePointer.$LT ? ConflictMarkerKind.CMK_Normal : ConflictMarkerKind.CMK_Perforce;
        if (LexerStatics.FindConflictEnd(CurPtr, this.$BufferEnd(), Kind2) != null) {
            this.Diag(CurPtr, 626L).$destroy();
            this.CurrentConflictMarkerState = Kind2;
            while (CurPtr.$star() != NativePointer.$CR && CurPtr.$star() != NativePointer.$LF) {
                assert (CurPtr.$index() != this.BufferEnd) : "Didn't find end of line";
                CurPtr.$preInc();
            }
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            return true;
        }
        return false;
    }

    private boolean HandleEndOfConflictMarker(char.ptr CurPtr) {
        if (CurPtr.$noteq((Object)this.BufferStart) && CurPtr.$at(-1) != NativePointer.$LF && CurPtr.$at(-1) != NativePointer.$CR) {
            return false;
        }
        if (this.CurrentConflictMarkerState.getValue() == 0 || this.isLexingRawMode()) {
            return false;
        }
        for (long i = 1L; i != 4L; ++i) {
            if (CurPtr.$at(i) == CurPtr.$at(0)) continue;
            return false;
        }
        char.ptr End = Native.$tryClone((char.ptr)LexerStatics.FindConflictEnd(CurPtr, this.$BufferEnd(), this.CurrentConflictMarkerState));
        if (End != null) {
            CurPtr = Native.$tryClone((char.ptr)End);
            while (CurPtr.$index() != this.BufferEnd && CurPtr.$star() != NativePointer.$CR && CurPtr.$star() != NativePointer.$LF) {
                CurPtr.$preInc();
            }
            Native.$setIndex((char.ptr)this.BufferPtr, (char.ptr)CurPtr);
            this.CurrentConflictMarkerState = ConflictMarkerKind.CMK_None;
            return true;
        }
        return false;
    }

    private boolean isCodeCompletionPoint(char.ptr CurPtr) {
        if (this.PP != null && this.PP.isCodeCompletionEnabled()) {
            int Loc = SourceLocation.getRawLocWithOffset((int)this.FileLoc, (int)CurPtr.$sub((abstract_iterator)this.BufferStart));
            return Loc == this.PP.getCodeCompletionLoc().getRawEncodingUInt();
        }
        return false;
    }

    void cutOffLexing() {
        Native.$setIndex((char.ptr)this.BufferPtr, (int)this.BufferEnd);
    }

    private boolean isHexaLiteral(char.ptr Start, LangOptions LangOpts) {
        long Size = Lexer.getCharAndSizeNoWarn(Start, LangOpts);
        byte C1 = std.$first_byte((long)Size);
        if (C1 != NativePointer.$0) {
            return false;
        }
        byte C2 = std.$first_byte((long)Lexer.getCharAndSizeNoWarn(Start.$array(), Start.$index() + std.$second_int((long)Size), LangOpts));
        return C2 == NativePointer.$x || C2 == NativePointer.$X;
    }

    private long tryReadUCN(char.ptr StartPtr, char.ptr SlashLoc, Token Result) {
        long NumHexDigits;
        long CharSize = this.getCharAndSize(StartPtr);
        byte Kind2 = std.$first_byte((long)CharSize);
        if (Kind2 == NativePointer.$u) {
            NumHexDigits = 4L;
        } else if (Kind2 == NativePointer.$U) {
            NumHexDigits = 8L;
        } else {
            return 0L;
        }
        if (!this.LangOpts.CPlusPlus && !this.LangOpts.C99) {
            if (Result != null && !this.isLexingRawMode()) {
                this.Diag(SlashLoc, 897L).$destroy();
            }
            return 0L;
        }
        char.ptr CurPtr = (char.ptr)StartPtr.$add(std.$second_int((long)CharSize));
        char.ptr KindLoc = (char.ptr)CurPtr.$add(-1);
        long CodePoint = 0L;
        for (long i = 0L; i < NumHexDigits; ++i) {
            CharSize = this.getCharAndSize(CurPtr);
            byte C = std.$first_byte((long)CharSize);
            long Value = llvm.hexDigitValue((byte)C);
            if (Value == -1L) {
                if (Result != null && !this.isLexingRawMode()) {
                    if (i == 0L) {
                        ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(this.BufferPtr, 895L), (StringRef)new StringRef(KindLoc, 1)).$destroy();
                    } else {
                        this.Diag(this.BufferPtr, 894L).$destroy();
                        if (i == 4L && NumHexDigits == 8L) {
                            CharSourceRange URange = LexerStatics.makeCharRange(this, KindLoc, (char.ptr)KindLoc.$add(1));
                            ClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)this.Diag(KindLoc, 813L), (FixItHint)FixItHint.CreateReplacement((CharSourceRange)URange, (StringRef)new StringRef((CharSequence)"u"))).$destroy();
                        }
                    }
                }
                return 0L;
            }
            CodePoint <<= 4;
            CodePoint += Value;
            CurPtr.$inc(std.$second_int((long)CharSize));
        }
        if (Result != null) {
            Result.setFlag(64);
            if (CurPtr.$sub((abstract_iterator)StartPtr) == (int)NumHexDigits + 2) {
                StartPtr.$assign((Object)Native.$tryClone((char.ptr)CurPtr));
            } else {
                while (StartPtr.$noteq((Object)CurPtr)) {
                    this.getAndAdvanceChar(StartPtr, Result);
                }
            }
        } else {
            StartPtr.$assign((Object)Native.$tryClone((char.ptr)CurPtr));
        }
        if (this.LangOpts.AsmPreprocessor) {
            return CodePoint;
        }
        if (CodePoint < 160L) {
            if (CodePoint == 36L || CodePoint == 64L || CodePoint == 96L) {
                return CodePoint;
            }
            if (Result != null && this.PP != null) {
                if (CodePoint < 32L || CodePoint >= 127L) {
                    this.Diag(this.BufferPtr, 744L).$destroy();
                } else {
                    byte C = (byte)CodePoint;
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(this.BufferPtr, 745L), (StringRef)new StringRef(NativePointer.new$char$elem((byte)C), 1)).$destroy();
                }
            }
            return 0L;
        }
        if (CodePoint >= 55296L && CodePoint <= 57343L) {
            if (Result != null && this.PP != null) {
                if (this.LangOpts.CPlusPlus && !this.LangOpts.CPlusPlus11) {
                    this.Diag(this.BufferPtr, 896L).$destroy();
                } else {
                    this.Diag(this.BufferPtr, 747L).$destroy();
                }
            }
            return 0L;
        }
        return CodePoint;
    }

    private boolean tryConsumeIdentifierUCN(char.ptr CurPtr, int Size, Token Result) {
        char.ptr UCNPtr = Native.$tryClone((char.ptr)((char.ptr)CurPtr.$add(Size)));
        long CodePoint = this.tryReadUCN(UCNPtr, CurPtr, null);
        if (CodePoint == 0L || !LexerStatics.isAllowedIDChar(CodePoint, this.LangOpts)) {
            return false;
        }
        if (!this.isLexingRawMode()) {
            LexerStatics.maybeDiagnoseIDCharCompat(this.PP.getDiagnostics(), CodePoint, LexerStatics.makeCharRange(this, CurPtr, UCNPtr), false);
        }
        Result.setFlag(64);
        if (UCNPtr.$sub((abstract_iterator)CurPtr) == 6 && CurPtr.$at(1) == NativePointer.$u || UCNPtr.$sub((abstract_iterator)CurPtr) == 10 && CurPtr.$at(1) == NativePointer.$U) {
            CurPtr.$assign((Object)UCNPtr);
        } else {
            while (CurPtr.$noteq((Object)UCNPtr)) {
                this.getAndAdvanceChar(CurPtr, Result);
            }
        }
        return true;
    }

    private boolean tryConsumeIdentifierUTF8Char(char.ptr CurPtr) {
        char.ptr UnicodePtr = Native.$tryClone((char.ptr)CurPtr);
        long[] CodePoint = NativePointer.new$long$elem((long)0L);
        ConvertUTFGlobals.ConversionResult Result = llvm.convertUTF8Sequence((type.ptr)UnicodePtr.$addr(), (char.ptr)this.$BufferEnd(), (long[])CodePoint, (ConvertUTFGlobals.ConversionFlags)ConvertUTFGlobals.ConversionFlags.strictConversion);
        if (Result != ConvertUTFGlobals.ConversionResult.conversionOK || !LexerStatics.isAllowedIDChar(CodePoint[0], this.LangOpts)) {
            return false;
        }
        if (!this.isLexingRawMode()) {
            LexerStatics.maybeDiagnoseIDCharCompat(this.PP.getDiagnostics(), CodePoint[0], LexerStatics.makeCharRange(this, CurPtr, UnicodePtr), false);
        }
        CurPtr.$assign((Object)Native.$tryClone((char.ptr)UnicodePtr));
        return true;
    }

    @Override
    public void $destroy() {
        super.$destroy();
        if (this.BufferStart != null) {
            NativePointer.clear_char$ptr((char.ptr)this.$LexTokenInternalCurPtr);
            NativePointer.clear_char$ptr((char.ptr)this.BufferPtr);
            this.$OrigBufferPtr = null;
            this.$ArrayBasedOrigBufferPtr = false;
            this.BufferStart = null;
        }
    }

    private char.ptr getTokenStartFromBufferPtr() {
        assert (this.$OrigBufferPtr.isComparableTo((void.ptr)this.BufferPtr)) : "BufferPtr was replaced by another buffer? " + this.BufferPtr + " vs. " + this.$OrigBufferPtr;
        if (this.$OrigBufferPtr.$index() == this.BufferPtr.$index()) {
            return this.$OrigBufferPtr;
        }
        return Native.$tryClone((char.ptr)this.BufferPtr);
    }

    private static void trackConsumeChar() {
        if (NativeTrace.STATISTICS) {
            ++ConsumeCharCalls;
        }
    }

    private static void trackInit() {
        if (NativeTrace.STATISTICS) {
            ++InitCalls;
        }
    }

    private static void trackInstance() {
        if (NativeTrace.STATISTICS) {
            ++instances;
        }
    }

    private static void trackPrepare() {
        if (NativeTrace.STATISTICS) {
            ++prepareCalls;
        }
    }

    public static void clearStatistics() {
        ConsumeCharCalls = 0L;
        InitCalls = 0L;
        prepareCalls = 0L;
        instances = 0L;
    }

    public static void PrintStats(raw_ostream out) {
        out.$out((CharSequence)String.format("%22s created:\t", Lexer.class.getSimpleName())).$out((CharSequence)NativeTrace.formatNumber((long)instances)).$out((CharSequence)".\n");
        out.$out((CharSequence)String.format("%22s called:\t", "Lexer.$Prepare")).$out((CharSequence)NativeTrace.formatNumber((long)prepareCalls)).$out((CharSequence)".\n");
        out.$out((CharSequence)String.format("%22s called:\t", "Lexer.InitLexer")).$out((CharSequence)NativeTrace.formatNumber((long)InitCalls)).$out((CharSequence)".\n");
        out.$out((CharSequence)String.format("%22s called:\t", "ConsumeChar")).$out((CharSequence)NativeTrace.formatNumber((long)ConsumeCharCalls)).$out((CharSequence)".\n");
    }

    private Token $getIsNextPPTokenLParenToken() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$IsNextPPTokenLParenHelperInUse) break block3;
                this.$IsNextPPTokenLParenHelperInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$IsNextPPTokenLParenHelper;
    }

    private void $releaseIsNextPPTokenLParenToken(Token tok2) {
        assert (this.$IsNextPPTokenLParenHelperInUse);
        if (!$assertionsDisabled) {
            this.$IsNextPPTokenLParenHelperInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (tok2 == this.$IsNextPPTokenLParenHelper);
        tok2.$destroy();
    }
}

