/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.lex.impl.ScratchBufferStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.MemoryBuffer;

public class ScratchBuffer
implements Destructors.ClassWithDestructor {
    private SourceManager SourceMgr;
    final BumpPtrAllocator Allocator = new BumpPtrAllocator();
    private char.ptr CurBuffer;
    private int BufferStartLoc;
    private int BytesUsed;
    private static final StringRef STRING_REF_SCRATCH_SPACE = new StringRef((CharSequence)"<scratch space>");

    public ScratchBuffer(SourceManager SM) {
        this.SourceMgr = SM;
        this.CurBuffer = null;
        this.BufferStartLoc = SourceLocation.getInvalid();
        this.BytesUsed = ScratchBufferStatics.ScratchBufSize;
    }

    public int getToken(char.ptr Buf, int Len, char.ptr DestPtr) {
        assert (DestPtr.$isNull()) : "" + DestPtr;
        if (this.BytesUsed + Len + 2 > ScratchBufferStatics.ScratchBufSize) {
            this.AllocScratchBuffer(Len + 2);
        }
        this.CurBuffer.$set(this.BytesUsed++, NativePointer.$((char)'\n'));
        DestPtr.$assign((Object)this.CurBuffer);
        DestPtr.$inc(this.BytesUsed);
        std.memcpy((byte[])DestPtr.$array(), (int)DestPtr.$index(), (char.ptr)Buf, (int)0, (int)Len);
        this.BytesUsed += Len + 1;
        this.CurBuffer.$set(this.BytesUsed - 1, NativePointer.$((char)'\u0000'));
        return SourceLocation.getRawLocWithOffset((int)this.BufferStartLoc, (int)(this.BytesUsed - Len - 1));
    }

    public int getToken(byte[] Buf, int idx, int Len, char.ptr DestPtr) {
        if (this.BytesUsed + Len + 2 > ScratchBufferStatics.ScratchBufSize) {
            this.AllocScratchBuffer(Len + 2);
        }
        this.CurBuffer.$set(this.BytesUsed++, NativePointer.$((char)'\n'));
        assert (DestPtr != null && this.CurBuffer.getClass().isAssignableFrom(DestPtr.getClass())) : "non assignable " + this.CurBuffer + " for " + DestPtr;
        DestPtr.$assign((Object)this.CurBuffer);
        DestPtr.$inc(this.BytesUsed);
        std.memcpy((byte[])DestPtr.$array(), (int)DestPtr.$index(), (byte[])Buf, (int)idx, (int)Len);
        this.BytesUsed += Len + 1;
        this.CurBuffer.$set(this.BytesUsed - 1, NativePointer.$((char)'\u0000'));
        return SourceLocation.getRawLocWithOffset((int)this.BufferStartLoc, (int)(this.BytesUsed - Len - 1));
    }

    public void $destroy() {
        this.Allocator.$destroy();
    }

    private void AllocScratchBuffer(int RequestLen) {
        std_ptr.unique_ptr OwnBuf = null;
        if (RequestLen < ScratchBufferStatics.ScratchBufSize) {
            RequestLen = ScratchBufferStatics.ScratchBufSize;
        }
        OwnBuf = MemoryBuffer.getNewMemBuffer((NativeMemory.Allocator)this.Allocator, (int)RequestLen, (StringRef)STRING_REF_SCRATCH_SPACE);
        MemoryBuffer Buf = (MemoryBuffer)OwnBuf.$star();
        int FID = this.SourceMgr.createFileID(OwnBuf);
        this.BufferStartLoc = this.SourceMgr.getLocForStartOfFile(FID);
        this.CurBuffer = Native.$tryClone((char.ptr)Buf.getBufferStart());
        this.BytesUsed = 1;
        this.CurBuffer.$set(0, NativePointer.$((char)'0'));
    }
}

