/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.lex.SmallVectorToken;
import org.clang.lex.TokenLexer;
import org.clank.support.NativePointer;

final class SmallVectorMacroExpandingLexersStack {
    private static final TokenLexer[] EMPTY_LEXERS = new TokenLexer[0];
    private static final int[] EMPTY_INDICES = NativePointer.new$int((int)0);
    private static final SmallVectorToken[] EMPTY_TOKENS = new SmallVectorToken[0];
    private TokenLexer[] array;
    private int[] indices;
    private SmallVectorToken[] tokens;
    private int end;

    public SmallVectorMacroExpandingLexersStack(int capacity) {
        this.array = capacity == 0 ? EMPTY_LEXERS : new TokenLexer[capacity];
        this.indices = capacity == 0 ? EMPTY_INDICES : NativePointer.new$int((int)capacity);
        this.tokens = capacity == 0 ? EMPTY_TOKENS : new SmallVectorToken[capacity];
        this.end = 0;
    }

    public final TokenLexer first$at(int idx) {
        assert (this.array[idx] != null);
        return this.array[idx];
    }

    public final int second$at(int idx) {
        return this.indices[idx];
    }

    public final SmallVectorToken tokens$at(int idx) {
        return this.tokens[idx];
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
        this.destroy_range(0, this.size());
        this.end = 0;
    }

    public final void push_back(TokenLexer val, SmallVectorToken tokens, int index) {
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.array[this.end] = val;
        this.tokens[this.end] = tokens;
        this.indices[this.end] = index;
        ++this.end;
    }

    public final TokenLexer back$first() {
        return this.array[this.end - 1];
    }

    public final int back$second() {
        return this.indices[this.end - 1];
    }

    public final SmallVectorToken back$tokens() {
        return this.tokens[this.end - 1];
    }

    public final void pop_back() {
        this.array[--this.end] = null;
        this.tokens[this.end] = null;
    }

    public final int size() {
        return this.end;
    }

    public final int capacity() {
        assert (this.array.length == this.indices.length);
        assert (this.array.length == this.tokens.length);
        return this.array.length;
    }

    private void destroy_range(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.array[i] = null;
            this.tokens[i] = null;
        }
    }

    private void grow(int newSize) {
        Object[] oldArray = this.array;
        this.array = new TokenLexer[newSize];
        NativePointer.copy$Object((Object[])oldArray, (int)0, (Object[])this.array, (int)0, (int)oldArray.length);
        Object[] oldTokens = this.tokens;
        this.tokens = new SmallVectorToken[newSize];
        NativePointer.copy$Object((Object[])oldTokens, (int)0, (Object[])this.tokens, (int)0, (int)oldTokens.length);
        this.indices = NativePointer.copyOf$int((int[])this.indices, (int)newSize);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorTokenLexer{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            TokenLexer element = this.array[i];
            int idx = this.indices[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(idx).append("=").append(element).append('\n');
        }
        out.append("}SmallVectorTokenLexer}\n");
        return out.toString();
    }
}

