/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.SourceRange;
import org.clang.lex.Token;
import org.clang.lex.impl.PPExpressionsStatics;
import org.clang.lex.impl.PPValue;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.llvm.adt.APSInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.aliases.SmallVector;

public final class EvaluateValueHelper {
    private final int $BitWidth;
    private final SmallVector<PPValue> $PPValues = new SmallVector(8, null);
    private final SmallVector<APSInt> $APSInts8 = new SmallVector(8, null);
    private final SmallVector<APSInt> $APSInts16 = new SmallVector(8, null);
    private final SmallVector<APSInt> $APSInts32 = new SmallVector(8, null);
    private final SmallVector<APSInt> $APSInts64 = new SmallVector(8, null);
    private final SmallVector<PPExpressionsStatics.DefinedTracker> $DefinedTrackers = new SmallVector(8, null);
    private final Token $MacroToken = new Token();
    private boolean $MacroTokenInUse = false;
    private final bool.ptr $InvalidFlag = NativePointer.create_bool$ptr();
    private boolean $InvalidFlagInUse = false;
    private final SourceRange $CallbackSourceRange = new SourceRange();
    private final SmallString $SpellingBuffer = new SmallString(128);
    private boolean $SpellingBufferInUse = false;
    private final SmallVector<bool.ref> $BoolRefs = new SmallVector(8, null);

    public static EvaluateValueHelper $create(int BitWidth) {
        return new EvaluateValueHelper(BitWidth);
    }

    private EvaluateValueHelper(int BitWidth) {
        this.$BitWidth = BitWidth;
    }

    public PPValue $getPPValue(int BitWidth) {
        PPValue out = this.$PPValues.empty() ? new PPValue(BitWidth) : (PPValue)this.$PPValues.pop_back_val();
        assert (out.Val.getBitWidth() == this.$BitWidth);
        return out;
    }

    public void $destroy(PPValue val) {
        val.$destroy();
        this.$PPValues.push_back((Object)val);
    }

    APSInt $getAPSInt(int BitWidth) {
        APSInt out;
        SmallVector<APSInt> $APSInts = this.getAPSIntContainer(BitWidth);
        if ($APSInts == null || $APSInts.empty()) {
            out = new APSInt(BitWidth);
        } else {
            out = (APSInt)$APSInts.pop_back_val();
            assert (out.getBitWidth() == BitWidth) : out.getBitWidth() + " vs. " + BitWidth;
        }
        return out;
    }

    void $destroy(APSInt val) {
        SmallVector<APSInt> $APSInts = this.getAPSIntContainer(val.getBitWidth());
        if ($APSInts != null) {
            $APSInts.push_back((Object)val);
        }
        val.$destroy();
    }

    private SmallVector<APSInt> getAPSIntContainer(int BitWidth) {
        switch (BitWidth) {
            case 8: {
                return this.$APSInts8;
            }
            case 16: {
                return this.$APSInts16;
            }
            case 32: {
                return this.$APSInts32;
            }
            case 64: {
                return this.$APSInts64;
            }
        }
        return null;
    }

    public PPExpressionsStatics.DefinedTracker $getDefinedTracker() {
        PPExpressionsStatics.DefinedTracker out = this.$DefinedTrackers.empty() ? new PPExpressionsStatics.DefinedTracker() : (PPExpressionsStatics.DefinedTracker)this.$DefinedTrackers.pop_back_val();
        return out;
    }

    public void $release(PPExpressionsStatics.DefinedTracker DT) {
        DT.TheMacro = null;
        this.$DefinedTrackers.push_back((Object)DT);
    }

    Token $getMacroToken(Token tok2) {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$MacroTokenInUse) break block3;
                this.$MacroTokenInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$MacroToken.$assign(tok2);
    }

    void $releaseMacroToken(Token tok2) {
        assert (this.$MacroTokenInUse);
        if (!$assertionsDisabled) {
            this.$MacroTokenInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (tok2 == this.$MacroToken);
        tok2.$destroy();
    }

    bool.ptr $getInvalidFlag(boolean val) {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$InvalidFlagInUse) break block3;
                this.$InvalidFlagInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        this.$InvalidFlag.$set(val);
        return this.$InvalidFlag;
    }

    void $releaseInvalidFlag(bool.ptr flag) {
        assert (this.$InvalidFlagInUse);
        if (!$assertionsDisabled) {
            this.$InvalidFlagInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (flag == this.$InvalidFlag);
    }

    SourceRange $getCallbackSourceRange(int B, int E) {
        return this.$CallbackSourceRange.$assign(B, E);
    }

    SmallString $getSpellingBuffer() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$SpellingBufferInUse) break block3;
                this.$SpellingBufferInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$SpellingBuffer;
    }

    void $releaseSpellingBuffer(SmallString buf) {
        assert (this.$SpellingBufferInUse);
        if (!$assertionsDisabled) {
            this.$SpellingBufferInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (buf == this.$SpellingBuffer);
        this.$SpellingBuffer.clear();
    }

    bool.ref $getOverflowRef(boolean b) {
        bool.ref out = this.$BoolRefs.empty() ? NativePointer.create_bool$ref() : (bool.ref)this.$BoolRefs.pop_back_val();
        out.$set(b);
        return out;
    }

    void $releaseOverflowRef(bool.ref Overflow) {
        this.$BoolRefs.push_back((Object)Overflow);
    }
}

