/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.FileEntry;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.LangOptions;
import org.clang.basic.SanitizerKind;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceRange;
import org.clang.basic.diag;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.MacroInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.SmallVectorToken;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.llvm;
import org.llvm.support.raw_svector_ostream;

public final class PPMacroExpansionStatics {
    private static CharSequence[] Months = new CharSequence[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static IdentifierInfo RegisterBuiltinMacro(Preprocessor PP, CharSequence Name) {
        IdentifierInfo Id = PP.getIdentifierInfo(new StringRef(Name));
        MacroInfo MI = PP.AllocateMacroInfo(SourceLocation.getInvalid());
        MI.setIsBuiltinMacro();
        PP.appendDefMacroDirective(Id, MI);
        return Id;
    }

    public static boolean isTrivialSingleTokenExpansion(MacroInfo MI, IdentifierInfo MacroIdent, Preprocessor PP) {
        IdentifierInfo II = MI.getReplacementToken(0).getIdentifierInfo();
        if (II == null) {
            return true;
        }
        if (II.isOutOfDate()) {
            PP.getExternalSource().updateOutOfDateIdentifier(II);
        }
        if (II.hasMacroDefinition() && PP.getMacroInfo(II).isEnabled() && II != MacroIdent) {
            return false;
        }
        if (MI.isObjectLike()) {
            return true;
        }
        IdentifierInfo[] ArgumentList = MI.$ArgumentList();
        int E = MI.getNumArgs();
        for (int I = 0; I != E; ++I) {
            if (ArgumentList[I] != II) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean CheckMatchedBrackets(SmallVectorToken Tokens) {
        SmallVector Brackets = null;
        try {
            Brackets = new SmallVector(8, (Object)Bracket.Brace);
            SmallVectorToken.iterator I = Tokens.begin();
            SmallVectorToken.iterator E = Tokens.end();
            while (I.$noteq(E)) {
                if (I.$star().is((short)21)) {
                    Brackets.push_back((Object)Bracket.Paren);
                } else if (I.$star().is((short)22)) {
                    if (Brackets.empty() || Brackets.back() == Bracket.Brace) {
                        boolean bl = false;
                        return bl;
                    }
                    Brackets.pop_back();
                } else if (I.$star().is((short)23)) {
                    Brackets.push_back((Object)Bracket.Brace);
                } else if (I.$star().is((short)24)) {
                    if (Brackets.empty() || Brackets.back() == Bracket.Paren) {
                        boolean bl = false;
                        return bl;
                    }
                    Brackets.pop_back();
                }
                I.$preInc();
            }
            if (!Brackets.empty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (Brackets != null) {
                Brackets.$destroy();
            }
        }
    }

    public static boolean GenerateNewArgTokens(Preprocessor PP, SmallVectorToken OldTokens, SmallVectorToken NewTokens, int.ref NumArgs, SmallVectorImpl<SourceRange> ParenHints, SmallVectorImpl<SourceRange> InitLists) {
        if (!PPMacroExpansionStatics.CheckMatchedBrackets(OldTokens)) {
            return false;
        }
        long Braces = 0L;
        SmallVectorToken.iterator ArgStartIterator = OldTokens.begin();
        SmallVectorToken.iterator ClosingBrace = OldTokens.end();
        NumArgs.$set(0);
        Token TempToken = new Token();
        boolean FoundSeparatorToken = false;
        SmallVectorToken.iterator I = OldTokens.begin();
        SmallVectorToken.iterator E = OldTokens.end();
        while (I.$noteq(E)) {
            if (I.$star().is((short)23)) {
                ++Braces;
            } else if (I.$star().is((short)24)) {
                if (--Braces == 0L && ClosingBrace == E && FoundSeparatorToken) {
                    ClosingBrace = I.clone();
                }
            } else if (I.$star().is((short)1)) {
                if (Braces != 0L) {
                    FoundSeparatorToken = true;
                    I.$star().setKind((short)64);
                    I.$star().setLength(1L);
                } else {
                    NumArgs.$set(NumArgs.$deref() + 1);
                    if (FoundSeparatorToken && ArgStartIterator.$star().is((short)23)) {
                        InitLists.push_back((Object)new SourceRange(ArgStartIterator.$star().getRawLocation(), PP.getLocForEndOfToken(ClosingBrace.$star().getRawLocation())));
                        ClosingBrace = E.clone();
                    }
                    if (FoundSeparatorToken) {
                        TempToken.startToken();
                        TempToken.setKind((short)21);
                        TempToken.setLocation(ArgStartIterator.$star().getRawLocation());
                        TempToken.setLength(0L);
                        NewTokens.push_back(TempToken);
                    }
                    NewTokens.insert(NewTokens.end(), (type.iterator<?, Token>)ArgStartIterator.toPointer(), (type.iterator<?, Token>)I.toPointer());
                    if (FoundSeparatorToken) {
                        int Loc = PP.getLocForEndOfToken(I.$sub(1).$star().getRawLocation());
                        TempToken.startToken();
                        TempToken.setKind((short)22);
                        TempToken.setLocation(Loc);
                        TempToken.setLength(0L);
                        NewTokens.push_back(TempToken);
                        ParenHints.push_back((Object)new SourceRange(ArgStartIterator.$star().getRawLocation(), Loc));
                    }
                    NewTokens.push_back(I.$star());
                    ArgStartIterator = I.$add(1);
                    FoundSeparatorToken = false;
                }
            }
            I.$preInc();
        }
        return !ParenHints.empty() && InitLists.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ComputeDATE_TIME(SourceLocation DATELoc, SourceLocation TIMELoc, Preprocessor PP) {
        Token TmpTok;
        SmallString TmpBuffer;
        long TT = std.time(null);
        std.tm TM = std.localtime((long)TT);
        raw_svector_ostream TmpStream = null;
        try {
            TmpBuffer = new SmallString(32);
            TmpStream = new raw_svector_ostream(TmpBuffer);
            TmpStream.$out((CharSequence)String.format("\"%s %2d %4d\"", Months[TM.tm_mon], TM.tm_mday, TM.tm_year + 1900));
            TmpTok = new Token();
            TmpTok.startToken();
            PP.CreateString(TmpStream.str(), TmpTok);
            DATELoc.$assign(TmpTok.getRawLocation());
        }
        finally {
            if (TmpStream != null) {
                TmpStream.$destroy();
            }
        }
        TmpStream = null;
        try {
            TmpBuffer = new SmallString(32);
            TmpStream = new raw_svector_ostream(TmpBuffer);
            TmpStream.$out((CharSequence)String.format("\"%02d:%02d:%02d\"", TM.tm_hour, TM.tm_min, TM.tm_sec));
            TmpTok = new Token();
            TmpTok.startToken();
            PP.CreateString(TmpStream.str(), TmpTok);
            TIMELoc.$assign(TmpTok.getRawLocation());
        }
        finally {
            if (TmpStream != null) {
                TmpStream.$destroy();
            }
        }
    }

    public static boolean HasFeature(Preprocessor PP, IdentifierInfo II) {
        LangOptions LangOpts = PP.getLangOpts();
        StringRef Feature2 = II.getName();
        if (Feature2.startswith((CharSequence)"__") && Feature2.endswith((CharSequence)"__") && Feature2.size() >= 4) {
            Feature2.$assignMove(Feature2.substr(2, Feature2.size() - 4));
        }
        return (Boolean)new StringSwitch(Feature2).Case(NativePointer.$((String)"address_sanitizer"), (Object)LangOpts.Sanitize.has(SanitizerKind.Address)).Case(NativePointer.$((String)"attribute_analyzer_noreturn"), (Object)true).Case(NativePointer.$((String)"attribute_availability"), (Object)true).Case(NativePointer.$((String)"attribute_availability_with_message"), (Object)true).Case(NativePointer.$((String)"attribute_cf_returns_not_retained"), (Object)true).Case(NativePointer.$((String)"attribute_cf_returns_retained"), (Object)true).Case(NativePointer.$((String)"attribute_deprecated_with_message"), (Object)true).Case(NativePointer.$((String)"attribute_ext_vector_type"), (Object)true).Case(NativePointer.$((String)"attribute_ns_returns_not_retained"), (Object)true).Case(NativePointer.$((String)"attribute_ns_returns_retained"), (Object)true).Case(NativePointer.$((String)"attribute_ns_consumes_self"), (Object)true).Case(NativePointer.$((String)"attribute_ns_consumed"), (Object)true).Case(NativePointer.$((String)"attribute_cf_consumed"), (Object)true).Case(NativePointer.$((String)"attribute_objc_ivar_unused"), (Object)true).Case(NativePointer.$((String)"attribute_objc_method_family"), (Object)true).Case(NativePointer.$((String)"attribute_overloadable"), (Object)true).Case(NativePointer.$((String)"attribute_unavailable_with_message"), (Object)true).Case(NativePointer.$((String)"attribute_unused_on_fields"), (Object)true).Case(NativePointer.$((String)"blocks"), (Object)LangOpts.Blocks).Case(NativePointer.$((String)"c_thread_safety_attributes"), (Object)true).Case(NativePointer.$((String)"cxx_exceptions"), (Object)LangOpts.CXXExceptions).Case(NativePointer.$((String)"cxx_rtti"), (Object)LangOpts.RTTI).Case(NativePointer.$((String)"enumerator_attributes"), (Object)true).Case(NativePointer.$((String)"memory_sanitizer"), (Object)LangOpts.Sanitize.has(SanitizerKind.Memory)).Case(NativePointer.$((String)"thread_sanitizer"), (Object)LangOpts.Sanitize.has(SanitizerKind.Thread)).Case(NativePointer.$((String)"dataflow_sanitizer"), (Object)LangOpts.Sanitize.has(SanitizerKind.DataFlow)).Case(NativePointer.$((String)"objc_arr"), (Object)LangOpts.ObjCAutoRefCount).Case(NativePointer.$((String)"objc_arc"), (Object)LangOpts.ObjCAutoRefCount).Case(NativePointer.$((String)"objc_arc_weak"), (Object)LangOpts.ObjCARCWeak).Case(NativePointer.$((String)"objc_default_synthesize_properties"), (Object)LangOpts.ObjC2).Case(NativePointer.$((String)"objc_fixed_enum"), (Object)LangOpts.ObjC2).Case(NativePointer.$((String)"objc_instancetype"), (Object)LangOpts.ObjC2).Case(NativePointer.$((String)"objc_modules"), (Object)(LangOpts.ObjC2 && LangOpts.Modules ? 1 : 0)).Case(NativePointer.$((String)"objc_nonfragile_abi"), (Object)LangOpts.ObjCRuntime.isNonFragile()).Case(NativePointer.$((String)"objc_property_explicit_atomic"), (Object)true).Case(NativePointer.$((String)"objc_protocol_qualifier_mangling"), (Object)true).Case(NativePointer.$((String)"objc_weak_class"), (Object)LangOpts.ObjCRuntime.hasWeakClassImport()).Case(NativePointer.$((String)"ownership_holds"), (Object)true).Case(NativePointer.$((String)"ownership_returns"), (Object)true).Case(NativePointer.$((String)"ownership_takes"), (Object)true).Case(NativePointer.$((String)"objc_bool"), (Object)true).Case(NativePointer.$((String)"objc_subscripting"), (Object)LangOpts.ObjCRuntime.isNonFragile()).Case(NativePointer.$((String)"objc_array_literals"), (Object)LangOpts.ObjC2).Case(NativePointer.$((String)"objc_dictionary_literals"), (Object)LangOpts.ObjC2).Case(NativePointer.$((String)"objc_boxed_expressions"), (Object)LangOpts.ObjC2).Case(NativePointer.$((String)"arc_cf_code_audited"), (Object)true).Case(NativePointer.$((String)"objc_bridge_id"), (Object)LangOpts.ObjC2).Case(NativePointer.$((String)"c_alignas"), (Object)LangOpts.C11).Case(NativePointer.$((String)"c_alignof"), (Object)LangOpts.C11).Case(NativePointer.$((String)"c_atomic"), (Object)LangOpts.C11).Case(NativePointer.$((String)"c_generic_selections"), (Object)LangOpts.C11).Case(NativePointer.$((String)"c_static_assert"), (Object)LangOpts.C11).Case(NativePointer.$((String)"c_thread_local"), (Object)(LangOpts.C11 && PP.getTargetInfo().isTLSSupported() ? 1 : 0)).Case(NativePointer.$((String)"cxx_access_control_sfinae"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_alias_templates"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_alignas"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_alignof"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_atomic"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_attributes"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_auto_type"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_constexpr"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_decltype"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_decltype_incomplete_return_types"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_default_function_template_args"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_defaulted_functions"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_delegating_constructors"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_deleted_functions"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_explicit_conversions"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_generalized_initializers"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_implicit_moves"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_inheriting_constructors"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_inline_namespaces"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_lambdas"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_local_type_template_args"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_nonstatic_member_init"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_noexcept"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_nullptr"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_override_control"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_range_for"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_raw_string_literals"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_reference_qualified_functions"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_rvalue_references"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_strong_enums"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_static_assert"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_thread_local"), (Object)(LangOpts.CPlusPlus11 && PP.getTargetInfo().isTLSSupported() ? 1 : 0)).Case(NativePointer.$((String)"cxx_trailing_return"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_unicode_literals"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_unrestricted_unions"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_user_literals"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_variadic_templates"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_aggregate_nsdmi"), (Object)LangOpts.CPlusPlus14).Case(NativePointer.$((String)"cxx_binary_literals"), (Object)LangOpts.CPlusPlus14).Case(NativePointer.$((String)"cxx_contextual_conversions"), (Object)LangOpts.CPlusPlus14).Case(NativePointer.$((String)"cxx_decltype_auto"), (Object)LangOpts.CPlusPlus14).Case(NativePointer.$((String)"cxx_generic_lambdas"), (Object)LangOpts.CPlusPlus14).Case(NativePointer.$((String)"cxx_init_captures"), (Object)LangOpts.CPlusPlus14).Case(NativePointer.$((String)"cxx_relaxed_constexpr"), (Object)LangOpts.CPlusPlus14).Case(NativePointer.$((String)"cxx_return_type_deduction"), (Object)LangOpts.CPlusPlus14).Case(NativePointer.$((String)"cxx_variable_templates"), (Object)LangOpts.CPlusPlus14).Case(NativePointer.$((String)"has_nothrow_assign"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"has_nothrow_copy"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"has_nothrow_constructor"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"has_trivial_assign"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"has_trivial_copy"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"has_trivial_constructor"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"has_trivial_destructor"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"has_virtual_destructor"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_abstract"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_base_of"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_class"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_constructible"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_convertible_to"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_empty"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_enum"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_final"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_literal"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_standard_layout"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_pod"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_polymorphic"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_sealed"), (Object)LangOpts.MicrosoftExt).Case(NativePointer.$((String)"is_trivial"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_trivially_assignable"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_trivially_constructible"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_trivially_copyable"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"is_union"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"modules"), (Object)LangOpts.Modules).Case(NativePointer.$((String)"tls"), (Object)PP.getTargetInfo().isTLSSupported()).Case(NativePointer.$((String)"underlying_type"), (Object)LangOpts.CPlusPlus).Default((Object)false);
    }

    public static boolean HasExtension(Preprocessor PP, IdentifierInfo II) {
        if (PPMacroExpansionStatics.HasFeature(PP, II)) {
            return true;
        }
        if (PP.getDiagnostics().getExtensionHandlingBehavior().getValue() >= diag.Severity.Error.getValue()) {
            return false;
        }
        LangOptions LangOpts = PP.getLangOpts();
        StringRef Extension = II.getName();
        if (Extension.startswith((CharSequence)"__") && Extension.endswith((CharSequence)"__") && Extension.size() >= 4) {
            Extension.$assignMove(Extension.substr(2, Extension.size() - 4));
        }
        return (Boolean)new StringSwitch(Extension).Case(NativePointer.$((String)"c_alignas"), (Object)true).Case(NativePointer.$((String)"c_alignof"), (Object)true).Case(NativePointer.$((String)"c_atomic"), (Object)true).Case(NativePointer.$((String)"c_generic_selections"), (Object)true).Case(NativePointer.$((String)"c_static_assert"), (Object)true).Case(NativePointer.$((String)"c_thread_local"), (Object)PP.getTargetInfo().isTLSSupported()).Case(NativePointer.$((String)"cxx_atomic"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_deleted_functions"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_explicit_conversions"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_inline_namespaces"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_local_type_template_args"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_nonstatic_member_init"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_override_control"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_range_for"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_reference_qualified_functions"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_rvalue_references"), (Object)LangOpts.CPlusPlus).Case(NativePointer.$((String)"cxx_binary_literals"), (Object)true).Case(NativePointer.$((String)"cxx_init_captures"), (Object)LangOpts.CPlusPlus11).Case(NativePointer.$((String)"cxx_variable_templates"), (Object)LangOpts.CPlusPlus).Default((Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean EvaluateHasIncludeCommon(Token Tok, IdentifierInfo II, Preprocessor PP, type.ptr<DirectoryLookup> LookupFrom, FileEntry LookupFromFile) {
        SmallString FilenameBuffer = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            SourceLocation LParenLoc = Tok.getLocation();
            if (!PP.isParsingIfOrElifDirective()) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)PP.Diag(LParenLoc, 689L))), (StringRef)II.getName()));
                boolean bl = false;
                return bl;
            }
            PP.LexNonComment(Tok);
            if (Tok.isNot((short)21)) {
                LParenLoc.$assignMove(PP.getLocForEndOfToken(LParenLoc));
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_TokenKind((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_IdentifierInfo((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)PP.Diag(LParenLoc, 697L))), (IdentifierInfo)II), (short)21));
                if (!(Tok.is((short)15) || Tok.is((short)13) || Tok.is((short)46))) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                LParenLoc.$assignMove(Tok.getLocation());
                if (PP.getCurrentLexer() != null) {
                    PP.getCurrentLexer().LexIncludeFilename(Tok);
                } else {
                    PP.Lex(Tok);
                }
            }
            FilenameBuffer = new SmallString(128);
            StringRef Filename = new StringRef();
            SourceLocation EndLoc = new SourceLocation();
            switch (Tok.getKind()) {
                case 2: {
                    boolean bl = false;
                    return bl;
                }
                case 13: 
                case 15: {
                    bool.ptr Invalid = NativePointer.create_bool$ptr((boolean)false);
                    Filename.$assignMove(PP.getSpelling(Tok, FilenameBuffer, Invalid));
                    if (!Invalid.$star()) break;
                    boolean bl = false;
                    return bl;
                }
                case 46: {
                    FilenameBuffer.push_back(NativePointer.$((char)'<'));
                    if (PP.ConcatenateIncludeName(FilenameBuffer, EndLoc)) {
                        Tok.setKind((short)2);
                        boolean Invalid = false;
                        return Invalid;
                    }
                    Filename.$assignMove(FilenameBuffer.str());
                    break;
                }
                default: {
                    $c.clean($c.track((Object)PP.Diag(Tok.getLocation(), 703L)));
                    boolean Invalid = false;
                    return Invalid;
                }
            }
            SourceLocation FilenameLoc = Tok.getLocation();
            PP.LexNonComment(Tok);
            if (Tok.isNot((short)22)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_TokenKind((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_IdentifierInfo((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)PP.Diag(PP.getLocForEndOfToken(FilenameLoc), 697L))), (IdentifierInfo)II), (short)22));
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_TokenKind((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)PP.Diag(LParenLoc, 46L))), (short)21));
                boolean bl = false;
                return bl;
            }
            boolean isAngled = PP.GetIncludeFilenameSpelling(Tok.getRawLocation(), Filename);
            if (Filename.empty()) {
                boolean bl = false;
                return bl;
            }
            type.ref CurDir = NativePointer.create_type$ref(null);
            FileEntry File2 = PP.LookupFile(FilenameLoc, Filename, isAngled, LookupFrom, LookupFromFile, (type.ref<type.ptr<DirectoryLookup>>)CurDir, null, null, null);
            boolean bl = File2 != null;
            return bl;
        }
        finally {
            if (FilenameBuffer != null) {
                FilenameBuffer.$destroy();
            }
            $c.$destroy();
        }
    }

    public static boolean EvaluateHasInclude(Token Tok, IdentifierInfo II, Preprocessor PP) {
        return PPMacroExpansionStatics.EvaluateHasIncludeCommon(Tok, II, PP, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean EvaluateHasIncludeNext(Token Tok, IdentifierInfo II, Preprocessor PP) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            type.ptr Lookup2 = (type.ptr)Native.$tryClone(PP.GetCurDirLookup());
            FileEntry LookupFromFile = null;
            if (PP.isInPrimaryFile()) {
                Lookup2 = null;
                $c.clean($c.track((Object)PP.Diag(Tok, 825L)));
            } else if (PP.getCurrentSubmodule() != null) {
                assert (PP.getCurrentLexer() != null) : "#include_next directive in macro?";
                LookupFromFile = PP.getCurrentLexer().getFileEntry();
                Lookup2 = null;
            } else if (Lookup2 == null) {
                $c.clean($c.track((Object)PP.Diag(Tok, 824L)));
            } else {
                Lookup2.$preInc();
            }
            boolean bl = PPMacroExpansionStatics.EvaluateHasIncludeCommon(Tok, II, PP, (type.ptr<DirectoryLookup>)Lookup2, LookupFromFile);
            return bl;
        }
        finally {
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean EvaluateBuildingModule(Token Tok, IdentifierInfo II, Preprocessor PP) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            PP.LexNonComment(Tok);
            if (Tok.isNot((short)21)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_TokenKind((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_IdentifierInfo((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)PP.Diag(Tok.getLocation(), 697L))), (IdentifierInfo)II), (short)21));
                boolean bl = false;
                return bl;
            }
            SourceLocation LParenLoc = Tok.getLocation();
            PP.LexNonComment(Tok);
            if (Tok.isNot((short)5)) {
                $c.clean($c.track((Object)PP.Diag(Tok.getLocation(), 630L)));
                boolean bl = false;
                return bl;
            }
            boolean Result = llvm.$eq_StringRef((StringRef)Tok.getIdentifierInfo().getName(), (StringRef)new StringRef(PP.getLangOpts().CurrentModule));
            PP.LexNonComment(Tok);
            if (Tok.isNot((short)22)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_TokenKind((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_IdentifierInfo((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)PP.Diag(Tok.getLocation(), 697L))), (IdentifierInfo)II), (short)22));
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_TokenKind((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)PP.Diag(LParenLoc, 46L))), (short)21));
                boolean bl = false;
                return bl;
            }
            boolean bl = Result;
            return bl;
        }
        finally {
            $c.$destroy();
        }
    }

    public static final class Bracket
    extends Enum<Bracket> {
        public static final /* enum */ Bracket Brace = new Bracket(0L);
        public static final /* enum */ Bracket Paren = new Bracket(1L);
        private final int value;
        private static final /* synthetic */ Bracket[] $VALUES;

        public static Bracket[] values() {
            return (Bracket[])$VALUES.clone();
        }

        public static Bracket valueOf(String name) {
            return Enum.valueOf(Bracket.class, name);
        }

        public static Bracket valueOf(int val) {
            Bracket out;
            Bracket bracket = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Bracket(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Bracket[]{Brace, Paren};
        }

        private static final class Values {
            private static final Bracket[] VALUES;
            private static final Bracket[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Bracket kind : Bracket.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Bracket[min < 0 ? 1 - min : 0];
                VALUES = new Bracket[max >= 0 ? 1 + max : 0];
                for (Bracket kind : Bracket.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Bracket)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Bracket)kind).value] = kind;
                }
            }
        }
    }
}

