/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallSet;

public class SetVector<T>
implements Native.NativeComparable<SetVector<T>>,
Destructors.ClassWithDestructor {
    private final T defaultValue;
    private SmallSet<T> set_;
    private std.vector<T> vector_;

    public SetVector(T defaultValue) {
        this(16L, defaultValue);
    }

    public SetVector(long N, T defaultValue) {
        this.set_ = new SmallSet(N);
        this.vector_ = new std.vector(defaultValue);
        this.defaultValue = defaultValue;
    }

    public SetVector(long N, type.iterator<?, T> Start, type.iterator<?, T> End, T defaultValue) {
        this(N, defaultValue);
        this.insert(Start, End);
    }

    public SetVector(SetVector<T> other) {
        this.set_ = new SmallSet<T>(other.set_);
        this.vector_ = new std.vector(other.vector_);
        this.defaultValue = other.defaultValue;
    }

    public boolean empty() {
        return this.vector_.empty();
    }

    public long size() {
        return this.vector_.size();
    }

    public StdVector.iterator<T> begin() {
        return this.vector_.begin();
    }

    public StdVector.iterator<T> end() {
        return this.vector_.end();
    }

    public T back() {
        assert (!this.empty()) : "Cannot call back() on empty SetVector!";
        return (T)this.vector_.back();
    }

    public T $at(long n) {
        assert (n < (long)this.vector_.size()) : "SetVector access out of range!";
        return (T)this.vector_.$at(n);
    }

    public boolean insert(T X) {
        boolean result = this.set_.insert(this.defaultValue == null ? X : Native.$tryClone(X));
        if (result) {
            this.vector_.push_back(this.defaultValue == null ? X : Native.$tryClone(X));
        }
        return result;
    }

    public void insert(type.iterator<?, T> Start, type.iterator<?, T> End) {
        Start = (type.iterator)Native.$tryClone(Start);
        while (Native.$noteq((abstract_iterator)Start, End)) {
            if (this.set_.insert(this.defaultValue == null ? Start.$star() : Native.$tryClone((Object)Start.$star()))) {
                this.vector_.push_back(this.defaultValue == null ? Start.$star() : Native.$tryClone((Object)Start.$star()));
            }
            Start.$preInc();
        }
    }

    public boolean remove(T X) {
        if (this.set_.erase(X)) {
            assert (this.vector_.contains(X)) : "Corrupted SetVector instances!";
            this.vector_.erase(X);
            return true;
        }
        return false;
    }

    public boolean remove_if(NativeCallback.BoolPredicate<T> P) {
        StdVector.iterator I = (StdVector.iterator)std.remove_if((type.iterator)this.vector_.begin(), (type.iterator)this.vector_.end(), new TestAndEraseFromSet<T>(P, this.set_));
        if (Native.$eq((abstract_iterator)I, (abstract_iterator)this.vector_.end())) {
            return false;
        }
        this.vector_.erase(I, this.vector_.end());
        return true;
    }

    public long count(T key) {
        return this.set_.count(key) ? 1L : 0L;
    }

    public void clear() {
        this.set_.clear();
        this.vector_.clear();
    }

    public void pop_back() {
        assert (!this.empty()) : "Cannot remove an element from an empty SetVector!";
        this.set_.erase(this.back());
        this.vector_.pop_back();
    }

    public T pop_back_val() {
        T Ret = this.back();
        this.pop_back();
        return Ret;
    }

    public boolean $eq(SetVector<T> that) {
        return Native.$eq(this.vector_, that.vector_);
    }

    public boolean $noteq(SetVector<T> that) {
        return Native.$noteq(this.vector_, that.vector_);
    }

    public void $destroy() {
        this.set_.$destroy();
        this.vector_.$destroy();
    }

    public static class TestAndEraseFromSet<T>
    implements NativeCallback.BoolPredicate<T> {
        private NativeCallback.BoolPredicate<T> P;
        private SmallSet<T> set_;

        public TestAndEraseFromSet(NativeCallback.BoolPredicate<T> P, SmallSet<T> set_) {
            this.P = P;
            this.set_ = set_;
        }

        public boolean $call(T Arg) {
            if (this.P.$call(Arg)) {
                this.set_.erase(Arg);
                return true;
            }
            return false;
        }
    }
}

