/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.support.llvm;

public class SmallPtrSetImpl
implements Destructors.ClassWithDestructor {
    protected final DenseMapInfo KeyInfo;
    protected type.ptr<Object> SmallArray;
    protected type.ptr<Object> CurArray;
    protected int CurArraySize;
    protected int NumElements;
    protected int NumTombstones;

    protected SmallPtrSetImpl(type.ptr<Object> SmallStorage, SmallPtrSetImpl that) {
        this.SmallArray = (type.ptr)Native.$tryClone(SmallStorage);
        if (that.isSmall()) {
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
        } else {
            this.CurArray = std.malloc((long)that.CurArraySize);
            assert (this.CurArray != null) : "Failed to allocate memory?";
        }
        this.CurArraySize = that.CurArraySize;
        std.memcpy(this.CurArray, that.CurArray, (int)this.CurArraySize);
        this.NumElements = that.NumElements;
        this.NumTombstones = that.NumTombstones;
        this.KeyInfo = that.KeyInfo;
    }

    protected SmallPtrSetImpl(DenseMapInfo KeyInfo, type.ptr<Object> SmallStorage, int SmallSize) {
        this.SmallArray = SmallStorage;
        this.CurArray = SmallStorage;
        this.CurArraySize = SmallSize;
        this.KeyInfo = KeyInfo;
        assert (SmallSize != 0 && (SmallSize & SmallSize - 1) == 0) : "Initial size must be a power of two!";
        if (ADTAliases.CHECK_DENSE_MAP_INFO) {
            assert (KeyInfo.getEmptyKey() != KeyInfo.getTombstoneKey()) : "EmptyKey must be different from TombstoneKey:" + KeyInfo;
            assert (!KeyInfo.isEqual(KeyInfo.getEmptyKey(), KeyInfo.getTombstoneKey())) : "EmptyKey must be not equal to TombstoneKey:" + KeyInfo;
            assert (KeyInfo.getHashValue(KeyInfo.getEmptyKey()) != KeyInfo.getHashValue(KeyInfo.getTombstoneKey())) : "EmptyKey must have different hashCode to TombstoneKey:" + KeyInfo;
        }
        this.clear();
    }

    public void $destroy() {
        if (!this.isSmall()) {
            std.free(this.CurArray);
        }
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public int size() {
        return this.NumElements;
    }

    public void clear() {
        if (!this.isSmall() && this.NumElements * 4 < this.CurArraySize && this.CurArraySize > 32) {
            this.shrink_and_clear();
            return;
        }
        std.memset(this.CurArray, this.KeyInfo.getEmptyKey(), (int)this.CurArraySize);
        this.NumElements = 0;
        this.NumTombstones = 0;
    }

    protected Object getTombstoneMarker() {
        return this.KeyInfo.getTombstoneKey();
    }

    protected Object getEmptyMarker() {
        return this.KeyInfo.getEmptyKey();
    }

    protected boolean insert_imp(Object Ptr) {
        if (this.isSmall()) {
            type.ptr APtr = (type.ptr)Native.$tryClone(this.SmallArray);
            type.ptr E = (type.ptr)this.SmallArray.$add(this.NumElements);
            while (APtr.$noteq((Object)E)) {
                if (this.KeyInfo.isEqual(Ptr, APtr.$star())) {
                    return false;
                }
                APtr.$preInc();
            }
            if (this.NumElements < this.CurArraySize - 1) {
                this.SmallArray.$set(this.NumElements++, Ptr);
                return true;
            }
        }
        if (this.NumElements * 4 >= this.CurArraySize * 3) {
            this.Grow(this.CurArraySize < 64 ? 128 : this.CurArraySize * 2);
        } else if (this.CurArraySize - (this.NumElements + this.NumTombstones) < this.CurArraySize / 8) {
            this.Grow(this.CurArraySize);
        }
        type.ptr Bucket = (type.ptr)Native.$tryClone(this.FindBucketFor(Ptr));
        if (this.KeyInfo.isEqual(Ptr, Bucket.$star())) {
            return false;
        }
        if (Bucket.$star() == this.getTombstoneMarker()) {
            --this.NumTombstones;
        }
        Bucket.$set(Native.$tryClone((Object)Ptr));
        ++this.NumElements;
        return true;
    }

    protected boolean erase_imp(Object Ptr) {
        if (this.isSmall()) {
            type.ptr APtr = (type.ptr)Native.$tryClone(this.SmallArray);
            type.ptr E = (type.ptr)this.SmallArray.$add(this.NumElements);
            while (APtr.$noteq((Object)E)) {
                if (this.KeyInfo.isEqual(Ptr, APtr.$star())) {
                    APtr.$set(Native.$tryClone((Object)E.$at(-1)));
                    E.$set(-1, this.getEmptyMarker());
                    --this.NumElements;
                    return true;
                }
                APtr.$preInc();
            }
            return false;
        }
        type.ptr Bucket = (type.ptr)Native.$tryClone(this.FindBucketFor(Ptr));
        if (!this.KeyInfo.isEqual(Ptr, Bucket.$star())) {
            return false;
        }
        Bucket.$set(Native.$tryClone((Object)this.getTombstoneMarker()));
        --this.NumElements;
        ++this.NumTombstones;
        return true;
    }

    protected boolean count_imp(Object Ptr) {
        if (this.isSmall()) {
            type.ptr APtr = (type.ptr)Native.$tryClone(this.SmallArray);
            type.ptr E = (type.ptr)this.SmallArray.$add(this.NumElements);
            while (APtr.$noteq((Object)E)) {
                if (this.KeyInfo.isEqual(Ptr, APtr.$star())) {
                    return true;
                }
                APtr.$preInc();
            }
            return false;
        }
        return this.KeyInfo.isEqual(this.FindBucketFor(Ptr).$star(), Ptr);
    }

    private boolean isSmall() {
        return this.CurArray.$eq(this.SmallArray);
    }

    private type.ptr<Object> FindBucketFor(Object Ptr) {
        long Bucket = this.KeyInfo.getHashValue(Ptr) & (long)(this.CurArraySize - 1);
        int ArraySize = this.CurArraySize;
        int ProbeAmt = 1;
        type.ptr Array = (type.ptr)Native.$tryClone(this.CurArray);
        type.ptr Tombstone = null;
        while (!this.KeyInfo.isEqual(Ptr, Array.$at(Bucket))) {
            if (Array.$at(Bucket) == this.getEmptyMarker()) {
                return Tombstone != null ? Tombstone : (type.ptr)Array.$add(Bucket);
            }
            if (Array.$at(Bucket) == this.getTombstoneMarker() && Tombstone == null) {
                Tombstone = (type.ptr)Array.$add(Bucket);
            }
            Bucket = Bucket + (long)ProbeAmt++ & (long)(ArraySize - 1);
        }
        return (type.ptr)Array.$add(Bucket);
    }

    private void shrink_and_clear() {
        assert (!this.isSmall()) : "Can't shrink a small set!";
        std.free(this.CurArray);
        this.CurArraySize = this.NumElements > 16 ? 1 << llvm.Log2_32_Ceil(this.NumElements) + 1 : 32;
        this.NumTombstones = 0;
        this.NumElements = 0;
        this.CurArray = std.malloc((long)this.CurArraySize);
        assert (this.CurArray != null) : "Failed to allocate memory?";
        std.memset(this.CurArray, this.KeyInfo.getEmptyKey(), (int)this.CurArraySize);
    }

    private void Grow(int NewSize) {
        int OldSize = this.CurArraySize;
        type.ptr OldBuckets = (type.ptr)Native.$tryClone(this.CurArray);
        boolean WasSmall = this.isSmall();
        this.CurArray = std.malloc((long)NewSize);
        assert (this.CurArray != null) : "Failed to allocate memory?";
        this.CurArraySize = NewSize;
        std.memset(this.CurArray, this.KeyInfo.getEmptyKey(), (int)NewSize);
        if (WasSmall) {
            type.ptr BucketPtr = (type.ptr)Native.$tryClone((NativeCloneable)OldBuckets);
            type.ptr E = (type.ptr)OldBuckets.$add(this.NumElements);
            while (BucketPtr.$noteq((Object)E)) {
                Object Elt = Native.$tryClone((Object)BucketPtr.$star());
                this.FindBucketFor(Elt).$set(Elt);
                BucketPtr.$preInc();
            }
        } else {
            type.ptr BucketPtr = (type.ptr)Native.$tryClone((NativeCloneable)OldBuckets);
            type.ptr E = (type.ptr)OldBuckets.$add(OldSize);
            while (BucketPtr.$noteq((Object)E)) {
                Object Elt = Native.$tryClone((Object)BucketPtr.$star());
                if (Elt != this.getTombstoneMarker() && Elt != this.getEmptyMarker()) {
                    this.FindBucketFor(Elt).$set(Elt);
                }
                BucketPtr.$preInc();
            }
            std.free((Object)OldBuckets);
            this.NumTombstones = 0;
        }
    }

    private void $assign(SmallPtrSetImpl RHS) {
    }

    protected void swap(SmallPtrSetImpl RHS) {
        if (this == RHS) {
            return;
        }
        if (!this.isSmall() && !RHS.isSmall()) {
            type.ptr<Object> tmpPtr = this.CurArray;
            this.CurArray = RHS.CurArray;
            RHS.CurArray = tmpPtr;
            int tmp = this.CurArraySize;
            this.CurArraySize = RHS.CurArraySize;
            RHS.CurArraySize = tmp;
            tmp = this.NumElements;
            this.NumElements = RHS.NumElements;
            RHS.NumElements = tmp;
            tmp = this.NumTombstones;
            this.NumTombstones = RHS.NumTombstones;
            RHS.NumTombstones = tmp;
            return;
        }
        if (!this.isSmall() && RHS.isSmall()) {
            std.copy(RHS.SmallArray, (type.iterator)((type.iterator)RHS.SmallArray.$add(RHS.CurArraySize)), this.SmallArray);
            int tmp = this.NumElements;
            this.NumElements = RHS.NumElements;
            RHS.NumElements = tmp;
            tmp = this.CurArraySize;
            this.CurArraySize = RHS.CurArraySize;
            RHS.CurArraySize = tmp;
            RHS.CurArray = (type.ptr)Native.$tryClone(this.CurArray);
            RHS.NumTombstones = this.NumTombstones;
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
            this.NumTombstones = 0;
            return;
        }
        if (this.isSmall() && !RHS.isSmall()) {
            std.copy(this.SmallArray, (type.iterator)((type.iterator)this.SmallArray.$add(this.CurArraySize)), RHS.SmallArray);
            int tmp = this.NumElements;
            this.NumElements = RHS.NumElements;
            RHS.NumElements = tmp;
            tmp = this.CurArraySize;
            this.CurArraySize = RHS.CurArraySize;
            RHS.CurArraySize = tmp;
            this.CurArray = (type.ptr)Native.$tryClone(RHS.CurArray);
            this.NumTombstones = RHS.NumTombstones;
            RHS.CurArray = (type.ptr)Native.$tryClone(RHS.SmallArray);
            RHS.NumTombstones = 0;
            return;
        }
        assert (this.isSmall() && RHS.isSmall());
        assert (this.CurArraySize == RHS.CurArraySize);
        std.swap_ranges(this.SmallArray, (type.iterator)((type.iterator)this.SmallArray.$add(this.CurArraySize)), RHS.SmallArray);
        int tmp = this.NumElements;
        this.NumElements = RHS.NumElements;
        RHS.NumElements = tmp;
    }

    protected void CopyFrom(SmallPtrSetImpl RHS) {
        if (this.isSmall() && RHS.isSmall()) assert (this.CurArraySize == RHS.CurArraySize) : "Cannot assign sets with different small sizes";
        if (RHS.isSmall()) {
            if (!this.isSmall()) {
                std.free(this.CurArray);
            }
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
        } else if (this.CurArraySize != RHS.CurArraySize) {
            if (this.isSmall()) {
                this.CurArray = std.malloc((long)RHS.CurArraySize);
            } else {
                type.ptr T = std.realloc(this.CurArray, (long)this.CurArraySize, (long)RHS.CurArraySize);
                if (T == null) {
                    std.free(this.CurArray);
                }
                this.CurArray = (type.ptr)Native.$tryClone((NativeCloneable)T);
            }
            assert (this.CurArray != null) : "Failed to allocate memory?";
        }
        this.CurArraySize = RHS.CurArraySize;
        std.memcpy(this.CurArray, RHS.CurArray, (int)this.CurArraySize);
        this.NumElements = RHS.NumElements;
        this.NumTombstones = RHS.NumTombstones;
    }
}

