/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Arrays;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapBaseTypeChar;
import org.llvm.support.llvm;

public class DenseMapTypeChar<KeyT>
extends DenseMapBaseTypeChar<DenseMapTypeChar<KeyT>, KeyT>
implements Native.assignable<DenseMapTypeChar<KeyT>>,
Destructors.ClassWithDestructor {
    private std.pairTypeChar<KeyT>[] Buckets;
    private int NumEntries;
    private int NumTombstones;
    private int NumBuckets;

    public DenseMapTypeChar(DenseMapInfo<KeyT> keyInfo, byte defaultValue) {
        this(keyInfo, 0L, defaultValue);
    }

    public DenseMapTypeChar(DenseMapInfo<KeyT> keyInfo, long NumInitBuckets, byte defaultValue) {
        super(keyInfo, defaultValue);
        this.init(NumInitBuckets);
    }

    public DenseMapTypeChar(DenseMapTypeChar<KeyT> other) {
        super(other.keyInfoT, other.defaultValue);
        this.init(0L);
        this.copyFrom(other);
    }

    public DenseMapTypeChar(DenseMapInfo<KeyT> keyInfo, type.iterator<?, std.pairTypeChar<KeyT>> I, type.iterator<?, std.pairTypeChar<KeyT>> E, byte defaultValue) {
        super(keyInfo, defaultValue);
        this.init(llvm.NextPowerOf2(std.distance(I, E)));
        this.insert(I, E);
    }

    public void $destroy() {
        this.destroyAll();
    }

    public void swap(DenseMapTypeChar<KeyT> RHS) {
        std.pairTypeChar<KeyT>[] BucketsOther = RHS.Buckets;
        RHS.Buckets = this.Buckets;
        this.Buckets = BucketsOther;
        int NumBucketsOther = RHS.NumBuckets;
        RHS.NumBuckets = this.NumBuckets;
        this.NumBuckets = NumBucketsOther;
        int NumEntriesOther = RHS.NumEntries;
        RHS.NumEntries = this.NumEntries;
        this.NumEntries = NumEntriesOther;
        int NumTombstonesOther = RHS.NumTombstones;
        RHS.NumTombstones = this.NumTombstones;
        this.NumTombstones = NumTombstonesOther;
    }

    public DenseMapTypeChar<KeyT> $assign(DenseMapTypeChar<KeyT> other) {
        this.copyFrom(other);
        return this;
    }

    public void copyFrom(DenseMapTypeChar<KeyT> other) {
        this.destroyAll();
        if (this.allocateBuckets(other.NumBuckets)) {
            super.copyFrom(other);
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    public void init(long InitBuckets) {
        if (this.allocateBuckets(InitBuckets)) {
            super.initEmpty();
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    @Override
    public void grow(long AtLeast) {
        int OldNumBuckets = this.NumBuckets;
        std.pairTypeChar<KeyT>[] OldBuckets = this.Buckets;
        this.allocateBuckets(std.max((int)64, (int)((int)llvm.NextPowerOf2(AtLeast - 1L))));
        if (OldBuckets == null) {
            super.initEmpty();
            return;
        }
        this.moveFromOldBuckets(OldBuckets, OldNumBuckets);
    }

    @Override
    public void shrink_and_clear() {
        long OldNumEntries = this.NumEntries;
        this.destroyAll();
        long NewNumBuckets = 0L;
        if (OldNumEntries != 0L) {
            NewNumBuckets = std.max((int)64, (int)(1 << llvm.Log2_32_Ceil(OldNumEntries) + 1));
        }
        if (NewNumBuckets == (long)this.NumBuckets) {
            super.initEmpty();
            return;
        }
        this.init(NewNumBuckets);
    }

    @Override
    protected int getNumEntries() {
        return this.NumEntries;
    }

    @Override
    protected void setNumEntries(int Num) {
        this.NumEntries = Num;
    }

    @Override
    protected int getNumTombstones() {
        return this.NumTombstones;
    }

    @Override
    protected void setNumTombstones(int Num) {
        this.NumTombstones = Num;
    }

    @Override
    protected type.ptr<std.pairTypeChar<KeyT>> getBuckets() {
        return NativePointer.create_type$ptr((Object[])this.Buckets);
    }

    @Override
    protected std.pairTypeChar<KeyT>[] $Buckets() {
        return this.Buckets;
    }

    @Override
    protected int getNumBuckets() {
        return this.NumBuckets;
    }

    private boolean allocateBuckets(long Num) {
        this.NumBuckets = (int)Num;
        if (this.NumBuckets == 0) {
            this.Buckets = null;
            return false;
        }
        std.pairTypeChar[] bucketsArray = new std.pairTypeChar[this.NumBuckets];
        for (int i = 0; i < this.NumBuckets; ++i) {
            bucketsArray[i] = new std.pairTypeChar();
        }
        this.Buckets = bucketsArray;
        return true;
    }

    public String toString() {
        return "DenseMap{Buckets=[\n" + Arrays.toString(this.Buckets) + "\n], NumEntries=" + this.NumEntries + ", NumTombstones=" + this.NumTombstones + ", NumBuckets=" + this.NumBuckets + '}';
    }
}

