/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;

public abstract class SmallVectorImplBool
implements Native.assignable<SmallVectorImplBool>,
Native.NativeComparable<SmallVectorImplBool>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<Boolean> {
    protected final boolean defaultValue;
    private boolean[] array;
    private static final boolean[] EMPTY = NativePointer.new$bool((int)0);
    private int end;

    public final boolean[] $array() {
        return this.array;
    }

    protected SmallVectorImplBool(int capacity, boolean defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$bool((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplBool(long capacity, boolean defaultValue) {
        this.array = capacity == 0L ? EMPTY : NativePointer.new$bool((long)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplBool(int capacity, int initialSize, boolean defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplBool(long capacity, long initialSize, boolean defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplBool(int capacity, int initialSize, boolean value, boolean defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplBool(long capacity, long initialSize, boolean value, boolean defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplBool(boolean[] array2, int length, boolean defaultValue) {
        this.array = array2;
        this.end = length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplBool(boolean[] array2, long length, boolean defaultValue) {
        this.array = array2;
        this.end = (int)length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplBool(int capacity, bool.iterator<?> iter, int length, boolean defaultValue) {
        this(capacity, iter, (bool.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplBool(long capacity, bool.iterator<?> iter, long length, boolean defaultValue) {
        this(capacity, iter, (bool.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplBool(int capacity, bool.iterator<?> begin, bool.iterator<?> end, boolean defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    protected SmallVectorImplBool(long capacity, bool.iterator<?> begin, bool.iterator<?> end, boolean defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    protected SmallVectorImplBool(SmallVectorImplBool other) {
        this.defaultValue = other.defaultValue;
        this.array = (boolean[])other.array.clone();
        this.end = other.end;
    }

    protected SmallVectorImplBool(JavaDifferentiators.Move _dparam, SmallVectorImplBool other) {
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = null;
    }

    public final SmallVectorImplBool $assign(SmallVectorImplBool other) {
        this.array = other.array;
        this.end = other.end;
        return this;
    }

    public final void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(long newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(long newSize, boolean defaultValue) {
        return this.resize(Unsigned.long2uint((long)newSize), defaultValue);
    }

    public final boolean resize(int newSize, boolean defaultValue) {
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.array.length) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.array.length) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((boolean)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(long N) {
        this.reserve(Unsigned.long2uint((long)N));
    }

    public final void reserve(int N) {
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(long NumElts, boolean Elt) {
        this.assign(Unsigned.long2uint((long)NumElts), Elt);
    }

    public final void assign(int NumElts, boolean Elt) {
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign(bool.iterator<?> __first, bool.iterator<?> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public final void swap(SmallVectorImplBool RHS) {
        boolean[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final long find(boolean elem) {
        return this.find(elem, 0L);
    }

    public final long find(boolean elem, long from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = Unsigned.long2uint((long)from); i < this.end; ++i) {
            if (!Native.$eq((boolean)this.array[i], (boolean)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(boolean elem) {
        return this.find(elem) != (long)std.string.npos;
    }

    public final boolean erase(boolean elem) {
        long _index = this.find(elem);
        if (_index == (long)std.string.npos) {
            return false;
        }
        int index = Unsigned.long2uint((long)_index);
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy((boolean[])this.array, (int)(index + 1), (int)(this.end - index), (boolean[])this.array, (int)index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy((bool.iterator)I.$add(1), (bool.iterator)this.end(), (bool.iterator)I);
        this.pop_back();
        return N;
    }

    public final iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = (iterator)std.copy((bool.iterator)E, (bool.iterator)this.end(), (bool.iterator)S);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public final iterator insert(iterator I, boolean Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((bool.iterator)I, (bool.iterator)this.end().$sub(1), (bool.iterator)this.end());
        I.star$ref().$set(Elt);
        return I;
    }

    public final iterator insert(iterator I, long NumToInsert, boolean Elt) {
        return this.insert(I, Unsigned.long2uint((long)NumToInsert), Elt);
    }

    public final iterator insert(iterator I, int NumToInsert, boolean Elt) {
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((bool.iterator)I, (bool.iterator)OldEnd.$sub(NumToInsert), (bool.iterator)OldEnd);
            std.fill_n((bool.iterator)I, (int)NumToInsert, (boolean)Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy((bool.iterator)I, (bool.iterator)OldEnd, (bool.iterator)this.end().$sub(NumOverwritten));
        std.fill_n((bool.iterator)I, (int)NumOverwritten, (boolean)Elt);
        std.fill_n((bool.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (boolean)Elt);
        return I;
    }

    public final iterator insert(iterator I, bool.iterator<?> From, bool.iterator<?> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((bool.iterator)I, (bool.iterator)OldEnd.$sub(NumToInsert), (bool.iterator)OldEnd);
            std.copy(From, To, (bool.iterator)I);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((bool.iterator)I, (bool.iterator)OldEnd, (bool.iterator)this.end().$sub(NumOverwritten));
        iterator J = I.clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, (bool.iterator)OldEnd);
        return I;
    }

    public final void append(bool.iterator<?> in_start, bool.iterator<?> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        bool.iterator iter = (bool.iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(boolean[] a) {
        this.append(a, 0, a.length);
    }

    public final void append(boolean[] a, int fromIndex, int count) {
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            boolean el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(long NumInputs, boolean Elt) {
        this.append(Unsigned.long2uint((long)NumInputs), Elt);
    }

    public final void append(int NumInputs, boolean Elt) {
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final boolean $eq(SmallVectorImplBool RHS) {
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((boolean)this.array[i], (boolean)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplBool RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplBool)obj).begin(), (Object)((SmallVectorImplBool)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((SmallVectorImplBool)obj);
    }

    public final bool.ref ref$at(int idx) {
        return NativePointer.create_bool$ref((boolean[])this.array, (long)idx);
    }

    public final bool.ref ref$at(long idx) {
        return NativePointer.create_bool$ref((boolean[])this.array, (long)idx);
    }

    public final boolean $at(int idx) {
        return this.array[idx];
    }

    public final boolean $at(long idx) {
        return this.array[(int)idx];
    }

    public final boolean $set(int idx, boolean value) {
        this.array[idx] = value;
        return value;
    }

    public final boolean $set(long idx, boolean value) {
        this.array[(int)idx] = value;
        return value;
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
    }

    public final void push_back(boolean val) {
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final boolean pop_back_val() {
        boolean val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0, false);
    }

    public final iterator end() {
        return new iterator(this, this.end, false);
    }

    public final std.reverse_iteratorBool rbegin() {
        return new std.reverse_iteratorBool((bool.iterator)NativePointer.create_bool$ptr((boolean[])this.array, (long)this.end));
    }

    public final std.reverse_iteratorBool rend() {
        return new std.reverse_iteratorBool((bool.iterator)NativePointer.create_bool$ptr((boolean[])this.array));
    }

    public final bool.ptr data() {
        return NativePointer.create_bool$ptr((boolean[])this.array);
    }

    public final boolean front() {
        return this.array[0];
    }

    public final boolean back() {
        return this.array[this.end - 1];
    }

    public final bool.ref ref$front() {
        return new bool.ref(){
            private final boolean stored;
            private final int index = 0;
            {
                this.stored = SmallVectorImplBool.this.array[0];
                this.index = 0;
            }

            public boolean $deref() {
                return this.stored;
            }

            public boolean $set(boolean value) {
                ((SmallVectorImplBool)SmallVectorImplBool.this).array[0] = value;
                return value;
            }

            public bool.ptr deref$ptr() {
                return (bool.ptr)SmallVectorImplBool.this.data().$add(0);
            }
        };
    }

    public final bool.ref ref$back() {
        return new bool.ref(){
            private final boolean stored;
            private final int index;
            {
                this.stored = SmallVectorImplBool.this.array[SmallVectorImplBool.this.end - 1];
                this.index = SmallVectorImplBool.this.end - 1;
            }

            public boolean $deref() {
                return this.stored;
            }

            public boolean $set(boolean value) {
                ((SmallVectorImplBool)SmallVectorImplBool.this).array[this.index] = value;
                return value;
            }

            public bool.ptr deref$ptr() {
                return (bool.ptr)SmallVectorImplBool.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final long $sizeof() {
        return this.capacity_in_bytes();
    }

    public final long capacity_in_bytes() {
        int oneElemSize = NativeType.sizeof((boolean)this.defaultValue);
        for (boolean elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((boolean)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final bool.ptr ptr$at(int idx) {
        return NativePointer.create_bool$ptr((boolean[])this.array, (long)idx);
    }

    public final bool.ptr ptr$at(long idx) {
        return NativePointer.create_bool$ptr((boolean[])this.array, (long)idx);
    }

    public final void set_size(long N) {
        this.set_size(Unsigned.long2uint((long)N));
    }

    public final void set_size(int N) {
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(long from, long to) {
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int capacity) {
        boolean[] oldArray = this.array;
        this.array = NativePointer.new$bool((int)capacity);
        NativePointer.copy$Object((boolean[])oldArray, (int)0, (boolean[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplBool{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            boolean element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplBool}\n");
        return out.toString();
    }

    private static final class JavaIterator
    implements Iterator<Boolean> {
        private final iterator begin;
        private final iterator end;

        public JavaIterator(iterator begin, iterator end) {
            this.begin = (iterator)Native.$tryClone((NativeCloneable)begin);
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.begin.$noteq(this.end);
        }

        @Override
        public Boolean next() {
            Boolean val = this.begin.$star();
            this.begin.$preInc();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static final class iterator
    implements bool.iterator<iterator>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final SmallVectorImplBool delegate;
        private int index;

        private iterator(SmallVectorImplBool delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        public boolean $arrow() {
            return this.$at(0);
        }

        public boolean $star() {
            return this.$at(0);
        }

        public bool.ref star$ref() {
            return this.ref$at(0);
        }

        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        public iterator $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        public iterator $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        public iterator $postInc() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        public iterator $postDec() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        public iterator $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        public iterator $inc(long amount) {
            assert (!this._const);
            this.index = (int)((long)this.index + amount);
            return this;
        }

        public iterator $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        public iterator $dec(long amount) {
            assert (!this._const);
            this.index = (int)((long)this.index - amount);
            return this;
        }

        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount, false);
        }

        public iterator $add(long amount) {
            return new iterator(this.delegate, (int)((long)this.index + amount), false);
        }

        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount, false);
        }

        public iterator $sub(long amount) {
            return new iterator(this.delegate, (int)((long)this.index - amount), false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        public iterator clone() {
            return new iterator(this.delegate, this.index, false);
        }

        public iterator const_clone() {
            return new iterator(this.delegate, this.index, true);
        }

        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public boolean $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public boolean $at(long index) {
            return this.delegate.$at((long)this.index + index);
        }

        public bool.ref ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public bool.ref ref$at(long index) {
            return this.delegate.ref$at((long)this.index + index);
        }

        public bool.ptr toPointer() {
            return NativePointer.create_bool$ptr((boolean[])this.delegate.array, (long)this.index);
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

