/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntryBool;
import org.llvm.adt.aliases.StringMapIteratorBool;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;

public class StringMapBool<AllocatorTy extends NativeMemory.Allocator>
extends StringMapImpl
implements Destructors.ClassWithDestructor {
    private AllocatorTy Allocator;
    private final boolean defaultValue;

    public StringMapBool(boolean defaultValue) {
        super(StringMapEntryBool.$sizeof_StringMapEntryBool());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapBool(long InitialSize, boolean defaultValue) {
        super(InitialSize, StringMapEntryBool.$sizeof_StringMapEntryBool());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapBool(AllocatorTy A, boolean defaultValue) {
        super(StringMapEntryBool.$sizeof_StringMapEntryBool());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapBool(long InitialSize, AllocatorTy A, boolean defaultValue) {
        super(InitialSize, StringMapEntryBool.$sizeof_StringMapEntryBool());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapBool(StringMapBool<AllocatorTy> RHS, boolean defaultValue) {
        super(StringMapEntryBool.$sizeof_StringMapEntryBool());
        this.defaultValue = defaultValue;
        if (!RHS.empty()) {
            throw new AssertionError((Object)"Copy ctor from non-empty stringmap not implemented yet!");
        }
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapBool(JavaDifferentiators.Move _dparam, StringMapBool<AllocatorTy> RHS) {
        super((StringMapImpl)std.move(RHS));
        this.Allocator = RHS.Allocator;
        this.defaultValue = RHS.defaultValue;
    }

    public StringMapBool<AllocatorTy> $assign(StringMapBool<AllocatorTy> RHS) {
        super.swap(RHS);
        AllocatorTy tmp = this.Allocator;
        this.Allocator = RHS.Allocator;
        RHS.Allocator = tmp;
        return this;
    }

    public AllocatorTy getAllocator() {
        return this.Allocator;
    }

    public StringMapIteratorBool begin() {
        return new StringMapIteratorBool(this.TheTable, 0, this.NumBuckets == 0);
    }

    public StringMapIteratorBool end() {
        return new StringMapIteratorBool(this.TheTable, this.NumBuckets, true);
    }

    public StringMapIteratorBool find(StringRef Key) {
        int Bucket = this.FindKey(Key);
        if (Bucket == -1) {
            return this.end();
        }
        return new StringMapIteratorBool(this.TheTable, Bucket, true);
    }

    public boolean lookup(StringRef Key) {
        return this.lookup(Key.data(), Key.size());
    }

    public boolean lookup(char.ptr Key, int KeyLen) {
        int Bucket = this.FindKey(Key, KeyLen);
        if (Bucket != -1) {
            return ((StringMapEntryBool)this.TheTable[Bucket]).getValue();
        }
        return Native.$tryClone((boolean)this.defaultValue);
    }

    public boolean $at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public bool.ref ref$at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public int count(StringRef Key) {
        return this.FindKey(Key) == -1 ? 0 : 1;
    }

    public std.pairTypeBool<StringMapIteratorBool> insert(std.pairTypeBool<StringRef> KV) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = ((StringRef)KV.first).data();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = ((StringRef)KV.first).size(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapBool.getTombstoneVal()) {
            return std.make_pair((Object)new StringMapIteratorBool(this.TheTable, BucketNo, false), (boolean)false);
        }
        if (Bucket == StringMapBool.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket = StringMapEntryBool.Create(keyData, keyLength, FullHashValue, this.Allocator, (Boolean)std.move((Object)KV.second));
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        BucketNo = this.RehashTable(BucketNo);
        return std.make_pair((Object)new StringMapIteratorBool(this.TheTable, BucketNo, false), (boolean)true);
    }

    public boolean insert(StringMapEntryBool KeyValue) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = KeyValue.getKeyData();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = KeyValue.getKeyLength(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapBool.getTombstoneVal()) {
            return false;
        }
        if (Bucket == StringMapBool.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket = KeyValue;
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.RehashTable();
        return true;
    }

    public void clear() {
        if (this.empty()) {
            return;
        }
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket = this.TheTable[I];
            this.TheTable[I] = null;
        }
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.Allocator.Reset();
    }

    public StringMapEntryBool GetOrCreateValue(StringRef Key, boolean Val) {
        return this.GetOrCreateValue(Key.data(), Key.size(), Val);
    }

    public StringMapEntryBool GetOrCreateValue(char.ptr Key, int Len, boolean Val) {
        int FullHashValue = llvm.HashString(Key, Len);
        int BucketNo = this.LookupBucketFor(Key, Len, FullHashValue);
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapBool.getTombstoneVal()) {
            return (StringMapEntryBool)Bucket;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((boolean)Val);
        }
        StringMapEntryBool NewItem = StringMapEntryBool.Create(Key, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapBool.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (StringMapEntryBool)Bucket;
    }

    private StringMapEntryBool GetOrCreateValue(byte[] Key, int KeyStIndex, int Len, boolean Val) {
        int FullHashValue = llvm.HashString(Key, KeyStIndex, Len);
        int BucketNo = this.LookupBucketFor(Key, KeyStIndex, Len, FullHashValue);
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapBool.getTombstoneVal()) {
            return (StringMapEntryBool)Bucket;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((boolean)Val);
        }
        StringMapEntryBool NewItem = StringMapEntryBool.Create(Key, KeyStIndex, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapBool.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (StringMapEntryBool)Bucket;
    }

    public StringMapEntryBool GetOrCreateValue(StringRef Key) {
        return this.GetOrCreateValue(Key, this.defaultValue);
    }

    public StringMapEntryBool GetOrCreateValue(char.ptr Key, int Len) {
        return this.GetOrCreateValue(Key, Len, this.defaultValue);
    }

    public StringMapEntryBool GetOrCreateValue(byte[] Key, int KeyStIndex, int Len) {
        return this.GetOrCreateValue(Key, KeyStIndex, Len, this.defaultValue);
    }

    public void remove(StringMapEntryBool KeyValue) {
        this.RemoveKey(KeyValue);
    }

    public void erase(StringMapIteratorBool I) {
        StringMapEntryBool V = I.$star();
        this.remove(V);
        V.Destroy(this.Allocator);
    }

    public boolean erase(StringRef Key) {
        StringMapIteratorBool I = this.find(Key);
        if (Native.$eq((abstract_iterator)I, (abstract_iterator)this.end())) {
            return false;
        }
        this.erase(I);
        return true;
    }

    public void $destroy() {
        this.clear();
        std.free((Object)this.TheTable);
        Destructors.$destroy(this.Allocator);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        StringMapIteratorBool B = this.begin();
        StringMapIteratorBool E = this.end();
        while (B.$noteq(E)) {
            out.append("{").append(B.$star().first()).append("=>").append(B.$star().getValue()).append("}\n");
            B.$preInc();
        }
        return out.toString();
    }
}

