/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntryInt;
import org.llvm.adt.aliases.StringMapIteratorInt;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;

public class StringMapInt<AllocatorTy extends NativeMemory.Allocator>
extends StringMapImpl
implements Destructors.ClassWithDestructor {
    private AllocatorTy Allocator;
    private final int defaultValue;

    public StringMapInt(int defaultValue) {
        super(StringMapEntryInt.$sizeof_StringMapEntryInt());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapInt(long InitialSize, int defaultValue) {
        super(InitialSize, StringMapEntryInt.$sizeof_StringMapEntryInt());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapInt(AllocatorTy A, int defaultValue) {
        super(StringMapEntryInt.$sizeof_StringMapEntryInt());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapInt(long InitialSize, AllocatorTy A, int defaultValue) {
        super(InitialSize, StringMapEntryInt.$sizeof_StringMapEntryInt());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapInt(StringMapInt<AllocatorTy> RHS, int defaultValue) {
        super(StringMapEntryInt.$sizeof_StringMapEntryInt());
        this.defaultValue = defaultValue;
        if (!RHS.empty()) {
            throw new AssertionError((Object)"Copy ctor from non-empty stringmap not implemented yet!");
        }
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapInt(JavaDifferentiators.Move _dparam, StringMapInt<AllocatorTy> RHS) {
        super((StringMapImpl)std.move(RHS));
        this.Allocator = RHS.Allocator;
        this.defaultValue = RHS.defaultValue;
    }

    public StringMapInt<AllocatorTy> $assign(StringMapInt<AllocatorTy> RHS) {
        super.swap(RHS);
        AllocatorTy tmp = this.Allocator;
        this.Allocator = RHS.Allocator;
        RHS.Allocator = tmp;
        return this;
    }

    public AllocatorTy getAllocator() {
        return this.Allocator;
    }

    public StringMapIteratorInt begin() {
        return new StringMapIteratorInt(this.TheTable, 0, this.NumBuckets == 0);
    }

    public StringMapIteratorInt end() {
        return new StringMapIteratorInt(this.TheTable, this.NumBuckets, true);
    }

    public StringMapIteratorInt find(StringRef Key) {
        int Bucket = this.FindKey(Key);
        if (Bucket == -1) {
            return this.end();
        }
        return new StringMapIteratorInt(this.TheTable, Bucket, true);
    }

    public int lookup(StringRef Key) {
        return this.lookup(Key.data(), Key.size());
    }

    public int lookup(char.ptr Key, int KeyLen) {
        int Bucket = this.FindKey(Key, KeyLen);
        if (Bucket != -1) {
            return ((StringMapEntryInt)this.TheTable[Bucket]).getValue();
        }
        return Native.$tryClone((int)this.defaultValue);
    }

    public int $at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public int.ref ref$at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public int count(StringRef Key) {
        return this.FindKey(Key) == -1 ? 0 : 1;
    }

    public std.pairTypeBool<StringMapIteratorInt> insert(std.pairTypeInt<StringRef> KV) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = ((StringRef)KV.first).data();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = ((StringRef)KV.first).size(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapInt.getTombstoneVal()) {
            return std.make_pair((Object)new StringMapIteratorInt(this.TheTable, BucketNo, false), (boolean)false);
        }
        if (Bucket == StringMapInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket = StringMapEntryInt.Create(keyData, keyLength, FullHashValue, this.Allocator, (Integer)std.move((Object)KV.second));
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        BucketNo = this.RehashTable(BucketNo);
        return std.make_pair((Object)new StringMapIteratorInt(this.TheTable, BucketNo, false), (boolean)true);
    }

    public boolean insert(StringMapEntryInt KeyValue) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = KeyValue.getKeyData();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = KeyValue.getKeyLength(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapInt.getTombstoneVal()) {
            return false;
        }
        if (Bucket == StringMapInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket = KeyValue;
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.RehashTable();
        return true;
    }

    public void clear() {
        if (this.empty()) {
            return;
        }
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket = this.TheTable[I];
            this.TheTable[I] = null;
        }
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.Allocator.Reset();
    }

    public StringMapEntryInt GetOrCreateValue(StringRef Key, int Val) {
        return this.GetOrCreateValue(Key.data(), Key.size(), Val);
    }

    public StringMapEntryInt GetOrCreateValue(char.ptr Key, int Len, int Val) {
        int FullHashValue = llvm.HashString(Key, Len);
        int BucketNo = this.LookupBucketFor(Key, Len, FullHashValue);
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapInt.getTombstoneVal()) {
            return (StringMapEntryInt)Bucket;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((int)Val);
        }
        StringMapEntryInt NewItem = StringMapEntryInt.Create(Key, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (StringMapEntryInt)Bucket;
    }

    private StringMapEntryInt GetOrCreateValue(byte[] Key, int KeyStIndex, int Len, int Val) {
        int FullHashValue = llvm.HashString(Key, KeyStIndex, Len);
        int BucketNo = this.LookupBucketFor(Key, KeyStIndex, Len, FullHashValue);
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapInt.getTombstoneVal()) {
            return (StringMapEntryInt)Bucket;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((int)Val);
        }
        StringMapEntryInt NewItem = StringMapEntryInt.Create(Key, KeyStIndex, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (StringMapEntryInt)Bucket;
    }

    public StringMapEntryInt GetOrCreateValue(StringRef Key) {
        return this.GetOrCreateValue(Key, this.defaultValue);
    }

    public StringMapEntryInt GetOrCreateValue(char.ptr Key, int Len) {
        return this.GetOrCreateValue(Key, Len, this.defaultValue);
    }

    public StringMapEntryInt GetOrCreateValue(byte[] Key, int KeyStIndex, int Len) {
        return this.GetOrCreateValue(Key, KeyStIndex, Len, this.defaultValue);
    }

    public void remove(StringMapEntryInt KeyValue) {
        this.RemoveKey(KeyValue);
    }

    public void erase(StringMapIteratorInt I) {
        StringMapEntryInt V = I.$star();
        this.remove(V);
        V.Destroy(this.Allocator);
    }

    public boolean erase(StringRef Key) {
        StringMapIteratorInt I = this.find(Key);
        if (Native.$eq((abstract_iterator)I, (abstract_iterator)this.end())) {
            return false;
        }
        this.erase(I);
        return true;
    }

    public void $destroy() {
        this.clear();
        std.free((Object)this.TheTable);
        Destructors.$destroy(this.Allocator);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        StringMapIteratorInt B = this.begin();
        StringMapIteratorInt E = this.end();
        while (B.$noteq(E)) {
            out.append("{").append(B.$star().first()).append("=>").append(B.$star().getValue()).append("}\n");
            B.$preInc();
        }
        return out.toString();
    }
}

