/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.built_in;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorChar;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.FormattedNumber;
import org.llvm.support.FormattedString;
import org.llvm.support.format_object_base;
import org.llvm.support.llvm;

public abstract class raw_ostream
implements Destructors.ClassWithDestructor {
    private byte[] OutBufStart;
    private char.ptr OutBufStartCharPtr;
    private int OutBufStartIndex;
    private int OutBufEnd;
    private int OutBufCur;
    private BufferKind BufferMode;
    private static final byte[] NULL_ARRAY = NativePointer.new$char((int)0, (byte[])new byte[0]);
    private static final char.ptr NULL_BUF = NativePointer.create_char$ptr((byte[])NULL_ARRAY);
    private final char.ptr single_char = NativePointer.create_char$ptr((byte[])NativePointer.new$char$elem((byte)0));
    private static final int NUMBER_BUFFER_LENGTH = 20;
    private final char.ptr number_buffer = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)20, (byte[])new byte[0]));
    private static final String SPACES = "                                                                                ";
    private static final byte[] Spaces = "                                                                                ".getBytes();
    private static long NonOptimizedWriteBytesCalls = 0L;
    private static long NonOptimizedWriteBytesSize = 0L;

    private void $assign(raw_ostream $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private raw_ostream(raw_ostream $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    public raw_ostream() {
        this(false);
    }

    public raw_ostream(boolean unbuffered) {
        this.BufferMode = unbuffered ? BufferKind.Unbuffered : BufferKind.InternalBuffer;
        this.OutBufStartCharPtr = NULL_BUF;
        this.OutBufStart = this.OutBufStartCharPtr.$array();
        this.OutBufCur = this.OutBufStartIndex = this.OutBufStartCharPtr.$index();
        this.OutBufEnd = this.OutBufStartIndex;
    }

    public void $destroy() {
        assert (this.OutBufCur == this.OutBufStartIndex) : "raw_ostream destructor called with non-empty buffer!";
        if (this.BufferMode == BufferKind.InternalBuffer) {
            Destructors.$destroyArray((Object)this.OutBufStart);
            this.OutBufStartCharPtr = NULL_BUF;
            this.OutBufStart = this.OutBufStartCharPtr.$array();
            this.OutBufCur = this.OutBufStartIndex = this.OutBufStartCharPtr.$index();
            this.OutBufEnd = this.OutBufStartIndex;
        }
    }

    public long tell() {
        return this.current_pos() + (long)this.GetNumBytesInBuffer();
    }

    public void SetBuffered() {
        long Size = this.preferred_buffer_size();
        if (Size != 0L) {
            this.SetBufferSize(Size);
        } else {
            this.SetUnbuffered();
        }
    }

    public void SetBufferSize(long Size) {
        assert (Size >= 0L) : "forgot about unsigned conversion?";
        this.flush();
        this.SetBufferAndMode(NativePointer.create_char$ptr((byte[])NativePointer.new$char((long)Size, (byte[])new byte[0])), Size, BufferKind.InternalBuffer);
    }

    public long GetBufferSize() {
        if (this.BufferMode != BufferKind.Unbuffered && this.OutBufStart == NULL_ARRAY) {
            return this.preferred_buffer_size();
        }
        return this.OutBufEnd - this.OutBufStartIndex;
    }

    public void SetUnbuffered() {
        this.flush();
        this.SetBufferAndMode(null, 0L, BufferKind.Unbuffered);
    }

    public int GetNumBytesInBuffer() {
        return this.OutBufCur - this.OutBufStartIndex;
    }

    public void flush() {
        if (this.OutBufCur != this.OutBufStartIndex) {
            this.flush_nonempty();
        }
    }

    public raw_ostream $out(CharSequence Str) {
        return this.$out(new StringRef(Str));
    }

    public raw_ostream $out(boolean b) {
        return this.$out((byte)(b ? 49 : 48));
    }

    public raw_ostream $out(char C) {
        assert (C <= '\u00ff');
        return this.$out((byte)C);
    }

    public raw_ostream $out(short C) {
        assert (0 <= C && C <= 255);
        return this.$out((byte)C);
    }

    public raw_ostream $out(byte C) {
        if (this.OutBufCur >= this.OutBufEnd) {
            return this.write(C);
        }
        this.OutBufStart[this.OutBufCur++] = C;
        return this;
    }

    public raw_ostream $out(long N) {
        if (N == 0L) {
            return this.$out('0');
        }
        if (N < 0L) {
            this.$out('-');
            N = -N;
        }
        int CurPtr = 20;
        while (N != 0L) {
            this.number_buffer.$set(--CurPtr, (byte)(48 + (byte)(N % 10L)));
            N /= 10L;
        }
        return this.write(this.number_buffer, CurPtr, 20 - CurPtr);
    }

    public raw_ostream $out(int N) {
        return this.$out((long)N);
    }

    public raw_ostream $out(double N) {
        return this.$out(llvm.format("%e", Double.valueOf(N)));
    }

    public raw_ostream $out_char(byte C) {
        if (this.OutBufCur >= this.OutBufEnd) {
            return this.write(C);
        }
        this.OutBufStart[this.OutBufCur++] = C;
        return this;
    }

    public raw_ostream $out_uchar(short C) {
        if (this.OutBufCur >= this.OutBufEnd) {
            return this.write((byte)C);
        }
        this.OutBufStart[this.OutBufCur++] = (byte)C;
        return this;
    }

    public raw_ostream $out_schar(byte C) {
        if (this.OutBufCur >= this.OutBufEnd) {
            return this.write(C);
        }
        this.OutBufStart[this.OutBufCur++] = C;
        return this;
    }

    public raw_ostream $out(StringRef Str) {
        int Size = Str.size();
        if ((long)Size > (long)(this.OutBufEnd - this.OutBufCur)) {
            return this.write(Str.data(), (long)Size);
        }
        std.memcpy((byte[])this.OutBufStart, (int)this.OutBufCur, (char.ptr)Str.data(), (int)0, (int)Size);
        this.OutBufCur += Size;
        return this;
    }

    public raw_ostream $out(char.ptr Str) {
        return this.$out(new StringRef(Str));
    }

    public raw_ostream $out(std.string Str) {
        return this.write(Str.data(), (long)Str.length());
    }

    public raw_ostream $out_ulong(long N) {
        if (N == 0L) {
            return this.$out_char(NativePointer.$((char)'0'));
        }
        byte[] NumberBuffer = NativePointer.new$char((int)20, (byte[])new byte[0]);
        char.ptr EndPtr = NativePointer.create_char$ptr((byte[])NumberBuffer, (long)20L);
        char.ptr CurPtr = Native.$tryClone((char.ptr)EndPtr);
        while (N != 0L) {
            ((char.ptr)CurPtr.$preDec()).$set((byte)(NativePointer.$((char)'0') + (byte)(N % 10L)));
            N /= 10L;
        }
        return this.write(CurPtr, (long)EndPtr.$sub((abstract_iterator)CurPtr));
    }

    public raw_ostream $out_long(long N) {
        if (N < 0L) {
            this.$out_char(NativePointer.$((char)'-'));
            N = -N;
        }
        return this.$out_ulong(N);
    }

    public raw_ostream $out_ullong(long N) {
        if (N >= 0L) {
            return this.$out_ulong(N);
        }
        assert (false) : "JAVA: implement it using BigInteger (was fixing SA_LOCAL_SELF_COMPARISON)";
        byte[] NumberBuffer = NativePointer.new$char((int)20, (byte[])new byte[0]);
        char.ptr EndPtr = NativePointer.create_char$ptr((byte[])NumberBuffer, (long)20L);
        char.ptr CurPtr = Native.$tryClone((char.ptr)EndPtr);
        while (N != 0L) {
            ((char.ptr)CurPtr.$preDec()).$set((byte)(NativePointer.$((char)'0') + (byte)(N % 10L)));
            N /= 10L;
        }
        return this.write(CurPtr, (long)EndPtr.$sub((abstract_iterator)CurPtr));
    }

    public raw_ostream $out_llong(long N) {
        if (N < 0L) {
            this.$out_char(NativePointer.$((char)'-'));
            N = -N;
        }
        return this.$out_ullong(N);
    }

    public raw_ostream $out(Object P) {
        this.$out_char(NativePointer.$((char)'0')).$out_char(NativePointer.$((char)'x'));
        return this.write_hex(Casts.reinterpret_cast_long((Object)P));
    }

    public raw_ostream $out_uint(long N) {
        return this.$out_ulong(N);
    }

    public raw_ostream $out_int(int N) {
        return this.$out_long(N);
    }

    public raw_ostream $out_double(double N) {
        return this.$out(llvm.format(NativePointer.$((String)"%e"), Double.valueOf(N)));
    }

    public raw_ostream $out(format_object_base Fmt) {
        SmallVectorImplChar V = null;
        try {
            long BytesUsed;
            long NextBufferSize = 127L;
            long BufferBytesLeft = this.OutBufEnd - this.OutBufCur;
            if (BufferBytesLeft > 3L) {
                BytesUsed = Fmt.print(this.OutBufStart, this.OutBufCur, (int)BufferBytesLeft);
                if (BytesUsed <= BufferBytesLeft) {
                    this.OutBufCur = (int)((long)this.OutBufCur + BytesUsed);
                    raw_ostream raw_ostream2 = this;
                    return raw_ostream2;
                }
                NextBufferSize = BytesUsed;
            }
            V = new SmallVectorChar(128);
            while (true) {
                V.resize(NextBufferSize);
                BytesUsed = Fmt.print(V.data(), (int)NextBufferSize);
                if (BytesUsed <= NextBufferSize) {
                    raw_ostream raw_ostream3 = this.write(V.data(), BytesUsed);
                    return raw_ostream3;
                }
                assert (BytesUsed > NextBufferSize) : "Didn't grow buffer!?";
                NextBufferSize = BytesUsed;
            }
        }
        finally {
            if (V != null) {
                V.$destroy();
            }
        }
    }

    public raw_ostream $out(FormattedString FS) {
        long Len = FS.Str.size();
        long PadAmount = FS.Width - Len;
        if (FS.RightJustify && PadAmount > 0L) {
            this.indent(PadAmount);
        }
        this.$out(new StringRef(FS.Str));
        if (!FS.RightJustify && PadAmount > 0L) {
            this.indent(PadAmount);
        }
        return this;
    }

    public raw_ostream $out(FormattedNumber FN) {
        long N;
        if (FN.Hex) {
            long N2;
            long Nibbles = (64 - llvm.countLeadingZeros_uint64_t_ZeroBehavior(FN.HexValue) + 3) / 4;
            long Width = FN.Width > Nibbles + 2L ? FN.Width : Nibbles + 2L;
            byte[] NumberBuffer = NativePointer.new$char((int)20, (byte[])new byte[]{NativePointer.$((char)'0'), NativePointer.$((char)'x'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0'), NativePointer.$((char)'0')});
            char.ptr EndPtr = NativePointer.create_char$ptr((byte[])NumberBuffer, (long)Width);
            char.ptr CurPtr = Native.$tryClone((char.ptr)EndPtr);
            byte A = FN.Upper ? NativePointer.$((char)'A') : NativePointer.$((char)'a');
            assert (N2 >= 0L) : "JAVA: N is unsigned in Clang here";
            for (N2 = FN.HexValue; N2 != 0L; N2 /= 16L) {
                long x = N2 % 16L;
                ((char.ptr)CurPtr.$preDec()).$set(x < 10L ? (byte)((long)NativePointer.$((char)'0') + x) : (byte)((long)A + x - 10L));
            }
            return this.write(NumberBuffer, 0L, Width);
        }
        if (FN.DecValue == 0L) {
            this.indent(FN.Width - 1L);
            return this.$out_char(NativePointer.$((char)'0'));
        }
        byte[] NumberBuffer = NativePointer.new$char((int)32, (byte[])new byte[0]);
        char.ptr EndPtr = NativePointer.create_char$ptr((byte[])NumberBuffer, (long)32L);
        char.ptr CurPtr = Native.$tryClone((char.ptr)EndPtr);
        boolean Neg = FN.DecValue < 0L;
        long l = N = Neg ? -FN.DecValue : FN.DecValue;
        while (N != 0L) {
            ((char.ptr)CurPtr.$preDec()).$set((byte)(NativePointer.$((char)'0') + (byte)(N % 10L)));
            N /= 10L;
        }
        int Len = EndPtr.$sub((abstract_iterator)CurPtr);
        long Pad = FN.Width - (long)Len;
        if (Neg) {
            --Pad;
        }
        if (Pad > 0L) {
            this.indent(Pad);
        }
        if (Neg) {
            this.$out_char(NativePointer.$((char)'-'));
        }
        return this.write(CurPtr, (long)Len);
    }

    public raw_ostream write_hex(long N) {
        assert (N >= 0L) : "forgot about unsigned conversion?";
        if (N == 0L) {
            return this.$out('0');
        }
        int CurPtr = 20;
        while (N != 0L) {
            long x = N % 16L;
            this.number_buffer.$set(--CurPtr, (byte)(x < 10L ? 48L + x : 97L + x - 10L));
            N /= 16L;
        }
        return this.write(this.number_buffer, CurPtr, 20 - CurPtr);
    }

    public raw_ostream write_escaped(StringRef Str) {
        return this.write_escaped(Str, false);
    }

    public raw_ostream write_escaped(StringRef Str, boolean UseHexEscapes) {
        long e = Str.size();
        block6: for (long i = 0L; i != e; ++i) {
            char c = Casts.$char((byte)Str.$at(i));
            switch (c) {
                case '\\': {
                    this.$out('\\').$out('\\');
                    continue block6;
                }
                case '\t': {
                    this.$out('\\').$out('t');
                    continue block6;
                }
                case '\n': {
                    this.$out('\\').$out('n');
                    continue block6;
                }
                case '\"': {
                    this.$out('\\').$out('\"');
                    continue block6;
                }
                default: {
                    if (std.isprint((int)c) != 0) {
                        this.$out(c);
                        continue block6;
                    }
                    if (UseHexEscapes) {
                        this.$out('\\').$out('x');
                        this.$out(llvm.hexdigit(c >> 4 & 0xF));
                        this.$out(llvm.hexdigit(c >> 0 & 0xF));
                        continue block6;
                    }
                    this.$out('\\');
                    this.$out((byte)(48 + (c >> 6 & 7)));
                    this.$out((byte)(48 + (c >> 3 & 7)));
                    this.$out((byte)(48 + (c >> 0 & 7)));
                }
            }
        }
        return this;
    }

    public raw_ostream write(byte C) {
        if (built_in.__builtin_expect((this.OutBufCur >= this.OutBufEnd ? 1 : 0) != 0, (boolean)false) != 0) {
            if (built_in.__builtin_expect((this.OutBufStart == NULL_ARRAY ? 1 : 0) != 0, (boolean)false) != 0) {
                if (this.BufferMode == BufferKind.Unbuffered) {
                    this.single_char.$set(0, C);
                    this.write_impl(this.single_char, 0, 1);
                    return this;
                }
                this.SetBuffered();
                return this.write(C);
            }
            this.flush_nonempty();
        }
        this.OutBufStart[this.OutBufCur++] = C;
        return this;
    }

    public raw_ostream write(CharSequence Str, long Size) {
        return this.write(NativePointer.create_char$ptr((CharSequence)Str), 0, (int)Size);
    }

    public raw_ostream write(CharSequence Str, int Size) {
        return this.write(NativePointer.create_char$ptr((CharSequence)Str), 0, Size);
    }

    public raw_ostream write(byte[] Ptr, long PtrIdx, long Size) {
        return this.writeBytes(Ptr, (int)PtrIdx, (int)Size);
    }

    private raw_ostream writeBytes(byte[] Ptr, int PtrIdx, int Size) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        if (built_in.__builtin_expect(((long)(this.OutBufEnd - this.OutBufCur) < (long)Size ? 1 : 0) != 0, (boolean)false) != 0) {
            if (built_in.__builtin_expect((this.OutBufStart == NULL_ARRAY ? 1 : 0) != 0, (boolean)false) != 0) {
                if (this.BufferMode == BufferKind.Unbuffered) {
                    this.write_impl(Ptr, PtrIdx, Size);
                    return this;
                }
                this.SetBuffered();
                return this.writeBytes(Ptr, PtrIdx, Size);
            }
            int NumBytes = this.OutBufEnd - this.OutBufCur;
            if (built_in.__builtin_expect((this.OutBufCur == this.OutBufStartIndex ? 1 : 0) != 0, (boolean)false) != 0) {
                assert (NumBytes != 0) : "undefined behavior";
                int BytesToWrite = Size - Size % NumBytes;
                this.write_impl(Ptr, PtrIdx, BytesToWrite);
                int BytesRemaining = Size - BytesToWrite;
                if ((long)BytesRemaining > (long)(this.OutBufEnd - this.OutBufCur)) {
                    return this.writeBytes(Ptr, PtrIdx + BytesToWrite, BytesRemaining);
                }
                this.copy_to_buffer(Ptr, PtrIdx + BytesToWrite, BytesRemaining);
                return this;
            }
            this.copy_to_buffer(Ptr, PtrIdx, NumBytes);
            this.flush_nonempty();
            return this.writeBytes(Ptr, PtrIdx + NumBytes, Size - NumBytes);
        }
        this.copy_to_buffer(Ptr, PtrIdx, Size);
        return this;
    }

    public raw_ostream write(char.ptr Ptr, long Size) {
        return this.write(Ptr, 0, (int)Size);
    }

    public raw_ostream write(char.ptr Ptr, int PtrIdx, int Size) {
        if (Native.$is_array_based((char.ptr)Ptr)) {
            return this.writeBytes(Ptr.$array(), Ptr.$index() + PtrIdx, Size);
        }
        return this.writeCharPtr(Ptr, PtrIdx, Size);
    }

    private raw_ostream writeCharPtr(char.ptr Ptr, int PtrIdx, int Size) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        if (built_in.__builtin_expect(((long)(this.OutBufEnd - this.OutBufCur) < (long)Size ? 1 : 0) != 0, (boolean)false) != 0) {
            if (built_in.__builtin_expect((this.OutBufStart == NULL_ARRAY ? 1 : 0) != 0, (boolean)false) != 0) {
                if (this.BufferMode == BufferKind.Unbuffered) {
                    this.write_impl(Ptr, PtrIdx, Size);
                    return this;
                }
                this.SetBuffered();
                return this.write(Ptr, PtrIdx, Size);
            }
            int NumBytes = this.OutBufEnd - this.OutBufCur;
            if (built_in.__builtin_expect((this.OutBufCur == this.OutBufStartIndex ? 1 : 0) != 0, (boolean)false) != 0) {
                assert (NumBytes != 0) : "undefined behavior";
                int BytesToWrite = Size - Size % NumBytes;
                this.write_impl(Ptr, PtrIdx, BytesToWrite);
                int BytesRemaining = Size - BytesToWrite;
                if ((long)BytesRemaining > (long)(this.OutBufEnd - this.OutBufCur)) {
                    return this.write(Ptr, PtrIdx + BytesToWrite, BytesRemaining);
                }
                this.copy_to_buffer(Ptr, PtrIdx + BytesToWrite, BytesRemaining);
                return this;
            }
            this.copy_to_buffer(Ptr, PtrIdx, NumBytes);
            this.flush_nonempty();
            return this.write(Ptr, PtrIdx + NumBytes, Size - NumBytes);
        }
        this.copy_to_buffer(Ptr, PtrIdx, Size);
        return this;
    }

    public raw_ostream indent(long NumSpaces) {
        assert (NumSpaces >= 0L) : "forgot about unsigned conversion?";
        if (NumSpaces < (long)llvm.array_lengthof(SPACES)) {
            return this.writeBytes(Spaces, 0, (int)NumSpaces);
        }
        while (NumSpaces != 0L) {
            int NumToWrite = std.min((int)((int)NumSpaces), (int)(llvm.array_lengthof(SPACES) - 1));
            this.writeBytes(Spaces, 0, NumToWrite);
            NumSpaces -= (long)NumToWrite;
        }
        return this;
    }

    public raw_ostream changeColor(Colors Color) {
        return this.changeColor(Color, false, false);
    }

    public raw_ostream changeColor(Colors Color, boolean Bold) {
        return this.changeColor(Color, Bold, false);
    }

    public raw_ostream changeColor(Colors Color, boolean Bold, boolean BG) {
        return this;
    }

    public raw_ostream resetColor() {
        return this;
    }

    public raw_ostream reverseColor() {
        return this;
    }

    public boolean is_displayed() {
        return false;
    }

    public boolean has_colors() {
        return this.is_displayed();
    }

    protected abstract void write_impl(char.ptr var1, int var2, int var3);

    protected void write_impl(byte[] Ptr, int PtrIdx, int Size) {
        raw_ostream.trackNonOptimizedWriteBytes(Size);
        this.write_impl(NativePointer.create_char$ptr((byte[])Ptr), PtrIdx, Size);
    }

    protected void handle() {
    }

    protected abstract long current_pos();

    protected void SetBuffer(char.ptr BufferStart, long Size) {
        this.SetBufferAndMode(BufferStart, Size, BufferKind.ExternalBuffer);
    }

    protected long preferred_buffer_size() {
        return 1024L;
    }

    protected char.ptr getBufferStart() {
        return this.OutBufStartCharPtr == NULL_BUF ? null : this.OutBufStartCharPtr;
    }

    private void SetBufferAndMode(char.ptr BufferStart, long Size, BufferKind Mode) {
        assert (Size >= 0L) : "forgot about unsigned conversion?";
        assert (Mode == BufferKind.Unbuffered && BufferStart == null && Size == 0L || Mode != BufferKind.Unbuffered && BufferStart != null && Size != 0L) : "stream must be unbuffered or have at least one byte";
        assert (this.GetNumBytesInBuffer() == 0) : "Current buffer is non-empty!";
        if (this.BufferMode == BufferKind.InternalBuffer) {
            Destructors.$destroyArray((Object)this.OutBufStart);
            this.OutBufStartCharPtr = NULL_BUF;
            this.OutBufStart = NULL_ARRAY;
        }
        char.ptr ptr2 = this.OutBufStartCharPtr = BufferStart == null ? NULL_BUF : BufferStart;
        assert (this.OutBufStartCharPtr.$array() != null);
        this.OutBufStart = this.OutBufStartCharPtr.$array();
        this.OutBufCur = this.OutBufStartIndex = this.OutBufStartCharPtr.$index();
        this.OutBufEnd = this.OutBufStartIndex + (int)Size;
        this.BufferMode = Mode;
        assert (this.OutBufStartIndex <= this.OutBufEnd) : "Invalid size!";
    }

    private void flush_nonempty() {
        assert (this.OutBufCur > this.OutBufStartIndex) : "Invalid call to flush_nonempty.";
        int Length = this.OutBufCur - this.OutBufStartIndex;
        this.OutBufCur = this.OutBufStartIndex;
        this.write_impl(this.OutBufStart, this.OutBufCur, Length);
    }

    private void copy_to_buffer(char.ptr Ptr, int PtrIdx, int Size) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        assert (Size <= this.OutBufEnd - this.OutBufCur) : "Buffer overrun!";
        std.memcpy((byte[])this.OutBufStart, (int)this.OutBufCur, (char.ptr)Ptr, (int)PtrIdx, (int)Size);
        this.OutBufCur += Size;
    }

    private void copy_to_buffer(byte[] Ptr, int PtrIdx, int Size) {
        assert (Size >= 0) : "forgot about unsigned conversion?";
        assert (Size <= this.OutBufEnd - this.OutBufCur) : "Buffer overrun!";
        std.memcpy((byte[])this.OutBufStart, (int)this.OutBufCur, (byte[])Ptr, (int)PtrIdx, (int)Size);
        this.OutBufCur += Size;
    }

    public String toString() {
        return "raw_ostream{BufferMode=" + (Object)((Object)this.BufferMode) + "\nStart=" + NativePointer.create_char$ptr((byte[])this.OutBufStart) + "\nCur=" + this.OutBufCur + "End=" + this.OutBufEnd + '}';
    }

    private static void trackNonOptimizedWriteBytes(int Size) {
        if (NativeTrace.STATISTICS) {
            ++NonOptimizedWriteBytesCalls;
            NonOptimizedWriteBytesSize += (long)Size;
        }
    }

    public static void clearStatistics() {
        NonOptimizedWriteBytesCalls = 0L;
        NonOptimizedWriteBytesSize = 0L;
    }

    public static void PrintStats(raw_ostream out) {
        out.$out(String.format("%22s called:\t", "slow write_impl(byte[])")).$out(NativeTrace.formatNumber((long)NonOptimizedWriteBytesCalls)).$out(".\n");
        out.$out(String.format("%22s  Bytes:\t", "slow write_impl(byte[])")).$out(NativeTrace.formatNumber((long)NonOptimizedWriteBytesSize)).$out(".\n");
    }

    public static final class Colors
    extends Enum<Colors> {
        public static final /* enum */ Colors BLACK = new Colors(0L);
        public static final /* enum */ Colors RED = new Colors(1L);
        public static final /* enum */ Colors GREEN = new Colors(2L);
        public static final /* enum */ Colors YELLOW = new Colors(3L);
        public static final /* enum */ Colors BLUE = new Colors(4L);
        public static final /* enum */ Colors MAGENTA = new Colors(5L);
        public static final /* enum */ Colors CYAN = new Colors(6L);
        public static final /* enum */ Colors WHITE = new Colors(7L);
        public static final /* enum */ Colors SAVEDCOLOR = new Colors(8L);
        private final int value;
        private static final /* synthetic */ Colors[] $VALUES;

        public static Colors[] values() {
            return (Colors[])$VALUES.clone();
        }

        public static Colors valueOf(String name) {
            return Enum.valueOf(Colors.class, name);
        }

        public static Colors valueOf(int val) {
            Colors out;
            Colors colors = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Colors(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Colors[]{BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE, SAVEDCOLOR};
        }

        private static final class Values {
            private static final Colors[] VALUES;
            private static final Colors[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Colors kind : Colors.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Colors[min < 0 ? 1 - min : 0];
                VALUES = new Colors[max >= 0 ? 1 + max : 0];
                for (Colors kind : Colors.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Colors)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Colors)kind).value] = kind;
                }
            }
        }
    }

    private static final class BufferKind
    extends Enum<BufferKind> {
        public static final /* enum */ BufferKind Unbuffered = new BufferKind(0L);
        public static final /* enum */ BufferKind InternalBuffer = new BufferKind(1L);
        public static final /* enum */ BufferKind ExternalBuffer = new BufferKind(2L);
        private final int value;
        private static final /* synthetic */ BufferKind[] $VALUES;

        public static BufferKind[] values() {
            return (BufferKind[])$VALUES.clone();
        }

        public static BufferKind valueOf(String name) {
            return Enum.valueOf(BufferKind.class, name);
        }

        public static BufferKind valueOf(int val) {
            BufferKind out;
            BufferKind bufferKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private BufferKind(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new BufferKind[]{Unbuffered, InternalBuffer, ExternalBuffer};
        }

        private static final class Values {
            private static final BufferKind[] VALUES;
            private static final BufferKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (BufferKind kind : BufferKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new BufferKind[min < 0 ? 1 - min : 0];
                VALUES = new BufferKind[max >= 0 ? 1 + max : 0];
                for (BufferKind kind : BufferKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((BufferKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((BufferKind)kind).value] = kind;
                }
            }
        }
    }
}

