/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys;

import org.clank.java.io;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.aliases.long;
import org.clank.support.aliases.uint;

public class TimeValue
implements Native.NativeComparable<TimeValue> {
    private static long PosixZeroTimeSeconds = -946684800L;
    private static long Win32ZeroTimeSeconds = -12591158400L;
    public static TimeValue MinTime = new TimeValue(Long.MIN_VALUE, 0);
    public static TimeValue MaxTime = new TimeValue(Long.MAX_VALUE, 0);
    public static TimeValue ZeroTime = new TimeValue(0L, 0);
    public static TimeValue PosixZeroTime = new TimeValue(PosixZeroTimeSeconds, 0);
    public static TimeValue Win32ZeroTime = new TimeValue(Win32ZeroTimeSeconds, 0);
    private long seconds_;
    private int nanos_;

    public TimeValue() {
        this.seconds_ = 0L;
        this.nanos_ = 0;
    }

    public TimeValue(long seconds) {
        this(seconds, 0);
    }

    public TimeValue(long seconds, int nanos) {
        this.seconds_ = seconds;
        this.nanos_ = nanos;
        this.normalize();
    }

    public TimeValue(double new_time) {
        long integer_part;
        this.seconds_ = 0L;
        this.nanos_ = 0;
        this.seconds_ = integer_part = (long)new_time;
        this.nanos_ = (int)((new_time - (double)integer_part) * (double)TimeConversions.NANOSECONDS_PER_SECOND.getValue());
        this.normalize();
    }

    public static TimeValue now() {
        io.timeval the_time = new io.timeval();
        the_time.tv_usec = 0L;
        the_time.tv_sec = 0L;
        if (0 != io.gettimeofday((io.timeval)the_time, null)) {
            return MinTime;
        }
        return new TimeValue(the_time.tv_sec + PosixZeroTimeSeconds, (int)(the_time.tv_usec * (long)TimeConversions.NANOSECONDS_PER_MICROSECOND.getValue()));
    }

    public TimeValue $addassign(TimeValue that) {
        this.seconds_ += that.seconds_;
        this.nanos_ += that.nanos_;
        this.normalize();
        return this;
    }

    public TimeValue $minusassign(TimeValue that) {
        this.seconds_ -= that.seconds_;
        this.nanos_ -= that.nanos_;
        this.normalize();
        return this;
    }

    public int $less(TimeValue that) {
        return that.$greater(this);
    }

    public int $greater(TimeValue that) {
        if (this.seconds_ > that.seconds_) {
            return 1;
        }
        if (this.seconds_ == that.seconds_ && this.nanos_ > that.nanos_) {
            return 1;
        }
        return 0;
    }

    public int $lesseq(TimeValue that) {
        return that.$greatereq(this);
    }

    public int $greatereq(TimeValue that) {
        if (this.seconds_ > that.seconds_) {
            return 1;
        }
        if (this.seconds_ == that.seconds_ && this.nanos_ >= that.nanos_) {
            return 1;
        }
        return 0;
    }

    public boolean $eq(TimeValue that) {
        return this.seconds_ == that.seconds_ && this.nanos_ == that.nanos_;
    }

    public boolean $noteq(TimeValue that) {
        return !this.$eq(that);
    }

    public long seconds() {
        return this.seconds_;
    }

    public int nanoseconds() {
        return this.nanos_;
    }

    public long microseconds() {
        return this.nanos_ / TimeConversions.NANOSECONDS_PER_MICROSECOND.getValue();
    }

    public long milliseconds() {
        return this.nanos_ / TimeConversions.NANOSECONDS_PER_MILLISECOND.getValue();
    }

    public long usec() {
        return this.seconds_ * (long)TimeConversions.MICROSECONDS_PER_SECOND.getValue() + (long)(this.nanos_ / TimeConversions.NANOSECONDS_PER_MICROSECOND.getValue());
    }

    public long msec() {
        return this.seconds_ * (long)TimeConversions.MILLISECONDS_PER_SECOND.getValue() + (long)(this.nanos_ / TimeConversions.NANOSECONDS_PER_MILLISECOND.getValue());
    }

    public long toPosixTime() {
        long result = this.seconds_ - PosixZeroTimeSeconds;
        return result += (long)(this.nanos_ / TimeConversions.NANOSECONDS_PER_POSIX_TICK.getValue());
    }

    public long toEpochTime() {
        return this.seconds_ - PosixZeroTimeSeconds;
    }

    public long toWin32Time() {
        long result = 10000000L * (this.seconds_ - Win32ZeroTimeSeconds);
        return result += (long)(this.nanos_ / TimeConversions.NANOSECONDS_PER_WIN32_TICK.getValue());
    }

    public void getTimespecTime(long.ref seconds, uint.ref nanos) {
        seconds.$set(this.seconds_ - PosixZeroTimeSeconds);
        nanos.$set((long)this.nanos_);
    }

    public std.string str() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public void seconds(long sec) {
        this.seconds_ = sec;
        this.normalize();
    }

    public void nanoseconds(int nanos) {
        this.nanos_ = nanos;
        this.normalize();
    }

    public void microseconds(int micros) {
        this.nanos_ = micros * TimeConversions.NANOSECONDS_PER_MICROSECOND.getValue();
        this.normalize();
    }

    public void milliseconds(int millis) {
        this.nanos_ = millis * TimeConversions.NANOSECONDS_PER_MILLISECOND.getValue();
        this.normalize();
    }

    public void usec(long microseconds) {
        this.seconds_ = microseconds / (long)TimeConversions.MICROSECONDS_PER_SECOND.getValue();
        this.nanos_ = (int)(microseconds % (long)TimeConversions.MICROSECONDS_PER_SECOND.getValue()) * TimeConversions.NANOSECONDS_PER_MICROSECOND.getValue();
        this.normalize();
    }

    public void msec(long milliseconds) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public void fromEpochTime(long seconds) {
        this.seconds_ = seconds + PosixZeroTimeSeconds;
        this.nanos_ = 0;
        this.normalize();
    }

    public void fromWin32Time(long win32Time) {
        this.seconds_ = win32Time / 10000000L + Win32ZeroTimeSeconds;
        this.nanos_ = (int)(win32Time % 10000000L) * 100;
    }

    private void normalize() {
        if (this.nanos_ >= TimeConversions.NANOSECONDS_PER_SECOND.getValue()) {
            do {
                ++this.seconds_;
                this.nanos_ -= TimeConversions.NANOSECONDS_PER_SECOND.getValue();
            } while (this.nanos_ >= TimeConversions.NANOSECONDS_PER_SECOND.getValue());
        } else if (this.nanos_ <= -TimeConversions.NANOSECONDS_PER_SECOND.getValue()) {
            do {
                --this.seconds_;
                this.nanos_ += TimeConversions.NANOSECONDS_PER_SECOND.getValue();
            } while (this.nanos_ <= -TimeConversions.NANOSECONDS_PER_SECOND.getValue());
        }
        if (this.seconds_ >= 1L && this.nanos_ < 0) {
            --this.seconds_;
            this.nanos_ += TimeConversions.NANOSECONDS_PER_SECOND.getValue();
        } else if (this.seconds_ < 0L && this.nanos_ > 0) {
            ++this.seconds_;
            this.nanos_ -= TimeConversions.NANOSECONDS_PER_SECOND.getValue();
        }
    }

    public TimeValue(TimeValue $Prm0) {
        this.seconds_ = $Prm0.seconds_;
        this.nanos_ = $Prm0.nanos_;
    }

    public static final class TimeConversions
    extends Enum<TimeConversions> {
        public static final /* enum */ TimeConversions NANOSECONDS_PER_SECOND = new TimeConversions(1000000000L);
        public static final /* enum */ TimeConversions MICROSECONDS_PER_SECOND = new TimeConversions(1000000L);
        public static final /* enum */ TimeConversions MILLISECONDS_PER_SECOND = new TimeConversions(1000L);
        public static final /* enum */ TimeConversions NANOSECONDS_PER_MICROSECOND = new TimeConversions(1000L);
        public static final /* enum */ TimeConversions NANOSECONDS_PER_MILLISECOND = new TimeConversions(1000000L);
        public static final /* enum */ TimeConversions NANOSECONDS_PER_POSIX_TICK = new TimeConversions(100L);
        public static final /* enum */ TimeConversions NANOSECONDS_PER_WIN32_TICK = new TimeConversions(100L);
        private final int value;
        private static final /* synthetic */ TimeConversions[] $VALUES;

        public static TimeConversions[] values() {
            return (TimeConversions[])$VALUES.clone();
        }

        public static TimeConversions valueOf(String name) {
            return Enum.valueOf(TimeConversions.class, name);
        }

        public static TimeConversions valueOf(int val) {
            TimeConversions out;
            TimeConversions timeConversions = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private TimeConversions(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new TimeConversions[]{NANOSECONDS_PER_SECOND, MICROSECONDS_PER_SECOND, MILLISECONDS_PER_SECOND, NANOSECONDS_PER_MICROSECOND, NANOSECONDS_PER_MILLISECOND, NANOSECONDS_PER_POSIX_TICK, NANOSECONDS_PER_WIN32_TICK};
        }

        private static final class Values {
            private static final TimeConversions[] VALUES;
            private static final TimeConversions[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (TimeConversions kind : TimeConversions.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new TimeConversions[min < 0 ? 1 - min : 0];
                VALUES = new TimeConversions[max >= 0 ? 1 + max : 0];
                for (TimeConversions kind : TimeConversions.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((TimeConversions)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((TimeConversions)kind).value] = kind;
                }
            }
        }
    }
}

