/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys;

import java.util.Comparator;
import org.clank.java.io;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.long;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoObject;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.RefCountedBase;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.impl.PathStatics;
import org.llvm.support.llvm;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.path;

public final class fs {
    public static final DenseMapInfo<UniqueID> DenseMapInfoUnqieID = new DenseMapInfoObject<UniqueID>(new UniqueID(-1L, 0L), new UniqueID(-1L, -1L));

    public static perms $bitor_perms(perms l, perms r) {
        return new perms(fs.$bitor_perms(l.value, r.value));
    }

    public static int $bitor_perms(int l, int r) {
        return (char)l | (char)r;
    }

    public static perms $bitand_perms(perms l, perms r) {
        return new perms((char)l.value & (char)r.value);
    }

    public static perms $orassign_perms(perms l, perms r) {
        l = fs.$bitor_perms(l, r);
        return l;
    }

    public static perms $andassign_perms(perms l, perms r) {
        l = fs.$bitand_perms(l, r);
        return l;
    }

    public static perms $bitnot_perms(perms x) {
        return new perms(~((char)x.value));
    }

    public static std_errors.error_code make_absolute(SmallString path2) {
        StringRef p = new StringRef(path2.data(), path2.size());
        boolean rootDirectory = path.has_root_directory(p);
        boolean rootName = true;
        rootName = llvm.LLVM_ON_WIN32 || NativeTrace.UNIT_TEST_MODE ? path.has_root_name(p) : true;
        if (rootName && rootDirectory) {
            return std_errors.error_code.success();
        }
        SmallString current_dir = new SmallString(128);
        std_errors.error_code ec = fs.current_path(current_dir);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        if (!rootName && !rootDirectory) {
            path.append(current_dir, p);
            path2.swap(current_dir);
            return std_errors.error_code.success();
        }
        if (!rootName && rootDirectory) {
            StringRef cdrn = path.root_name(current_dir.$StringRef());
            SmallString curDirRootName = new SmallString(cdrn.begin(), cdrn.end(), 128);
            path.append(curDirRootName, p);
            path2.swap(curDirRootName);
            return std_errors.error_code.success();
        }
        if (rootName && !rootDirectory) {
            StringRef pRootName = path.root_name(p);
            StringRef bRootDirectory = path.root_directory(current_dir.$StringRef());
            StringRef bRelativePath = path.relative_path(current_dir.$StringRef());
            StringRef pRelativePath = path.relative_path(p);
            SmallString res = new SmallString(128);
            path.append(res, pRootName, bRootDirectory, bRelativePath, pRelativePath);
            path2.swap(res);
            return std_errors.error_code.success();
        }
        llvm.llvm_unreachable_internal("All rootName and rootDirectory combinations should have occurred above!");
        throw new IllegalStateException();
    }

    public static std_errors.error_code create_directories(Twine path2, bool.ref existed) {
        SmallString path_storage = new SmallString(128);
        StringRef p = path2.toStringRef(path_storage);
        StringRef parent = path.parent_path(p);
        if (!parent.empty()) {
            bool.ref parent_exists = NativePointer.create_bool$ref();
            std_errors.error_code ec = fs.exists(new Twine(parent), parent_exists);
            if (ec.$Void2Void() != null) {
                return ec;
            }
            if (!parent_exists.$deref() && (ec = fs.create_directories(new Twine(parent), existed)).$Void2Void() != null) {
                return ec;
            }
        }
        return fs.create_directory(new Twine(p), existed);
    }

    public static std_errors.error_code create_directories(Twine Path2) {
        bool.ref Existed = NativePointer.create_bool$ref();
        return fs.create_directories(Path2, Existed);
    }

    public static std_errors.error_code create_directory(Twine path2, bool.ref existed) {
        SmallString path_storage = new SmallString(128);
        StringRef p = path2.toNullTerminatedStringRef(path_storage);
        if (std.mkdir((char.iterator)p.begin(), (int)504) == -1) {
            if (std.errno() != std_errors.errc.file_exists.getValue()) {
                return new std_errors.error_code(std.errno(), std.system_category());
            }
            existed.$set(true);
        } else {
            existed.$set(false);
        }
        return std_errors.error_code.success();
    }

    public static std_errors.error_code create_directory(Twine Path2) {
        bool.ref Existed = NativePointer.create_bool$ref();
        return fs.create_directory(Path2, Existed);
    }

    public static std_errors.error_code create_hard_link(Twine to, Twine from) {
        SmallString from_storage = new SmallString(128);
        SmallString to_storage = new SmallString(128);
        StringRef f = from.toNullTerminatedStringRef(from_storage);
        StringRef t = to.toNullTerminatedStringRef(to_storage);
        if (std.link((char.iterator)t.begin(), (char.iterator)f.begin()) == -1) {
            return new std_errors.error_code(std.errno(), std.system_category());
        }
        return std_errors.error_code.success();
    }

    public static std_errors.error_code create_symlink(Twine to, Twine from) {
        SmallString from_storage = new SmallString(128);
        SmallString to_storage = new SmallString(128);
        StringRef f = from.toNullTerminatedStringRef(from_storage);
        StringRef t = to.toNullTerminatedStringRef(to_storage);
        if (std.symlink((char.iterator)t.begin(), (char.iterator)f.begin()) == -1) {
            return new std_errors.error_code(std.errno(), std.system_category());
        }
        return std_errors.error_code.success();
    }

    public static std_errors.error_code current_path(SmallString result) {
        result.clear();
        char.ptr pwd = std.getenv((String)"PWD");
        file_status PWDStatus = new file_status();
        file_status DotStatus = new file_status();
        if (pwd != null && path.is_absolute(pwd) && fs.status(new Twine(pwd), PWDStatus).$Void2Void() == null && fs.status(Twine.DOT, DotStatus).$Void2Void() == null && PWDStatus.getUniqueID().$eq(DotStatus.getUniqueID())) {
            result.append(pwd, std.strlen((char.ptr)pwd));
            return std_errors.error_code.success();
        }
        result.reserve(1024);
        while (std.getcwd((char.iterator)result.data(), (long)result.capacity()) == null) {
            if (std.errno() != 12) {
                return new std_errors.error_code(std.errno(), std.system_category());
            }
            result.reserve(result.capacity() * 2);
        }
        result.set_size(std.strlen((char.ptr)result.data()));
        return std_errors.error_code.success();
    }

    public static std_errors.error_code remove(Twine path2, bool.ref existed) {
        SmallString path_storage = new SmallString(128);
        StringRef p = path2.toNullTerminatedStringRef(path_storage);
        io.stat buf = new io.stat();
        if (std.stat((char.ptr)p.begin(), (io.stat)buf) != 0) {
            if (std.errno() != std_errors.errc.no_such_file_or_directory.getValue()) {
                return new std_errors.error_code(std.errno(), std.system_category());
            }
            existed.$set(false);
            return std_errors.error_code.success();
        }
        if (!std.S_ISREG((long)buf.st_mode) && !std.S_ISDIR((long)buf.st_mode)) {
            return std_errors.errc.operation_not_permitted.make_error_code();
        }
        if (io.remove((char.iterator)p.begin()) == -1) {
            if (std.errno() != std_errors.errc.no_such_file_or_directory.getValue()) {
                return new std_errors.error_code(std.errno(), std.system_category());
            }
            existed.$set(false);
        } else {
            existed.$set(true);
        }
        return std_errors.error_code.success();
    }

    public static std_errors.error_code remove(Twine Path2) {
        bool.ref Existed = NativePointer.create_bool$ref();
        return fs.remove(Path2, Existed);
    }

    public static std_errors.error_code rename(Twine from, Twine to) {
        SmallString from_storage = new SmallString(128);
        SmallString to_storage = new SmallString(128);
        StringRef f = from.toNullTerminatedStringRef(from_storage);
        StringRef t = to.toNullTerminatedStringRef(to_storage);
        if (io.rename((char.iterator)f.begin(), (char.iterator)t.begin()) == -1) {
            return new std_errors.error_code(std.errno(), std.system_category());
        }
        return std_errors.error_code.success();
    }

    public static std_errors.error_code resize_file(Twine path2, long size) {
        SmallString path_storage = new SmallString(128);
        StringRef p = path2.toNullTerminatedStringRef(path_storage);
        if (std.truncate((char.iterator)p.begin(), (long)size) == -1) {
            return new std_errors.error_code(std.errno(), std.system_category());
        }
        return std_errors.error_code.success();
    }

    public static std_errors.error_code copy_file(Twine From, Twine To) {
        int.ref ReadFD = NativePointer.create_int$ref();
        int.ref WriteFD = NativePointer.create_int$ref();
        std_errors.error_code EC = fs.openFileForRead(From, ReadFD);
        if (EC.$boolean()) {
            return EC;
        }
        EC = fs.openFileForWrite(To, WriteFD, OpenFlags.F_None);
        if (EC.$boolean()) {
            std.close((int)ReadFD.$deref());
            return EC;
        }
        long BufSize = 4096L;
        char.ptr Buf = NativePointer.create_char$ptr((byte[])NativePointer.new$char((long)BufSize, (byte[])new byte[0]));
        int BytesRead = 0;
        int BytesWritten = 0;
        while ((BytesRead = (int)std.read((int)ReadFD.$deref(), (char.iterator)Buf, (long)BufSize)) > 0) {
            while (BytesRead != 0 && (BytesWritten = (int)std.write((int)WriteFD.$deref(), (char.ptr)Buf, (long)BytesRead)) >= 0) {
                BytesRead -= BytesWritten;
            }
            if (BytesWritten >= 0) continue;
        }
        std.close((int)ReadFD.$deref());
        std.close((int)WriteFD.$deref());
        Destructors.$destroyArray((Object)Buf);
        if (BytesRead < 0 || BytesWritten < 0) {
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        return new std_errors.error_code();
    }

    public static boolean exists(file_status status) {
        return fs.status_known(status) && status.type().getValue() != file_type.file_not_found.getValue();
    }

    public static std_errors.error_code exists(Twine path2, bool.ref result) {
        SmallString path_storage = new SmallString(128);
        StringRef p = path2.toNullTerminatedStringRef(path_storage);
        if (std.access((char.iterator)p.begin(), (long)0L) == -1) {
            if (std.errno() != std_errors.errc.no_such_file_or_directory.getValue()) {
                return new std_errors.error_code(std.errno(), std.system_category());
            }
            result.$set(false);
        } else {
            result.$set(true);
        }
        return std_errors.error_code.success();
    }

    public static boolean exists(Twine path2) {
        bool.ref result = NativePointer.create_bool$ref();
        return fs.exists(path2, result).$Void2Void() == null && result.$deref();
    }

    public static boolean can_execute(Twine Path2) {
        SmallString PathStorage = new SmallString(128);
        StringRef P = Path2.toNullTerminatedStringRef(PathStorage);
        if (0 != std.access((char.iterator)P.begin(), (long)5L)) {
            return false;
        }
        io.stat buf = new io.stat();
        if (0 != std.stat((char.ptr)P.begin(), (io.stat)buf)) {
            return false;
        }
        return std.S_ISREG((long)buf.st_mode);
    }

    public static boolean can_write(Twine Path2) {
        SmallString PathStorage = new SmallString(128);
        StringRef P = Path2.toNullTerminatedStringRef(PathStorage);
        return 0 == std.access((char.iterator)P.begin(), (long)2L);
    }

    public static boolean equivalent(file_status A, file_status B) {
        assert (fs.status_known(A) && fs.status_known(B));
        return A.fs_st_dev == B.fs_st_dev && A.fs_st_ino == B.fs_st_ino;
    }

    public static std_errors.error_code equivalent(Twine A, Twine B, bool.ref result) {
        file_status fsA = new file_status();
        file_status fsB = new file_status();
        std_errors.error_code ec = fs.status(A, fsA);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        ec = fs.status(B, fsB);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        result.$set(fs.equivalent(fsA, fsB));
        return std_errors.error_code.success();
    }

    public static boolean equivalent(Twine A, Twine B) {
        bool.ref result = NativePointer.create_bool$ref();
        return fs.equivalent(A, B, result).$Void2Void() == null && result.$deref();
    }

    public static boolean is_directory(file_status status) {
        return status.type().getValue() == file_type.directory_file.getValue();
    }

    public static std_errors.error_code is_directory(Twine path2, bool.ref result) {
        file_status st = new file_status();
        std_errors.error_code ec = fs.status(path2, st);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        result.$set(fs.is_directory(st));
        return std_errors.error_code.success();
    }

    public static boolean is_directory(Twine Path2) {
        bool.ref Result = NativePointer.create_bool$ref();
        return fs.is_directory(Path2, Result).$Void2Void() == null && Result.$deref();
    }

    public static boolean is_regular_file(file_status status) {
        return status.type().getValue() == file_type.regular_file.getValue();
    }

    public static std_errors.error_code is_regular_file(Twine path2, bool.ref result) {
        file_status st = new file_status();
        std_errors.error_code ec = fs.status(path2, st);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        result.$set(fs.is_regular_file(st));
        return std_errors.error_code.success();
    }

    public static boolean is_regular_file(Twine Path2) {
        bool.ref Result = NativePointer.create_bool$ref();
        if (fs.is_regular_file(Path2, Result).$Void2Void() != null) {
            return false;
        }
        return Result.$deref();
    }

    public static boolean is_other(file_status status) {
        return fs.exists(status) && !fs.is_regular_file(status) && !fs.is_directory(status) && !fs.is_symlink(status);
    }

    public static std_errors.error_code is_other(Twine path2, bool.ref result) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean is_symlink(file_status status) {
        return status.type().getValue() == file_type.symlink_file.getValue();
    }

    public static std_errors.error_code is_symlink(Twine path2, bool.ref result) {
        file_status st = new file_status();
        std_errors.error_code ec = fs.status(path2, st);
        if (ec.$Void2Void() != null) {
            return ec;
        }
        result.$set(fs.is_symlink(st));
        return std_errors.error_code.success();
    }

    public static std_errors.error_code status(Twine Path2, file_status Result) {
        SmallString PathStorage = new SmallString(128);
        StringRef P = Path2.toNullTerminatedStringRef(PathStorage);
        io.stat Status2 = new io.stat();
        int StatRet = std.stat((char.ptr)P.begin(), (io.stat)Status2);
        return fs.fillStatus(StatRet, Status2, Result);
    }

    public static std_errors.error_code status(int FD, file_status Result) {
        io.stat Status2 = new io.stat();
        int StatRet = std.fstat((int)FD, (io.stat)Status2);
        return fs.fillStatus(StatRet, Status2, Result);
    }

    public static std_errors.error_code file_size(Twine Path2, long.ref Result) {
        file_status Status2 = new file_status();
        std_errors.error_code EC = fs.status(Path2, Status2);
        if (EC.$Void2Void() != null) {
            return EC;
        }
        Result.$set(Status2.getSize());
        return std_errors.error_code.success();
    }

    public static std_errors.error_code setLastModificationAndAccessTime(int FD, TimeValue Time) {
        io.timespec[] Times = new io.timespec[2];
        Times[0].tv_sec = Time.toPosixTime();
        Times[0].tv_nsec = 0L;
        Times[1].$assign(Times[0]);
        if (std.futimens((int)FD, (io.timespec[])Times) != 0) {
            return new std_errors.error_code(std.errno(), std.system_category());
        }
        return std_errors.error_code.success();
    }

    public static boolean status_known(file_status s) {
        return s.type().getValue() != file_type.status_error.getValue();
    }

    public static std_errors.error_code status_known(Twine path2, bool.ref result) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std_errors.error_code createUniqueFile(Twine Model2, int.ref ResultFd, SmallString ResultPath) {
        return fs.createUniqueFile(Model2, ResultFd, ResultPath, fs.$bitor_perms(292, 146));
    }

    public static std_errors.error_code createUniqueFile(Twine Model2, int.ref ResultFd, SmallString ResultPath, long Mode) {
        return PathStatics.createUniqueEntity(Model2, ResultFd, ResultPath, false, Mode, PathStatics.FSEntity.FS_File);
    }

    public static std_errors.error_code createUniqueFile(Twine Model2, SmallString ResultPath) {
        int.ref Dummy = NativePointer.create_int$ref();
        return PathStatics.createUniqueEntity(Model2, Dummy, ResultPath, false, 0L, PathStatics.FSEntity.FS_Name);
    }

    public static std_errors.error_code createTemporaryFile(Twine Prefix, StringRef Suffix, int.ref ResultFD, SmallString ResultPath) {
        return fs.createTemporaryFile(Prefix, Suffix, ResultFD, ResultPath, PathStatics.FSEntity.FS_File);
    }

    public static std_errors.error_code createTemporaryFile(Twine Prefix, StringRef Suffix, SmallString ResultPath) {
        int.ref Dummy = NativePointer.create_int$ref();
        return fs.createTemporaryFile(Prefix, Suffix, Dummy, ResultPath, PathStatics.FSEntity.FS_Name);
    }

    public static std_errors.error_code createUniqueDirectory(Twine Prefix, SmallString ResultPath) {
        int.ref Dummy = NativePointer.create_int$ref();
        return PathStatics.createUniqueEntity(llvm.$plus_Twine(Prefix, new Twine("-%%%%%%")), Dummy, ResultPath, true, 0L, PathStatics.FSEntity.FS_Dir);
    }

    public static OpenFlags $bitor_OpenFlags(OpenFlags A, OpenFlags B) {
        return OpenFlags.valueOf((int)((long)A.getValue() | (long)B.getValue()));
    }

    public static OpenFlags $orassign_OpenFlags(OpenFlags A, OpenFlags B) {
        A = fs.$bitor_OpenFlags(A, B);
        return A;
    }

    public static std_errors.error_code openFileForWrite(Twine Name, int.ref ResultFD, OpenFlags Flags) {
        return fs.openFileForWrite(Name, ResultFD, Flags, 438L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_errors.error_code openFileForWrite(Twine Name, int.ref ResultFD, OpenFlags Flags, long Mode) {
        SmallVectorImplChar Storage = null;
        try {
            assert ((Flags.getValue() & OpenFlags.F_Excl.getValue()) == 0 || (Flags.getValue() & OpenFlags.F_Append.getValue()) == 0) : "Cannot specify both 'excl' and 'append' file creation flags!";
            int OpenFlags2 = 256;
            OpenFlags2 = (Flags.getValue() & OpenFlags.F_RW.getValue()) != 0 ? (OpenFlags2 |= 2) : (OpenFlags2 |= 1);
            OpenFlags2 = (Flags.getValue() & OpenFlags.F_Append.getValue()) != 0 ? (OpenFlags2 |= 8) : (OpenFlags2 |= 0x200);
            if ((Flags.getValue() & OpenFlags.F_Excl.getValue()) != 0) {
                OpenFlags2 |= 0x400;
            }
            Storage = new SmallString(128);
            StringRef P = Name.toNullTerminatedStringRef((SmallString)Storage);
            while (ResultFD.$set(std.open((char.iterator)P.begin(), (long)OpenFlags2, (long[])new long[]{Mode})) < 0) {
                if (std.errno() == 4) continue;
                std_errors.error_code error_code2 = new std_errors.error_code(std.errno(), std.generic_category());
                return error_code2;
            }
            std_errors.error_code error_code3 = new std_errors.error_code();
            return error_code3;
        }
        finally {
            if (Storage != null) {
                Storage.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_errors.error_code openFileForRead(Twine Name, int.ref ResultFD) {
        SmallString Storage = null;
        try {
            Storage = new SmallString(128);
            StringRef P = Name.toNullTerminatedStringRef(Storage);
            while (ResultFD.$set(std.open((char.iterator)P.begin(), (long)0L, (long[])new long[0])) < 0) {
                if (std.errno() == 4) continue;
                std_errors.error_code error_code2 = new std_errors.error_code(std.errno(), std.generic_category());
                return error_code2;
            }
            std_errors.error_code error_code3 = new std_errors.error_code();
            return error_code3;
        }
        finally {
            if (Storage != null) {
                Storage.$destroy();
            }
        }
    }

    public static file_magic identify_magic(StringRef Magic) {
        if (Magic.size() < 4) {
            return new file_magic(file_magic.Impl.unknown);
        }
        block0 : switch (Casts.$char((byte)Magic.$at(0))) {
            case '\u0000': {
                if (Magic.$at(1) == 0 && Magic.$at(2) == -1 && Magic.$at(3) == -1) {
                    return new file_magic(file_magic.Impl.coff_import_library);
                }
                byte[] Expected = new byte[]{0, 0, 0, 0, 32, 0, 0, 0, -1};
                if (Magic.size() >= NativeType.sizeof((Object)Expected) && std.memcmp((char.ptr)Magic.data(), (char.ptr)NativePointer.create_char$ptr((byte[])Expected), (int)NativeType.sizeof((Object)Expected)) == 0) {
                    return new file_magic(file_magic.Impl.windows_resource);
                }
                if (Magic.$at(1) != 0) break;
                return new file_magic(file_magic.Impl.coff_object);
            }
            case '\u00de': {
                if (Magic.$at(1) != -64 || Magic.$at(2) != 23 || Magic.$at(3) != 11) break;
                return new file_magic(file_magic.Impl.bitcode);
            }
            case 'B': {
                if (Magic.$at(1) != NativePointer.$((char)'C') || Magic.$at(2) != -64 || Magic.$at(3) != -34) break;
                return new file_magic(file_magic.Impl.bitcode);
            }
            case '!': {
                if (Magic.size() < 8 || std.memcmp((char.ptr)Magic.data(), (CharSequence)"!<arch>\n", (int)8) != 0) break;
                return new file_magic(file_magic.Impl.archive);
            }
            case '\u007f': {
                long low;
                if (Magic.size() < 18 || Magic.$at(1) != NativePointer.$((char)'E') || Magic.$at(2) != NativePointer.$((char)'L') || Magic.$at(3) != NativePointer.$((char)'F')) break;
                boolean Data2MSB = Magic.$at(5) == 2;
                long high = Data2MSB ? 16L : 17L;
                long l = low = Data2MSB ? 17L : 16L;
                if (Magic.$at(high) != 0) break;
                switch (Magic.$at(low)) {
                    default: {
                        break block0;
                    }
                    case 1: {
                        return new file_magic(file_magic.Impl.elf_relocatable);
                    }
                    case 2: {
                        return new file_magic(file_magic.Impl.elf_executable);
                    }
                    case 3: {
                        return new file_magic(file_magic.Impl.elf_shared_object);
                    }
                    case 4: 
                }
                return new file_magic(file_magic.Impl.elf_core);
            }
            case '\u00ca': {
                if (Magic.$at(1) != -2 || Magic.$at(2) != -70 || Magic.$at(3) != -66 || Magic.size() < 8 || Magic.$at(7) >= 43) break;
                return new file_magic(file_magic.Impl.macho_universal_binary);
            }
            case '\u00ce': 
            case '\u00cf': 
            case '\u00fe': {
                int type2 = 0;
                if (Magic.$at(0) == -2 && Magic.$at(1) == -19 && Magic.$at(2) == -6 && (Magic.$at(3) == -50 || Magic.$at(3) == -49)) {
                    if (Magic.size() >= 16) {
                        type2 = (char)(Magic.$at(14) << 8 | Magic.$at(15));
                    }
                } else if ((Magic.$at(0) == -50 || Magic.$at(0) == -49) && Magic.$at(1) == -6 && Magic.$at(2) == -19 && Magic.$at(3) == -2 && Magic.size() >= 14) {
                    type2 = (char)(Magic.$at(13) << 8 | Magic.$at(12));
                }
                switch (type2) {
                    default: {
                        break block0;
                    }
                    case 1: {
                        return new file_magic(file_magic.Impl.macho_object);
                    }
                    case 2: {
                        return new file_magic(file_magic.Impl.macho_executable);
                    }
                    case 3: {
                        return new file_magic(file_magic.Impl.macho_fixed_virtual_memory_shared_lib);
                    }
                    case 4: {
                        return new file_magic(file_magic.Impl.macho_core);
                    }
                    case 5: {
                        return new file_magic(file_magic.Impl.macho_preload_executable);
                    }
                    case 6: {
                        return new file_magic(file_magic.Impl.macho_dynamically_linked_shared_lib);
                    }
                    case 7: {
                        return new file_magic(file_magic.Impl.macho_dynamic_linker);
                    }
                    case 8: {
                        return new file_magic(file_magic.Impl.macho_bundle);
                    }
                    case 9: {
                        return new file_magic(file_magic.Impl.macho_dynamic_linker);
                    }
                    case 10: 
                }
                return new file_magic(file_magic.Impl.macho_dsym_companion);
            }
            case 'L': 
            case 'P': 
            case 'f': 
            case '\u0083': 
            case '\u0084': 
            case '\u00f0': {
                if (Magic.$at(1) == 1) {
                    return new file_magic(file_magic.Impl.coff_object);
                }
            }
            case 'h': 
            case '\u0090': {
                if (Magic.$at(1) != 2) break;
                return new file_magic(file_magic.Impl.coff_object);
            }
            case 'M': {
                long off;
                if (Magic.$at(1) != 90 || (off = ((Long)new llvm.support.ulittle32_t((char.ptr)Magic.data().$add(60)).$value()).longValue()) >= (long)Magic.size() || std.memcmp((char.ptr)((char.ptr)Magic.data().$add(off)), (CharSequence)"PE\u0000\u0000", (int)4) != 0) break;
                return new file_magic(file_magic.Impl.pecoff_executable);
            }
            case 'd': {
                if (Magic.$at(1) != -122) break;
                return new file_magic(file_magic.Impl.coff_object);
            }
        }
        return new file_magic(file_magic.Impl.unknown);
    }

    public static std_errors.error_code identify_magic(Twine Path2, file_magic Result) {
        int.ref FD = NativePointer.create_int$ref();
        std_errors.error_code EC = fs.openFileForRead(Path2, FD);
        if (EC.$boolean()) {
            return EC;
        }
        int BufSize = 32;
        char.ptr Buffer = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)BufSize, (byte[])new byte[0]));
        long Length = std.read((int)FD.$deref(), (char.iterator)Buffer, (long)BufSize);
        if (std.close((int)FD.$deref()) != 0 || Length < 0L) {
            return new std_errors.error_code(std.errno(), std.generic_category());
        }
        Result.$assignMove(fs.identify_magic(new StringRef(Buffer, Length)));
        return new std_errors.error_code();
    }

    public static std_errors.error_code getUniqueID(Twine Path2, UniqueID Result) {
        file_status Status2 = new file_status();
        std_errors.error_code EC = fs.status(Path2, Status2);
        if (EC.$Void2Void() != null) {
            return EC;
        }
        Result.$assign(Status2.getUniqueID());
        return std_errors.error_code.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_errors.error_code map_file_pages(Twine path2, long file_offset, long size, boolean map_writable, type.ref<void.ptr> result) {
        PathStatics.AutoFD fd = null;
        try {
            SmallString path_storage = new SmallString(128);
            StringRef name = path2.toNullTerminatedStringRef(path_storage);
            int oflags = map_writable ? 2 : 0;
            int ofd = std.open((char.iterator)name.begin(), (long)oflags, (long[])new long[0]);
            if (ofd == -1) {
                std_errors.error_code error_code2 = new std_errors.error_code(std.errno(), std.system_category());
                return error_code2;
            }
            fd = new PathStatics.AutoFD(ofd);
            int flags = map_writable ? 1 : 2;
            int prot = map_writable ? 3 : 1;
            result.$set((Object)std.mmap(null, (long)size, (int)prot, (int)(flags |= 0), (int)fd.$int(), (long)file_offset));
            if (result.$deref() == std.MAP_FAILED) {
                std_errors.error_code error_code3 = new std_errors.error_code(std.errno(), std.system_category());
                return error_code3;
            }
            std_errors.error_code error_code4 = std_errors.error_code.success();
            return error_code4;
        }
        finally {
            if (fd != null) {
                fd.$destroy();
            }
        }
    }

    public static std_errors.error_code unmap_file_pages(void.ptr base, long size) {
        if (std.munmap((void.ptr)base, (long)size) == -1) {
            return new std_errors.error_code(std.errno(), std.system_category());
        }
        return std_errors.error_code.success();
    }

    public static std.string getMainExecutable(char.ptr argv0, void.ptr MainAddr) {
        if (argv0 != null) {
            return new std.string(argv0);
        }
        io.Dl_info DLInfo = new io.Dl_info();
        int err = std.dladdr((void.ptr)MainAddr, (io.Dl_info)DLInfo);
        if (err == 0) {
            return new std.string((CharSequence)"");
        }
        byte[] link_path = NativePointer.new$char((int)1024, (byte[])new byte[0]);
        if (std.realpath((char.ptr)DLInfo.dli_fname, (byte[])link_path) != null) {
            return new std.string(link_path);
        }
        return new std.string((CharSequence)"");
    }

    public static std_errors.error_code createTemporaryFile(Twine Model2, int.ref ResultFD, SmallString ResultPath, PathStatics.FSEntity Type2) {
        SmallString Storage = new SmallString(128);
        StringRef P = Model2.toNullTerminatedStringRef(Storage);
        assert (P.find_first_of(PathStatics.separators) == StringRef.npos) : "Model must be a simple filename.";
        return PathStatics.createUniqueEntity(new Twine(P.begin()), ResultFD, ResultPath, true, fs.$bitor_perms(256, 128), Type2);
    }

    public static std_errors.error_code createTemporaryFile(Twine Prefix, StringRef Suffix, int.ref ResultFD, SmallString ResultPath, PathStatics.FSEntity Type2) {
        char.ptr Middle = NativePointer.create_char$ptr((CharSequence)(Suffix.empty() ? "-%%%%%%" : "-%%%%%%."));
        return fs.createTemporaryFile(llvm.$plus_Twine(llvm.$plus_Twine(Prefix, new Twine(Middle)), new Twine(Suffix)), ResultFD, ResultPath, Type2);
    }

    public static std_errors.error_code fillStatus(int StatRet, io.stat Status2, file_status Result) {
        if (StatRet != 0) {
            std_errors.error_code ec = new std_errors.error_code(std.errno(), std.generic_category());
            if (std.$eq_error_code((std_errors.error_code)ec, (std_errors.error_code)std_errors.errc.no_such_file_or_directory.make_error_code())) {
                Result.$assign(new file_status(file_type.file_not_found));
            } else {
                Result.$assign(new file_status(file_type.status_error));
            }
            return ec;
        }
        file_type Type2 = file_type.type_unknown;
        if (std.S_ISDIR((long)Status2.st_mode)) {
            Type2 = file_type.directory_file;
        } else if (std.S_ISREG((long)Status2.st_mode)) {
            Type2 = file_type.regular_file;
        } else if (std.S_ISBLK((long)Status2.st_mode)) {
            Type2 = file_type.block_file;
        } else if (std.S_ISCHR((long)Status2.st_mode)) {
            Type2 = file_type.character_file;
        } else if (std.S_ISFIFO((long)Status2.st_mode)) {
            Type2 = file_type.fifo_file;
        } else if (std.S_ISSOCK((long)Status2.st_mode)) {
            Type2 = file_type.socket_file;
        }
        perms Perms = perms.valueOf(Status2.st_mode);
        Result.$assign(new file_status(Type2, Perms, Status2.st_dev, Status2.st_ino, Status2.st_mtim.tv_sec, Status2.st_uid, Status2.st_gid, Status2.st_size));
        return new std_errors.error_code();
    }

    public static class recursive_directory_iterator
    implements Destructors.ClassWithDestructor,
    Native.NativeComparable<recursive_directory_iterator> {
        private IntrusiveRefCntPtr<detail.RecDirIterState> State;

        public recursive_directory_iterator() {
            this.State = new IntrusiveRefCntPtr();
        }

        public recursive_directory_iterator(Twine path2, std_errors.error_code ec) {
            this.State = new IntrusiveRefCntPtr<detail.RecDirIterState>(new detail.RecDirIterState());
            this.State.$arrow().Stack.push((Object)new directory_iterator(path2, ec));
            if (((directory_iterator)this.State.$arrow().Stack.top()).$eq(new directory_iterator())) {
                this.State.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public recursive_directory_iterator increment(std_errors.error_code ec) {
            directory_iterator end_itr = null;
            try {
                end_itr = new directory_iterator();
                if (this.State.$arrow().HasNoPushRequest) {
                    this.State.$arrow().HasNoPushRequest = false;
                } else {
                    file_status st = new file_status();
                    if (ec.$assign(((directory_iterator)this.State.$arrow().Stack.top()).$arrow().status(st)).$Void2Void() != null) {
                        recursive_directory_iterator recursive_directory_iterator2 = this;
                        return recursive_directory_iterator2;
                    }
                    if (fs.is_directory(st)) {
                        this.State.$arrow().Stack.push((Object)new directory_iterator(((directory_iterator)this.State.$arrow().Stack.top()).$star(), ec));
                        if (ec.$Void2Void() != null) {
                            recursive_directory_iterator recursive_directory_iterator3 = this;
                            return recursive_directory_iterator3;
                        }
                        if (((directory_iterator)this.State.$arrow().Stack.top()).$noteq(end_itr)) {
                            this.State.$arrow().Level = (char)(this.State.$arrow().Level + '\u0001');
                            recursive_directory_iterator recursive_directory_iterator4 = this;
                            return recursive_directory_iterator4;
                        }
                        this.State.$arrow().Stack.pop();
                    }
                }
                while (!this.State.$arrow().Stack.empty() && ((directory_iterator)this.State.$arrow().Stack.top()).increment(ec).$eq(end_itr)) {
                    this.State.$arrow().Stack.pop();
                    this.State.$arrow().Level = (char)(this.State.$arrow().Level - '\u0001');
                }
                if (this.State.$arrow().Stack.empty()) {
                    this.State.reset();
                }
                recursive_directory_iterator recursive_directory_iterator5 = this;
                return recursive_directory_iterator5;
            }
            finally {
                if (end_itr != null) {
                    end_itr.$destroy();
                }
            }
        }

        public directory_entry $star() {
            return ((directory_iterator)this.State.$arrow().Stack.top()).$star();
        }

        public directory_entry $arrow() {
            return ((directory_iterator)this.State.$arrow().Stack.top()).$star();
        }

        public int level() {
            return this.State.$arrow().Level;
        }

        public boolean no_push_request() {
            return this.State.$arrow().HasNoPushRequest;
        }

        public void pop() {
            directory_iterator end_itr = null;
            try {
                assert (this.State.$Void2Type() != null) : "Cannot pop an end iterator!";
                assert (this.State.$arrow().Level > '\u0000') : "Cannot pop an iterator with level < 1";
                end_itr = new directory_iterator();
                std_errors.error_code ec = new std_errors.error_code();
                do {
                    if (ec.$Void2Void() != null) {
                        llvm.report_fatal_error("Error incrementing directory iterator.");
                    }
                    this.State.$arrow().Stack.pop();
                    this.State.$arrow().Level = (char)(this.State.$arrow().Level - '\u0001');
                } while (!this.State.$arrow().Stack.empty() && ((directory_iterator)this.State.$arrow().Stack.top()).increment(ec).$eq(end_itr));
                if (this.State.$arrow().Stack.empty()) {
                    this.State.reset();
                }
            }
            finally {
                if (end_itr != null) {
                    end_itr.$destroy();
                }
            }
        }

        public void no_push() {
            this.State.$arrow().HasNoPushRequest = true;
        }

        public boolean $eq(recursive_directory_iterator RHS) {
            return llvm.$eq_IntrusiveRefCntPtr(this.State, RHS.State);
        }

        public boolean $noteq(recursive_directory_iterator RHS) {
            return !this.$eq(RHS);
        }

        public void $destroy() {
            throw new UnsupportedOperationException("EmptyBody");
        }
    }

    public static class directory_iterator
    implements Destructors.ClassWithDestructor,
    Native.NativeComparable<directory_iterator> {
        private IntrusiveRefCntPtr<detail.DirIterState> State;

        public directory_iterator(Twine path2, std_errors.error_code ec) {
            this.State = new IntrusiveRefCntPtr();
            this.State.$assign(new IntrusiveRefCntPtr<detail.DirIterState>(new detail.DirIterState()));
            SmallString path_storage = new SmallString(128);
            ec.$assign(detail.directory_iterator_construct(this.State.$star(), path2.toStringRef(path_storage)));
        }

        public directory_iterator(directory_entry de, std_errors.error_code ec) {
            this.State = new IntrusiveRefCntPtr();
            this.State.$assign(new IntrusiveRefCntPtr<detail.DirIterState>(new detail.DirIterState()));
            ec.$assign(detail.directory_iterator_construct(this.State.$star(), new StringRef(de.path())));
        }

        public directory_iterator() {
            this.State = new IntrusiveRefCntPtr<detail.DirIterState>((detail.DirIterState)null);
        }

        public directory_iterator increment(std_errors.error_code ec) {
            ec.$assign(detail.directory_iterator_increment(this.State.$star()));
            return this;
        }

        public directory_entry $star() {
            return this.State.$arrow().CurrentEntry;
        }

        public directory_entry $arrow() {
            return this.State.$arrow().CurrentEntry;
        }

        public boolean $eq(directory_iterator RHS) {
            if (llvm.$eq_IntrusiveRefCntPtr(this.State, RHS.State)) {
                return true;
            }
            if (RHS.State.$Void2Type() == null) {
                return this.State.$arrow().CurrentEntry.$eq(new directory_entry());
            }
            if (this.State.$Void2Type() == null) {
                return RHS.State.$arrow().CurrentEntry.$eq(new directory_entry());
            }
            return this.State.$arrow().CurrentEntry.$eq(RHS.State.$arrow().CurrentEntry);
        }

        public boolean $noteq(directory_iterator RHS) {
            return !this.$eq(RHS);
        }

        public void $destroy() {
        }

        public directory_iterator $assign(directory_iterator $Prm0) {
            this.State.$assign($Prm0.State);
            return this;
        }

        public directory_iterator(directory_iterator $Prm0) {
            this.State = new IntrusiveRefCntPtr<detail.DirIterState>($Prm0.State);
        }
    }

    public static final class detail {
        public static std_errors.error_code directory_iterator_construct(DirIterState it, StringRef path2) {
            SmallString path_null = new SmallString(path2, 128);
            io.DIR directory = io.opendir((char.iterator)path_null.c_str());
            if (directory == null) {
                return new std_errors.error_code(std.errno(), std.system_category());
            }
            it.IterationHandle = directory;
            path.append(path_null, StringRef.DOT);
            it.CurrentEntry.$assign(new directory_entry(new Twine(path_null.str())));
            return detail.directory_iterator_increment(it);
        }

        public static std_errors.error_code directory_iterator_increment(DirIterState it) {
            StringRef name;
            std.setErrno((int)0);
            io.dirent cur_dir = io.readdir((io.DIR)it.IterationHandle);
            if (cur_dir == null && std.errno() != 0) {
                return new std_errors.error_code(std.errno(), std.system_category());
            }
            if (cur_dir != null) {
                name = new StringRef(cur_dir.d_name, std.strlen((byte[])cur_dir.d_name));
                if (name.size() == 1 && name.$at(0) == NativePointer.$((char)'.') || name.size() == 2 && name.$at(0) == NativePointer.$((char)'.') && name.$at(1) == NativePointer.$((char)'.')) {
                    return detail.directory_iterator_increment(it);
                }
            } else {
                return detail.directory_iterator_destruct(it);
            }
            it.CurrentEntry.replace_filename(new Twine(name));
            return std_errors.error_code.success();
        }

        public static std_errors.error_code directory_iterator_destruct(DirIterState it) {
            if (it.IterationHandle != null) {
                io.closedir((io.DIR)it.IterationHandle);
            }
            it.IterationHandle = null;
            it.CurrentEntry.$assign(new directory_entry());
            return std_errors.error_code.success();
        }

        public static class RecDirIterState
        extends RefCountedBase<RecDirIterState> {
            public std.stack<directory_iterator> Stack = new std.stack();
            public char Level = '\u0000';
            public boolean HasNoPushRequest = false;
        }

        public static class DirIterState
        extends RefCountedBase<DirIterState>
        implements Destructors.ClassWithDestructor {
            public io.DIR IterationHandle = null;
            public directory_entry CurrentEntry = new directory_entry();

            @Override
            public void $destroy() {
                detail.directory_iterator_destruct(this);
                super.$destroy();
            }
        }
    }

    public static class directory_entry
    implements Destructors.ClassWithDestructor,
    Native.NativeComparable<directory_entry> {
        private std.string Path;
        private file_status Status;

        public directory_entry(Twine path2) {
            this(path2, new file_status());
        }

        public directory_entry(Twine path2, file_status st) {
            this.Path = new std.string(path2.str());
            this.Status = new file_status(st);
        }

        public directory_entry() {
            this.Path = new std.string();
            this.Status = new file_status();
        }

        public void assign(Twine path2) {
            this.assign(path2, new file_status());
        }

        public void assign(Twine path2, file_status st) {
            this.Path.$assign(path2.str());
            this.Status.$assign(st);
        }

        public void replace_filename(Twine filename) {
            this.replace_filename(filename, new file_status());
        }

        public void replace_filename(Twine filename, file_status st) {
            SmallString path2 = new SmallString(this.Path.begin(), this.Path.end(), 128);
            path.remove_filename(path2);
            path.append(path2, filename);
            this.Path.$assign(path2.str().$basic_string());
            this.Status.$assign(st);
        }

        public std.string path() {
            return this.Path;
        }

        public std_errors.error_code status(file_status result) {
            return fs.status(new Twine(this.Path), result);
        }

        public boolean $eq(directory_entry rhs) {
            return std.$eq_str((std.string)this.Path, (std.string)rhs.Path);
        }

        public boolean $noteq(directory_entry rhs) {
            return !this.$eq(rhs);
        }

        public directory_entry $assign(directory_entry $Prm0) {
            this.Path.$assign($Prm0.Path);
            this.Status.$assign($Prm0.Status);
            return this;
        }

        public boolean $less(directory_entry rhs) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public boolean $lesseq(directory_entry rhs) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public boolean $greater(directory_entry rhs) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public boolean $greatereq(directory_entry rhs) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public void $destroy() {
        }
    }

    public static class mapped_file_region
    implements Destructors.ClassWithDestructor {
        private long Size;
        private char.ptr Mapping;

        private mapped_file_region() {
            throw new UnsupportedOperationException("Deleted");
        }

        private mapped_file_region(mapped_file_region $Prm0) {
            throw new UnsupportedOperationException("Deleted");
        }

        private mapped_file_region $assign(mapped_file_region $Prm0) {
            throw new UnsupportedOperationException("Deleted");
        }

        private std_errors.error_code init(int FD, long Offset, mapmode Mode) {
            assert (this.Size != 0L);
            int flags = Mode == mapmode.readwrite ? 1 : 2;
            int prot = Mode == mapmode.readonly ? 1 : 3;
            this.Mapping = std.mmap(null, (long)this.Size, (int)prot, (int)flags, (int)FD, (long)Offset);
            if (this.Mapping.$eq((Object)std.MAP_FAILED)) {
                return new std_errors.error_code(std.errno(), std.generic_category());
            }
            return new std_errors.error_code();
        }

        public mapped_file_region(int fd, mapmode mode, long length, long offset, std_errors.error_code ec) {
            this.Size = length;
            this.Mapping = null;
            if (length > std.numeric_limits_long.max()) {
                ec.$assign(llvm.make_error_code(std_errors.errc.invalid_argument));
                return;
            }
            ec.$assign(this.init(fd, offset, mode));
            if (ec.$boolean()) {
                this.Mapping = null;
            }
        }

        public void $destroy() {
            if (this.Mapping != null) {
                std.munmap((void.ptr)this.Mapping, (long)this.Size);
            }
        }

        public long size() {
            assert (this.Mapping != null) : "Mapping failed but used anyway!";
            return this.Size;
        }

        public char.ptr data() {
            assert (this.Mapping != null) : "Mapping failed but used anyway!";
            return this.Mapping;
        }

        public char.ptr const_data() {
            assert (this.Mapping != null) : "Mapping failed but used anyway!";
            return Native.$toConst((char.ptr)this.Mapping);
        }

        public static int alignment() {
            return (int)Process.getPageSize();
        }

        public String toString() {
            return "Size=" + this.Size + ", Mapping=" + this.Mapping;
        }

        public static final class mapmode
        extends Enum<mapmode> {
            public static final /* enum */ mapmode readonly = new mapmode(0L);
            public static final /* enum */ mapmode readwrite = new mapmode(readonly.getValue() + 1);
            public static final /* enum */ mapmode priv = new mapmode(readwrite.getValue() + 1);
            private final int value;
            private static final /* synthetic */ mapmode[] $VALUES;

            public static mapmode[] values() {
                return (mapmode[])$VALUES.clone();
            }

            public static mapmode valueOf(String name) {
                return Enum.valueOf(mapmode.class, name);
            }

            public static mapmode valueOf(int val) {
                mapmode out;
                mapmode mapmode2 = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
                assert (out != null) : "no value for " + val;
                return out;
            }

            private mapmode(long val) {
                this.value = (int)val;
            }

            public int getValue() {
                return this.value;
            }

            static {
                $VALUES = new mapmode[]{readonly, readwrite, priv};
            }

            private static final class Values {
                private static final mapmode[] VALUES;
                private static final mapmode[] _VALUES;

                private Values() {
                }

                static {
                    int max = 0;
                    int min = 0;
                    for (mapmode kind : mapmode.values()) {
                        if (kind.value > max) {
                            max = kind.value;
                        }
                        if (kind.value >= min) continue;
                        min = kind.value;
                    }
                    _VALUES = new mapmode[min < 0 ? 1 - min : 0];
                    VALUES = new mapmode[max >= 0 ? 1 + max : 0];
                    for (mapmode kind : mapmode.values()) {
                        if (kind.value < 0) {
                            Values._VALUES[-((mapmode)kind).value] = kind;
                            continue;
                        }
                        Values.VALUES[((mapmode)kind).value] = kind;
                    }
                }
            }
        }
    }

    public static final class OpenFlags
    extends Enum<OpenFlags> {
        public static final /* enum */ OpenFlags F_None = new OpenFlags(0L);
        public static final /* enum */ OpenFlags F_Excl = new OpenFlags(1L);
        public static final /* enum */ OpenFlags F_Append = new OpenFlags(2L);
        public static final /* enum */ OpenFlags F_Text = new OpenFlags(4L);
        public static final /* enum */ OpenFlags F_RW = new OpenFlags(8L);
        private final int value;
        private static final /* synthetic */ OpenFlags[] $VALUES;

        public static OpenFlags[] values() {
            return (OpenFlags[])$VALUES.clone();
        }

        public static OpenFlags valueOf(String name) {
            return Enum.valueOf(OpenFlags.class, name);
        }

        public static OpenFlags valueOf(int val) {
            OpenFlags out;
            OpenFlags openFlags = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private OpenFlags(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new OpenFlags[]{F_None, F_Excl, F_Append, F_Text, F_RW};
        }

        private static final class Values {
            private static final OpenFlags[] VALUES;
            private static final OpenFlags[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (OpenFlags kind : OpenFlags.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new OpenFlags[min < 0 ? 1 - min : 0];
                VALUES = new OpenFlags[max >= 0 ? 1 + max : 0];
                for (OpenFlags kind : OpenFlags.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((OpenFlags)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((OpenFlags)kind).value] = kind;
                }
            }
        }
    }

    public static class file_magic {
        private Impl V;

        public boolean is_object() {
            return this.V != Impl.unknown;
        }

        public file_magic() {
            this.V = Impl.unknown;
        }

        public file_magic(Impl V) {
            this.V = V;
        }

        public Impl $Impl() {
            return this.V;
        }

        public file_magic(file_magic $Prm0) {
            this.V = $Prm0.V;
        }

        public file_magic $assign(file_magic $Prm0) {
            this.V = $Prm0.V;
            return this;
        }

        public file_magic $assignMove(file_magic $Prm0) {
            this.V = $Prm0.V;
            return this;
        }

        public String toString() {
            return "file_magic{" + (Object)((Object)this.V) + '}';
        }

        public static final class Impl
        extends Enum<Impl> {
            public static final /* enum */ Impl unknown = new Impl(0L);
            public static final /* enum */ Impl bitcode = new Impl(1L);
            public static final /* enum */ Impl archive = new Impl(2L);
            public static final /* enum */ Impl elf_relocatable = new Impl(3L);
            public static final /* enum */ Impl elf_executable = new Impl(4L);
            public static final /* enum */ Impl elf_shared_object = new Impl(5L);
            public static final /* enum */ Impl elf_core = new Impl(6L);
            public static final /* enum */ Impl macho_object = new Impl(7L);
            public static final /* enum */ Impl macho_executable = new Impl(8L);
            public static final /* enum */ Impl macho_fixed_virtual_memory_shared_lib = new Impl(9L);
            public static final /* enum */ Impl macho_core = new Impl(10L);
            public static final /* enum */ Impl macho_preload_executable = new Impl(11L);
            public static final /* enum */ Impl macho_dynamically_linked_shared_lib = new Impl(12L);
            public static final /* enum */ Impl macho_dynamic_linker = new Impl(13L);
            public static final /* enum */ Impl macho_bundle = new Impl(14L);
            public static final /* enum */ Impl macho_dynamically_linked_shared_lib_stub = new Impl(15L);
            public static final /* enum */ Impl macho_dsym_companion = new Impl(16L);
            public static final /* enum */ Impl macho_universal_binary = new Impl(17L);
            public static final /* enum */ Impl coff_object = new Impl(18L);
            public static final /* enum */ Impl coff_import_library = new Impl(19L);
            public static final /* enum */ Impl pecoff_executable = new Impl(20L);
            public static final /* enum */ Impl windows_resource = new Impl(21L);
            private final int value;
            private static final /* synthetic */ Impl[] $VALUES;

            public static Impl[] values() {
                return (Impl[])$VALUES.clone();
            }

            public static Impl valueOf(String name) {
                return Enum.valueOf(Impl.class, name);
            }

            public static Impl valueOf(int val) {
                Impl out;
                Impl impl = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
                assert (out != null) : "no value for " + val;
                return out;
            }

            private Impl(long val) {
                this.value = (int)val;
            }

            public int getValue() {
                return this.value;
            }

            static {
                $VALUES = new Impl[]{unknown, bitcode, archive, elf_relocatable, elf_executable, elf_shared_object, elf_core, macho_object, macho_executable, macho_fixed_virtual_memory_shared_lib, macho_core, macho_preload_executable, macho_dynamically_linked_shared_lib, macho_dynamic_linker, macho_bundle, macho_dynamically_linked_shared_lib_stub, macho_dsym_companion, macho_universal_binary, coff_object, coff_import_library, pecoff_executable, windows_resource};
            }

            private static final class Values {
                private static final Impl[] VALUES;
                private static final Impl[] _VALUES;

                private Values() {
                }

                static {
                    int max = 0;
                    int min = 0;
                    for (Impl kind : Impl.values()) {
                        if (kind.value > max) {
                            max = kind.value;
                        }
                        if (kind.value >= min) continue;
                        min = kind.value;
                    }
                    _VALUES = new Impl[min < 0 ? 1 - min : 0];
                    VALUES = new Impl[max >= 0 ? 1 + max : 0];
                    for (Impl kind : Impl.values()) {
                        if (kind.value < 0) {
                            Values._VALUES[-((Impl)kind).value] = kind;
                            continue;
                        }
                        Values.VALUES[((Impl)kind).value] = kind;
                    }
                }
            }
        }
    }

    public static class file_status {
        private long fs_st_dev;
        private long fs_st_ino;
        private long fs_st_mtime;
        private long fs_st_uid;
        private long fs_st_gid;
        private long fs_st_size;
        private file_type Type;
        private perms Perms;

        public file_status() {
            this.Type = file_type.status_error;
        }

        public file_status(file_type Type2) {
            this.Type = Type2;
        }

        public file_status(file_type Type2, perms Perms, long Dev, long Ino, long MTime, long UID, long GID, long Size) {
            this.fs_st_dev = Dev;
            this.fs_st_ino = Ino;
            this.fs_st_mtime = MTime;
            this.fs_st_uid = UID;
            this.fs_st_gid = GID;
            this.fs_st_size = Size;
            this.Type = Type2;
            this.Perms = Perms;
        }

        public file_type type() {
            return this.Type;
        }

        public perms permissions() {
            return this.Perms;
        }

        public TimeValue getLastModificationTime() {
            TimeValue Ret = new TimeValue();
            Ret.fromEpochTime(this.fs_st_mtime);
            return Ret;
        }

        public UniqueID getUniqueID() {
            return new UniqueID(this.fs_st_dev, this.fs_st_ino);
        }

        public long getUser() {
            return this.fs_st_uid;
        }

        public long getGroup() {
            return this.fs_st_gid;
        }

        public long getSize() {
            return this.fs_st_size;
        }

        public void type(file_type v) {
            this.Type = v;
        }

        public void permissions(perms p) {
            this.Perms = p;
        }

        public file_status $assign(file_status $Prm0) {
            this.fs_st_dev = $Prm0.fs_st_dev;
            this.fs_st_ino = $Prm0.fs_st_ino;
            this.fs_st_mtime = $Prm0.fs_st_mtime;
            this.fs_st_uid = $Prm0.fs_st_uid;
            this.fs_st_gid = $Prm0.fs_st_gid;
            this.fs_st_size = $Prm0.fs_st_size;
            this.Type = $Prm0.Type;
            this.Perms = $Prm0.Perms;
            return this;
        }

        public file_status(file_status $Prm0) {
            this.fs_st_dev = $Prm0.fs_st_dev;
            this.fs_st_ino = $Prm0.fs_st_ino;
            this.fs_st_mtime = $Prm0.fs_st_mtime;
            this.fs_st_uid = $Prm0.fs_st_uid;
            this.fs_st_gid = $Prm0.fs_st_gid;
            this.fs_st_size = $Prm0.fs_st_size;
            this.Type = $Prm0.Type;
            this.Perms = $Prm0.Perms;
        }

        public String toString() {
            return "file_status{Type=" + (Object)((Object)this.Type) + ", fs_st_dev=" + this.fs_st_dev + ", fs_st_ino=" + this.fs_st_ino + ", fs_st_uid=" + this.fs_st_uid + ", fs_st_gid=" + this.fs_st_gid + ", fs_st_mtime=" + this.fs_st_mtime + ", fs_st_size=" + this.fs_st_size + ", Perms=" + this.Perms + '}';
        }
    }

    public static class UniqueID
    implements Native.ComparableLower,
    Native.NativePOD<UniqueID> {
        public static final Comparator<UniqueID> COMPARATOR = new Comparator<UniqueID>(){

            @Override
            public int compare(UniqueID o1, UniqueID o2) {
                if (o1.Device == o2.Device) {
                    return Long.compare(o1.File, o2.File);
                }
                return Long.compare(o1.Device, o2.Device);
            }
        };
        private long Device;
        private long File;

        public UniqueID() {
        }

        public UniqueID(long Device, long File2) {
            this.Device = Device;
            this.File = File2;
        }

        public boolean $eq(UniqueID Other) {
            return this.Device == Other.Device && this.File == Other.File;
        }

        public boolean $noteq(UniqueID Other) {
            return !this.$eq(Other);
        }

        public boolean $less(Object Other) {
            return this.Device < ((UniqueID)Other).Device || this.Device == ((UniqueID)Other).Device && this.File < ((UniqueID)Other).File;
        }

        public boolean $lesseq(Object Other) {
            return this.Device < ((UniqueID)Other).Device || this.Device == ((UniqueID)Other).Device && this.File <= ((UniqueID)Other).File;
        }

        public long getDevice() {
            return this.Device;
        }

        public long getFile() {
            return this.File;
        }

        public UniqueID $assign(UniqueID $Prm0) {
            this.Device = $Prm0.Device;
            this.File = $Prm0.File;
            return this;
        }

        public UniqueID(UniqueID $Prm0) {
            this.Device = $Prm0.Device;
            this.File = $Prm0.File;
        }

        public UniqueID clone() {
            return new UniqueID(this);
        }

        public int hashCode() {
            int hash = 3;
            hash = 23 * hash + (int)(this.Device ^ this.Device >>> 32);
            hash = 23 * hash + (int)(this.File ^ this.File >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UniqueID other = (UniqueID)obj;
            return this.$eq(other);
        }

        public String toString() {
            return "UniqueID{Device=" + this.Device + ", File=" + this.File + '}';
        }
    }

    public static final class perms {
        public static final int no_perms = 0;
        public static final int owner_read = 256;
        public static final int owner_write = 128;
        public static final int owner_exe = 64;
        public static final int owner_all = 448;
        public static final int group_read = 32;
        public static final int group_write = 16;
        public static final int group_exe = 8;
        public static final int group_all = 56;
        public static final int others_read = 4;
        public static final int others_write = 2;
        public static final int others_exe = 1;
        public static final int others_all = 7;
        public static final int all_read = 292;
        public static final int all_write = 146;
        public static final int all_exe = 73;
        public static final int all_all = 511;
        public static final int set_uid_on_exe = 2048;
        public static final int set_gid_on_exe = 1024;
        public static final int sticky_bit = 512;
        public static final int perms_not_known = 65535;
        private final int value;

        private perms(long val) {
            this.value = (int)val;
        }

        public static perms valueOf(long val) {
            return new perms(val);
        }

        public String toString() {
            return "perms{" + Integer.toHexString(this.value) + '}';
        }
    }

    public static class space_info {
        public long capacity;
        public long free;
        public long available;
    }

    public static final class file_type
    extends Enum<file_type>
    implements Native.NativeComparable<file_type> {
        public static final /* enum */ file_type status_error = new file_type(0L);
        public static final /* enum */ file_type file_not_found = new file_type(status_error.getValue() + 1);
        public static final /* enum */ file_type regular_file = new file_type(file_not_found.getValue() + 1);
        public static final /* enum */ file_type directory_file = new file_type(regular_file.getValue() + 1);
        public static final /* enum */ file_type symlink_file = new file_type(directory_file.getValue() + 1);
        public static final /* enum */ file_type block_file = new file_type(symlink_file.getValue() + 1);
        public static final /* enum */ file_type character_file = new file_type(block_file.getValue() + 1);
        public static final /* enum */ file_type fifo_file = new file_type(character_file.getValue() + 1);
        public static final /* enum */ file_type socket_file = new file_type(fifo_file.getValue() + 1);
        public static final /* enum */ file_type type_unknown = new file_type(socket_file.getValue() + 1);
        private final int value;
        private static final /* synthetic */ file_type[] $VALUES;

        public static file_type[] values() {
            return (file_type[])$VALUES.clone();
        }

        public static file_type valueOf(String name) {
            return Enum.valueOf(file_type.class, name);
        }

        public int $int() {
            return this.getValue();
        }

        public static file_type valueOf(int val) {
            file_type out;
            file_type file_type2 = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private file_type(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $noteq(file_type other) {
            return this != other;
        }

        public boolean $eq(file_type other) {
            return this == other;
        }

        static {
            $VALUES = new file_type[]{status_error, file_not_found, regular_file, directory_file, symlink_file, block_file, character_file, fifo_file, socket_file, type_unknown};
        }

        private static final class Values {
            private static final file_type[] VALUES;
            private static final file_type[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (file_type kind : file_type.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new file_type[min < 0 ? 1 - min : 0];
                VALUES = new file_type[max >= 0 ? 1 + max : 0];
                for (file_type kind : file_type.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((file_type)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((file_type)kind).value] = kind;
                }
            }
        }
    }
}

