/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.AtRule;
import org.netbeans.modules.css.model.api.Body;
import org.netbeans.modules.css.model.api.BodyItem;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Media;
import org.netbeans.modules.css.model.api.MediaBody;
import org.netbeans.modules.css.model.api.MediaQueryList;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelVisitor;
import org.netbeans.modules.css.model.api.PropertyValue;
import org.netbeans.modules.css.model.api.SelectorsGroup;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.webkit.debugging.api.css.Media;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.css.SourceRange;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetOrigin;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class Utilities {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static org.netbeans.modules.css.model.api.Rule findRuleInStyleSheet(Model sourceModel, StyleSheet styleSheet, Rule rule) {
        int index;
        org.netbeans.modules.css.model.api.Rule result;
        int line;
        int startOffset;
        String selector = CSSUtils.normalizeSelector(rule.getSelector());
        String mediaQuery = null;
        for (org.netbeans.modules.web.webkit.debugging.api.css.Media media : rule.getMedia()) {
            if (media.getSource() != Media.Source.MEDIA_RULE) continue;
            mediaQuery = media.getText();
            mediaQuery = CSSUtils.normalizeMediaQuery(mediaQuery);
        }
        HashSet<String> properties = new HashSet<String>();
        for (Property property : rule.getStyle().getProperties()) {
            if (property.getText() == null) continue;
            String propertyName = property.getName();
            properties.add(propertyName.trim());
        }
        int sourceLine = rule.getSourceLine();
        SourceRange range = rule.getSelectorRange();
        int n = startOffset = range == null ? Short.MIN_VALUE : range.getStart();
        if (startOffset == -1 && (line = range.getStartLine()) != -1) {
            try {
                startOffset = LexerUtils.getLineBeginningOffset((CharSequence)sourceModel.getModelSource(), (int)line);
                startOffset += range.getStartColumn();
            }
            catch (BadLocationException blex) {
                Exceptions.printStackTrace((Throwable)blex);
            }
        }
        if ((result = Utilities.findRuleInStyleSheet0(sourceModel, styleSheet, selector, mediaQuery, properties, sourceLine, startOffset)) != null) return result;
        StyleSheetBody parentStyleSheet = rule.getParentStyleSheet();
        if (parentStyleSheet == null) return result;
        if (range == null) return result;
        String styleSheetText = parentStyleSheet.getText();
        if (styleSheetText == null) return result;
        int start = range.getStart();
        int end = range.getEnd();
        int startLine = range.getStartLine();
        if (start == -1 && startLine != -1) {
            try {
                styleSheetText = styleSheetText.replaceAll("\r", "");
                start = LexerUtils.getLineBeginningOffset((CharSequence)sourceModel.getModelSource(), (int)startLine);
                start += range.getStartColumn();
                end = LexerUtils.getLineBeginningOffset((CharSequence)sourceModel.getModelSource(), (int)range.getEndLine());
                end += range.getEndColumn();
            }
            catch (BadLocationException blex) {
                Exceptions.printStackTrace((Throwable)blex);
            }
        }
        selector = styleSheetText.substring(start, end);
        result = Utilities.findRuleInStyleSheet0(sourceModel, styleSheet, selector = CSSUtils.normalizeSelector(selector), mediaQuery, properties, sourceLine, startOffset);
        if (result != null) return result;
        if (rule.getMedia().isEmpty()) return result;
        if (range.getStart() != 0) return result;
        boolean inLiteral = false;
        block10: for (index = selector.length() - 1; index >= 0; --index) {
            char c = selector.charAt(index);
            switch (c) {
                case '\"': {
                    inLiteral = !inLiteral;
                    break;
                }
                case '{': 
                case '}': {
                    if (!inLiteral) break block10;
                }
            }
        }
        if (index == -1) return result;
        selector = selector.substring(index + 1);
        selector = CSSUtils.normalizeSelector(selector);
        return Utilities.findRuleInStyleSheet0(sourceModel, styleSheet, selector, mediaQuery, properties, sourceLine, startOffset);
    }

    private static org.netbeans.modules.css.model.api.Rule findRuleInStyleSheet0(final Model sourceModel, StyleSheet styleSheet, final String selector, final String mediaQuery, final Set<String> properties, final int sourceLine, final int startOffset) {
        final org.netbeans.modules.css.model.api.Rule[] result = new org.netbeans.modules.css.model.api.Rule[1];
        styleSheet.accept((ModelVisitor)new ModelVisitor.Adapter(){
            private int bestMatchValue = 0;

            public void visitRule(org.netbeans.modules.css.model.api.Rule rule) {
                int matchValue;
                String selectorInFile;
                SelectorsGroup selectorGroup = rule.getSelectorsGroup();
                CharSequence image = sourceModel.getElementSource((org.netbeans.modules.css.model.api.Element)selectorGroup);
                org.netbeans.modules.css.model.api.Element parent = rule.getParent();
                if (parent instanceof MediaBody) {
                    parent = parent.getParent();
                } else if (parent != null && parent.getParent() instanceof MediaBody) {
                    parent = parent.getParent().getParent();
                }
                String queryListText = null;
                if (parent instanceof Media) {
                    Media media = (Media)parent;
                    MediaQueryList queryList = media.getMediaQueryList();
                    queryListText = sourceModel.getElementSource((org.netbeans.modules.css.model.api.Element)queryList).toString();
                    queryListText = CSSUtils.normalizeMediaQuery(queryListText);
                }
                if (selector.equals(selectorInFile = CSSUtils.normalizeSelector(image.toString())) && (mediaQuery == null ? queryListText == null : mediaQuery.equals(queryListText)) && (matchValue = this.matchValue(rule)) >= this.bestMatchValue) {
                    this.bestMatchValue = matchValue;
                    result[0] = rule;
                }
            }

            private int matchValue(org.netbeans.modules.css.model.api.Rule rule) {
                int offset;
                int value = 0;
                Declarations declarations = rule.getDeclarations();
                if (declarations != null) {
                    for (Declaration declaration : declarations.getDeclarations()) {
                        org.netbeans.modules.css.model.api.Property modelProperty = declaration.getPropertyDeclaration().getProperty();
                        String modelPropertyName = modelProperty.getContent().toString().trim();
                        if (!properties.contains(modelPropertyName)) continue;
                        value += 2;
                    }
                }
                if ((offset = rule.getStartOffset()) == startOffset || offset + sourceLine == startOffset) {
                    try {
                        int line = LexerUtils.getLineOffset((CharSequence)sourceModel.getModelSource(), (int)offset);
                        if (line == sourceLine) {
                            ++value;
                        }
                    }
                    catch (BadLocationException blex) {
                        // empty catch block
                    }
                }
                return value;
            }
        });
        return result[0];
    }

    public static boolean goToMetaSource(org.netbeans.modules.css.model.api.Rule rule) {
        Body body;
        List bodyItems;
        int index;
        BodyItem bodyItem;
        org.netbeans.modules.css.model.api.Element parent = rule.getParent();
        if (parent instanceof BodyItem && (parent = (bodyItem = (BodyItem)parent).getParent()) instanceof Body && (index = (bodyItems = (body = (Body)parent).getBodyItems()).indexOf(bodyItem)) > 0) {
            Media media;
            BodyItem previousBodyItem = (BodyItem)bodyItems.get(index - 1);
            org.netbeans.modules.css.model.api.Element element = previousBodyItem.getElement();
            if (element instanceof AtRule) {
                element = ((AtRule)element).getElement();
            }
            if (element instanceof Media && Utilities.isMetaSourceInfo(media = (Media)element)) {
                return Utilities.goToMetaSource(media);
            }
        }
        return false;
    }

    private static boolean isMetaSourceInfo(Media media) {
        MediaQueryList queryList = media.getMediaQueryList();
        Model sourceModel = media.getModel();
        String queryListText = sourceModel.getElementSource((org.netbeans.modules.css.model.api.Element)queryList).toString();
        return "-sass-debug-info".equals(queryListText);
    }

    private static Collection<org.netbeans.modules.css.model.api.Rule> getRules(Media media) {
        return media.getMediaBody() == null ? Collections.emptySet() : media.getMediaBody().getRules();
    }

    private static boolean goToMetaSource(Media media) {
        String originalFileName = null;
        int originalLineNumber = -1;
        for (org.netbeans.modules.css.model.api.Rule rule : Utilities.getRules(media)) {
            String value;
            SelectorsGroup selectorGroup = rule.getSelectorsGroup();
            Model sourceModel = media.getModel();
            CharSequence image = sourceModel.getElementSource((org.netbeans.modules.css.model.api.Element)selectorGroup);
            String selector = image.toString();
            if ("filename".equals(selector)) {
                String prefix;
                value = Utilities.propertyValue(rule, "font-family");
                if (value == null) continue;
                StringBuilder sb = new StringBuilder();
                boolean slash = false;
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (slash && c != ':' && c != '/' && c != '.') {
                        sb.append('\\');
                    }
                    boolean bl = slash = !slash && c == '\\';
                    if (slash) continue;
                    sb.append(c);
                }
                originalFileName = sb.toString();
                if (!originalFileName.startsWith(prefix = "file://")) continue;
                originalFileName = originalFileName.substring(prefix.length());
                continue;
            }
            if (!"line".equals(selector)) continue;
            value = Utilities.propertyValue(rule, "font-family");
            String prefix = "\\00003";
            if (value == null || !value.startsWith(prefix)) continue;
            String lineTxt = value.substring(prefix.length());
            try {
                originalLineNumber = Integer.parseInt(lineTxt);
            }
            catch (NumberFormatException nfex) {
                Logger.getLogger(Utilities.class.getName()).log(Level.INFO, null, nfex);
            }
        }
        if (originalFileName != null && originalLineNumber != -1) {
            File file = new File(originalFileName);
            final FileObject fob = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
            if (fob != null) {
                final int lineNo = originalLineNumber - 1;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CSSUtils.openAtLine(fob, lineNo);
                    }
                });
                return true;
            }
        }
        return false;
    }

    private static String propertyValue(org.netbeans.modules.css.model.api.Rule rule, String propertyName) {
        String propertyValue = null;
        Declarations declarations = rule.getDeclarations();
        if (declarations != null) {
            for (Declaration declaration : declarations.getDeclarations()) {
                org.netbeans.modules.css.model.api.Property modelProperty = declaration.getPropertyDeclaration().getProperty();
                String modelPropertyName = modelProperty.getContent().toString().trim();
                if (!propertyName.equals(modelPropertyName)) continue;
                PropertyValue value = declaration.getPropertyDeclaration().getPropertyValue();
                propertyValue = value.getExpression().getContent().toString();
            }
        }
        return propertyValue;
    }

    public static boolean showInCSSStyles(Rule rule) {
        return rule.getOrigin() != StyleSheetOrigin.USER_AGENT;
    }

    public static org.openide.nodes.Node findRule(org.openide.nodes.Node root, Rule rule) {
        Rule candidate = (Rule)root.getLookup().lookup(Rule.class);
        if (candidate != null && Objects.equals(rule.getId(), candidate.getId()) && Objects.equals(rule.getSourceURL(), candidate.getSourceURL()) && Objects.equals(rule.getSelector(), candidate.getSelector())) {
            return root;
        }
        for (org.openide.nodes.Node node : root.getChildren().getNodes()) {
            org.openide.nodes.Node result = Utilities.findRule(node, rule);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<CssParserResult> cssParserResults(ResultIterator resultIterator) throws ParseException {
        ArrayList<ResultIterator> resultIterators = new ArrayList<ResultIterator>();
        resultIterators.add(resultIterator);
        for (Embedding embedding : resultIterator.getEmbeddings()) {
            String mimeType = embedding.getMimeType();
            if (!"text/css".equals(mimeType)) continue;
            resultIterators.add(resultIterator.getResultIterator(embedding));
        }
        ArrayList<CssParserResult> parserResults = new ArrayList<CssParserResult>(resultIterators.size());
        for (ResultIterator iterator : resultIterators) {
            Parser.Result parserResult = iterator.getParserResult();
            if (!(parserResult instanceof CssParserResult)) continue;
            parserResults.add((CssParserResult)parserResult);
        }
        return parserResults;
    }

    public static String relativeResourceName(String resourceUrl, Project project) {
        FileObject projectDir;
        String relativePath;
        FileObject fob;
        String name = resourceUrl;
        if (project != null && (fob = new Resource(project, resourceUrl).toFileObject()) != null && (relativePath = FileUtil.getRelativePath((FileObject)(projectDir = project.getProjectDirectory()), (FileObject)fob)) != null) {
            name = relativePath;
        }
        return name;
    }

    public static org.netbeans.modules.html.editor.lib.api.elements.Node findNode(HtmlParsingResult result, Node node) {
        org.netbeans.modules.html.editor.lib.api.elements.Node root;
        org.netbeans.modules.html.editor.lib.api.elements.Node nearestNode = root = result.root();
        for (Node domParent = node; domParent != null; domParent = domParent.getParent()) {
            org.netbeans.modules.html.editor.lib.api.elements.Node sourceParent;
            String id;
            String tagName = domParent.getNodeName();
            Node.Attribute attribute = domParent.getAttribute("id");
            String string = id = attribute == null ? null : attribute.getValue();
            if (id != null && (sourceParent = Utilities.findElementByID(root, id)) != null) {
                nearestNode = Utilities.findNode(node, domParent, sourceParent);
                break;
            }
            if (!"html".equalsIgnoreCase(tagName)) continue;
            sourceParent = Utilities.findElementByTagName(root, "html");
            nearestNode = Utilities.findNode(node, domParent, sourceParent);
            break;
        }
        return nearestNode;
    }

    private static org.netbeans.modules.html.editor.lib.api.elements.Node findElementByID(org.netbeans.modules.html.editor.lib.api.elements.Node root, String id) {
        org.netbeans.modules.html.editor.lib.api.elements.Node result;
        block3: {
            String nodeId;
            result = null;
            if (!(root instanceof OpenTag)) break block3;
            OpenTag tag = (OpenTag)root;
            Attribute attr = tag.getAttribute("id");
            CharSequence seq = attr == null ? null : attr.unquotedValue();
            String string = nodeId = seq == null ? null : seq.toString();
            if (id.equals(nodeId)) {
                result = root;
            } else {
                Element element;
                Iterator i$ = root.children(ElementType.OPEN_TAG).iterator();
                while (i$.hasNext() && (result = Utilities.findElementByID((org.netbeans.modules.html.editor.lib.api.elements.Node)(element = (Element)i$.next()), id)) == null) {
                }
            }
        }
        return result;
    }

    private static org.netbeans.modules.html.editor.lib.api.elements.Node findElementByTagName(org.netbeans.modules.html.editor.lib.api.elements.Node root, String tagName) {
        org.netbeans.modules.html.editor.lib.api.elements.Node result;
        block3: {
            result = null;
            if (!(root instanceof OpenTag)) break block3;
            OpenTag tag = (OpenTag)root;
            String name = tag.name().toString();
            if (tagName.equalsIgnoreCase(name)) {
                result = root;
            } else {
                Element element;
                Iterator i$ = root.children(ElementType.OPEN_TAG).iterator();
                while (i$.hasNext() && (result = Utilities.findElementByTagName((org.netbeans.modules.html.editor.lib.api.elements.Node)(element = (Element)i$.next()), tagName)) == null) {
                }
            }
        }
        return result;
    }

    private static org.netbeans.modules.html.editor.lib.api.elements.Node findNode(Node node, Node domParent, org.netbeans.modules.html.editor.lib.api.elements.Node sourceParent) {
        Node parent;
        LinkedList<Node> parentChain = new LinkedList<Node>();
        for (parent = node; parent != domParent; parent = parent.getParent()) {
            parentChain.add(0, parent);
        }
        parentChain.add(0, parent);
        return Utilities.findNode(parentChain, sourceParent);
    }

    private static org.netbeans.modules.html.editor.lib.api.elements.Node findNode(List<Node> parentChain, org.netbeans.modules.html.editor.lib.api.elements.Node sourceParent) {
        if (parentChain.size() == 1) {
            return sourceParent;
        }
        org.netbeans.modules.html.editor.lib.api.elements.Node nextParent = null;
        parentChain.remove(0);
        Node domChild = parentChain.get(0);
        int domIndex = Utilities.elementIndexInParent(domChild);
        if (domIndex == -1) {
            return sourceParent;
        }
        ArrayList children = new ArrayList(sourceParent.children(ElementType.OPEN_TAG));
        for (int i = 0; i <= Math.max(domIndex, children.size() - 1); ++i) {
            org.netbeans.modules.html.editor.lib.api.elements.Node candidate;
            int index = domIndex + i;
            if (index < children.size() && Utilities.match(domChild, candidate = (org.netbeans.modules.html.editor.lib.api.elements.Node)children.get(index))) {
                nextParent = candidate;
                break;
            }
            if (i == 0 || 0 > (index = domIndex - i) || index >= children.size() || !Utilities.match(domChild, candidate = (org.netbeans.modules.html.editor.lib.api.elements.Node)children.get(index))) continue;
            nextParent = candidate;
        }
        return nextParent == null ? sourceParent : Utilities.findNode(parentChain, nextParent);
    }

    private static boolean match(Node domNode, org.netbeans.modules.html.editor.lib.api.elements.Node sourceNode) {
        if (sourceNode instanceof OpenTag) {
            String name;
            Attribute sourceAttr;
            CharSequence seq;
            String sourceID;
            OpenTag tag = (OpenTag)sourceNode;
            String sourceTagName = tag.name().toString();
            if (!domNode.getNodeName().equalsIgnoreCase(sourceTagName)) {
                return false;
            }
            if ("html".equalsIgnoreCase(sourceTagName) || "body".equalsIgnoreCase(sourceTagName) || "head".equalsIgnoreCase(sourceTagName) || "title".equalsIgnoreCase(sourceTagName)) {
                return true;
            }
            Node.Attribute domAttr = domNode.getAttribute("id");
            String domID = domAttr == null ? null : domAttr.getValue();
            if (domID == null != ((sourceID = (seq = (sourceAttr = tag.getAttribute("id")) == null ? null : sourceAttr.unquotedValue()) == null ? null : seq.toString()) == null)) {
                return false;
            }
            if (domID != null && domID.equals(sourceID)) {
                return true;
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Node.Attribute attribute : domNode.getAttributes()) {
                name = attribute.getName().toUpperCase();
                if (Utilities.ignoreWhenMatching(name)) continue;
                attributes.put(name, attribute.getValue());
            }
            for (Node.Attribute attribute : tag.attributes()) {
                String sourceValue;
                name = attribute.name().toString().toUpperCase();
                if (Utilities.ignoreWhenMatching(name)) continue;
                String domValue = (String)attributes.get(name);
                CharSequence sourceSeq = attribute.unquotedValue();
                String string = sourceValue = sourceSeq == null ? "" : sourceSeq.toString();
                if (domValue == null || !domValue.equals(sourceValue)) {
                    return false;
                }
                attributes.remove(name);
            }
            return attributes.isEmpty();
        }
        return false;
    }

    private static boolean ignoreWhenMatching(String attribute) {
        return "STYLE".equals(attribute) || "CLASS".equals(attribute) || attribute.startsWith("DATA-");
    }

    private static int elementIndexInParent(Node element) {
        int index = 0;
        Node parent = element.getParent();
        for (Node child : parent.getChildren()) {
            if (child.getNodeType() != 1) continue;
            if (child == element) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

