/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.highlight.security.FunctionUsageAudit;
import org.netbeans.modules.cnd.highlight.security.FunctionsXmlService;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SecurityCheckProvider
extends CsmErrorProvider
implements CodeAuditProvider {
    public static final String WARNING_SECURITY_ANNOTATION_TYPE = "org-netbeans-modules-cnd-highlight-security-warning";
    public static final String ERROR_SECURITY_ANNOTATION_TYPE = "org-netbeans-modules-cnd-highlight-security-error";
    public static final String NAME = "Security";
    private Collection<CodeAudit> audits;
    private final AuditPreferences myPreferences;

    public static CodeAuditProvider getInstance() {
        for (CodeAuditProvider provider : Lookup.getDefault().lookupAll(CodeAuditProvider.class)) {
            if (!NAME.equals(provider.getName())) continue;
            return provider;
        }
        return null;
    }

    public SecurityCheckProvider() {
        this.myPreferences = new AuditPreferences(AuditPreferences.AUDIT_PREFERENCES_ROOT.node(NAME));
    }

    SecurityCheckProvider(Preferences preferences) {
        try {
            if (preferences.nodeExists(NAME)) {
                preferences = preferences.node(NAME);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.myPreferences = preferences.absolutePath().endsWith("/Security") ? new AuditPreferences(preferences) : new AuditPreferences(preferences.node(NAME));
    }

    protected boolean validate(CsmErrorProvider.Request request) {
        CsmFile file = request.getFile();
        if (file == null) {
            return false;
        }
        for (CodeAudit audit : this.getAudits()) {
            if (!audit.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean hasHintControlPanel() {
        return true;
    }

    public String getName() {
        return NAME;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SecurityCheckProvider.class, (String)"SecurityCheck_NAME");
    }

    public String getDescription() {
        return NbBundle.getMessage(SecurityCheckProvider.class, (String)"SecurityCheck_DESCRIPTION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        if (file != null) {
            if (request.isCancelled()) {
                return;
            }
            CsmCacheManager.enter();
            try {
                for (CodeAudit audit : this.getAudits()) {
                    if (request.isCancelled()) {
                        return;
                    }
                    AbstractCodeAudit engine = (AbstractCodeAudit)audit;
                    if (!engine.isEnabled() || !engine.isSupportedEvent(request.getEvent())) continue;
                    engine.doGetErrors(request, response);
                }
            }
            finally {
                CsmCacheManager.leave();
            }
        }
    }

    public synchronized Collection<CodeAudit> getAudits() {
        if (this.audits == null || this.audits.isEmpty()) {
            String description;
            String name;
            String id;
            FunctionsXmlService service = FunctionsXmlService.getInstance();
            ArrayList<CodeAudit> result = new ArrayList<CodeAudit>(service.getChecksCount());
            for (FunctionsXmlService.Category category : service.getCategories(FunctionsXmlService.Level.UNSAFE)) {
                id = FunctionsXmlService.Level.UNSAFE.getLevel() + category.getName();
                name = "(" + FunctionsXmlService.Level.UNSAFE.name().toUpperCase(Locale.getDefault()) + ") " + category.getName();
                description = NbBundle.getMessage(FunctionUsageAudit.class, (String)("FunctionUsageAudit." + category.getName() + ".description"));
                result.add((CodeAudit)new FunctionUsageAudit(FunctionsXmlService.Level.UNSAFE, category, id, name, description, "error", ERROR_SECURITY_ANNOTATION_TYPE, true, this.myPreferences));
            }
            for (FunctionsXmlService.Category category : service.getCategories(FunctionsXmlService.Level.AVOID)) {
                id = FunctionsXmlService.Level.AVOID.getLevel() + category.getName();
                name = "(" + FunctionsXmlService.Level.AVOID.name().toUpperCase(Locale.getDefault()) + ") " + category.getName();
                description = NbBundle.getMessage(FunctionUsageAudit.class, (String)("FunctionUsageAudit." + category.getName() + ".description"));
                result.add((CodeAudit)new FunctionUsageAudit(FunctionsXmlService.Level.AVOID, category, id, name, description, "warning", WARNING_SECURITY_ANNOTATION_TYPE, true, this.myPreferences));
            }
            for (FunctionsXmlService.Category category : service.getCategories(FunctionsXmlService.Level.CAUTION)) {
                id = FunctionsXmlService.Level.CAUTION.getLevel() + category.getName();
                name = "(" + FunctionsXmlService.Level.CAUTION.name().toUpperCase(Locale.getDefault()) + ") " + category.getName();
                description = NbBundle.getMessage(FunctionUsageAudit.class, (String)("FunctionUsageAudit." + category.getName() + ".description"));
                result.add((CodeAudit)new FunctionUsageAudit(FunctionsXmlService.Level.CAUTION, category, id, name, description, "warning", WARNING_SECURITY_ANNOTATION_TYPE, false, this.myPreferences));
            }
            Collections.sort(result, new Comparator<CodeAudit>(){

                @Override
                public int compare(CodeAudit o1, CodeAudit o2) {
                    return o1.getID().compareTo(o2.getID());
                }
            });
            this.audits = result;
        }
        return this.audits;
    }

    public AuditPreferences getPreferences() {
        return this.myPreferences;
    }

    public String getMimeType() {
        return "text/x-cnd+sourcefile";
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        for (CodeAudit audit : this.getAudits()) {
            AbstractCodeAudit engine = (AbstractCodeAudit)audit;
            if (!engine.isSupportedEvent(kind)) continue;
            return true;
        }
        return false;
    }
}

