/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;

public final class BuildTraceSupport {
    public static final String CND_TOOLS = "__CND_TOOLS__";
    public static final String CND_BUILD_LOG = "__CND_BUILD_LOG__";
    private static final String SEPARATOR = ":";

    private BuildTraceSupport() {
    }

    public static boolean useBuildTrace(MakeConfiguration conf) {
        return conf.getCodeAssistanceConfiguration().getBuildAnalyzer().getValue();
    }

    public static boolean resolveSymbolicLinks(MakeConfiguration conf) {
        return conf.getCodeAssistanceConfiguration().getResolveSymbolicLinks().getValue();
    }

    public static String getTools(MakeConfiguration conf, ExecutionEnvironment execEnv) {
        String res = conf.getCodeAssistanceConfiguration().getTools().getValue();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        res = BuildTraceSupport.prepengTool(compilerSet, execEnv, PredefinedToolKind.CCompiler, res);
        res = BuildTraceSupport.prepengTool(compilerSet, execEnv, PredefinedToolKind.CCCompiler, res);
        res = BuildTraceSupport.prepengTool(compilerSet, execEnv, PredefinedToolKind.FortranCompiler, res);
        return res;
    }

    public static boolean supportedPlatforms(ExecutionEnvironment execEnv) {
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            HostInfo.OSFamily osFamily = hostInfo.getOSFamily();
            HostInfo.CpuFamily cpuFamily = hostInfo.getCpuFamily();
            switch (osFamily) {
                case MACOSX: {
                    return cpuFamily == HostInfo.CpuFamily.X86;
                }
                case LINUX: {
                    return cpuFamily == HostInfo.CpuFamily.X86 || cpuFamily == HostInfo.CpuFamily.SPARC;
                }
                case SUNOS: {
                    return cpuFamily == HostInfo.CpuFamily.X86 || cpuFamily == HostInfo.CpuFamily.SPARC;
                }
            }
        }
        catch (IOException ex) {
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return false;
    }

    public static Set<String> getCompilerNames(Project project, PredefinedToolKind kind) {
        HashSet<String> res = new HashSet<String>();
        switch (kind) {
            case CCompiler: {
                res.add("cc");
                res.add("gcc");
                res.add("xgcc");
                res.add("clang");
                res.add("icc");
                BuildTraceSupport.addTool(project, kind, res);
                break;
            }
            case CCCompiler: {
                res.add("CC");
                res.add("g++");
                res.add("c++");
                res.add("clang++");
                res.add("icpc");
                res.add("cl");
                BuildTraceSupport.addTool(project, kind, res);
                break;
            }
            case FortranCompiler: {
                res.add("ffortran");
                res.add("f77");
                res.add("f90");
                res.add("f95");
                res.add("gfortran");
                res.add("g77");
                res.add("g90");
                res.add("g95");
                res.add("ifort");
                BuildTraceSupport.addTool(project, kind, res);
            }
        }
        return res;
    }

    private static String prepengTool(CompilerSet compilerSet, ExecutionEnvironment execEnv, PredefinedToolKind kind, String res) {
        if (compilerSet == null) {
            return res;
        }
        Tool tool = compilerSet.getTool((ToolKind)kind);
        if (tool == null) {
            return res;
        }
        String name = tool.getName();
        if (name == null || name.isEmpty()) {
            return res;
        }
        res = BuildTraceSupport.addIfNeeded(name, res);
        String path = tool.getPath();
        try {
            String canonicalPath = FileSystemProvider.getCanonicalPath((ExecutionEnvironment)execEnv, (String)path);
            if (canonicalPath != null && (name = CndPathUtilities.getBaseName((String)canonicalPath)) != null && !name.isEmpty()) {
                res = BuildTraceSupport.addIfNeeded(name, res);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return res;
    }

    private static String addIfNeeded(String name, String res) {
        for (String s : res.split(SEPARATOR)) {
            if (!s.equals(name)) continue;
            return res;
        }
        res = res.isEmpty() ? name : name + SEPARATOR + res;
        return res;
    }

    private static void addTool(Project project, PredefinedToolKind kind, Set<String> res) {
        CompilerSet compilerSet;
        ProjectBridge projectBridge;
        if (project != null && (projectBridge = new ProjectBridge(project)).isValid() && (compilerSet = projectBridge.getCompilerSet()) != null) {
            Tool tool;
            MakeConfiguration activeConfiguration;
            MakeConfigurationDescriptor descriptor;
            ExecutionEnvironment execEnv = null;
            ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (provider != null && provider.gotDescriptor() && (descriptor = provider.getConfigurationDescriptor()) != null && (activeConfiguration = descriptor.getActiveConfiguration()) != null) {
                execEnv = activeConfiguration.getDevelopmentHost().getExecutionEnvironment();
            }
            if ((tool = compilerSet.getTool((ToolKind)kind)) != null) {
                String name = tool.getName();
                if (name != null && !name.isEmpty()) {
                    if (name.endsWith(".exe")) {
                        name = name.substring(0, name.length() - 4);
                    }
                    res.add(name);
                }
                if (execEnv != null) {
                    String path = tool.getPath();
                    try {
                        String canonicalPath = FileSystemProvider.getCanonicalPath((ExecutionEnvironment)execEnv, (String)path);
                        if (canonicalPath != null && (name = CndPathUtilities.getBaseName((String)canonicalPath)) != null && !name.isEmpty()) {
                            if (name.endsWith(".exe")) {
                                name = name.substring(0, name.length() - 4);
                            }
                            res.add(name);
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

