/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.performance;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class FileSystemChecker {
    private static final int SOCKET_CONNECTION_TIMEOUT = 5000;
    private static final int TIME_TRASH_HOLD = 10;
    private static final int LS_SPEED_TRASH_HOLD = 300;
    private static final int READ_SPEED_TRASH_HOLD = 100;

    public static void main(String[] args) throws IOException {
        if (args.length < 4) {
            FileSystemChecker.usages();
            return;
        }
        String root = null;
        int depth = 0;
        boolean checkLinks = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-path".equals(args[i]) && i + 1 < args.length) {
                root = args[i + 1];
                continue;
            }
            if ("-depth".equals(args[i]) && i + 1 < args.length) {
                depth = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (!"-link".equals(args[i])) continue;
            checkLinks = true;
        }
        if (root == null || depth == 0) {
            FileSystemChecker.usages();
            return;
        }
        Path resolve = Paths.get(root, new String[0]);
        if (Files.exists(resolve, new LinkOption[0])) {
            FileSystemChecker.go(resolve, depth, checkLinks);
        } else {
            System.err.println("Path " + resolve + " does not exist");
        }
    }

    private static void go(Path root, int depth, boolean checkLinks) throws IOException {
        HashSet<FileVisitOption> options = new HashSet<FileVisitOption>();
        options.add(FileVisitOption.FOLLOW_LINKS);
        System.out.println("Root " + root);
        System.out.println("Depth " + depth);
        MyFileVisitor myVisitor = new MyFileVisitor(root, checkLinks);
        Files.walkFileTree(root, options, depth, myVisitor);
        for (Statistic store : myVisitor.stores.values()) {
            String host;
            int sep;
            System.out.println(store.store.type() + "\t" + store.store.name());
            if (store.startPath != null) {
                System.out.println("\tShortest path\t" + store.startPath);
            }
            if (store.duration > 0L) {
                System.out.println("\tVisit " + FileSystemChecker.format(store.visitCount) + " items for " + FileSystemChecker.format(store.duration / 1000L / 1000L) + " ms. " + FileSystemChecker.format(store.visitCount * 1000L * 1000L * 1000L / store.duration) + " items/s");
            }
            if (store.readTime > 0L) {
                System.out.println("\tRead " + FileSystemChecker.format(store.readCount / 1024L) + " Kb for " + FileSystemChecker.format(store.readTime / 1000L / 1000L) + " ms. " + FileSystemChecker.format(store.readCount * 1000L * 1000L * 1000L / store.readTime / 1024L) + " Kb/s");
            }
            if ("nfs".equals(store.store.type()) && (sep = (host = store.store.name()).indexOf(58)) > 0) {
                String mountPath = host.substring(sep + 1);
                if ((host = host.substring(0, sep)).indexOf(44) > 0) {
                    host = host.substring(0, host.indexOf(44));
                }
                long socketPing = FileSystemChecker.getSocketPing(host);
                System.out.println("\tPing " + FileSystemChecker.format(socketPing / 1000L) + " mcs.");
            }
            if (store.duration > 0L) {
                long time = store.duration / 1000L / 1000L / 1000L;
                long speed = store.visitCount * 1000L * 1000L * 1000L / store.duration;
                if (time > 10L && speed < 300L) {
                    System.out.println("\tSlow file system detected. Expected visiting speed more than 300 items/s.");
                }
            }
            if (store.readTime <= 0L) continue;
            long time = store.readTime / 1000L / 1000L / 1000L;
            long speed = store.readCount * 1000L * 1000L * 1000L / store.readTime / 1024L;
            if (time <= 10L || speed >= 100L) continue;
            System.out.println("\tSlow file system detected. Expected reading speed more than 100 Kb/s.");
        }
    }

    private static long getSocketPing(String host) {
        try {
            ArrayList<Long> times = new ArrayList<Long>();
            int COUNT = 25;
            InetAddress addr = InetAddress.getByName(host);
            for (int i = 0; i < COUNT; ++i) {
                try {
                    long s = System.nanoTime();
                    addr.isReachable(5000);
                    long delta = System.nanoTime() - s;
                    times.add(delta);
                    continue;
                }
                catch (ConnectException ex) {
                    continue;
                }
                catch (SocketTimeoutException ex) {
                    continue;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (times.size() > 0) {
                Collections.sort(times);
                return (Long)times.get(0);
            }
        }
        catch (UnknownHostException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }

    private static String format(long val) {
        String res = Long.toString(val);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < res.length(); ++i) {
            char c = res.charAt(res.length() - i - 1);
            if (i % 3 == 0 && i > 0) {
                buf.insert(0, ',');
            }
            buf.insert(0, c);
        }
        return buf.toString();
    }

    private static void usages() {
        System.err.println("Check File System Performance");
        System.err.println("Usage:");
        System.err.println("java -cp org-netbeans-modules-cnd-discovery.jar org.netbeans.modules.cnd.discovery.performance.FileSystemChecker -path <path> -depth <depth>");
        System.err.println("\t-path <path>\tAbsolute path to source root");
        System.err.println("\t-depth <depth>\tRestrict traverse subfolders");
        System.err.println("\t-link\tPrint links that go out of the root");
    }

    private static final class Statistic {
        private final FileStore store;
        private Path startPath = null;
        private long readCount = 0L;
        private long readTime = 0L;
        private long visitCount = 0L;
        private long duration;

        private Statistic(FileStore store) {
            this.store = store;
        }
    }

    private static final class MyFileVisitor
    implements FileVisitor<Path> {
        private final Path root;
        private final boolean checkLinks;
        private long currStart;
        private final HashMap<FileStore, Statistic> stores = new HashMap();

        private MyFileVisitor(Path root, boolean checkLinks) {
            this.root = root;
            this.checkLinks = checkLinks;
            this.currStart = System.nanoTime();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String name;
            FileStore fileStore = Files.getFileStore(dir);
            Statistic stat = this.stores.get(fileStore);
            if (stat == null) {
                stat = new Statistic(fileStore);
                this.stores.put(fileStore, stat);
            }
            if (stat.startPath == null) {
                stat.startPath = dir;
            } else if (stat.startPath.toString().length() > dir.toString().length()) {
                stat.startPath = dir;
            }
            Path fileName = dir.getFileName();
            if (fileName != null && (name = fileName.toString()) != null && (name.equals("SCCS") || name.equals("CVS") || name.equals(".hg") || name.equals(".svn") || name.equals(".ade_path"))) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            try {
                if (Files.isSymbolicLink(file)) {
                    Path to = Files.readSymbolicLink(file);
                    if (!to.isAbsolute()) {
                        to = file.getParent().resolve(to).normalize();
                    }
                    if (this.checkLinks && !to.startsWith(this.root)) {
                        System.out.println("Linked dir " + file + " -> " + to);
                    }
                    if (Files.isRegularFile(to, new LinkOption[0])) {
                        this.countRegularFile(to);
                    }
                } else if (Files.isRegularFile(file, new LinkOption[0])) {
                    this.countRegularFile(file);
                } else if (Files.isDirectory(file, new LinkOption[0])) {
                    FileStore fileStore = Files.getFileStore(file);
                    Statistic stat = this.stores.get(fileStore);
                    if (stat == null) {
                        stat = new Statistic(fileStore);
                        this.stores.put(fileStore, stat);
                    }
                    if (stat.startPath == null) {
                        stat.startPath = file;
                    } else if (stat.startPath.toString().length() > file.toString().length()) {
                        stat.startPath = file;
                    }
                    stat.visitCount++;
                    long beg = System.nanoTime();
                    stat.duration += beg - this.currStart;
                    this.currStart = beg;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFile(Path file, Statistic stat) {
            long beg = System.nanoTime();
            if (Files.isReadable(file)) {
                try (InputStream read = Files.newInputStream(file, new OpenOption[0]);){
                    int i;
                    int count = 0;
                    while ((i = read.read()) >= 0) {
                        stat.readCount++;
                        if (count > 10240) {
                            break;
                        }
                        ++count;
                    }
                }
                catch (IOException ex) {
                }
                finally {
                    stat.readTime += System.nanoTime() - beg;
                }
            }
        }

        private void countRegularFile(Path file) throws IOException {
            FileStore fileStore = Files.getFileStore(file);
            Statistic stat = this.stores.get(fileStore);
            if (stat == null) {
                stat = new Statistic(fileStore);
                this.stores.put(fileStore, stat);
            }
            if (stat.startPath == null) {
                stat.startPath = file;
            } else if (stat.startPath.toString().length() > file.toString().length()) {
                stat.startPath = file;
            }
            stat.visitCount++;
            stat.duration += System.nanoTime() - this.currStart;
            this.readFile(file, stat);
            this.currStart = System.nanoTime();
        }
    }
}

