/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class DoubleFile {
    private final File localFile;
    private final String remotePath;
    private final ExecutionEnvironment remoteEE;
    private boolean validLocal = true;
    private boolean validRemote = true;

    private DoubleFile(File localPath, String remotePath, ExecutionEnvironment remoteEE) {
        this.localFile = localPath;
        this.remotePath = remotePath;
        this.remoteEE = remoteEE;
    }

    public static DoubleFile createFile(String prefix, FSPath path) {
        File local;
        ExecutionEnvironment ee = FileSystemProvider.getExecutionEnvironment((FileSystem)path.getFileSystem());
        if (ee.isLocal()) {
            return new DoubleFile(new File(path.getPath()), null, ee);
        }
        try {
            local = File.createTempFile(prefix, ".log");
            local.deleteOnExit();
        }
        catch (IOException ex) {
            return null;
        }
        return new DoubleFile(local, path.getPath(), ee);
    }

    public static DoubleFile createFile(File path, ExecutionEnvironment ee) {
        File local = path;
        local.deleteOnExit();
        String remotePath = null;
        if (ee.isRemote()) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ee);
                if (ee.isRemote()) {
                    remotePath = hostInfo.getTempDir() + "/" + local.getName();
                }
            }
            catch (IOException | ConnectionManager.CancellationException ex) {
                // empty catch block
            }
        }
        return new DoubleFile(local, remotePath, ee);
    }

    public static DoubleFile createTmpFile(String prefix, ExecutionEnvironment ee) {
        File local;
        try {
            local = File.createTempFile(prefix, ".log");
            local.deleteOnExit();
        }
        catch (IOException ex) {
            return null;
        }
        local.deleteOnExit();
        String remotePath = null;
        if (ee.isRemote()) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ee);
                if (ee.isRemote()) {
                    remotePath = hostInfo.getTempDir() + "/" + local.getName();
                }
            }
            catch (IOException | ConnectionManager.CancellationException ex) {
                // empty catch block
            }
        }
        return new DoubleFile(local, remotePath, ee);
    }

    public boolean isValidRemote() {
        return this.validRemote;
    }

    public FileObject getLocalFileObject() {
        return FileUtil.toFileObject((File)this.localFile);
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public boolean existLocalFile() {
        return this.localFile.exists() && this.validLocal;
    }

    public String getLocalPath() {
        return this.localFile.getAbsolutePath();
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    void upload() {
        try {
            Future task = CommonTasksSupport.uploadFile((File)this.localFile, (ExecutionEnvironment)this.remoteEE, (String)this.remotePath, (int)365);
            if (ImportProject.TRACE) {
                ImportProject.logger.log(Level.INFO, "#upload file {0}->{1}", new Object[]{this.localFile.getAbsolutePath(), this.remotePath});
            }
            task.get();
        }
        catch (Throwable ex) {
            ImportProject.logger.log(Level.INFO, "Cannot upload file {0}->{1}. Exception {2}", new Object[]{this.localFile.getAbsolutePath(), this.remotePath, ex.getMessage()});
            this.validRemote = false;
        }
    }

    void download() {
        try {
            if (HostInfoUtils.fileExists((ExecutionEnvironment)this.remoteEE, (String)this.remotePath)) {
                Future task = CommonTasksSupport.downloadFile((String)this.remotePath, (ExecutionEnvironment)this.remoteEE, (String)this.localFile.getAbsolutePath(), null);
                if (ImportProject.TRACE) {
                    ImportProject.logger.log(Level.INFO, "#download file {0}->{1}", new Object[]{this.remotePath, this.localFile.getAbsolutePath()});
                }
                task.get();
            }
        }
        catch (Throwable ex) {
            ImportProject.logger.log(Level.INFO, "Cannot download file {0}->{1}. Exception {2}", new Object[]{this.remotePath, this.localFile.getAbsolutePath(), ex.getMessage()});
            this.validLocal = false;
        }
    }
}

