/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFunctionDefinitionResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.projectimport.CreateDependencies;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.support.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.api.wizards.WizardConstants;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImportExecutable
implements PropertyChangeListener {
    private static final boolean DLL_FILE_SEARCH = true;
    private static final RequestProcessor RP = new RequestProcessor(ImportExecutable.class.getName(), 2);
    private final Map<String, Object> map;
    private Project lastSelectedProject;
    private final IteratorExtension.ProjectKind projectKind;
    private CreateDependencies cd;
    private final boolean createProjectMode;
    private String sourcesPath;
    private boolean addSourceRoot;
    private List<String> dependencies;
    private CsmModel model;
    private IteratorExtension extension;
    private FileSystem sourceFileSystem;
    private static final List<CsmProgressListener> listeners = new ArrayList<CsmProgressListener>(1);

    public ImportExecutable(Map<String, Object> map, Project lastSelectedProject, IteratorExtension.ProjectKind projectKind) {
        this.map = map;
        this.lastSelectedProject = lastSelectedProject;
        this.projectKind = projectKind;
        if (lastSelectedProject == null) {
            this.createProjectMode = true;
            this.postCreateProject();
        } else {
            this.addSourceRoot = true;
            this.createProjectMode = false;
            try {
                this.sourceFileSystem = lastSelectedProject.getProjectDirectory().getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                ex.printStackTrace(System.err);
            }
            this.extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
        }
    }

    private void postCreateProject() {
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportExecutable.class, (String)"ImportExecutable.Progress.ProjectCreating"));
                progress.start();
                try {
                    ImportExecutable.this.createProject();
                }
                catch (Throwable ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    progress.finish();
                }
            }
        });
    }

    private void createProject() {
        String baseDir;
        String binaryPath = (String)WizardConstants.PROPERTY_BUILD_RESULT.fromMap(this.map);
        ArrayList<String> libs = new ArrayList<String>();
        String firstBinary = null;
        for (String s : binaryPath.split(";")) {
            String path = s.trim();
            if (path.isEmpty()) continue;
            if (firstBinary == null) {
                firstBinary = path;
                continue;
            }
            libs.add(s);
        }
        binaryPath = firstBinary;
        ExecutionEnvironment fullRemoteEnv = (ExecutionEnvironment)WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.fromMap(this.map);
        FileSystem fullRemotefileSystem = null;
        if (fullRemoteEnv != null) {
            fullRemotefileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)fullRemoteEnv);
        }
        this.sourcesPath = (String)WizardConstants.PROPERTY_SOURCE_FOLDER_PATH.fromMap(this.map);
        FSPath projectFolder = (FSPath)WizardConstants.PROPERTY_PROJECT_FOLDER.fromMap(this.map);
        String projectName = (String)WizardConstants.PROPERTY_NAME.fromMap(this.map);
        this.dependencies = (List)WizardConstants.PROPERTY_DEPENDENCIES.fromMap(this.map);
        if (projectFolder != null) {
            projectFolder = new FSPath(projectFolder.getFileSystem(), RemoteFileUtil.normalizeAbsolutePath((String)projectFolder.getPath(), (ExecutionEnvironment)FileSystemProvider.getExecutionEnvironment((FileSystem)projectFolder.getFileSystem())));
            baseDir = projectFolder.getPath();
            this.sourceFileSystem = projectFolder.getFileSystem();
            if (projectName == null) {
                projectName = CndPathUtilities.getBaseName((String)baseDir);
            }
        } else {
            String projectParentFolder = ProjectGenerator.getDefaultProjectFolder();
            if (projectName == null) {
                projectName = ProjectGenerator.getValidProjectName((String)projectParentFolder, (String)CndPathUtilities.getBaseName((String)binaryPath));
            }
            ExecutionEnvironment ee = ExecutionEnvironmentFactory.getLocal();
            this.sourceFileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)ee);
            baseDir = projectParentFolder + CndFileUtils.getFileSeparatorChar((FileSystem)this.sourceFileSystem) + projectName;
            projectFolder = new FSPath(this.sourceFileSystem, RemoteFileUtil.normalizeAbsolutePath((String)baseDir, (ExecutionEnvironment)ee));
        }
        String hostUID = (String)WizardConstants.PROPERTY_HOST_UID.fromMap(this.map);
        CompilerSet toolchain = (CompilerSet)WizardConstants.PROPERTY_TOOLCHAIN.fromMap(this.map);
        boolean defaultToolchain = Boolean.TRUE.equals(WizardConstants.PROPERTY_TOOLCHAIN_DEFAULT.fromMap(this.map));
        MakeConfiguration conf = MakeConfiguration.createMakefileConfiguration((FSPath)projectFolder, (String)"Default", (String)hostUID, (CompilerSet)toolchain, (boolean)defaultToolchain);
        String workingDirRel = ProjectSupport.toProperPath((FSPath)new FSPath(this.sourceFileSystem, baseDir), (String)this.sourcesPath, (MakeProjectOptions.PathMode)MakeProjectOptions.getPathMode());
        workingDirRel = CndPathUtilities.naturalizeSlashes((FileSystem)this.sourceFileSystem, (String)workingDirRel);
        conf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(workingDirRel);
        String exe = binaryPath;
        if (fullRemotefileSystem != null) {
            exe = CndPathUtilities.toRelativePath((String)CndPathUtilities.naturalizeSlashes((FileSystem)fullRemotefileSystem, (String)baseDir), (String)exe);
            exe = CndPathUtilities.normalizeSlashes((String)exe);
        } else {
            exe = CndPathUtilities.toRelativePath((String)CndPathUtilities.naturalizeSlashes((String)baseDir), (String)exe);
            exe = CndPathUtilities.normalizeSlashes((String)exe);
        }
        conf.getMakefileConfiguration().getOutput().setValue(exe);
        String exePath = CndPathUtilities.getDirName((String)binaryPath);
        if (fullRemotefileSystem != null) {
            exePath = CndPathUtilities.toRelativePath((String)CndPathUtilities.naturalizeSlashes((FileSystem)fullRemotefileSystem, (String)baseDir), (String)exePath);
            exePath = CndPathUtilities.normalizeSlashes((String)exePath);
        } else {
            exePath = CndPathUtilities.toRelativePath((String)CndPathUtilities.naturalizeSlashes((String)baseDir), (String)exePath);
            exePath = CndPathUtilities.normalizeSlashes((String)exePath);
        }
        conf.getProfile().setRunDirectory(exePath);
        conf.getProfile().setBuildFirst(false);
        ArrayList<String> importantBinaries = new ArrayList<String>();
        importantBinaries.add(binaryPath);
        importantBinaries.addAll(libs);
        String launcher = projectFolder.getPath() + "/nbproject/private/launcher.properties";
        launcher = ProjectSupport.toProperPath((FSPath)projectFolder, (String)CndPathUtilities.naturalizeSlashes((FileSystem)this.sourceFileSystem, (String)launcher), (MakeProjectOptions.PathMode)MakeProjectOptions.getPathMode());
        launcher = CndPathUtilities.normalizeSlashes((String)launcher);
        importantBinaries.add(launcher);
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(projectName, projectFolder);
        prjParams.setOpenFlag(false).setConfiguration(conf).setImportantFiles(importantBinaries.iterator()).setMakefileName("");
        Boolean trueSourceRoot = (Boolean)WizardConstants.PROPERTY_TRUE_SOURCE_ROOT.fromMap(this.map);
        if (trueSourceRoot != null && trueSourceRoot.booleanValue()) {
            ArrayList<2> list = new ArrayList<2>();
            list.add(new SourceFolderInfo(){

                public FileObject getFileObject() {
                    return CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)ImportExecutable.this.sourcesPath));
                }

                public String getFolderName() {
                    return this.getFileObject().getNameExt();
                }

                public boolean isAddSubfoldersSelected() {
                    return true;
                }
            });
            prjParams.setSourceFolders(list.iterator());
        } else {
            this.addSourceRoot = true;
        }
        prjParams.setSourceFoldersFilter("^(nbproject)$");
        try {
            this.lastSelectedProject = ProjectGenerator.createProject((ProjectGenerator.ProjectParameters)prjParams);
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            DiscoveryWizardDescriptor.BUILD_RESULT.toMap(this.map, (Object)binaryPath);
            if (fullRemotefileSystem != null) {
                DiscoveryWizardDescriptor.FILE_SYSTEM.toMap(this.map, (Object)fullRemotefileSystem);
            }
            DiscoveryWizardDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(this.map, (Object)CommonUtilities.resolveSymbolicLinks());
            if (this.sourcesPath != null && this.sourcesPath.length() > 1) {
                DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(this.map, (Object)this.sourcesPath);
            } else {
                DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(this.map, (Object)this.lastSelectedProject.getProjectDirectory().getPath());
            }
            if (libs.size() > 0) {
                StringBuilder buf = new StringBuilder();
                for (String lib : libs) {
                    if (buf.length() > 0) {
                        buf.append(';');
                    }
                    buf.append(lib);
                }
                DiscoveryWizardDescriptor.ADDITIONAL_LIBRARIES.toMap(this.map, (Object)buf.toString());
            }
            this.model = CsmModelAccessor.getModel();
            ImportExecutable.switchModel(this.model, false, this.lastSelectedProject);
            this.extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            OpenProjects.getDefault().open(new Project[]{this.lastSelectedProject}, false);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects = (Project[])evt.getNewValue();
            if (projects.length == 0) {
                return;
            }
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            if (this.lastSelectedProject == null) {
                return;
            }
            if (this.extension != null) {
                this.process((DiscoveryExtension)this.extension);
            }
        }
    }

    public void process(final DiscoveryExtension extension) {
        this.model = CsmModelAccessor.getModel();
        ImportExecutable.switchModel(this.model, false, this.lastSelectedProject);
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DiscoveryExtensionInterface.Applicable applicable;
                    block23: {
                        ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportExecutable.class, (String)"ImportExecutable.Progress"));
                        progress.start();
                        applicable = null;
                        try {
                            ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)ImportExecutable.this.lastSelectedProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
                            MakeConfigurationDescriptor configurationDescriptor = provider.getConfigurationDescriptor();
                            for (Folder folder : configurationDescriptor.getLogicalFolders().getFolders()) {
                                if (!"HeaderFiles".equals(folder.getName()) && !"ResourceFiles".equals(folder.getName())) continue;
                                configurationDescriptor.getLogicalFolders().removeFolderAction(folder);
                            }
                            applicable = extension.isApplicable(ImportExecutable.this.map, ImportExecutable.this.lastSelectedProject, true);
                            if (!applicable.isApplicable()) break block23;
                            if (ImportExecutable.this.sourcesPath == null) {
                                ImportExecutable.this.sourcesPath = applicable.getSourceRoot();
                            }
                            if (ImportExecutable.this.addSourceRoot && ImportExecutable.this.sourcesPath != null && ImportExecutable.this.sourcesPath.length() > 1) {
                                configurationDescriptor.addSourceRoot(ImportExecutable.this.sourcesPath);
                                DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(ImportExecutable.this.map, (Object)ImportExecutable.this.sourcesPath);
                            }
                            configurationDescriptor.getActiveConfiguration().getCodeAssistanceConfiguration().getResolveSymbolicLinks().setValue(CommonUtilities.resolveSymbolicLinks());
                            if (!ImportExecutable.this.createProjectMode) {
                                ImportExecutable.resetCompilerSet(configurationDescriptor.getActiveConfiguration(), applicable);
                            }
                            if (ImportExecutable.this.projectKind == IteratorExtension.ProjectKind.IncludeDependencies) {
                                String additionalDependencies = (String)DiscoveryWizardDescriptor.ADDITIONAL_LIBRARIES.fromMap(ImportExecutable.this.map);
                                String ad = ImportExecutable.this.additionalDependencies(applicable, configurationDescriptor.getActiveConfiguration(), DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getBuildResult());
                                if (ad != null && !ad.isEmpty()) {
                                    if (additionalDependencies == null) {
                                        DiscoveryWizardDescriptor.ADDITIONAL_LIBRARIES.toMap(ImportExecutable.this.map, (Object)ad);
                                        additionalDependencies = ad;
                                    } else {
                                        DiscoveryWizardDescriptor.ADDITIONAL_LIBRARIES.toMap(ImportExecutable.this.map, (Object)(additionalDependencies + ";" + ad));
                                    }
                                }
                            }
                            if (!extension.canApply(ImportExecutable.this.map, ImportExecutable.this.lastSelectedProject, null)) break block23;
                            try {
                                extension.apply(ImportExecutable.this.map, ImportExecutable.this.lastSelectedProject, null);
                                ImportExecutable.this.discoverScripts(ImportExecutable.this.lastSelectedProject, DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getBuildResult());
                                DiscoveryProjectGenerator.saveMakeConfigurationDescriptor(ImportExecutable.this.lastSelectedProject, null);
                                if (ImportExecutable.this.projectKind == IteratorExtension.ProjectKind.CreateDependencies) {
                                    ImportExecutable.this.cd = new CreateDependencies(ImportExecutable.this.lastSelectedProject, ImportExecutable.this.sourceFileSystem, DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getDependencies(), ImportExecutable.this.dependencies, DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getSearchPaths(), DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getBuildResult());
                                }
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                        finally {
                            progress.finish();
                        }
                    }
                    DiscoveryExtensionInterface.Position mainFunction = applicable.getMainFunction();
                    boolean open = true;
                    if (mainFunction != null) {
                        FileObject toFileObject;
                        String mainFilePath = mainFunction.getFilePath();
                        if (ImportExecutable.this.sourcesPath != null && !mainFilePath.startsWith(ImportExecutable.this.sourcesPath)) {
                            String mainFileName = CndPathUtilities.getBaseName((String)mainFilePath);
                            NativeProject np = (NativeProject)ImportExecutable.this.lastSelectedProject.getLookup().lookup(NativeProject.class);
                            ArrayList<NativeFileItem> items = new ArrayList<NativeFileItem>();
                            if (np != null) {
                                for (NativeFileItem item : np.getAllFiles()) {
                                    String itemPath = item.getAbsolutePath();
                                    String name = CndPathUtilities.getBaseName((String)itemPath);
                                    if (!name.equals(mainFileName)) continue;
                                    items.add(item);
                                }
                            }
                            if (items.size() > 0) {
                                String bestCandidate = null;
                                int min = Integer.MAX_VALUE;
                                for (NativeFileItem item : items) {
                                    String candidate = item.getAbsolutePath();
                                    int end = ImportExecutable.this.commonEnd(mainFilePath, candidate);
                                    if (end >= min) continue;
                                    bestCandidate = candidate;
                                    min = end;
                                }
                                mainFilePath = bestCandidate;
                            }
                        }
                        if ((toFileObject = CndFileUtils.toFileObject((FileSystem)ImportExecutable.this.sourceFileSystem, (CharSequence)mainFilePath)) != null && toFileObject.isValid() && CsmUtilities.openSource((FileObject)toFileObject, (int)mainFunction.getLine(), (int)0)) {
                            open = false;
                        }
                    }
                    String main = open ? "main" : null;
                    ImportExecutable.this.onProjectParsingFinished(main, ImportExecutable.this.lastSelectedProject);
                    ImportExecutable.switchModel(ImportExecutable.this.model, true, ImportExecutable.this.lastSelectedProject);
                }
                catch (Throwable ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        RP.post(run);
    }

    private int commonEnd(String mainFilePath, String candidate) {
        char c2;
        char c1;
        int len = mainFilePath.length() - 1;
        for (int i = candidate.length() - 1; !(i < 0 || (c1 = candidate.charAt(i)) != (c2 = mainFilePath.charAt(len)) && (c1 != '\\' && c1 != '/' || c2 != '\\' && c2 != '/') || --len < 0); --i) {
        }
        return len;
    }

    private void discoverScripts(Project project, String binary) {
        FileObject parentFile;
        DiscoveredConfigure parentConfigure;
        ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (provider == null) {
            return;
        }
        MakeConfigurationDescriptor configurationDescriptor = provider.getConfigurationDescriptor();
        if (configurationDescriptor == null) {
            return;
        }
        MakeConfiguration activeConfiguration = configurationDescriptor.getActiveConfiguration();
        if (activeConfiguration == null) {
            return;
        }
        String root = ImportExecutable.findFolderPath(configurationDescriptor, ImportExecutable.getRoot(configurationDescriptor));
        if (root == null) {
            return;
        }
        FileObject rootFile = this.sourceFileSystem.findResource(root);
        if (rootFile == null || !rootFile.isValid()) {
            return;
        }
        DiscoveredConfigure configure = ImportExecutable.scanFolder(rootFile);
        if ((configure.script == null || configure.makefile == null) && (parentConfigure = ImportExecutable.scanFolder(parentFile = rootFile.getParent())).script != null && parentConfigure.makefile != null && configure.scriptWeight < parentConfigure.scriptWeight) {
            configure = parentConfigure;
        }
        if (configure.script == null || configure.makefile == null) {
            FileObject[] listFiles;
            String binaryName = CndPathUtilities.getBaseName((String)binary);
            if (binaryName.indexOf(46) > 0) {
                binaryName = binaryName.substring(0, binaryName.lastIndexOf(46));
            }
            if ((listFiles = rootFile.getChildren()) != null) {
                for (FileObject file : listFiles) {
                    if (file == null || !file.isValid() || !file.isFolder()) continue;
                    DiscoveredConfigure childConfigure = ImportExecutable.scanFolder(file);
                    if (childConfigure.script != null && childConfigure.makefile != null) {
                        if (configure.scriptWeight >= childConfigure.scriptWeight) continue;
                        configure = childConfigure;
                        continue;
                    }
                    if (childConfigure.makefile == null || configure.makefile != null || !binaryName.equals(file.getNameExt())) continue;
                    configure.setMakefile(childConfigure.makefile, childConfigure.makefileWeight);
                }
            }
        }
        if (configure.makefile != null) {
            activeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(configure.makefile.getParent().getPath());
            activeConfiguration.getMakefileConfiguration().getBuildCommand().setValue("${MAKE} -f " + configure.makefile.getName());
            activeConfiguration.getMakefileConfiguration().getCleanCommand().setValue("${MAKE} -f " + configure.makefile.getName() + " clean");
            Folder externalItemFolder = configurationDescriptor.getExternalItemFolder();
            for (Item item : externalItemFolder.getAllItemsAsArray()) {
                if (!"text/x-make".equals(item.getMIMEType())) continue;
                externalItemFolder.removeItem(item);
                break;
            }
            externalItemFolder.addItem(Item.createInFileSystem((FileSystem)configurationDescriptor.getBaseDirFileSystem(), (String)configure.makefile.getPath()));
            if (configure.script != null) {
                externalItemFolder.addItem(Item.createInFileSystem((FileSystem)configurationDescriptor.getBaseDirFileSystem(), (String)configure.script.getPath()));
            }
        }
    }

    private static DiscoveredConfigure scanFolder(FileObject rootFile) {
        FileObject[] listFiles;
        DiscoveredConfigure configure = new DiscoveredConfigure();
        if (rootFile != null && rootFile.isValid() && (listFiles = rootFile.getChildren()) != null) {
            for (FileObject file : listFiles) {
                if (file == null || !file.isValid() || !file.isData()) continue;
                String name = file.getName();
                if ("CMakeLists.txt".equals(name)) {
                    configure.setScript(file, 3);
                    continue;
                }
                if (name.endsWith(".pro")) {
                    configure.setScript(file, 4);
                    continue;
                }
                if ("configure".equals(name) || "configure.exe".equals(name)) {
                    configure.setScript(file, 5);
                    continue;
                }
                if ("Makefile".equals(name)) {
                    configure.setMakefile(file, 5);
                    continue;
                }
                if ("makefile".equals(name)) {
                    configure.setMakefile(file, 4);
                    continue;
                }
                if ("GNUmakefile".equals(name)) {
                    configure.setMakefile(file, 3);
                    continue;
                }
                if (!name.endsWith(".mk")) continue;
                configure.setMakefile(file, 2);
            }
        }
        return configure;
    }

    private String additionalDependencies(DiscoveryExtensionInterface.Applicable applicable, MakeConfiguration activeConfiguration, String binariesPath) {
        if (this.dependencies == null) {
            ArrayList<String> binaries = new ArrayList<String>();
            for (String path : binariesPath.split(";")) {
                if (path.trim().isEmpty()) continue;
                binaries.add(path.trim());
            }
            HashSet<String> checkedDll = new HashSet<String>();
            HashMap<String, String> dllPaths = new HashMap<String, String>();
            String root = this.sourcesPath;
            for (String binary : binaries) {
                ArrayList<String> secondary;
                int search;
                int newSearch;
                if (root == null || root.length() == 0) {
                    root = applicable.getSourceRoot();
                }
                if (root == null || root.length() == 0) {
                    return null;
                }
                if (applicable.getDependencies() == null || applicable.getDependencies().isEmpty()) {
                    return null;
                }
                checkedDll.add(binary);
                String ldLibPath = CommonUtilities.getLdLibraryPath((MakeConfiguration)activeConfiguration);
                ldLibPath = CommonUtilities.addSearchPaths((String)ldLibPath, applicable.getSearchPaths(), (String)binary);
                for (String dll : applicable.getDependencies()) {
                    dllPaths.put(dll, ImportExecutable.findLocation(this.sourceFileSystem, dll, ldLibPath));
                }
                do {
                    FileObject rootFO;
                    secondary = new ArrayList<String>();
                    for (Map.Entry entry : dllPaths.entrySet()) {
                        if (entry.getValue() == null || checkedDll.contains(entry.getValue())) continue;
                        checkedDll.add((String)entry.getValue());
                        HashMap extMap = new HashMap();
                        DiscoveryWizardDescriptor.BUILD_RESULT.toMap(extMap, entry.getValue());
                        if (this.extension == null) continue;
                        this.extension.discoverArtifacts(extMap);
                        List dlls = (List)DiscoveryWizardDescriptor.DEPENDENCIES.fromMap(extMap);
                        if (dlls == null) continue;
                        for (String so : dlls) {
                            if (dllPaths.containsKey(so)) continue;
                            secondary.add(so);
                        }
                    }
                    for (String so : secondary) {
                        dllPaths.put(so, ImportExecutable.findLocation(this.sourceFileSystem, so, ldLibPath));
                    }
                    search = 0;
                    for (Map.Entry entry : dllPaths.entrySet()) {
                        if (entry.getValue() != null) continue;
                        ++search;
                    }
                    if (search > 0 && root.length() > 1 && (rootFO = this.sourceFileSystem.findResource(root)) != null && rootFO.isValid()) {
                        ImportExecutable.gatherSubFolders(rootFO, new HashSet<String>(), dllPaths);
                    }
                    newSearch = 0;
                    for (Map.Entry entry : dllPaths.entrySet()) {
                        if (entry.getValue() != null) continue;
                        ++newSearch;
                    }
                } while (newSearch != search || !secondary.isEmpty());
            }
            StringBuilder buf = new StringBuilder();
            String binaryDir = CndPathUtilities.getDirName((String)((String)binaries.get(0)));
            for (Map.Entry entry : dllPaths.entrySet()) {
                if (entry.getValue() == null || !ImportExecutable.isMyDll((String)entry.getValue(), root) && !ImportExecutable.isMyDll((String)entry.getValue(), binaryDir)) continue;
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append((String)entry.getValue());
            }
            return buf.toString();
        }
        StringBuilder buf = new StringBuilder();
        for (String path : this.dependencies) {
            if (buf.length() > 0) {
                buf.append(';');
            }
            buf.append(path);
        }
        return buf.toString();
    }

    private void onProjectParsingFinished(final String functionName, final Project makeProject) {
        if (makeProject != null) {
            final NativeProject np = (NativeProject)makeProject.getLookup().lookup(NativeProject.class);
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject project) {
                    Object id = project.getPlatformProject();
                    if (id != null && id.equals(np)) {
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        listeners.remove((Object)this);
                        if (functionName != null) {
                            Collection decls = CsmFunctionDefinitionResolver.getDefault().findDeclarationByName(project, functionName);
                            CsmOffsetableDeclaration best = null;
                            for (CsmOffsetableDeclaration decl : decls) {
                                if (!functionName.contentEquals(decl.getName())) continue;
                                if (CsmKindUtilities.isFunctionDefinition((CsmObject)decl)) {
                                    best = decl;
                                    break;
                                }
                                if (best != null) continue;
                                best = decl;
                            }
                            if (best != null) {
                                CsmUtilities.openSource(best);
                            }
                        }
                        DiscoveryProjectGenerator.fixExcludedHeaderFiles(makeProject, ImportProject.logger);
                        if (ImportExecutable.this.cd != null) {
                            ImportExecutable.this.cd.create();
                        }
                    }
                }
            };
            listeners.add((CsmProgressListener)listener);
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
        }
    }

    static void switchModel(CsmModel model, boolean state, Project makeProject) {
        if (model != null && makeProject != null) {
            NativeProject np = (NativeProject)makeProject.getLookup().lookup(NativeProject.class);
            if (state) {
                model.enableProject((Object)np);
            } else {
                model.disableProject((Object)np);
            }
        }
    }

    static void resetCompilerSet(MakeConfiguration configuration, DiscoveryExtensionInterface.Applicable applicable) {
        if (configuration != null) {
            CompilerSetManager manager = CompilerSetManager.get((ExecutionEnvironment)configuration.getDevelopmentHost().getExecutionEnvironment());
            if (applicable.isSunStudio()) {
                CompilerSet def = manager.getDefaultCompilerSet();
                if (def != null && def.getCompilerFlavor().isSunStudioCompiler()) {
                    return;
                }
                List compilerSets = CompilerSetManager.get((ExecutionEnvironment)configuration.getDevelopmentHost().getExecutionEnvironment()).getCompilerSets();
                def = null;
                for (CompilerSet set : compilerSets) {
                    if (!set.getCompilerFlavor().isSunStudioCompiler()) continue;
                    if ("OracleSolarisStudio".equals(set.getName())) {
                        def = set;
                    }
                    if (def != null) continue;
                    def = set;
                }
                if (def != null) {
                    configuration.getCompilerSet().setValue(def.getName());
                }
            } else {
                CompilerSet def = manager.getDefaultCompilerSet();
                if (def != null && !def.getCompilerFlavor().isSunStudioCompiler()) {
                    return;
                }
                List compilerSets = CompilerSetManager.get((ExecutionEnvironment)configuration.getDevelopmentHost().getExecutionEnvironment()).getCompilerSets();
                def = null;
                for (CompilerSet set : compilerSets) {
                    if (set.getCompilerFlavor().isSunStudioCompiler() || def != null) continue;
                    def = set;
                }
                if (def != null) {
                    configuration.getCompilerSet().setValue(def.getName());
                }
            }
        }
    }

    static boolean isMyDll(String path, String root) {
        if (path.startsWith(root)) {
            return true;
        }
        String[] p1 = path.split("/");
        String[] p2 = root.split("/");
        for (int i = 0; i < Math.min(p1.length - 1, p2.length); ++i) {
            if (p1[i].equals(p2[i])) continue;
            return i > 2;
        }
        return false;
    }

    static String findLocation(FileSystem fs, String dll, String ldPath) {
        if (ldPath != null) {
            String separator = ":";
            if (ldPath.indexOf(59) > 0) {
                separator = ";";
            }
            for (String search : ldPath.split(separator)) {
                FileObject file = fs.findResource(search + "/" + dll);
                if (file == null || !file.isValid()) continue;
                String path = file.getPath();
                return path.replace('\\', '/');
            }
        }
        return null;
    }

    static void gatherSubFolders(FileObject startFolder, HashSet<String> set, Map<String, String> result) {
        ArrayList<FileObject> down = new ArrayList<FileObject>();
        down.add(startFolder);
        while (!down.isEmpty()) {
            ArrayList<FileObject> next = new ArrayList<FileObject>();
            for (FileObject file : down) {
                String canPath;
                if (CndPathUtilities.isIgnoredFolder((String)file.getNameExt()) || !file.isValid() || !file.isFolder() || !file.canRead()) continue;
                try {
                    canPath = CndFileUtils.getCanonicalPath((FileObject)file);
                }
                catch (IOException ex) {
                    continue;
                }
                if (set.contains(canPath)) continue;
                set.add(canPath);
                FileObject[] fileList = file.getChildren();
                if (fileList == null) continue;
                for (int i = 0; i < fileList.length; ++i) {
                    if (fileList[i].isFolder()) {
                        next.add(fileList[i]);
                        continue;
                    }
                    String name = fileList[i].getName();
                    if (!result.containsKey(name)) continue;
                    result.put(name, fileList[i].getPath());
                    boolean finished = true;
                    for (String path : result.values()) {
                        if (path != null && !path.isEmpty()) continue;
                        finished = false;
                        break;
                    }
                    if (!finished) continue;
                    return;
                }
            }
            down = next;
        }
    }

    static Folder getRoot(MakeConfigurationDescriptor configurationDescriptor) {
        Folder folder = configurationDescriptor.getLogicalFolders();
        List sources = folder.getFolders();
        for (Folder sub : sources) {
            if (!sub.isProjectFiles()) continue;
            if ("SourceFiles".equals(sub.getName())) {
                return sub;
            }
            if ("HeaderFiles".equals(sub.getName()) || "ResourceFiles".equals(sub.getName())) continue;
            return sub;
        }
        return folder;
    }

    static String findFolderPath(MakeConfigurationDescriptor configurationDescriptor, Folder root) {
        if (root == null) {
            return null;
        }
        if (root.isDiskFolder()) {
            String AbsRootPath = CndPathUtilities.toAbsolutePath((FileObject)configurationDescriptor.getBaseDirFileObject(), (String)root.getRoot());
            return RemoteFileUtil.normalizeAbsolutePath((String)AbsRootPath, (Project)configurationDescriptor.getProject());
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (Object o : root.getElements()) {
            Folder f;
            String res;
            if (!(o instanceof Folder) || (res = ImportExecutable.findFolderPath(f = (Folder)o, "/" + f.getName())) == null) continue;
            candidates.add(res + "/" + f.getName());
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (String)candidates.get(0);
        }
        String bestCandidate = null;
        for (String candidate : candidates) {
            if (bestCandidate == null) {
                bestCandidate = candidate;
                continue;
            }
            if (bestCandidate.startsWith(candidate)) {
                bestCandidate = candidate;
                continue;
            }
            if (bestCandidate.length() <= candidate.length()) continue;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }

    static String findFolderPath(Folder root, String prefix) {
        for (Object o : root.getElements()) {
            int j;
            if (!(o instanceof Item)) continue;
            Item i = (Item)o;
            String path = i.getAbsPath();
            if (prefix.isEmpty() || (j = (path = path.replace('\\', '/')).indexOf(prefix + "/")) < 0) continue;
            return path.substring(0, j);
        }
        for (Object o : root.getElements()) {
            Folder f;
            String res;
            if (!(o instanceof Folder) || (res = ImportExecutable.findFolderPath(f = (Folder)o, prefix + "/" + f.getName())) == null) continue;
            if (prefix.isEmpty()) {
                return res + "/" + f.getName();
            }
            return res;
        }
        return null;
    }

    private static final class DiscoveredConfigure {
        private FileObject script;
        private int scriptWeight;
        private FileObject makefile;
        private int makefileWeight;

        private DiscoveredConfigure() {
        }

        private void setScript(FileObject script, int weight) {
            if (this.script == null || this.scriptWeight < weight) {
                this.script = script;
                this.scriptWeight = weight;
            }
        }

        private void setMakefile(FileObject makefile, int weight) {
            if (this.makefile == null || this.makefileWeight < weight) {
                this.makefile = makefile;
                this.makefileWeight = weight;
            }
        }
    }
}

