/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.actions.CMakeAction;
import org.netbeans.modules.cnd.actions.QMakeAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.builds.CMakeExecSupport;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.builds.QMakeExecSupport;
import org.netbeans.modules.cnd.discovery.api.BuildTraceSupport;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.projectimport.DoubleFile;
import org.netbeans.modules.cnd.discovery.projectimport.ExecuteCommand;
import org.netbeans.modules.cnd.discovery.projectimport.FollowUp;
import org.netbeans.modules.cnd.discovery.projectimport.RfsListenerImpl;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.support.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.api.wizards.PreBuildSupport;
import org.netbeans.modules.cnd.makeproject.api.wizards.WizardConstants;
import org.netbeans.modules.cnd.remote.api.RfsListener;
import org.netbeans.modules.cnd.remote.api.RfsListenerSupport;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImportProject
implements PropertyChangeListener {
    private static final String BUILD_COMMAND = "${MAKE} -f Makefile";
    private static final String CLEAN_COMMAND = "${MAKE} -f Makefile clean";
    static final boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    public static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportProject");
    private static final RequestProcessor RP;
    private static final RequestProcessor RPR;
    private final String nativeProjectPath;
    private final FileObject nativeProjectFO;
    private final FSPath projectFolder;
    private String projectName;
    private String makefilePath;
    private String configurePath;
    private String configureRunFolder;
    private String configureArguments;
    private String configureCommand;
    private boolean runConfigure = false;
    private boolean manualCA = false;
    private boolean buildArifactWasAnalyzed = false;
    private final String hostUID;
    private final ExecutionEnvironment executionEnvironment;
    private final ExecutionEnvironment fileSystemExecutionEnvironment;
    private final MakeProjectOptions.PathMode pathMode;
    private CompilerSet toolchain;
    private boolean defaultToolchain;
    private String workingDir;
    private String buildCommand = "${MAKE} -f Makefile";
    private String cleanCommand = "${MAKE} -f Makefile clean";
    private String buildResult = "";
    private FileObject dwarfSource;
    private Project makeProject;
    private boolean runMake;
    private String includeDirectories = "";
    private String macros = "";
    private Iterator<? extends SourceFolderInfo> sources;
    private Iterator<? extends SourceFolderInfo> tests;
    private String sourceFoldersFilter = null;
    private FileObject configureFileObject;
    private final Map<Step, State> importResult = new EnumMap<Step, State>(Step.class);
    private final CountDownLatch waitSources = new CountDownLatch(1);
    private final AtomicInteger openState = new AtomicInteger(0);
    private Interrupter interrupter;
    private final boolean isFullRemoteProject;
    private volatile boolean isFinished = false;
    private DoubleFile makeLog = null;
    private DoubleFile execLog = null;
    private DoubleFile expectedCmakeLog = null;
    private DoubleFile existingBuildLog;
    private File configureLog = null;
    private boolean resolveSymLinks;
    private boolean isUILessMode = false;
    private Map<String, Item> normalizedItems;
    private static final Map<CsmProject, CsmProgressListener> listeners;

    public ImportProject(WizardDescriptor wizard) {
        this.isFullRemoteProject = WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(wizard) != null;
        this.hostUID = (String)WizardConstants.PROPERTY_HOST_UID.get(wizard);
        this.executionEnvironment = this.hostUID == null ? ServerList.getDefaultRecord().getExecutionEnvironment() : ExecutionEnvironmentFactory.fromUniqueID((String)this.hostUID);
        this.fileSystemExecutionEnvironment = this.isFullRemoteProject ? this.executionEnvironment : ExecutionEnvironmentFactory.getLocal();
        this.pathMode = MakeProjectOptions.getPathMode();
        this.projectFolder = (FSPath)WizardConstants.PROPERTY_PROJECT_FOLDER.get(wizard);
        this.nativeProjectPath = (String)WizardConstants.PROPERTY_NATIVE_PROJ_DIR.get(wizard);
        assert (this.nativeProjectPath != null);
        if (this.isFullRemoteProject) {
            FileObject npfo = (FileObject)WizardConstants.PROPERTY_NATIVE_PROJ_FO.get(wizard);
            if (npfo == null) {
                npfo = FileSystemProvider.getFileObject((ExecutionEnvironment)this.executionEnvironment, (String)this.nativeProjectPath);
                if (logger.isLoggable(Level.INFO)) {
                    String warning = "Null file object for " + this.nativeProjectPath + " at " + this.executionEnvironment + (npfo == null ? " NOT " : "") + " found at 2-nd attempt";
                    logger.log(Level.INFO, warning, new Exception(warning));
                }
            } else {
                FileObject npfo2 = FileSystemProvider.getFileObject((ExecutionEnvironment)this.executionEnvironment, (String)this.nativeProjectPath);
                if (!npfo.equals(npfo2)) {
                    String warning = "Inconsistent file objects when creating a project: " + npfo + " vs " + npfo2;
                    logger.log(Level.INFO, warning, new Exception(warning));
                }
            }
            this.nativeProjectFO = npfo;
        } else {
            this.nativeProjectFO = (FileObject)WizardConstants.PROPERTY_NATIVE_PROJ_FO.get(wizard);
        }
        if (Boolean.TRUE.equals(WizardConstants.PROPERTY_SIMPLE_MODE.get(wizard))) {
            this.simpleSetup(wizard);
        } else {
            this.customSetup(wizard);
        }
    }

    private void simpleSetup(WizardDescriptor wizard) {
        this.projectName = CndPathUtilities.getBaseName((String)this.projectFolder.getPath());
        this.workingDir = this.nativeProjectPath;
        this.runConfigure = Boolean.TRUE.equals(WizardConstants.PROPERTY_RUN_CONFIGURE.get(wizard));
        if (this.runConfigure) {
            this.configurePath = (String)WizardConstants.PROPERTY_CONFIGURE_SCRIPT_PATH.get(wizard);
            this.configureArguments = (String)WizardConstants.PROPERTY_CONFIGURE_SCRIPT_ARGS.get(wizard);
            this.configureRunFolder = (String)WizardConstants.PROPERTY_CONFIGURE_RUN_FOLDER.get(wizard);
            this.configureCommand = (String)WizardConstants.PROPERTY_CONFIGURE_COMMAND.get(wizard);
        }
        this.runMake = Boolean.TRUE.equals(WizardConstants.PROPERTY_RUN_REBUILD.get(wizard));
        if (this.runMake) {
            this.makefilePath = (String)WizardConstants.PROPERTY_USER_MAKEFILE_PATH.get(wizard);
            if (this.makefilePath == null) {
                this.makefilePath = this.nativeProjectPath + "/Makefile";
            }
            this.buildCommand = (String)WizardConstants.PROPERTY_BUILD_COMMAND.get(wizard);
            this.cleanCommand = (String)WizardConstants.PROPERTY_CLEAN_COMMAND.get(wizard);
        }
        this.toolchain = (CompilerSet)WizardConstants.PROPERTY_TOOLCHAIN.get(wizard);
        this.defaultToolchain = Boolean.TRUE.equals(WizardConstants.PROPERTY_TOOLCHAIN_DEFAULT.get(wizard));
        ArrayList<1> list = new ArrayList<1>();
        list.add(new SourceFolderInfo(){

            public FileObject getFileObject() {
                return ImportProject.this.nativeProjectFO;
            }

            public String getFolderName() {
                return ImportProject.this.nativeProjectFO.getNameExt();
            }

            public boolean isAddSubfoldersSelected() {
                return true;
            }
        });
        this.sources = list.iterator();
        this.sourceFoldersFilter = "^(nbproject)$";
        this.resolveSymLinks = CommonUtilities.resolveSymbolicLinks();
    }

    private void customSetup(WizardDescriptor wizard) {
        FileObject fo;
        this.projectName = (String)WizardConstants.PROPERTY_NAME.get(wizard);
        this.workingDir = (String)WizardConstants.PROPERTY_WORKING_DIR.get(wizard);
        this.buildCommand = (String)WizardConstants.PROPERTY_BUILD_COMMAND.get(wizard);
        this.cleanCommand = (String)WizardConstants.PROPERTY_CLEAN_COMMAND.get(wizard);
        this.buildResult = (String)WizardConstants.PROPERTY_BUILD_RESULT.get(wizard);
        this.includeDirectories = (String)WizardConstants.PROPERTY_INCLUDES.get(wizard);
        this.macros = (String)WizardConstants.PROPERTY_MACROS.get(wizard);
        this.makefilePath = (String)WizardConstants.PROPERTY_USER_MAKEFILE_PATH.get(wizard);
        this.configurePath = (String)WizardConstants.PROPERTY_CONFIGURE_SCRIPT_PATH.get(wizard);
        this.configureRunFolder = (String)WizardConstants.PROPERTY_CONFIGURE_RUN_FOLDER.get(wizard);
        this.configureArguments = (String)WizardConstants.PROPERTY_CONFIGURE_SCRIPT_ARGS.get(wizard);
        this.configureCommand = (String)WizardConstants.PROPERTY_CONFIGURE_COMMAND.get(wizard);
        this.runConfigure = Boolean.TRUE.equals(WizardConstants.PROPERTY_RUN_CONFIGURE.get(wizard));
        this.sources = (Iterator)WizardConstants.PROPERTY_SOURCE_FOLDERS.get(wizard);
        this.tests = (Iterator)WizardConstants.PROPERTY_TEST_FOLDERS.get(wizard);
        this.sourceFoldersFilter = (String)WizardConstants.PROPERTY_SOURCE_FOLDERS_FILTER.get(wizard);
        this.runMake = Boolean.TRUE.equals(WizardConstants.PROPERTY_RUN_REBUILD.get(wizard));
        String path = (String)WizardConstants.PROPERTY_BUILD_LOG.get(wizard);
        if (path != null && !path.isEmpty() && (fo = RemoteFileUtil.getFileObject((String)path, (ExecutionEnvironment)this.fileSystemExecutionEnvironment)) != null && fo.isValid()) {
            this.existingBuildLog = DoubleFile.createFile("make", new FSPath(FileSystemProvider.getFileSystem((ExecutionEnvironment)this.fileSystemExecutionEnvironment), path));
        }
        this.manualCA = Boolean.TRUE.equals(WizardConstants.PROPERTY_MANUAL_CODE_ASSISTANCE.get(wizard));
        this.toolchain = (CompilerSet)WizardConstants.PROPERTY_TOOLCHAIN.get(wizard);
        this.defaultToolchain = Boolean.TRUE.equals(WizardConstants.PROPERTY_TOOLCHAIN_DEFAULT.get(wizard));
        Boolean resolve = (Boolean)WizardConstants.PROPERTY_RESOLVE_SYM_LINKS.get(wizard);
        this.resolveSymLinks = resolve != null ? resolve : CommonUtilities.resolveSymbolicLinks();
    }

    public Set<FileObject> create() throws IOException {
        StringTokenizer tokenizer;
        MakeConfiguration extConf;
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        String aHostUID = this.hostUID;
        if (this.isFullRemoteProject) {
            aHostUID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            extConf = MakeConfiguration.createMakefileConfiguration((FSPath)this.projectFolder, (String)"Default", (String)aHostUID, (CompilerSet)this.toolchain, (boolean)this.defaultToolchain);
            int platform = CompilerSetManager.get((ExecutionEnvironment)this.executionEnvironment).getPlatform();
            extConf.getDevelopmentHost().setBuildPlatform(platform);
        } else {
            extConf = MakeConfiguration.createConfiguration((FSPath)this.projectFolder, (String)"Default", (int)0, null, (String)aHostUID, (CompilerSet)this.toolchain, (boolean)this.defaultToolchain);
        }
        if (this.runConfigure && this.configureRunFolder != null && !this.configureRunFolder.isEmpty()) {
            String workingDirRel = ProjectSupport.toProperPath((FSPath)this.projectFolder, (String)CndPathUtilities.naturalizeSlashes((String)this.configureRunFolder), (MakeProjectOptions.PathMode)this.pathMode);
            workingDirRel = CndPathUtilities.normalizeSlashes((String)workingDirRel);
            extConf.getPreBuildConfiguration().getPreBuildCommandWorkingDir().setValue(workingDirRel);
            extConf.getPreBuildConfiguration().getPreBuildCommand().setValue(this.configureCommand);
        }
        String workingDirRel = ProjectSupport.toProperPath((FSPath)this.projectFolder, (String)CndPathUtilities.naturalizeSlashes((String)this.workingDir), (MakeProjectOptions.PathMode)this.pathMode);
        workingDirRel = CndPathUtilities.normalizeSlashes((String)workingDirRel);
        extConf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(workingDirRel);
        extConf.getMakefileConfiguration().getBuildCommand().setValue(this.buildCommand);
        extConf.getMakefileConfiguration().getCleanCommand().setValue(this.cleanCommand);
        if (this.buildResult != null && this.buildResult.length() > 0) {
            FileObject fo = RemoteFileUtil.getFileObject((String)this.buildResult, (ExecutionEnvironment)this.fileSystemExecutionEnvironment);
            if (fo != null && fo.isValid()) {
                this.dwarfSource = fo;
            }
            if (fo == null || !fo.isValid() || !fo.isFolder()) {
                this.buildResult = ProjectSupport.toProperPath((FSPath)this.projectFolder, (String)CndPathUtilities.naturalizeSlashes((String)this.buildResult), (MakeProjectOptions.PathMode)this.pathMode);
                this.buildResult = CndPathUtilities.normalizeSlashes((String)this.buildResult);
                extConf.getMakefileConfiguration().getOutput().setValue(this.buildResult);
            }
        }
        extConf.getProfile().setRunDirectory(workingDirRel);
        extConf.getProfile().setBuildFirst(false);
        if (this.includeDirectories != null && this.includeDirectories.length() > 0) {
            tokenizer = new StringTokenizer(this.includeDirectories, ";");
            ArrayList<String> includeDirectoriesVector = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String includeDirectory = tokenizer.nextToken();
                includeDirectory = CndPathUtilities.toRelativePath((String)this.projectFolder.getPath(), (String)CndPathUtilities.naturalizeSlashes((String)includeDirectory));
                includeDirectory = CndPathUtilities.normalizeSlashes((String)includeDirectory);
                includeDirectoriesVector.add(includeDirectory);
            }
            extConf.getCCompilerConfiguration().getIncludeDirectories().setValue(includeDirectoriesVector);
            extConf.getCCCompilerConfiguration().getIncludeDirectories().setValue(new ArrayList(includeDirectoriesVector));
        }
        extConf.getCodeAssistanceConfiguration().getResolveSymbolicLinks().setValue(TRACE);
        if (this.macros != null && this.macros.length() > 0) {
            tokenizer = new StringTokenizer(this.macros, "; ");
            ArrayList<String> list = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
            extConf.getCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(list);
            extConf.getCCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(list);
        }
        ArrayList<String> importantItems = new ArrayList<String>();
        if (this.makefilePath != null && this.makefilePath.length() > 0) {
            this.makefilePath = ProjectSupport.toProperPath((FSPath)this.projectFolder, (String)CndPathUtilities.naturalizeSlashes((String)this.makefilePath), (MakeProjectOptions.PathMode)this.pathMode);
            this.makefilePath = CndPathUtilities.normalizeSlashes((String)this.makefilePath);
        }
        if (this.configurePath != null && this.configurePath.length() > 0) {
            String normPath = RemoteFileUtil.normalizeAbsolutePath((String)this.configurePath, (ExecutionEnvironment)this.fileSystemExecutionEnvironment);
            this.configureFileObject = RemoteFileUtil.getFileObject((String)normPath, (ExecutionEnvironment)this.fileSystemExecutionEnvironment);
            this.configurePath = ProjectSupport.toProperPath((FSPath)this.projectFolder, (String)CndPathUtilities.naturalizeSlashes((String)this.configurePath), (MakeProjectOptions.PathMode)this.pathMode);
            this.configurePath = CndPathUtilities.normalizeSlashes((String)this.configurePath);
            importantItems.add(this.configurePath);
        }
        String launcher = this.projectFolder.getPath() + "/nbproject/private/launcher.properties";
        launcher = ProjectSupport.toProperPath((FSPath)this.projectFolder, (String)CndPathUtilities.naturalizeSlashes((String)launcher), (MakeProjectOptions.PathMode)this.pathMode);
        launcher = CndPathUtilities.normalizeSlashes((String)launcher);
        importantItems.add(launcher);
        Iterator importantItemsIterator = importantItems.iterator();
        if (!importantItemsIterator.hasNext()) {
            importantItemsIterator = null;
        }
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(this.projectName, this.projectFolder);
        prjParams.setConfiguration(extConf).setSourceFolders(Collections.emptyList().iterator()).setSourceFoldersFilter(this.sourceFoldersFilter).setTestFolders(this.tests).setImportantFiles(importantItemsIterator).setFullRemoteNativeProjectPath(this.nativeProjectPath).setHostUID(aHostUID);
        if (this.makefilePath != null) {
            prjParams.setMakefileName(this.makefilePath);
        } else {
            prjParams.setMakefileName("");
        }
        this.makeProject = ProjectGenerator.createProject((ProjectGenerator.ProjectParameters)prjParams);
        FileObject dir = this.projectFolder.getFileObject();
        this.importResult.put(Step.Project, State.Successful);
        this.switchModel(false);
        resultSet.add(dir);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        return resultSet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.openState.get() == 0) {
            if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
                Project[] projects = (Project[])evt.getNewValue();
                if (projects.length == 0) {
                    return;
                }
                this.interrupter = new Interrupter(){

                    public boolean cancelled() {
                        return !ImportProject.this.isProjectOpened();
                    }
                };
                this.openState.incrementAndGet();
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        ImportProject.this.doWork();
                    }
                });
            }
        } else if (this.openState.get() == 1 && evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects;
            for (Project p : projects = (Project[])evt.getNewValue()) {
                if (p != this.makeProject) continue;
                return;
            }
            this.openState.incrementAndGet();
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    boolean isProjectOpened() {
        return this.openState.get() == 1;
    }

    private void doWork() {
        try {
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            pdp.getConfigurationDescriptor();
            if (pdp.gotDescriptor()) {
                final MakeConfigurationDescriptor configurationDescriptor = pdp.getConfigurationDescriptor();
                if (this.sources != null) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportProject.class, (String)"ImportProject.Progress.AnalyzeRoot"));
                            handle.start();
                            while (ImportProject.this.sources.hasNext()) {
                                SourceFolderInfo next = (SourceFolderInfo)ImportProject.this.sources.next();
                                configurationDescriptor.addFilesFromRoot(configurationDescriptor.getLogicalFolders(), next.getFileObject(), handle, ImportProject.this.interrupter, true, Folder.Kind.SOURCE_DISK_FOLDER, null);
                            }
                            handle.finish();
                            ImportProject.this.waitSources.countDown();
                        }
                    });
                } else {
                    this.waitSources.countDown();
                }
                if (configurationDescriptor.getActiveConfiguration() != null) {
                    configurationDescriptor.getActiveConfiguration().getCodeAssistanceConfiguration().getResolveSymbolicLinks().setValue(this.resolveSymLinks);
                    if (this.runConfigure && (this.configurePath != null && this.configurePath.length() > 0 && this.configureFileObject != null && this.configureFileObject.isValid() || this.configureCommand != null)) {
                        this.waitSources.await();
                        this.configureProject();
                    } else if (this.runMake) {
                        this.makeProject(null);
                    } else {
                        this.discovery(MakeResult.Skipped, this.existingBuildLog, null, null);
                    }
                } else {
                    this.isFinished = true;
                }
            } else {
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static File createTempFile(String prefix) {
        try {
            File file = File.createTempFile(prefix, ".log");
            file.deleteOnExit();
            return file;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void configureProject() {
        ExecutionListener listener = new ExecutionListener(){
            private RfsListenerImpl listener;

            public void executionStarted(int pid) {
                if (ImportProject.this.executionEnvironment.isRemote()) {
                    this.listener = new RfsListenerImpl(ImportProject.this.executionEnvironment);
                    RfsListenerSupport.addListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                }
            }

            public void executionFinished(int rc) {
                if (rc == 0) {
                    ImportProject.this.importResult.put(Step.Configure, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.Configure, State.Fail);
                }
                if (this.listener != null) {
                    this.listener.download();
                    RfsListenerSupport.removeListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                }
                if (ImportProject.this.runMake && rc == 0) {
                    ImportProject.this.makeProject(ImportProject.this.configureLog);
                } else {
                    ImportProject.this.discovery(MakeResult.Skipped, ImportProject.this.existingBuildLog, null, null);
                }
            }
        };
        if (this.configurePath != null && this.configurePath.length() > 0 && this.configureFileObject != null && this.configureFileObject.isValid()) {
            try {
                DataObject dObj = DataObject.find((FileObject)this.configureFileObject);
                Node node = dObj.getNodeDelegate();
                this.postConfigure(node, listener);
            }
            catch (Throwable e) {
                logger.log(Level.INFO, "Cannot configure project", e);
                this.importResult.put(Step.Configure, State.Fail);
                this.importResult.put(Step.MakeClean, State.Skiped);
                this.discovery(MakeResult.Skipped, this.existingBuildLog, null, null);
            }
        } else {
            try {
                ExecuteCommand ec = new ExecuteCommand(this.makeProject, this.workingDir, this.configureCommand);
                String name = NbBundle.getMessage(ImportProject.class, (String)"CONFIGURE_LABEL");
                String tabName = ec.getExecutionEnvironment().isLocal() ? name : NbBundle.getMessage(ExecuteCommand.class, (String)"CONFIGURE_REMOTE_LABEL", (Object)ec.getExecutionEnvironment().getDisplayName());
                ec.setName(name, tabName);
                Future<Integer> task = ec.performAction(listener, null, null);
                if (task == null) {
                    logger.log(Level.INFO, "Cannot execute clean command");
                    this.isFinished = true;
                }
            }
            catch (Throwable ex) {
                this.isFinished = true;
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void postConfigure(Node node, ExecutionListener listener) throws Exception {
        Future task;
        String mime;
        BufferedWriter outputListener;
        block35: {
            if (!this.isProjectOpened()) {
                this.isFinished = true;
                return;
            }
            if (this.configureLog == null) {
                this.configureLog = ImportProject.createTempFile("configure");
            }
            outputListener = null;
            try {
                outputListener = new BufferedWriter(new FileWriter(this.configureLog));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            mime = FileUtil.getMIMEType((FileObject)this.configureFileObject);
            if (this.configureArguments != null) {
                ShellExecSupport ses;
                this.configureArguments = PreBuildSupport.expandMacros((String)this.configureArguments, (CompilerSet)this.toolchain);
                if ("text/sh".equals(mime)) {
                    ses = (ShellExecSupport)node.getLookup().lookup(ShellExecSupport.class);
                    try {
                        ses.setArguments(new String[]{this.configureArguments});
                        List vars = ImportUtils.parseEnvironment((String)this.configureArguments);
                        ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                        if (this.configureRunFolder != null) {
                            FileObject createdFolder = this.mkDir(this.configureFileObject.getParent(), CndPathUtilities.toRelativePath((FileObject)this.configureFileObject.getParent(), (String)this.configureRunFolder));
                            if (createdFolder != null) {
                                ses.setRunDirectory(createdFolder.getPath());
                            }
                            break block35;
                        }
                        ses.setRunDirectory(this.configureFileObject.getParent().getPath());
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if ("text/x-cmake".equals(mime)) {
                    ses = (CMakeExecSupport)node.getLookup().lookup(CMakeExecSupport.class);
                    try {
                        List vars = ImportUtils.parseEnvironment((String)this.configureArguments);
                        for (String s : ImportUtils.quoteList((List)vars)) {
                            int i = this.configureArguments.indexOf(s);
                            if (i < 0) continue;
                            this.configureArguments = this.configureArguments.substring(0, i) + this.configureArguments.substring(i + s.length());
                        }
                        ses.setArguments(new String[]{this.configureArguments});
                        ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                        if (this.configureRunFolder != null) {
                            FileObject createdFolder = this.mkDir(this.configureFileObject.getParent(), CndPathUtilities.toRelativePath((FileObject)this.configureFileObject.getParent(), (String)this.configureRunFolder));
                            if (createdFolder != null) {
                                ses.setRunDirectory(createdFolder.getPath());
                                this.expectedCmakeLog = DoubleFile.createFile("json", new FSPath(createdFolder.getFileSystem(), createdFolder.getPath() + "/compile_commands.json"));
                            }
                            break block35;
                        }
                        ses.setRunDirectory(this.configureFileObject.getParent().getPath());
                        this.expectedCmakeLog = DoubleFile.createFile("json", new FSPath(this.configureFileObject.getFileSystem(), this.configureFileObject.getParent().getPath() + "/compile_commands.json"));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if ("text/x-qtproject".equals(mime)) {
                    ses = (QMakeExecSupport)node.getLookup().lookup(QMakeExecSupport.class);
                    try {
                        ses.setArguments(new String[]{this.configureArguments});
                        if (this.configureRunFolder != null) {
                            FileObject createdFolder = this.mkDir(this.configureFileObject.getParent(), CndPathUtilities.toRelativePath((FileObject)this.configureFileObject.getParent(), (String)this.configureRunFolder));
                            if (createdFolder != null) {
                                ses.setRunDirectory(createdFolder.getPath());
                            }
                        } else {
                            ses.setRunDirectory(this.configureFileObject.getParent().getPath());
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        if (TRACE) {
            logger.log(Level.INFO, "#{0} {1}", new Object[]{this.configureFileObject, this.configureArguments});
        }
        if ("text/sh".equals(mime)) {
            task = ShellRunAction.performAction((Node)node, (ExecutionListener)listener, (Writer)outputListener, (Project)this.makeProject, null);
            if (task == null) {
                throw new Exception("Cannot execute configure script");
            }
        } else if ("text/x-cmake".equals(mime)) {
            task = CMakeAction.performAction((Node)node, (ExecutionListener)listener, null, (Project)this.makeProject, null);
            if (task == null) {
                throw new Exception("Cannot execute cmake");
            }
        } else if ("text/x-qtproject".equals(mime)) {
            task = QMakeAction.performAction((Node)node, (ExecutionListener)listener, null, (Project)this.makeProject, null);
            if (task == null) {
                throw new Exception("Cannot execute qmake");
            }
        } else {
            if (TRACE) {
                logger.log(Level.INFO, "#Configure script does not supported");
            }
            this.importResult.put(Step.Configure, State.Fail);
            this.importResult.put(Step.MakeClean, State.Skiped);
            this.discovery(MakeResult.Skipped, this.existingBuildLog, null, null);
        }
    }

    private FileObject mkDir(FileObject parent, String relative) {
        if (relative != null) {
            try {
                relative = relative.replace('\\', '/');
                for (String segment : relative.split("/")) {
                    FileObject test;
                    if (parent == null) {
                        return null;
                    }
                    if (segment.isEmpty() || ".".equals(segment)) continue;
                    parent = "..".equals(segment) ? parent.getParent() : ((test = parent.getFileObject(segment, null)) != null ? test : parent.createFolder(segment));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            return parent;
        }
        return null;
    }

    private void downloadRemoteFile(File file) {
        if (file != null && !file.exists() && this.executionEnvironment.isRemote()) {
            String remoteFile = HostInfoProvider.getMapper((ExecutionEnvironment)this.executionEnvironment).getRemotePath(file.getAbsolutePath());
            try {
                if (HostInfoUtils.fileExists((ExecutionEnvironment)this.executionEnvironment, (String)remoteFile)) {
                    Future task = CommonTasksSupport.downloadFile((String)remoteFile, (ExecutionEnvironment)this.executionEnvironment, (String)file.getAbsolutePath(), null);
                    if (TRACE) {
                        logger.log(Level.INFO, "#download file {0}->{1}", new Object[]{remoteFile, file.getAbsolutePath()});
                    }
                    task.get();
                }
            }
            catch (Throwable ex) {
                logger.log(Level.INFO, "Cannot download file {0}->{1}. Exception {2}", new Object[]{remoteFile, file.getAbsolutePath(), ex.getMessage()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanConfigureLog(File logFile) {
        String configureCteatePattern = " creating ";
        if (logFile != null && logFile.exists() && logFile.canRead()) {
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new FileReader(logFile));
                while ((line = in.readLine()) != null) {
                    int i = line.indexOf(configureCteatePattern);
                    if (i <= 0) continue;
                    String f = line.substring(i + configureCteatePattern.length()).trim();
                    this.downloadRemoteFile(CndFileUtils.createLocalFile((String)this.projectFolder.getPath(), (String)f));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    private void makeProject(File logFile) {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        FileObject makeFileObject = null;
        if (this.makefilePath != null && this.makefilePath.length() > 0) {
            makeFileObject = CndFileUtils.toFileObject((CharSequence)FileUtil.normalizePath((String)CndPathUtilities.toAbsolutePath((FileObject)this.projectFolder.getFileObject(), (String)this.makefilePath)));
        }
        if (makeFileObject != null) {
            this.downloadRemoteFile(CndFileUtils.createLocalFile((String)makeFileObject.getPath()));
            makeFileObject = CndFileUtils.toFileObject((CharSequence)FileUtil.normalizePath((String)CndPathUtilities.toAbsolutePath((FileObject)this.projectFolder.getFileObject(), (String)this.makefilePath)));
        }
        this.scanConfigureLog(logFile);
        this.postClean();
    }

    private void postClean() {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
            }

            public void executionFinished(int rc) {
                if (rc == 0) {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Fail);
                }
                ImportProject.this.postMake();
            }
        };
        if (TRACE) {
            logger.log(Level.INFO, "#{0}", this.cleanCommand);
        }
        try {
            ExecuteCommand ec = new ExecuteCommand(this.makeProject, this.workingDir, this.cleanCommand);
            String name = NbBundle.getMessage(ImportProject.class, (String)"CLEAN_LABEL");
            String tabName = ec.getExecutionEnvironment().isLocal() ? name : NbBundle.getMessage(ExecuteCommand.class, (String)"CLEAN_REMOTE_LABEL", (Object)ec.getExecutionEnvironment().getDisplayName());
            ec.setName(name, tabName);
            Future<Integer> task = ec.performAction(listener, null, null);
            if (task == null) {
                logger.log(Level.INFO, "Cannot execute clean command");
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private ExecutionListener createMakeExecutionListener() {
        ConfigurationDescriptorProvider pdp;
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        if (this.makeLog == null) {
            this.makeLog = DoubleFile.createTmpFile("make", this.executionEnvironment);
        }
        if (BuildTraceSupport.useBuildTrace((makeConfigurationDescriptor = (pdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class)).getConfigurationDescriptor()).getActiveConfiguration()) && BuildTraceSupport.supportedPlatforms(this.executionEnvironment)) {
            this.execLog = DoubleFile.createTmpFile("exec", this.executionEnvironment);
        }
        return new ExecutionListener(){
            private RfsListenerImpl listener;

            public void executionStarted(int pid) {
                if (!ImportProject.this.isFullRemoteProject && ImportProject.this.executionEnvironment.isRemote()) {
                    this.listener = new RfsListenerImpl(ImportProject.this.executionEnvironment);
                    RfsListenerSupport.addListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                }
            }

            public void executionFinished(int rc) {
                FileObject fo;
                if (this.listener != null) {
                    this.listener.download();
                    RfsListenerSupport.removeListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                }
                if (rc == 0) {
                    ImportProject.this.importResult.put(Step.Make, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.Make, State.Fail);
                }
                if (ImportProject.this.execLog != null) {
                    if (ImportProject.this.executionEnvironment.isRemote()) {
                        ImportProject.this.execLog.download();
                    }
                    if (ImportProject.this.execLog.existLocalFile()) {
                        fo = ImportProject.this.execLog.getLocalFileObject();
                        try {
                            FileUtil.copyFile((FileObject)fo, (FileObject)ImportProject.this.projectFolder.getFileObject().getFileObject("nbproject/private"), (String)"Default-exec");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                }
                if (ImportProject.this.makeLog != null) {
                    if (ImportProject.this.isFullRemoteProject) {
                        ImportProject.this.makeLog.upload();
                    }
                    if (ImportProject.this.makeLog.existLocalFile()) {
                        fo = ImportProject.this.makeLog.getLocalFileObject();
                        try {
                            FileUtil.copyFile((FileObject)fo, (FileObject)ImportProject.this.projectFolder.getFileObject().getFileObject("nbproject/private"), (String)"Default-build");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                }
                if (ImportProject.this.expectedCmakeLog != null) {
                    if (ImportProject.this.isFullRemoteProject) {
                        ImportProject.this.expectedCmakeLog.download();
                    }
                    if (!ImportProject.this.expectedCmakeLog.existLocalFile()) {
                        ImportProject.this.expectedCmakeLog = null;
                    }
                }
                if (rc == 0) {
                    ImportProject.this.discovery(MakeResult.Successful, ImportProject.this.makeLog, ImportProject.this.execLog, ImportProject.this.expectedCmakeLog);
                } else {
                    ImportProject.this.discovery(MakeResult.Failed, ImportProject.this.makeLog, ImportProject.this.execLog, ImportProject.this.expectedCmakeLog);
                }
            }
        };
    }

    private void postMake() {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        ExecutionListener listener = this.createMakeExecutionListener();
        BufferedWriter outputListener = null;
        if (this.makeLog != null) {
            try {
                outputListener = new BufferedWriter(new FileWriter(this.makeLog.getLocalFile()));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        List vars = ImportUtils.parseEnvironment((String)this.configureArguments);
        if (this.execLog != null) {
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
            vars.add("__CND_TOOLS__=" + BuildTraceSupport.getTools(makeConfigurationDescriptor.getActiveConfiguration(), this.executionEnvironment));
            if (this.executionEnvironment.isLocal()) {
                vars.add("__CND_BUILD_LOG__=" + this.execLog.getLocalPath());
            } else {
                vars.add("__CND_BUILD_LOG__=" + this.execLog.getRemotePath());
            }
        }
        if (TRACE) {
            logger.log(Level.INFO, "#{0}", this.buildCommand);
        }
        try {
            ExecuteCommand ec = new ExecuteCommand(this.makeProject, this.workingDir, this.buildCommand);
            String name = NbBundle.getMessage(ImportProject.class, (String)"BUILD_LABEL");
            String tabName = ec.getExecutionEnvironment().isLocal() ? name : NbBundle.getMessage(ExecuteCommand.class, (String)"BUILD_REMOTE_LABEL", (Object)ec.getExecutionEnvironment().getDisplayName());
            ec.setName(name, tabName);
            Future<Integer> task = ec.performAction(listener, outputListener, vars);
            if (task == null) {
                logger.log(Level.INFO, "Cannot execute build command");
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void waitConfigurationDescriptor() {
        ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        provider.getConfigurationDescriptor();
        try {
            this.waitSources.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.refreshAfterBuild(this.interrupter);
    }

    private void refreshAfterBuild(final Interrupter interrupter) {
        RequestProcessor.Task refresh = RPR.post(new Runnable(){

            @Override
            public void run() {
                ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)ImportProject.this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
                Folder rootFolder = provider.getConfigurationDescriptor().getLogicalFolders();
                for (Folder sub : rootFolder.getFolders()) {
                    if (!sub.isDiskFolder()) continue;
                    sub.forceDiskFolderRefreshAndWait();
                    sub.refreshDiskFolder(interrupter);
                }
            }
        });
        refresh.waitFinished();
    }

    private void discovery(MakeResult rc, DoubleFile makeLog, DoubleFile execLog, DoubleFile expectedCmakeLog) {
        try {
            if (!this.isProjectOpened()) {
                this.isFinished = true;
                return;
            }
            this.waitConfigurationDescriptor();
            if (!this.isProjectOpened()) {
                this.isFinished = true;
                return;
            }
            boolean done = false;
            boolean exeLogDone = false;
            boolean makeLogDone = false;
            if (!this.manualCA) {
                if (expectedCmakeLog != null) {
                    done = this.discoveryByExecLog(expectedCmakeLog, done);
                    exeLogDone = true;
                }
                if (rc == MakeResult.Successful) {
                    if (!done && execLog != null) {
                        done = this.discoveryByExecLog(execLog, done);
                        exeLogDone = true;
                    }
                    if (!done) {
                        if (!this.isProjectOpened()) {
                            this.isFinished = true;
                            return;
                        }
                        done = this.discoveryByDwarfOrBuildLog(done);
                        this.buildArifactWasAnalyzed = true;
                        if (done && makeLog != null) {
                            if (!this.isProjectOpened()) {
                                this.isFinished = true;
                                return;
                            }
                            this.discoveryMacrosByBuildLog(makeLog);
                        }
                    }
                } else if (rc == MakeResult.Skipped) {
                    if (!done) {
                        if (this.isFullRemoteProject) {
                            if (makeLog != null) {
                                if (TRACE) {
                                    logger.log(Level.INFO, "#start remote discovery by log file {0}", makeLog);
                                }
                                this.updateRemoteProjectImpl(makeLog);
                                done = true;
                                this.buildArifactWasAnalyzed = true;
                            }
                        } else if (makeLog != null) {
                            done = this.dicoveryByBuildLog(makeLog, done);
                            makeLogDone = true;
                        } else {
                            done = this.discoveryByDwarfOrBuildLog(done);
                            this.buildArifactWasAnalyzed = true;
                        }
                    }
                } else if (rc == MakeResult.Failed) {
                    if (this.isFullRemoteProject) {
                        this.updateRemoteProjectImpl(makeLog);
                        done = true;
                        this.buildArifactWasAnalyzed = true;
                    } else {
                        if (!done && execLog != null && !exeLogDone) {
                            done = this.discoveryByExecLog(execLog, done);
                            exeLogDone = true;
                        }
                        if (!this.isProjectOpened()) {
                            this.isFinished = true;
                            return;
                        }
                        if (!done && makeLog != null && !makeLogDone) {
                            done = this.dicoveryByBuildLog(makeLog, done);
                            makeLogDone = true;
                        }
                    }
                }
            }
            if (!(done || this.manualCA || this.buildArifactWasAnalyzed)) {
                done = this.discoveryByDwarf(done);
            }
            this.switchModel(true);
            this.postModelDiscovery();
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void fixMacros(List<ProjectConfiguration> confs) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        ConfigurationDescriptorProvider.SnapShot delta = pdp.startModifications();
        boolean changed = false;
        for (ProjectConfiguration conf : confs) {
            List<FileConfiguration> files = conf.getFiles();
            for (FileConfiguration fileConf : files) {
                Item item;
                if (fileConf.getUserMacros().size() <= 0 || (item = this.findByNormalizedName(new File(fileConf.getFilePath()))) == null) continue;
                if (TRACE) {
                    logger.log(Level.FINE, "#fix macros for file {0}", fileConf.getFilePath());
                }
                changed |= ProjectBridge.setSourceStandard(item, fileConf.getLanguageStandard(), false);
                changed |= ProjectBridge.fixFileMacros(fileConf.getUserMacros(), item);
            }
        }
        if (changed) {
            DiscoveryProjectGenerator.saveMakeConfigurationDescriptor(this.makeProject, delta);
        } else {
            pdp.endModifications(delta, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRemoteProjectImpl(DoubleFile makeLog) {
        ProgressHandle createHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportProject.class, (String)"CONFIGURING_PROJECT_CREATOR", (Object)this.executionEnvironment.getDisplayName()));
        createHandle.start();
        try {
            FileObject projectCreator = this.findProjectCreator();
            if (projectCreator == null) {
                if (TRACE) {
                    logger.log(Level.INFO, NbBundle.getMessage(ImportProject.class, (String)"ERROR_FIND_PROJECT_CREATOR", (Object)this.executionEnvironment.getDisplayName()));
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE) {
                logger.log(Level.INFO, "#{0} --netbeans-project={1} --project-reconfigure build-log={2}", new Object[]{projectCreator.getPath(), this.projectFolder.getPath(), makeLog.getRemotePath()});
            }
            DiscoveryProjectGenerator.saveMakeConfigurationDescriptor(this.makeProject, null);
            FileObject conf1 = this.projectFolder.getFileObject().getFileObject("nbproject/configurations.xml");
            ProcessUtils.ExitStatus execute = ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--netbeans-project=" + this.projectFolder.getPath(), "--project-reconfigure", "build-log=" + makeLog.getRemotePath()});
            if (TRACE) {
                logger.log(Level.INFO, "#exitCode={0}", execute.exitCode);
                logger.log(Level.INFO, execute.error);
                logger.log(Level.INFO, execute.output);
            }
            if (!execute.isOK()) {
                String java = null;
                try {
                    java = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment).getEnvironment().get("JDK_HOME");
                    if (java == null || java.isEmpty()) {
                        java = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment).getEnvironment().get("JAVA_HOME");
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ConnectionManager.CancellationException ex) {
                    // empty catch block
                }
                if (java != null) {
                    execute = ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--netbeans-project=" + this.projectFolder.getPath(), "--project-reconfigure", "build-log=" + makeLog.getRemotePath()});
                }
                if (!execute.isOK()) {
                    if (TRACE) {
                        logger.log(Level.INFO, NbBundle.getMessage(ImportProject.class, (String)"ERROR_RUN_PROJECT_CREATOR", (Object)this.executionEnvironment.getDisplayName()));
                    }
                    boolean ex = false;
                    return ex;
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.makeProject.getProjectDirectory().refresh(true);
            conf1.getParent().refresh(true);
            ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            Type cdpClass = cdp.getClass().getGenericSuperclass();
            for (Method method : ((Class)cdpClass).getDeclaredMethods()) {
                if (!"resetConfiguration".equals(method.getName())) continue;
                try {
                    method.setAccessible(true);
                    method.invoke((Object)cdp, new Object[0]);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            this.waitConfigurationDescriptor();
            boolean bl = true;
            return bl;
        }
        finally {
            createHandle.finish();
        }
    }

    private FileObject findProjectCreator() {
        FileSystem fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)this.fileSystemExecutionEnvironment);
        for (CompilerSet set : CompilerSetManager.get((ExecutionEnvironment)this.fileSystemExecutionEnvironment).getCompilerSets()) {
            String directory;
            FileObject projectCreator;
            if (!set.getCompilerFlavor().isSunStudioCompiler() || (projectCreator = fileSystem.findResource((directory = set.getDirectory()) + "/../lib/ide_project/bin/ide_project")) == null || !projectCreator.isValid()) continue;
            return projectCreator;
        }
        return null;
    }

    private void postModelDiscovery() {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        CsmModel model = CsmModelAccessor.getModel();
        if (model != null && this.makeProject != null) {
            final NativeProject np = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            final CsmProject p = model.getProject((Object)np);
            if (p == null) {
                if (TRACE) {
                    logger.log(Level.INFO, "#discovery cannot be done by model");
                }
                this.isFinished = true;
                return;
            }
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject project) {
                    if (project.equals(p)) {
                        listeners.remove(p);
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                ImportProject.this.postModelDiscovery(np, p);
                            }
                        });
                    }
                }
            };
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
            listeners.put(p, (CsmProgressListener)listener);
        } else {
            this.isFinished = true;
        }
    }

    private void postModelDiscovery(NativeProject np, CsmProject p) {
        try {
            if (TRACE) {
                logger.log(Level.INFO, "#model ready, explore model");
            }
            this.fixExcludedHeaderFiles();
            this.showFollwUp(np);
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public Map<Step, State> getState() {
        return new EnumMap<Step, State>(this.importResult);
    }

    public Project getProject() {
        return this.makeProject;
    }

    public void setUILessMode() {
        this.isUILessMode = true;
    }

    public void setConfigureLog(File configureLog) {
        this.configureLog = configureLog;
    }

    public void setMakeLog(File log) {
        this.makeLog = DoubleFile.createFile(log, this.executionEnvironment);
    }

    private void showFollwUp(final NativeProject project) {
        this.isFinished = true;
        if (this.isUILessMode) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FollowUp.showFollowUp(ImportProject.this, project);
            }
        });
    }

    Project getMakeProject() {
        return this.makeProject;
    }

    Map<Step, State> getImportResult() {
        return this.importResult;
    }

    private void fixExcludedHeaderFiles() {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        if (TRACE) {
            logger.log(Level.INFO, "#start fixing excluded header files by model");
        }
        if (DiscoveryProjectGenerator.fixExcludedHeaderFiles(this.makeProject, logger)) {
            this.importResult.put(Step.FixExcluded, State.Successful);
        }
    }

    private Item findByNormalizedName(File file) {
        if (this.normalizedItems == null) {
            this.normalizedItems = DiscoveryProjectGenerator.initNormalizedNames(this.makeProject);
        }
        String path = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
        return this.normalizedItems.get(path);
    }

    private void switchModel(boolean state) {
        CsmModel model = CsmModelAccessor.getModel();
        if (model != null && this.makeProject != null) {
            NativeProject np = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            if (state) {
                if (TRACE) {
                    logger.log(Level.INFO, "#enable model for {0}", np.getProjectDisplayName());
                }
                model.enableProject((Object)np);
            } else {
                if (TRACE) {
                    logger.log(Level.INFO, "#disable model for {0}", np.getProjectDisplayName());
                }
                model.disableProject((Object)np);
            }
        }
    }

    private boolean discoveryByExecLog(DoubleFile execLog, boolean done) {
        DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
        if (extension != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(map, (Object)this.nativeProjectPath);
            DiscoveryWizardDescriptor.EXEC_LOG_FILE.toMap(map, (Object)execLog.getLocalPath());
            DiscoveryWizardDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(map, (Object)this.resolveSymLinks);
            if (extension.canApply(map, this.makeProject, this.interrupter)) {
                if (TRACE) {
                    logger.log(Level.INFO, "#start discovery by exec log file {0}", execLog.getLocalPath());
                }
                try {
                    done = true;
                    extension.apply(map, this.makeProject, this.interrupter);
                    this.setBuildResults((List)DiscoveryWizardDescriptor.BUILD_ARTIFACTS.fromMap(map));
                    DiscoveryProjectGenerator.saveMakeConfigurationDescriptor(this.makeProject, null);
                    this.importResult.put(Step.DiscoveryLog, State.Successful);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            } else if (TRACE) {
                logger.log(Level.INFO, "#discovery cannot be done by exec log file {0}", execLog.getLocalPath());
            }
            DiscoveryWizardDescriptor.EXEC_LOG_FILE.toMap(map, null);
        }
        return done;
    }

    private void setBuildResults(List<String> buildArtifacts) {
        String value;
        MakeConfiguration activeConfiguration;
        if (buildArtifacts == null || buildArtifacts.isEmpty()) {
            return;
        }
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        if (buildArtifacts.size() == 1 && (activeConfiguration = makeConfigurationDescriptor.getActiveConfiguration()) != null && ((value = activeConfiguration.getMakefileConfiguration().getOutput().getValue()) == null || value.isEmpty())) {
            this.buildResult = buildArtifacts.get(0);
            this.buildResult = ProjectSupport.toProperPath((FSPath)this.projectFolder, (String)CndPathUtilities.naturalizeSlashes((String)this.buildResult), (MakeProjectOptions.PathMode)this.pathMode);
            this.buildResult = CndPathUtilities.normalizeSlashes((String)this.buildResult);
            activeConfiguration.getMakefileConfiguration().getOutput().setValue(this.buildResult);
        }
    }

    private boolean discoveryByDwarfOrBuildLog(boolean done) {
        block14: {
            DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(map, (Object)this.nativeProjectPath);
                DiscoveryWizardDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(map, (Object)this.resolveSymLinks);
                if (this.dwarfSource != null) {
                    if (this.dwarfSource.isFolder()) {
                        DiscoveryWizardDescriptor.BUILD_FOLDER.toMap(map, (Object)this.dwarfSource.getPath());
                    } else {
                        DiscoveryWizardDescriptor.BUILD_RESULT.toMap(map, (Object)this.dwarfSource.getPath());
                    }
                }
                if (extension.canApply(map, this.makeProject, this.interrupter)) {
                    DiscoveryProvider provider = (DiscoveryProvider)DiscoveryWizardDescriptor.PROVIDER.fromMap(map);
                    if (provider != null && "make-log".equals(provider.getID())) {
                        if (TRACE) {
                            logger.log(Level.INFO, "#start discovery by log file {0}", ProviderPropertyType.MakeLogPropertyType.getProperty(provider));
                        }
                    } else if (TRACE) {
                        logger.log(Level.INFO, "#start discovery by object files");
                    }
                    try {
                        done = true;
                        extension.apply(map, this.makeProject, this.interrupter);
                        if (provider != null && "make-log".equals(provider.getID())) {
                            this.importResult.put(Step.DiscoveryLog, State.Successful);
                            break block14;
                        }
                        this.importResult.put(Step.DiscoveryDwarf, State.Successful);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                } else if (TRACE) {
                    logger.log(Level.INFO, "#no dwarf information found in object files");
                }
            }
        }
        return done;
    }

    private boolean dicoveryByBuildLog(DoubleFile makeLog, boolean done) {
        DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
        if (extension != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(map, (Object)this.nativeProjectPath);
            DiscoveryWizardDescriptor.LOG_FILE.toMap(map, (Object)makeLog.getLocalPath());
            DiscoveryWizardDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(map, (Object)this.resolveSymLinks);
            if (extension.canApply(map, this.makeProject, this.interrupter)) {
                if (TRACE) {
                    DiscoveryProvider provider = (DiscoveryProvider)DiscoveryWizardDescriptor.PROVIDER.fromMap(map);
                    if (provider != null && "make-log".equals(provider.getID())) {
                        logger.log(Level.INFO, "#start discovery by build log file {0}", makeLog.getLocalPath());
                    } else {
                        logger.log(Level.INFO, "#start discovery by exec log file {0}", makeLog.getLocalPath());
                    }
                }
                try {
                    done = true;
                    extension.apply(map, this.makeProject, this.interrupter);
                    this.setBuildResults((List)DiscoveryWizardDescriptor.BUILD_ARTIFACTS.fromMap(map));
                    DiscoveryProjectGenerator.saveMakeConfigurationDescriptor(this.makeProject, null);
                    this.importResult.put(Step.DiscoveryLog, State.Successful);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            } else if (TRACE) {
                logger.log(Level.INFO, "#discovery cannot be done by log file {0}", makeLog.getLocalPath());
            }
        }
        return done;
    }

    private void discoveryMacrosByBuildLog(DoubleFile makeLog) {
        DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
        if (extension != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(map, (Object)this.nativeProjectPath);
            DiscoveryWizardDescriptor.LOG_FILE.toMap(map, (Object)makeLog.getLocalPath());
            DiscoveryWizardDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(map, (Object)this.resolveSymLinks);
            if (extension.canApply(map, this.makeProject, this.interrupter)) {
                if (TRACE) {
                    logger.log(Level.INFO, "#start fix macros by log file {0}", makeLog.getLocalPath());
                }
                List confs = (List)DiscoveryWizardDescriptor.CONFIGURATIONS.fromMap(map);
                this.fixMacros(confs);
                this.importResult.put(Step.FixMacros, State.Successful);
            } else if (TRACE) {
                logger.log(Level.INFO, "#fix macros cannot be done by log file {0}", makeLog.getLocalPath());
            }
        }
    }

    private boolean discoveryByDwarf(boolean does) {
        DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
        if (extension != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(map, (Object)this.nativeProjectPath);
            DiscoveryWizardDescriptor.INVOKE_PROVIDER.toMap(map, (Object)Boolean.TRUE);
            DiscoveryWizardDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(map, (Object)this.resolveSymLinks);
            if (extension.canApply(map, this.makeProject, this.interrupter)) {
                if (TRACE) {
                    logger.log(Level.INFO, "#start discovery by object files");
                }
                try {
                    extension.apply(map, this.makeProject, this.interrupter);
                    this.importResult.put(Step.DiscoveryDwarf, State.Successful);
                    does = true;
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            } else if (TRACE) {
                logger.log(Level.INFO, "#no dwarf information found in object files");
            }
        }
        return does;
    }

    static {
        if (TRACE) {
            logger.setLevel(Level.ALL);
        }
        RP = new RequestProcessor(ImportProject.class.getName(), 2);
        RPR = new RequestProcessor(ImportProject.class.getName(), 1);
        listeners = new WeakHashMap<CsmProject, CsmProgressListener>();
    }

    private static enum MakeResult {
        Successful,
        Failed,
        Skipped;

    }

    public static enum Step {
        Project,
        Configure,
        MakeClean,
        Make,
        DiscoveryDwarf,
        DiscoveryLog,
        FixMacros,
        DiscoveryModel,
        FixExcluded;

    }

    public static enum State {
        Successful,
        Fail,
        Skiped;

    }
}

