/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.util;

import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.SwingUtilities;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.io.TreeStreamResult;
import org.netbeans.tax.io.TreeWriter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.xml.XMLUtil;

public final class TAXUtil {
    public static void setAttributeValue(TreeAttribute attribute, String value) throws TreeException {
        try {
            attribute.setValue(XMLUtil.toAttributeValue((String)value));
        }
        catch (CharConversionException exc) {
            throw new TreeException(exc);
        }
    }

    public static void setTextData(TreeText text, String value) throws TreeException {
        try {
            text.setData(XMLUtil.toElementContent((String)value));
        }
        catch (CharConversionException exc) {
            throw new TreeException(exc);
        }
    }

    public static void notifyWarning(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        });
    }

    public static String printableValue(String value) {
        if (value == null) {
            return "<null>";
        }
        int MAX_LENGTH = 33;
        int len = Math.min(value.length(), MAX_LENGTH);
        StringBuffer sb = new StringBuffer(2 * len);
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if ('\r' == ch) {
                sb.append("\\r");
                continue;
            }
            if ('\n' == ch) {
                sb.append("\\n");
                continue;
            }
            if ('\t' == ch) {
                sb.append("\\t");
                continue;
            }
            if ('\b' == ch) {
                sb.append("\\b");
                continue;
            }
            if ('\f' == ch) {
                sb.append("\\f");
                continue;
            }
            sb.append(ch);
        }
        if (value.length() > len) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static void notifyTreeException(TreeException exc) {
        TAXUtil.notifyWarning(exc.getMessage());
    }

    public static String treeToString(TreeDocumentRoot doc) throws IOException {
        StringWriter out = new StringWriter();
        TreeStreamResult result = new TreeStreamResult(out);
        TreeWriter writer = result.getWriter(doc);
        try {
            writer.writeDocument();
            String string = out.toString();
            return string;
        }
        catch (TreeException ex) {
            throw new IOException("Cannot read tree " + ex.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ioex) {}
        }
    }

    public static byte[] treeToByteArray(TreeDocumentRoot doc) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        TreeStreamResult result = new TreeStreamResult(out);
        TreeWriter writer = result.getWriter(doc);
        try {
            byte[] array;
            writer.writeDocument();
            byte[] byArray = array = out.toByteArray();
            return byArray;
        }
        catch (TreeException ex) {
            throw new IOException("Cannot read tree " + ex.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ioex) {}
        }
    }
}

