/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs;

import java.util.ArrayList;
import java.util.Collection;

public final class Library {
    private String name;
    private String description;
    private String homePage;
    private Version[] versions;

    Library() {
    }

    void setName(String name) {
        this.name = name;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    void setVersions(Version[] versions) {
        this.versions = versions;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public Version[] getVersions() {
        return this.versions;
    }

    public static final class Version {
        private final Library library;
        private String name;
        private String[] files;
        private String[] localFiles;

        Version(Library library) {
            this.library = library;
        }

        public Library getLibrary() {
            return this.library;
        }

        void setName(String name) {
            this.name = name;
        }

        void setFileInfo(String[] files, String[] localFiles) {
            assert (localFiles == null || files.length == localFiles.length);
            this.files = files;
            this.localFiles = localFiles;
        }

        public String getName() {
            return this.name;
        }

        public String[] getFiles() {
            return this.files;
        }

        public String[] getLocalFiles() {
            return this.localFiles;
        }

        public Version filterVersion(Collection<String> refusedFiles) {
            Version clone = new Version(this.library);
            clone.setName(this.name);
            ArrayList<String> fileList = new ArrayList<String>();
            for (String file : this.files) {
                if (refusedFiles.contains(file)) continue;
                fileList.add(file);
            }
            clone.setFileInfo(fileList.toArray(new String[fileList.size()]), null);
            return clone;
        }
    }
}

