/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.EnvProjectProblemsProvider;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectConfigurationProvider;
import org.netbeans.modules.cnd.makeproject.TempEnv;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectHelper;
import org.netbeans.modules.cnd.makeproject.configurations.ui.FormattingPropPanel;
import org.netbeans.modules.cnd.makeproject.ui.BrokenLinks;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.ResolveReferencePanel;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class BrokenReferencesSupport {
    private BrokenReferencesSupport() {
    }

    @NonNull
    public static ProjectProblemsProvider createPlatformVersionProblemProvider(@NonNull MakeProject project, @NonNull MakeProjectHelper helper, @NonNull ConfigurationDescriptorProvider projectDescriptorProvider, @NonNull MakeProjectConfigurationProvider makeProjectConfigurationProvider) {
        ProjectProblemsProviderImpl pp = new ProjectProblemsProviderImpl(project, helper, projectDescriptorProvider, makeProjectConfigurationProvider);
        pp.attachListeners();
        return pp;
    }

    public static boolean isIncorrectPlatform(ConfigurationDescriptorProvider projectDescriptorProvider) {
        if (projectDescriptorProvider.gotDescriptor()) {
            Configuration[] confs;
            for (Configuration cf : confs = projectDescriptorProvider.getConfigurationDescriptor().getConfs().toArray()) {
                if (!cf.isDefault()) continue;
                cf.getName();
                MakeConfiguration conf = (MakeConfiguration)cf;
                if (!conf.getDevelopmentHost().isLocalhost() || CompilerSetManager.get((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).getPlatform() == conf.getDevelopmentHost().getBuildPlatformConfiguration().getValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static String getActiveConfigurationName(ConfigurationDescriptorProvider projectDescriptorProvider) {
        if (projectDescriptorProvider.gotDescriptor()) {
            Configuration[] confs;
            for (Configuration cf : confs = projectDescriptorProvider.getConfigurationDescriptor().getConfs().toArray()) {
                if (!cf.isDefault()) continue;
                return cf.getName();
            }
        }
        return "";
    }

    public static boolean hasTemporaryEnv(ExecutionEnvironment ee) {
        return TempEnv.getInstance(ee).hasTemporaryEnv();
    }

    public static void addTemporaryEnv(ExecutionEnvironment ee, Map<String, String> map2fill) {
        TempEnv.getInstance(ee).addTemporaryEnv(map2fill);
    }

    public static String getTemporaryEnv(ExecutionEnvironment ee, String key) {
        return TempEnv.getInstance(ee).getTemporaryEnv(key);
    }

    private static boolean isIncorectVersion(@NonNull MakeProject project) {
        MakeLogicalViewProvider view = (MakeLogicalViewProvider)project.getLookup().lookup(MakeLogicalViewProvider.class);
        return view.isIncorectVersion();
    }

    @NonNull
    private static Set<? extends ProjectProblemsProvider.ProjectProblem> getReferenceProblems(@NonNull MakeProject project) {
        List<BrokenLinks.BrokenLink> brokenLinks = BrokenLinks.getBrokenLinks(project);
        if (!brokenLinks.isEmpty()) {
            ProjectProblemsProvider.ProjectProblem error = ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(ResolveReferencePanel.class, (String)"Link_Resolve_Name"), (String)NbBundle.getMessage(ResolveReferencePanel.class, (String)"Link_Resolve_Description"), (ProjectProblemResolver)new ToolCollectionResolverImpl(project, brokenLinks));
            return Collections.singleton(error);
        }
        return Collections.emptySet();
    }

    @NonNull
    private static Set<? extends ProjectProblemsProvider.ProjectProblem> getPlatformProblems(@NonNull MakeProject project) {
        if (BrokenReferencesSupport.isIncorrectPlatform((ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class))) {
            String name = BrokenReferencesSupport.getActiveConfigurationName((ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class));
            ProjectProblemsProvider.ProjectProblem error = ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(ResolveReferencePanel.class, (String)"MSG_platform_resolve_name"), (String)NbBundle.getMessage(ResolveReferencePanel.class, (String)"MSG_platform_resolve_description", (Object)name), (ProjectProblemResolver)new PlatformResolverImpl(project));
            return Collections.singleton(error);
        }
        return Collections.emptySet();
    }

    @NonNull
    private static Set<? extends ProjectProblemsProvider.ProjectProblem> getFormattingStyleProblems(@NonNull MakeProject project) {
        Iterator<Style> i$;
        List<Style> styles = BrokenReferencesSupport.getUndefinedFormattingStyles(project);
        if (styles != null && !styles.isEmpty() && (i$ = styles.iterator()).hasNext()) {
            Style style = i$.next();
            String source = "";
            if ("text/x-c".equals(style.mime)) {
                source = NbBundle.getMessage(ResolveReferencePanel.class, (String)"style_c");
            } else if ("text/x-c++".equals(style.mime)) {
                source = NbBundle.getMessage(ResolveReferencePanel.class, (String)"style_cpp");
            } else if ("text/x-h".equals(style.mime)) {
                source = NbBundle.getMessage(ResolveReferencePanel.class, (String)"style_header");
            }
            String message = NbBundle.getMessage(ResolveReferencePanel.class, (String)"style_resolve_description", (Object)style.aStyle.getDisplayName(), (Object)source);
            ProjectProblemsProvider.ProjectProblem error = ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(ResolveReferencePanel.class, (String)"style_resolve_name"), (String)message, (ProjectProblemResolver)new StyleResolverImpl(project, style));
            return Collections.singleton(error);
        }
        return Collections.emptySet();
    }

    private static Style undefinedStyle(MakeProject project, String mime) {
        MakeProject.CodeStyleWrapper aStyle = project.getProjectFormattingStyle(mime);
        if (aStyle == null) {
            return null;
        }
        Map<String, MakeProject.CodeStyleWrapper> allStyles = FormattingPropPanel.getAllStyles(mime);
        for (Map.Entry<String, MakeProject.CodeStyleWrapper> entry : allStyles.entrySet()) {
            if (!aStyle.getStyleId().equals(entry.getValue().getStyleId())) continue;
            return null;
        }
        return new Style(aStyle, mime);
    }

    private static List<Style> getUndefinedFormattingStyles(MakeProject project) {
        if (!project.isProjectFormattingStyle()) {
            return null;
        }
        ArrayList<Style> list = new ArrayList<Style>();
        Style s = BrokenReferencesSupport.undefinedStyle(project, "text/x-c");
        if (s != null) {
            list.add(s);
        }
        if ((s = BrokenReferencesSupport.undefinedStyle(project, "text/x-c++")) != null) {
            list.add(s);
        }
        if ((s = BrokenReferencesSupport.undefinedStyle(project, "text/x-h")) != null) {
            list.add(s);
        }
        return list;
    }

    @NonNull
    private static Set<? extends ProjectProblemsProvider.ProjectProblem> getVersionProblems(@NonNull MakeProject project) {
        LinkedHashSet<ProjectProblemsProvider.ProjectProblem> set = new LinkedHashSet<ProjectProblemsProvider.ProjectProblem>();
        if (BrokenReferencesSupport.isIncorectVersion(project)) {
            ProjectProblemsProvider.ProjectProblem error = ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(ResolveReferencePanel.class, (String)"MSG_version_resolve_name"), (String)NbBundle.getMessage(ResolveReferencePanel.class, (String)"MSG_version_resolve_description"), (ProjectProblemResolver)new VersionResolverImpl(project));
            set.add(error);
        }
        return set;
    }

    private static void reInitWithRemovedPrivate(MakeProject project) {
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor mcd = cdp.getConfigurationDescriptor();
        Configuration[] confs = mcd.getConfs().toArray();
        boolean save = false;
        for (Configuration cf : confs) {
            int platform2;
            int platform1;
            MakeConfiguration conf;
            if (!cf.isDefault() || !(conf = (MakeConfiguration)cf).getDevelopmentHost().isLocalhost() || (platform1 = CompilerSetManager.get((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).getPlatform()) == (platform2 = conf.getDevelopmentHost().getBuildPlatformConfiguration().getValue())) continue;
            conf.getDevelopmentHost().getBuildPlatformConfiguration().setValue(platform1);
            mcd.setModified();
            save = true;
        }
        if (save) {
            mcd.save();
        }
        MakeLogicalViewProvider view = (MakeLogicalViewProvider)project.getLookup().lookup(MakeLogicalViewProvider.class);
        view.reInit(mcd, false);
    }

    private static void reInitWithUnsupportedVersion(MakeProject project) {
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor mcd = cdp.getConfigurationDescriptor();
        MakeLogicalViewProvider view = (MakeLogicalViewProvider)project.getLookup().lookup(MakeLogicalViewProvider.class);
        view.reInit(mcd, true);
    }

    public static void updateProblems(Project project) {
        ProjectProblemsProvider pp = (ProjectProblemsProvider)project.getLookup().lookup(ProjectProblemsProvider.class);
        if (pp instanceof ProjectProblemsProviderImpl) {
            ((ProjectProblemsProviderImpl)pp).propertyChange(null);
        }
    }

    private static class StyleResolverImpl
    extends BaseProjectProblemResolver {
        private final Style style;

        private StyleResolverImpl(MakeProject project, Style style) {
            super(project);
            this.style = style;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            FormattingPropPanel.createStyle(this.style.aStyle, this.style.mime);
            this.updateProblems();
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED));
        }

        public int hashCode() {
            return this.style.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StyleResolverImpl other = (StyleResolverImpl)obj;
            return this.style.equals(other.style);
        }
    }

    public static final class Style {
        private final MakeProject.CodeStyleWrapper aStyle;
        private final String mime;

        Style(MakeProject.CodeStyleWrapper aStyle, String mime) {
            this.aStyle = aStyle;
            this.mime = mime;
        }

        public int hashCode() {
            return this.aStyle.getStyleId().hashCode() + this.mime.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Style other = (Style)obj;
            return this.aStyle.getStyleId().equals(other.aStyle.getStyleId()) && this.mime.equals(other.mime);
        }
    }

    private static class ToolCollectionResolverImpl
    extends BaseProjectProblemResolver {
        private final List<BrokenLinks.BrokenLink> brokenLinks;

        public ToolCollectionResolverImpl(MakeProject project, List<BrokenLinks.BrokenLink> brokenLinks) {
            super(project);
            this.brokenLinks = brokenLinks;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            ResolveReferencePanel panel = new ResolveReferencePanel(this.brokenLinks);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ResolveReferencePanel.class, (String)"Link_Dialog_Title"), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            dialog.dispose();
            this.updateProblems();
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED));
        }

        public int hashCode() {
            return this.getProject().hashCode() + ToolCollectionResolverImpl.class.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ToolCollectionResolverImpl other = (ToolCollectionResolverImpl)obj;
            return this.getProject().equals(other.getProject());
        }
    }

    private static class VersionResolverImpl
    extends BaseProjectProblemResolver {
        public VersionResolverImpl(MakeProject project) {
            super(project);
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            String title = NbBundle.getMessage(ResolveReferencePanel.class, (String)"MSG_version_ignore_title");
            String message = NbBundle.getMessage(ResolveReferencePanel.class, (String)"MSG_version_ignore");
            NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, 0, 3, null, NotifyDescriptor.YES_OPTION);
            Object ret = DialogDisplayer.getDefault().notify(nd);
            if (ret == NotifyDescriptor.YES_OPTION) {
                BrokenReferencesSupport.reInitWithUnsupportedVersion(this.getProject());
                this.updateProblems();
                return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED));
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
        }

        public int hashCode() {
            return this.getProject().hashCode() + VersionResolverImpl.class.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VersionResolverImpl other = (VersionResolverImpl)obj;
            return this.getProject().equals(other.getProject());
        }
    }

    private static class PlatformResolverImpl
    extends BaseProjectProblemResolver {
        private final String name;

        public PlatformResolverImpl(MakeProject project) {
            super(project);
            this.name = BrokenReferencesSupport.getActiveConfigurationName((ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class));
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            String title = NbBundle.getMessage(ResolveReferencePanel.class, (String)"MSG_platform_fix_title");
            String message = NbBundle.getMessage(ResolveReferencePanel.class, (String)"MSG_platform_fix", (Object)this.name);
            NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, 0, 3, null, NotifyDescriptor.YES_OPTION);
            Object ret = DialogDisplayer.getDefault().notify(nd);
            if (ret == NotifyDescriptor.YES_OPTION) {
                MakeProject project = this.getProject();
                if (project != null) {
                    BrokenReferencesSupport.reInitWithRemovedPrivate(project);
                    this.updateProblems();
                }
                return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED));
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
        }

        public int hashCode() {
            return this.getProject().hashCode() + PlatformResolverImpl.class.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PlatformResolverImpl other = (PlatformResolverImpl)obj;
            return this.getProject().equals(other.getProject());
        }
    }

    static abstract class BaseProjectProblemResolver
    implements ProjectProblemResolver {
        private final MakeProject project;

        public BaseProjectProblemResolver(MakeProject project) {
            CndUtils.assertNotNull((Object)project, (String)"null project");
            this.project = project;
        }

        protected final void updateProblems() {
            BrokenReferencesSupport.updateProblems(this.project);
        }

        protected final MakeProject getProject() {
            return this.project;
        }
    }

    static final class Done
    implements Future<ProjectProblemsProvider.Result> {
        private final ProjectProblemsProvider.Result result;

        Done(@NonNull ProjectProblemsProvider.Result result) {
            Parameters.notNull((CharSequence)"result", (Object)result);
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public ProjectProblemsProvider.Result get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public ProjectProblemsProvider.Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    private static class ProjectProblemsProviderImpl
    implements ProjectProblemsProvider,
    PropertyChangeListener {
        private final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
        private final MakeProject project;
        private final MakeProjectHelper helper;
        private final ConfigurationDescriptorProvider projectDescriptorProvider;
        private final MakeProjectConfigurationProvider makeProjectConfigurationProvider;
        private final EnvProjectProblemsProvider envProblemsProvider;

        public ProjectProblemsProviderImpl(@NonNull MakeProject project, @NonNull MakeProjectHelper helper, @NonNull ConfigurationDescriptorProvider projectDescriptorProvider, @NonNull MakeProjectConfigurationProvider makeProjectConfigurationProvider) {
            this.project = project;
            this.helper = helper;
            this.projectDescriptorProvider = projectDescriptorProvider;
            this.makeProjectConfigurationProvider = makeProjectConfigurationProvider;
            this.envProblemsProvider = new EnvProjectProblemsProvider(project);
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.problemsProviderSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.problemsProviderSupport.removePropertyChangeListener(listener);
        }

        public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
            return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

                public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                    Collection currentProblems = (Collection)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Collection<? extends ProjectProblemsProvider.ProjectProblem>>(){

                        public Collection<? extends ProjectProblemsProvider.ProjectProblem> run() {
                            LinkedHashSet<? extends ProjectProblemsProvider.ProjectProblem> newProblems = new LinkedHashSet<ProjectProblemsProvider.ProjectProblem>();
                            Set versionProblems = BrokenReferencesSupport.getVersionProblems(ProjectProblemsProviderImpl.this.project);
                            newProblems.addAll(versionProblems);
                            if (versionProblems.isEmpty()) {
                                newProblems.addAll(BrokenReferencesSupport.getReferenceProblems(ProjectProblemsProviderImpl.this.project));
                                newProblems.addAll(BrokenReferencesSupport.getPlatformProblems(ProjectProblemsProviderImpl.this.project));
                                newProblems.addAll(ProjectProblemsProviderImpl.this.envProblemsProvider.getEnvProblems());
                                newProblems.addAll(BrokenReferencesSupport.getFormattingStyleProblems(ProjectProblemsProviderImpl.this.project));
                            }
                            return Collections.unmodifiableSet(newProblems);
                        }
                    });
                    return currentProblems;
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.problemsProviderSupport.fireProblemsChange();
        }

        void attachListeners() {
            this.makeProjectConfigurationProvider.addPropertyChangeListener(this);
        }
    }
}

